/**
 * Copyright (c) 2021 Contributors to the Eclipse Foundation
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Do not edit: This file is generated by Xtext
 */
package org.eclipse.lsat.dispatching.teditor.serializer;

import com.google.inject.Inject;
import dispatching.ActivityDispatching;
import dispatching.Attribute;
import dispatching.Dispatch;
import dispatching.DispatchGroup;
import dispatching.DispatchingPackage;
import dispatching.Repeat;
import java.util.Map;
import java.util.Set;
import machine.Import;
import machine.MachinePackage;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.lsat.dispatching.teditor.services.DispatchingGrammarAccess;
import org.eclipse.xtext.Action;
import org.eclipse.xtext.Parameter;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.serializer.ISerializationContext;
import org.eclipse.xtext.serializer.acceptor.SequenceFeeder;
import org.eclipse.xtext.serializer.sequencer.AbstractDelegatingSemanticSequencer;
import org.eclipse.xtext.serializer.sequencer.ITransientValueService.ValueTransient;

@SuppressWarnings("all")
public abstract class AbstractDispatchingSemanticSequencer extends AbstractDelegatingSemanticSequencer {

    @Inject
    private DispatchingGrammarAccess grammarAccess;
    
    @Override
    public void sequence(ISerializationContext context, EObject semanticObject) {
        EPackage epackage = semanticObject.eClass().getEPackage();
        ParserRule rule = context.getParserRule();
        Action action = context.getAssignedAction();
        Set<Parameter> parameters = context.getEnabledBooleanParameters();
        if (epackage == DispatchingPackage.eINSTANCE)
            switch (semanticObject.eClass().getClassifierID()) {
            case DispatchingPackage.ACTIVITY_DISPATCHING:
                sequence_ActivityDispatching(context, (ActivityDispatching) semanticObject); 
                return; 
            case DispatchingPackage.ATTRIBUTE:
                sequence_Attribute(context, (Attribute) semanticObject); 
                return; 
            case DispatchingPackage.ATTRIBUTES_MAP_ENTRY:
                sequence_AttributesMapEntry(context, (Map.Entry & EObject) semanticObject); 
                return; 
            case DispatchingPackage.DISPATCH:
                sequence_Dispatch(context, (Dispatch) semanticObject); 
                return; 
            case DispatchingPackage.DISPATCH_GROUP:
                sequence_DispatchGroup(context, (DispatchGroup) semanticObject); 
                return; 
            case DispatchingPackage.REPEAT:
                if (rule == grammarAccess.getNumberRepeatsRule()) {
                    sequence_NumberRepeats(context, (Repeat) semanticObject); 
                    return; 
                }
                else if (rule == grammarAccess.getRangeRule()) {
                    sequence_Range(context, (Repeat) semanticObject); 
                    return; 
                }
                else break;
            case DispatchingPackage.RESOURCE_ITERATIONS_MAP_ENTRY:
                sequence_ResourceIterationsMapEntry(context, (Map.Entry & EObject) semanticObject); 
                return; 
            case DispatchingPackage.RESOURCE_YIELD_MAP_ENTRY:
                sequence_ResourceYieldMapEntry(context, (Map.Entry & EObject) semanticObject); 
                return; 
            }
        else if (epackage == MachinePackage.eINSTANCE)
            switch (semanticObject.eClass().getClassifierID()) {
            case MachinePackage.IMPORT:
                sequence_Import(context, (Import) semanticObject); 
                return; 
            }
        if (errorAcceptor != null)
            errorAcceptor.accept(diagnosticProvider.createInvalidContextOrTypeDiagnostic(semanticObject, context));
    }
    
    /**
     * Contexts:
     *     ActivityDispatching returns ActivityDispatching
     *
     * Constraint:
     *     (imports+=Import* numberOfIterations=INT? resourceIterations+=ResourceIterationsMapEntry* dispatchGroups+=DispatchGroup*)
     */
    			protected void sequence_ActivityDispatching(ISerializationContext context, ActivityDispatching semanticObject) {
    genericSequencer.createSequence(context, semanticObject);
    }
    
    
    /**
     * Contexts:
     *     Attribute returns Attribute
     *
     * Constraint:
     *     name=ID
     */
    			protected void sequence_Attribute(ISerializationContext context, Attribute semanticObject) {
    if (errorAcceptor != null) {
        if (transientValues.isValueTransient(semanticObject, DispatchingPackage.Literals.ATTRIBUTE__NAME) == ValueTransient.YES)
            errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, DispatchingPackage.Literals.ATTRIBUTE__NAME));
    }
    SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
    feeder.accept(grammarAccess.getAttributeAccess().getNameIDTerminalRuleCall_1_0(), semanticObject.getName());
    feeder.finish();
    }
    
    
    /**
     * Contexts:
     *     AttributesMapEntry returns AttributesMapEntry
     *
     * Constraint:
     *     (key=Attribute (value=IDString | value=INTASString))
     */
    			protected <T extends Map.Entry & EObject> void sequence_AttributesMapEntry(ISerializationContext context, T semanticObject) {
    genericSequencer.createSequence(context, (EObject) semanticObject);
    }
    
    
    /**
     * Contexts:
     *     DispatchGroup returns DispatchGroup
     *
     * Constraint:
     *     (
     *         name=IDString? 
     *         (userAttributes+=AttributesMapEntry userAttributes+=AttributesMapEntry*)? 
     *         (iteratorName=IDString? (repeats+=NumberRepeats | (repeats+=Range repeats+=Range*)))? 
     *         yield=INT? 
     *         resourceYield+=ResourceYieldMapEntry* 
     *         offset=EBigDecimal? 
     *         dispatches+=Dispatch*
     *     )
     */
    			protected void sequence_DispatchGroup(ISerializationContext context, DispatchGroup semanticObject) {
    genericSequencer.createSequence(context, semanticObject);
    }
    
    
    /**
     * Contexts:
     *     Dispatch returns Dispatch
     *
     * Constraint:
     *     (
     *         activity=[Activity|ID] 
     *         (resourceItems+=[ResourceItem|ResourceItemQualifiedName] resourceItems+=[ResourceItem|ResourceItemQualifiedName]*)? 
     *         description=STRING? 
     *         (userAttributes+=AttributesMapEntry userAttributes+=AttributesMapEntry*)?
     *     )
     */
    			protected void sequence_Dispatch(ISerializationContext context, Dispatch semanticObject) {
    genericSequencer.createSequence(context, semanticObject);
    }
    
    
    /**
     * Contexts:
     *     Import returns Import
     *
     * Constraint:
     *     importURI=STRING
     */
    			protected void sequence_Import(ISerializationContext context, Import semanticObject) {
    if (errorAcceptor != null) {
        if (transientValues.isValueTransient(semanticObject, MachinePackage.Literals.IMPORT__IMPORT_URI) == ValueTransient.YES)
            errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, MachinePackage.Literals.IMPORT__IMPORT_URI));
    }
    SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
    feeder.accept(grammarAccess.getImportAccess().getImportURISTRINGTerminalRuleCall_2_0(), semanticObject.getImportURI());
    feeder.finish();
    }
    
    
    /**
     * Contexts:
     *     NumberRepeats returns Repeat
     *
     * Constraint:
     *     numRepeats=INT
     */
    			protected void sequence_NumberRepeats(ISerializationContext context, Repeat semanticObject) {
    if (errorAcceptor != null) {
        if (transientValues.isValueTransient(semanticObject, DispatchingPackage.Literals.REPEAT__NUM_REPEATS) == ValueTransient.YES)
            errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, DispatchingPackage.Literals.REPEAT__NUM_REPEATS));
    }
    SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
    feeder.accept(grammarAccess.getNumberRepeatsAccess().getNumRepeatsINTTerminalRuleCall_1_0(), semanticObject.getNumRepeats());
    feeder.finish();
    }
    
    
    /**
     * Contexts:
     *     Range returns Repeat
     *
     * Constraint:
     *     (start=INT | (start=INT end=INT))
     */
    			protected void sequence_Range(ISerializationContext context, Repeat semanticObject) {
    genericSequencer.createSequence(context, semanticObject);
    }
    
    
    /**
     * Contexts:
     *     ResourceIterationsMapEntry returns ResourceIterationsMapEntry
     *
     * Constraint:
     *     (key=[IResource|ResourceQualifiedName] value=INT)
     */
    			protected <T extends Map.Entry & EObject> void sequence_ResourceIterationsMapEntry(ISerializationContext context, T semanticObject) {
    if (errorAcceptor != null) {
        if (transientValues.isValueTransient((EObject) semanticObject, DispatchingPackage.Literals.RESOURCE_ITERATIONS_MAP_ENTRY__KEY) == ValueTransient.YES)
            errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing((EObject) semanticObject, DispatchingPackage.Literals.RESOURCE_ITERATIONS_MAP_ENTRY__KEY));
        if (transientValues.isValueTransient((EObject) semanticObject, DispatchingPackage.Literals.RESOURCE_ITERATIONS_MAP_ENTRY__VALUE) == ValueTransient.YES)
            errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing((EObject) semanticObject, DispatchingPackage.Literals.RESOURCE_ITERATIONS_MAP_ENTRY__VALUE));
    }
    SequenceFeeder feeder = createSequencerFeeder(context, (EObject) semanticObject);
    feeder.accept(grammarAccess.getResourceIterationsMapEntryAccess().getKeyIResourceResourceQualifiedNameParserRuleCall_2_0_1(), semanticObject.eGet(DispatchingPackage.Literals.RESOURCE_ITERATIONS_MAP_ENTRY__KEY, false));
    feeder.accept(grammarAccess.getResourceIterationsMapEntryAccess().getValueINTTerminalRuleCall_4_0(), semanticObject.getValue());
    feeder.finish();
    }
    
    
    /**
     * Contexts:
     *     ResourceYieldMapEntry returns ResourceYieldMapEntry
     *
     * Constraint:
     *     (key=[IResource|ResourceQualifiedName] value=INT)
     */
    			protected <T extends Map.Entry & EObject> void sequence_ResourceYieldMapEntry(ISerializationContext context, T semanticObject) {
    if (errorAcceptor != null) {
        if (transientValues.isValueTransient((EObject) semanticObject, DispatchingPackage.Literals.RESOURCE_YIELD_MAP_ENTRY__KEY) == ValueTransient.YES)
            errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing((EObject) semanticObject, DispatchingPackage.Literals.RESOURCE_YIELD_MAP_ENTRY__KEY));
        if (transientValues.isValueTransient((EObject) semanticObject, DispatchingPackage.Literals.RESOURCE_YIELD_MAP_ENTRY__VALUE) == ValueTransient.YES)
            errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing((EObject) semanticObject, DispatchingPackage.Literals.RESOURCE_YIELD_MAP_ENTRY__VALUE));
    }
    SequenceFeeder feeder = createSequencerFeeder(context, (EObject) semanticObject);
    feeder.accept(grammarAccess.getResourceYieldMapEntryAccess().getKeyIResourceResourceQualifiedNameParserRuleCall_1_0_1(), semanticObject.eGet(DispatchingPackage.Literals.RESOURCE_YIELD_MAP_ENTRY__KEY, false));
    feeder.accept(grammarAccess.getResourceYieldMapEntryAccess().getValueINTTerminalRuleCall_3_0(), semanticObject.getValue());
    feeder.finish();
    }
    
    
}
