/**
 * Copyright (c) 2021 Contributors to the Eclipse Foundation
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 */
/*
 * generated by Xtext
 */
package org.eclipse.lsat.activity.teditor.ui.contentassist

import activity.ActivitySet
import activity.Event
import activity.Move
import machine.PathTargetReference
import org.eclipse.emf.ecore.EObject
import org.eclipse.xtext.Assignment
import org.eclipse.xtext.CrossReference
import org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext
import org.eclipse.xtext.ui.editor.contentassist.ICompletionProposalAcceptor

import static extension org.eclipse.lsat.common.xtend.Queries.*
import static extension org.eclipse.xtext.EcoreUtil2.getContainerOfType
import activity.Activity

/**
 * see http://www.eclipse.org/Xtext/documentation.html#contentAssist on how to customize content assistant
 */
class ActivityProposalProvider extends AbstractActivityProposalProvider {
    
    override completeMove_TargetPosition(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        val move = model as Move
        val sourcePosition = move.sourcePosition
        if (!move.positionMove || move.incomingEdges.empty || null === sourcePosition) {
            // Source position not set, use default scoping
            super.completeMove_TargetPosition(move, assignment, context, acceptor)
        } else {
            var Iterable<PathTargetReference> targetReferences = sourcePosition.outgoingPaths.xcollect[targets]
            if (!move.stopAtTarget) {
                targetReferences = targetReferences.select[settling.isEmpty];
            }

            // TODO: IterableQueries should support including/excluding, then excluding can be used instead of select
            val allowedPositions = targetReferences.xcollectOne[position].excluding(sourcePosition).toSet;

            lookupCrossReference(assignment.terminal as CrossReference, context, acceptor, [
                allowedPositions.contains(EObjectOrProxy)
            ])
        }
    }

    override completeMove_Profile(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        val move = model as Move
        val sourcePosition = move.sourcePosition
        val targetPosition = move.targetPosition
        if (!move.positionMove || move.incomingEdges.empty || null === sourcePosition || null === targetPosition) {
            // Positions not set, use default scoping
            super.completeMove_Profile(move, assignment, context, acceptor)
        } else {
            val allowedProfiles = sourcePosition.outgoingPaths.select[
                    it.targets.xcollectOne[position].includes(targetPosition)
                ].xcollect[profiles].toSet
            
            lookupCrossReference(assignment.terminal as CrossReference, context, acceptor, [
                allowedProfiles.contains(EObjectOrProxy)
            ])
        }
    }
    
    override void completeActivity_Edges(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.completeActivity_Edges(model,assignment,context,acceptor)
    }
    
    override completeRequireEvent_EventName(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.completeRequireEvent_EventName(model,assignment,context,acceptor);
        completeEvent_EventName(model,assignment,context,acceptor)
    }

    override completeRaiseEvent_EventName(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.completeRaiseEvent_EventName(model,assignment,context,acceptor);
        completeEvent_EventName(model,assignment,context,acceptor)
    }
    
    def completeEvent_EventName(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        val set = model.getContainerOfType(ActivitySet)
        val activity = model.getContainerOfType(Activity)
        val ownedEvents = activity.nodes.filter(Event).map[eventName].toSet
        set.activities.filter[it!==activity].flatMap[nodes].filter(Event).map[eventName].filter[!ownedEvents.contains(it)].forEach [
            acceptor.accept(createCompletionProposal(it, it, null, context))
        ]
    }
    
    
}
