/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.scheduler;

import activity.Claim;
import activity.Release;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import lsat_graph.ClaimTask;
import lsat_graph.EventAnnotation;
import lsat_graph.ReleaseTask;
import lsat_graph.lsat_graphFactory;
import machine.IResource;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.lsat.common.graph.directed.DirectedGraph;
import org.eclipse.lsat.common.graph.directed.Edge;
import org.eclipse.lsat.common.graph.directed.Node;
import org.eclipse.lsat.common.scheduler.graph.Dependency;
import org.eclipse.lsat.common.scheduler.graph.GraphFactory;
import org.eclipse.lsat.common.scheduler.graph.Task;
import org.eclipse.lsat.common.scheduler.graph.TaskDependencyGraph;
import org.eclipse.lsat.motioncalculator.MotionException;
import org.eclipse.lsat.timing.util.SpecificationException;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShortcutClaimRelease<T extends Task> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ShortcutClaimRelease.class);

    private ShortcutClaimRelease() {
    }

    public static <T extends Task> TaskDependencyGraph<T> transformModel(TaskDependencyGraph<T> graph) {
        try {
            LOGGER.debug("Starting transformation");
            ShortcutClaimRelease.processGraph(graph);
            LOGGER.debug("Finished transformation");
            return graph;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private static <T extends Task, E extends Edge> void processGraph(DirectedGraph<T, E> graph) throws SpecificationException, MotionException {
        Consumer<DirectedGraph> _function = it -> {
            try {
                ShortcutClaimRelease.processGraph(it);
            }
            catch (Throwable _e) {
                throw Exceptions.sneakyThrow((Throwable)_e);
            }
        };
        ((List)Conversions.doWrapArray((Object)((DirectedGraph[])Conversions.unwrapArray((Object)graph.getSubGraphs(), DirectedGraph.class)).clone())).forEach(_function);
        Consumer<Task> _function_1 = it -> {
            try {
                ShortcutClaimRelease.shortcutClaimRelease((Node)it);
            }
            catch (Throwable _e) {
                throw Exceptions.sneakyThrow((Throwable)_e);
            }
        };
        ((List)Conversions.doWrapArray((Object)((Task[])Conversions.unwrapArray((Object)graph.getNodes(), Task.class)).clone())).forEach(_function_1);
    }

    private static void _shortcutClaimRelease(Node node) {
    }

    private static void _shortcutClaimRelease(ClaimTask claimTask) throws SpecificationException, MotionException {
        ReleaseTask releaseTask = ShortcutClaimRelease.getCorrespondingReleaseTask(claimTask);
        if (releaseTask != null) {
            Functions.Function1 _function = it -> it.getSourceNode();
            Consumer<Node> _function_1 = s -> {
                Functions.Function1 _function_2 = it -> it.getTargetNode();
                Consumer<Node> _function_3 = t -> ShortcutClaimRelease.addDependency(s, t, ((Claim)claimTask.getAction()).getResource().getName());
                ListExtensions.map((List)releaseTask.getOutgoingEdges(), (Functions.Function1)_function_2).forEach(_function_3);
            };
            ListExtensions.map((List)claimTask.getIncomingEdges(), (Functions.Function1)_function).forEach(_function_1);
            Consumer<Edge> _function_2 = it -> ShortcutClaimRelease.delete(it);
            ((List)Conversions.doWrapArray((Object)((Edge[])Conversions.unwrapArray((Object)claimTask.getIncomingEdges(), Edge.class)).clone())).forEach(_function_2);
            Consumer<Edge> _function_3 = it -> ShortcutClaimRelease.delete(it);
            ((List)Conversions.doWrapArray((Object)((Edge[])Conversions.unwrapArray((Object)claimTask.getOutgoingEdges(), Edge.class)).clone())).forEach(_function_3);
            Consumer<Edge> _function_4 = it -> ShortcutClaimRelease.delete(it);
            ((List)Conversions.doWrapArray((Object)((Edge[])Conversions.unwrapArray((Object)releaseTask.getOutgoingEdges(), Edge.class)).clone())).forEach(_function_4);
            ShortcutClaimRelease.delete((Node)claimTask);
            ShortcutClaimRelease.delete((Node)releaseTask);
        }
    }

    private static ReleaseTask getCorrespondingReleaseTask(ClaimTask claimTask) {
        boolean _notEquals;
        int _size = claimTask.getOutgoingEdges().size();
        boolean bl = _notEquals = _size != 1;
        if (_notEquals) {
            return null;
        }
        Functions.Function1 _function = it -> it.getTargetNode();
        Functions.Function1 _function_1 = it -> {
            IResource _resource_1;
            IResource _resource = ((Release)it.getAction()).getResource();
            return _resource == (_resource_1 = ((Claim)claimTask.getAction()).getResource());
        };
        return (ReleaseTask)IterableExtensions.findFirst((Iterable)Iterables.filter((Iterable)ListExtensions.map((List)claimTask.getOutgoingEdges(), (Functions.Function1)_function), ReleaseTask.class), (Functions.Function1)_function_1);
    }

    private static void delete(Edge edge) {
        edge.setTargetNode(null);
        edge.setSourceNode(null);
        edge.setGraph(null);
        EcoreUtil.delete((EObject)edge);
    }

    private static void delete(Node node) {
        node.setGraph(null);
        EcoreUtil.delete((EObject)node);
    }

    private static <T extends Task, E extends Edge> void addDependency(Node src, Node target, String eventName) {
        Dependency dep = GraphFactory.eINSTANCE.createDependency();
        EventAnnotation eventAnnotation = lsat_graphFactory.eINSTANCE.createEventAnnotation();
        eventAnnotation.setName(eventName);
        EList _aspects = dep.getAspects();
        _aspects.add((Object)eventAnnotation);
        dep.setGraph(src.getGraph());
        dep.setSourceNode(src);
        dep.setTargetNode(target);
    }

    private static void shortcutClaimRelease(Node claimTask) throws SpecificationException, MotionException {
        if (claimTask instanceof ClaimTask) {
            ShortcutClaimRelease._shortcutClaimRelease((ClaimTask)claimTask);
            return;
        }
        if (claimTask != null) {
            ShortcutClaimRelease._shortcutClaimRelease(claimTask);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(claimTask).toString());
    }
}

