/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.xinclude;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.xerces.impl.XMLEntityManager;
import org.apache.xerces.util.URI;
import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lemminx.dom.DOMAttr;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.dom.DOMElement;
import org.eclipse.lemminx.dom.DOMNode;
import org.eclipse.lemminx.dom.DOMRange;
import org.eclipse.lemminx.extensions.xinclude.XIncludeUtils;
import org.eclipse.lemminx.services.extensions.IDocumentLinkParticipant;
import org.eclipse.lemminx.utils.StringUtils;
import org.eclipse.lemminx.utils.XMLPositionUtility;
import org.eclipse.lsp4j.DocumentLink;

public class XIncludeDocumentLinkParticipant
implements IDocumentLinkParticipant {
    private static Logger LOGGER = Logger.getLogger(XIncludeDocumentLinkParticipant.class.getName());

    @Override
    public void findDocumentLinks(DOMDocument document, List<DocumentLink> links) {
        this.findDocumentLinks(document, document, links);
    }

    public void findDocumentLinks(DOMNode parent, DOMDocument document, List<DocumentLink> links) {
        for (DOMNode child : parent.getChildren()) {
            DOMAttr hrefAttr;
            if (!child.isElement()) continue;
            DOMElement xincludeElement = (DOMElement)child;
            if (XIncludeUtils.isInclude(xincludeElement) && (hrefAttr = XIncludeUtils.getHref(xincludeElement)) != null && !StringUtils.isEmpty(hrefAttr.getValue())) {
                String location = XIncludeDocumentLinkParticipant.getResolvedLocation(document.getDocumentURI(), hrefAttr.getValue());
                DOMRange hrefRange = hrefAttr.getNodeAttrValue();
                try {
                    links.add(XMLPositionUtility.createDocumentLink(hrefRange, location, true));
                }
                catch (BadLocationException e) {
                    LOGGER.log(Level.SEVERE, "Creation of document link failed", e);
                }
            }
            this.findDocumentLinks(xincludeElement, document, links);
        }
    }

    private static String getResolvedLocation(String documentURI, String location) {
        if (location == null) {
            return null;
        }
        try {
            return XMLEntityManager.expandSystemId((String)location, (String)documentURI, (boolean)false);
        }
        catch (URI.MalformedURIException e) {
            return location;
        }
    }
}

