/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.util.pushstream;

import java.util.concurrent.BlockingQueue;
import org.osgi.util.pushstream.PushEvent;
import org.osgi.util.pushstream.QueuePolicy;

public enum QueuePolicyOption {
    DISCARD_OLDEST{

        @Override
        public <T, U extends BlockingQueue<PushEvent<? extends T>>> QueuePolicy<T, U> getPolicy() {
            return (queue, event) -> {
                while (!queue.offer(event)) {
                    queue.poll();
                }
            };
        }
    }
    ,
    BLOCK{

        @Override
        public <T, U extends BlockingQueue<PushEvent<? extends T>>> QueuePolicy<T, U> getPolicy() {
            return (queue, event) -> {
                try {
                    queue.put(event);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            };
        }
    }
    ,
    FAIL{

        @Override
        public <T, U extends BlockingQueue<PushEvent<? extends T>>> QueuePolicy<T, U> getPolicy() {
            return (queue, event) -> {
                boolean bl = queue.add(event);
            };
        }
    };


    private QueuePolicyOption() {
    }

    public abstract <T, U extends BlockingQueue<PushEvent<? extends T>>> QueuePolicy<T, U> getPolicy();

    /* synthetic */ QueuePolicyOption(String string, int n, QueuePolicyOption queuePolicyOption) {
        this();
    }
}

