/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.callbacks;

import com.bugsnag.Report;
import com.bugsnag.callbacks.Callback;
import com.bugsnag.servlet.javax.BugsnagServletRequestListener;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class JavaxServletCallback
implements Callback {
    private static final String HEADER_X_FORWARDED_FOR = "X-FORWARDED-FOR";

    public static boolean isAvailable() {
        try {
            Class.forName("javax.servlet.ServletRequestListener", false, JavaxServletCallback.class.getClassLoader());
            return true;
        }
        catch (ClassNotFoundException ex) {
            return false;
        }
    }

    @Override
    public void beforeNotify(Report report) {
        HttpServletRequest request = BugsnagServletRequestListener.getServletRequest();
        if (request == null) {
            return;
        }
        report.addToTab("request", "url", request.getRequestURL().toString()).addToTab("request", "method", request.getMethod()).addToTab("request", "params", new HashMap(request.getParameterMap())).addToTab("request", "clientIp", this.getClientIp(request)).addToTab("request", "headers", this.getHeaderMap(request));
        if (report.getContext() == null) {
            report.setContext(request.getMethod() + " " + request.getRequestURI());
        }
    }

    private String getClientIp(HttpServletRequest request) {
        int idx;
        String remoteAddr = request.getRemoteAddr();
        String forwardedAddr = request.getHeader(HEADER_X_FORWARDED_FOR);
        if (forwardedAddr != null && (idx = (remoteAddr = forwardedAddr).indexOf(44)) > -1) {
            remoteAddr = remoteAddr.substring(0, idx);
        }
        return remoteAddr;
    }

    private Map<String, String> getHeaderMap(HttpServletRequest request) {
        HashMap<String, String> headers = new HashMap<String, String>();
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames != null && headerNames.hasMoreElements()) {
            String key = (String)headerNames.nextElement();
            Enumeration headerValues = request.getHeaders(key);
            StringBuilder value = new StringBuilder();
            if (headerValues != null && headerValues.hasMoreElements()) {
                value.append((String)headerValues.nextElement());
                while (headerValues.hasMoreElements()) {
                    value.append(",").append((String)headerValues.nextElement());
                }
            }
            headers.put(key, value.toString());
        }
        return headers;
    }
}

