/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.mtoolkit.iagent.internal.mbsa;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.tigris.mtoolkit.iagent.internal.mbsa.DataFormater;
import org.tigris.mtoolkit.iagent.internal.utils.DebugUtils;
import org.tigris.mtoolkit.iagent.mbsa.MBSAException;
import org.tigris.mtoolkit.iagent.mbsa.MBSARequest;
import org.tigris.mtoolkit.iagent.mbsa.MBSARequestHandler;
import org.tigris.mtoolkit.iagent.mbsa.MBSAResponse;
import org.tigris.mtoolkit.iagent.mbsa.MBSAServer;

public class MBSAServerImpl
implements MBSAServer,
Runnable {
    private static final byte SUPPORTED_VERSION = 2;
    private volatile boolean running;
    private Thread serverThread;
    private MBSARequestHandler handler;
    private InputStream input;
    private OutputStream output;
    private volatile boolean closed;
    private byte protocolVersion = 1;

    public MBSAServerImpl(MBSARequestHandler handler, InputStream input, OutputStream output) throws MBSAException {
        if (handler == null || input == null || output == null) {
            throw new NullPointerException("one of the arguments is null");
        }
        this.handler = handler;
        this.input = input;
        this.output = output;
        this.serverThread = new Thread(this);
        this.serverThread.setName("MBSA Session");
        this.start();
    }

    private void start() throws MBSAException {
        if (this.running || this.closed) {
            return;
        }
        this.running = true;
        this.serverThread.start();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        try {
            while (this.running || !this.closed) {
                try {
                    MBSARequest request = this.readRequest(this.input);
                    MBSAResponse rsp = this.handleRequest(request);
                    if (this.running) {
                        if (rsp == null) continue;
                        this.sendRsp(rsp, this.output);
                    }
                    break;
                }
                catch (IOException iOException) {
                    this.close();
                }
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.fireDisconnected();
            throw throwable;
        }
        {
            Object var3_5 = null;
            this.fireDisconnected();
            return;
        }
    }

    private void fireDisconnected() {
        this.handler.disconnected(this);
    }

    private MBSAResponse handleRequest(MBSARequest request) throws IOException {
        if (request.getCommand() == 0x12121212) {
            this.respondToPing(request);
            return null;
        }
        MBSAResponse rsp = this.handler.handleRequest(request);
        if (rsp == null) {
            rsp = request.respond(16);
        }
        return rsp;
    }

    private void respondToPing(MBSARequest request) throws IOException {
        MBSAResponse rsp = request.respond();
        byte protocolVersion = 1;
        if (request.available() > 0) {
            protocolVersion = request.readByte();
            this.debug("[pingResponse] Clients supported version: " + protocolVersion);
            rsp.writeByte((byte)2);
        }
        rsp.done();
        this.sendRsp(rsp, this.output);
        this.protocolVersion = protocolVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MBSARequest readRequest(InputStream is) throws IOException {
        this.debug("[readRequest] >>> is: " + is);
        InputStream inputStream = is;
        synchronized (inputStream) {
            int msgId = DataFormater.readInt(is);
            int cmdId = DataFormater.readInt(is);
            int cmdLength = DataFormater.readInt(is);
            byte[] data = new byte[cmdLength];
            int readed = is.read(data);
            while (readed < cmdLength) {
                readed += is.read(data, readed, cmdLength - readed);
            }
            MBSARequest request = new MBSARequest(msgId, cmdId, data);
            this.debug("[readRequest] <<< " + request);
            return request;
        }
    }

    private void sendRsp(MBSAResponse rsp, OutputStream os) throws IOException {
        this.debug("[sendRsp] Send response >>> " + rsp);
        if (this.protocolVersion > 1) {
            try {
                rsp = new MBSAResponse(rsp.getId() | Integer.MIN_VALUE, rsp.getStatus(), rsp.getData()).done();
            }
            catch (MBSAException e) {
                this.info("[sendRsp] Failed to send response", e);
                rsp = new MBSAResponse(rsp.getId(), 16);
                rsp.writeString(e.toString());
                rsp.done();
            }
        }
        rsp.writeTo(os);
        os.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        MBSAServerImpl mBSAServerImpl = this;
        synchronized (mBSAServerImpl) {
            if (this.closed) {
                return;
            }
            this.closed = true;
        }
        this.running = false;
        try {
            this.input.close();
        }
        catch (IOException iOException) {}
        try {
            this.output.close();
        }
        catch (IOException iOException) {}
    }

    private final void debug(String message) {
        DebugUtils.debug(this, message);
    }

    private final void info(String message, Throwable t) {
        DebugUtils.info(this, message, t);
    }

    public boolean isClosed() {
        return this.closed;
    }
}

