/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.useradmin.impl.role;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.felix.useradmin.impl.role.UserImpl;
import org.osgi.service.useradmin.Group;
import org.osgi.service.useradmin.Role;
import org.osgi.service.useradmin.UserAdminPermission;

public class GroupImpl
extends UserImpl
implements Group {
    private static final long serialVersionUID = 5543895177109398569L;
    private final Object m_lock = new Object();
    private final Map m_members = new HashMap();
    private final Map m_requiredMembers = new HashMap();

    public GroupImpl(String name) {
        super(2, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addMember(Role role) {
        Role result;
        this.checkPermissions();
        String name = role.getName();
        Object object = this.m_lock;
        synchronized (object) {
            if (this.m_members.containsKey(name) || this.m_requiredMembers.containsKey(name)) {
                return false;
            }
            result = this.m_members.put(name, role);
        }
        return result == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addRequiredMember(Role role) {
        Role result;
        this.checkPermissions();
        String name = role.getName();
        Object object = this.m_lock;
        synchronized (object) {
            if (this.m_requiredMembers.containsKey(name) || this.m_members.containsKey(name)) {
                return false;
            }
            result = this.m_requiredMembers.put(name, role);
        }
        return result == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Role[] getMembers() {
        Role[] roles;
        Object object = this.m_lock;
        synchronized (object) {
            Collection values = this.m_members.values();
            roles = values.toArray(new Role[values.size()]);
        }
        return roles.length == 0 ? null : roles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Role[] getRequiredMembers() {
        Role[] roles;
        Object object = this.m_lock;
        synchronized (object) {
            Collection values = this.m_requiredMembers.values();
            roles = values.toArray(new Role[values.size()]);
        }
        return roles.length == 0 ? null : roles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeMember(Role role) {
        this.checkPermissions();
        String name = role.getName();
        Object result = null;
        Object object = this.m_lock;
        synchronized (object) {
            if (this.m_requiredMembers.containsKey(name)) {
                result = this.m_requiredMembers.remove(name);
            } else if (this.m_members.containsKey(name)) {
                result = this.m_members.remove(name);
            }
        }
        return result != null;
    }

    @Override
    public String toString() {
        return "Group(" + this.getName() + "): R{" + this.m_requiredMembers + "}, B{" + this.m_members + "}";
    }

    private void checkPermissions() throws SecurityException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new UserAdminPermission("admin", null));
        }
    }
}

