/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.core.net;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.kura.KuraErrorCode;
import org.eclipse.kura.KuraException;
import org.eclipse.kura.core.net.util.NetworkUtil;
import org.eclipse.kura.net.NetConfig;
import org.eclipse.kura.net.NetConfigIP4;
import org.eclipse.kura.net.NetInterface;
import org.eclipse.kura.net.NetInterfaceAddress;
import org.eclipse.kura.net.NetInterfaceAddressConfig;
import org.eclipse.kura.net.NetInterfaceState;
import org.eclipse.kura.net.NetInterfaceStatus;
import org.eclipse.kura.usb.UsbDevice;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractNetInterface<T extends NetInterfaceAddress>
implements NetInterface<T> {
    private static final Logger logger = LoggerFactory.getLogger(AbstractNetInterface.class);
    private String name;
    private byte[] hardwareAddress;
    private boolean loopback;
    private boolean pointToPoint;
    private boolean virtual;
    private boolean supportsMulticast;
    private boolean up;
    private int mtu;
    private UsbDevice usbDevice;
    private String driver;
    private String driverVersion;
    private String firmwareVersion;
    private NetInterfaceState state;
    private boolean autoConnect;
    private List<T> interfaceAddresses;

    protected AbstractNetInterface(String name) {
        this.name = name;
        this.interfaceAddresses = new ArrayList<T>();
    }

    protected AbstractNetInterface(NetInterface<? extends NetInterfaceAddress> other) {
        this.name = other.getName();
        this.hardwareAddress = other.getHardwareAddress();
        this.loopback = other.isLoopback();
        this.pointToPoint = other.isPointToPoint();
        this.virtual = other.isVirtual();
        this.supportsMulticast = other.supportsMulticast();
        this.up = other.isUp();
        this.mtu = other.getMTU();
        this.usbDevice = other.getUsbDevice();
        this.driver = other.getDriver();
        this.driverVersion = other.getDriverVersion();
        this.firmwareVersion = other.getFirmwareVersion();
        this.state = other.getState();
        this.autoConnect = other.isAutoConnect();
        this.interfaceAddresses = new ArrayList<T>();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public byte[] getHardwareAddress() {
        return this.hardwareAddress;
    }

    public boolean isLoopback() {
        return this.loopback;
    }

    public boolean isPointToPoint() {
        return this.pointToPoint;
    }

    public boolean isVirtual() {
        return this.virtual;
    }

    public boolean supportsMulticast() {
        return this.supportsMulticast;
    }

    public boolean isUp() {
        return this.up;
    }

    public int getMTU() {
        return this.mtu;
    }

    public void setMTU(int mtu) {
        this.mtu = mtu;
    }

    public String getDriver() {
        return this.driver;
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    public String getDriverVersion() {
        return this.driverVersion;
    }

    public void setDriverVersion(String driverVersion) {
        this.driverVersion = driverVersion;
    }

    public String getFirmwareVersion() {
        return this.firmwareVersion;
    }

    public void setFirmwareVersion(String firmwareVersion) {
        this.firmwareVersion = firmwareVersion;
    }

    public NetInterfaceState getState() {
        return this.state;
    }

    public void setState(NetInterfaceState state) {
        this.state = state;
    }

    public UsbDevice getUsbDevice() {
        return this.usbDevice;
    }

    public void setHardwareAddress(byte[] hardwareAddress) {
        this.hardwareAddress = hardwareAddress;
    }

    public void setLoopback(boolean loopback) {
        this.loopback = loopback;
    }

    public void setPointToPoint(boolean pointToPoint) {
        this.pointToPoint = pointToPoint;
    }

    public void setVirtual(boolean virtual) {
        this.virtual = virtual;
    }

    public void setSupportsMulticast(boolean supportsMulticast) {
        this.supportsMulticast = supportsMulticast;
    }

    public void setUp(boolean up) {
        this.up = up;
    }

    public void setUsbDevice(UsbDevice usbDevice) {
        this.usbDevice = usbDevice;
    }

    public boolean isAutoConnect() {
        return this.autoConnect;
    }

    public void setAutoConnect(boolean autoConnect) {
        this.autoConnect = autoConnect;
    }

    public List<T> getNetInterfaceAddresses() {
        if (this.interfaceAddresses != null) {
            return Collections.unmodifiableList(this.interfaceAddresses);
        }
        return Collections.emptyList();
    }

    public void setNetInterfaceAddresses(List<T> interfaceAddresses) {
        this.interfaceAddresses = interfaceAddresses;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("name=").append(this.name);
        if (this.hardwareAddress != null && this.hardwareAddress.length == 6) {
            sb.append(" :: hardwareAddress=").append(NetworkUtil.macToString(this.hardwareAddress));
        }
        sb.append(" :: loopback=").append(this.loopback).append(" :: pointToPoint=").append(this.pointToPoint).append(" :: virtual=").append(this.virtual).append(" :: supportsMulticast=").append(this.supportsMulticast).append(" :: up=").append(this.up).append(" :: mtu=").append(this.mtu);
        if (this.usbDevice != null) {
            sb.append(" :: usbDevice=").append(this.usbDevice);
        }
        sb.append(" :: driver=").append(this.driver).append(" :: driverVersion=").append(this.driverVersion).append(" :: firmwareVersion=").append(this.firmwareVersion).append(" :: state=").append(this.state).append(" :: autoConnect=").append(this.autoConnect);
        if (this.interfaceAddresses != null && !this.interfaceAddresses.isEmpty()) {
            sb.append(" :: InterfaceAddress=");
            for (NetInterfaceAddress interfaceAddress : this.interfaceAddresses) {
                sb.append(interfaceAddress).append(" ");
            }
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.autoConnect ? 1231 : 1237);
        result = 31 * result + (this.driver == null ? 0 : this.driver.hashCode());
        result = 31 * result + (this.driverVersion == null ? 0 : this.driverVersion.hashCode());
        result = 31 * result + (this.firmwareVersion == null ? 0 : this.firmwareVersion.hashCode());
        result = 31 * result + Arrays.hashCode(this.hardwareAddress);
        result = 31 * result + (this.interfaceAddresses == null ? 0 : this.interfaceAddresses.hashCode());
        result = 31 * result + (this.loopback ? 1231 : 1237);
        result = 31 * result + this.mtu;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.pointToPoint ? 1231 : 1237);
        result = 31 * result + (this.state == null ? 0 : this.state.hashCode());
        result = 31 * result + (this.supportsMulticast ? 1231 : 1237);
        result = 31 * result + (this.up ? 1231 : 1237);
        result = 31 * result + (this.usbDevice == null ? 0 : this.usbDevice.hashCode());
        result = 31 * result + (this.virtual ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AbstractNetInterface)) {
            return false;
        }
        AbstractNetInterface other = (AbstractNetInterface)obj;
        if (this.autoConnect != other.autoConnect) {
            return false;
        }
        if (this.driver == null ? other.driver != null : !this.driver.equals(other.driver)) {
            return false;
        }
        if (this.driverVersion == null ? other.driverVersion != null : !this.driverVersion.equals(other.driverVersion)) {
            return false;
        }
        if (this.firmwareVersion == null ? other.firmwareVersion != null : !this.firmwareVersion.equals(other.firmwareVersion)) {
            return false;
        }
        if (!Arrays.equals(this.hardwareAddress, other.hardwareAddress)) {
            return false;
        }
        if (this.interfaceAddresses == null ? other.interfaceAddresses != null : !this.interfaceAddresses.equals(other.interfaceAddresses)) {
            return false;
        }
        if (this.loopback != other.loopback) {
            return false;
        }
        if (this.mtu != other.mtu) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.pointToPoint != other.pointToPoint) {
            return false;
        }
        if (this.state != other.state) {
            return false;
        }
        if (this.supportsMulticast != other.supportsMulticast) {
            return false;
        }
        if (this.up != other.up) {
            return false;
        }
        if (this.usbDevice == null ? other.usbDevice != null : !this.usbDevice.equals(other.usbDevice)) {
            return false;
        }
        return this.virtual == other.virtual;
    }

    public NetInterfaceAddressConfig getNetInterfaceAddressConfig() throws KuraException {
        if (this.getNetInterfaceAddresses() == null || this.getNetInterfaceAddresses().isEmpty()) {
            throw new KuraException(KuraErrorCode.CONFIGURATION_ERROR, new Object[]{"Empty NetInterfaceAddressConfig list"});
        }
        return (NetInterfaceAddressConfig)this.getNetInterfaceAddresses().get(0);
    }

    public List<NetConfig> getNetConfigs() {
        List<Object> ret = new ArrayList<NetConfig>();
        try {
            List netConfigs = this.getNetInterfaceAddressConfig().getConfigs();
            if (netConfigs != null) {
                ret = netConfigs;
            }
        }
        catch (KuraException e) {
            logger.error("Failed to obtain NetConfigs", (Throwable)e);
        }
        return ret;
    }

    public NetInterfaceStatus getInterfaceStatus() {
        List<NetConfig> netConfigs = this.getNetConfigs();
        if (netConfigs == null) {
            return NetInterfaceStatus.netIPv4StatusUnknown;
        }
        NetInterfaceStatus status = NetInterfaceStatus.netIPv4StatusUnknown;
        for (NetConfig netConfig : netConfigs) {
            if (!(netConfig instanceof NetConfigIP4)) continue;
            status = ((NetConfigIP4)netConfig).getStatus();
            break;
        }
        return status;
    }

    public NetConfigIP4 getIP4config() {
        NetConfigIP4 netConfigIP4 = null;
        List<NetConfig> netConfigs = this.getNetConfigs();
        for (NetConfig netConfig : netConfigs) {
            if (!(netConfig instanceof NetConfigIP4)) continue;
            netConfigIP4 = (NetConfigIP4)netConfig;
            break;
        }
        return netConfigIP4;
    }

    public boolean isInterfaceManaged() {
        NetInterfaceStatus status = this.getInterfaceStatus();
        return status != NetInterfaceStatus.netIPv4StatusUnmanaged && status != NetInterfaceStatus.netIPv4StatusUnknown;
    }

    public boolean isInterfaceEnabled() {
        NetInterfaceStatus status = this.getInterfaceStatus();
        return status == NetInterfaceStatus.netIPv4StatusL2Only || status == NetInterfaceStatus.netIPv4StatusEnabledLAN || status == NetInterfaceStatus.netIPv4StatusEnabledWAN;
    }

    public boolean isInterfaceUnknown() {
        return this.getInterfaceStatus() == NetInterfaceStatus.netIPv4StatusUnknown;
    }
}

