/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.richtext.widget.internal;

import java.beans.PropertyChangeEvent;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.browser.BrowserFunction;
import org.polarsys.kitalpha.richtext.common.intf.MDERichTextWidget;
import org.polarsys.kitalpha.richtext.nebula.widget.MDENebulaBasedRichTextWidget;
import org.polarsys.kitalpha.richtext.widget.editor.intf.MDERichTextEditorCallback;
import org.polarsys.kitalpha.richtext.widget.internal.Activator;
import org.polarsys.kitalpha.richtext.widget.tools.manager.LinkManagerImpl;

public class ListenerInstaller {
    public void createAllListeners(MDENebulaBasedRichTextWidget widget) {
        this.createBeforePasteConfirmationDialogListener(widget);
        this.createOpenLinkListener(widget);
        this.createSaveListener(widget);
        this.createChangeNotificationHandlerListener(widget);
        this.createChangeContentListener(widget);
        this.createFocusEventListener(widget);
        this.createWorkspaceResourceSaveListener((MDERichTextWidget)widget);
    }

    public void installAllListeners(MDENebulaBasedRichTextWidget widget) {
        this.installBeforePasteConfirmationDialogListener(widget);
        this.installOpenLinkListener(widget);
        this.installSaveListener(widget);
        this.installChangeNotificationHandlerListener(widget);
        this.installChangeContentListener(widget);
        this.installFocusEventListener(widget);
    }

    protected void createBeforePasteConfirmationDialogListener(MDENebulaBasedRichTextWidget widget) {
        new BrowserFunction(widget.getBrowser(), "getConfirmCleanupMsg"){

            public Object function(Object[] arguments) {
                return "Press OK to clean the Non-XHTML before pasting.\n\nPress Cancel to paste text as it is (not recommended) or better use toolbar action \"Paste as plain text\"";
            }
        };
    }

    protected void installBeforePasteConfirmationDialogListener(MDENebulaBasedRichTextWidget widget) {
        StringBuilder script = new StringBuilder();
        script.append("editor = CKEDITOR.instances.editor;");
        script.append("editor.on('beforePaste', function (event) {");
        script.append("editor.lang.pastefromword.confirmCleanup = getConfirmCleanupMsg();");
        script.append("});");
        script.append("editor.on('beforeCommandExec', function (cmd) {");
        script.append("if(cmd.data.name == 'pastetext'){");
        script.append("editor.config.pasteFromWordPromptCleanup = false;");
        script.append("}});");
        script.append("editor.on('afterPaste', function (event) {");
        script.append("editor.config.pasteFromWordPromptCleanup = true;");
        script.append("});");
        if (!widget.executeScript(script.toString())) {
            Activator.getDefault().getLog().log((IStatus)new Status(2, "org.polarsys.kitalpha.richtext.widget", "Rich text widget can not install beforePaste/afterPaste/beforeCommandExec listeners!"));
        }
    }

    protected void createOpenLinkListener(final MDENebulaBasedRichTextWidget widget) {
        new BrowserFunction(widget.getBrowser(), "openLinks"){

            public Object function(Object[] arguments) {
                if (arguments != null && arguments.length > 0) {
                    Object[] objectArray = arguments;
                    int n = arguments.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object object = objectArray[n2];
                        new LinkManagerImpl((MDERichTextWidget)widget).openLink((String)object);
                        ++n2;
                    }
                }
                return null;
            }
        };
    }

    protected void installOpenLinkListener(MDENebulaBasedRichTextWidget widget) {
        StringBuilder scriptAddMenu = new StringBuilder();
        scriptAddMenu.append("  CKEDITOR.instances.editor.on('doubleclick', function(event)");
        scriptAddMenu.append("  {");
        scriptAddMenu.append("    var element = CKEDITOR.plugins.link.getSelectedLink( CKEDITOR.currentInstance ) || event.data.element;");
        scriptAddMenu.append("    if (element!=undefined &&  element.is( 'a' ) ) {");
        scriptAddMenu.append("      event.stop();");
        scriptAddMenu.append("      openLinks(element.getAttribute('href'));");
        scriptAddMenu.append("    }");
        scriptAddMenu.append("  }, null, null, 1);");
        scriptAddMenu.append("CKEDITOR.on( 'instanceReady', function(e) {");
        scriptAddMenu.append("CKEDITOR.instances.editor.addCommand(\"openLink\", {");
        scriptAddMenu.append("exec : function( editor ) {");
        scriptAddMenu.append("\t\t\tvar linkTag = editor.getSelection().getStartElement().getAscendant('a', true);");
        scriptAddMenu.append("          if (linkTag != null && linkTag.is('a')){ openLinks(linkTag.getAttribute('href'));}");
        scriptAddMenu.append("    }});");
        scriptAddMenu.append("\tvar openLink = {");
        scriptAddMenu.append("   label : 'Open Link',");
        scriptAddMenu.append("   command : 'openLink'");
        scriptAddMenu.append("\t};");
        scriptAddMenu.append("\tCKEDITOR.instances.editor.contextMenu.addListener( function( element, selection ) {");
        scriptAddMenu.append("\t   var linkTag = element.getAscendant('a', true);");
        scriptAddMenu.append("\t   if (linkTag != null && linkTag.is('a')){return { ");
        scriptAddMenu.append("     \topenLink : CKEDITOR.TRISTATE_ON ");
        scriptAddMenu.append("   };}");
        scriptAddMenu.append("\t});");
        scriptAddMenu.append("\tCKEDITOR.instances.editor.addMenuItems({");
        scriptAddMenu.append("  openLink : {");
        scriptAddMenu.append(" label : 'Open Link',");
        scriptAddMenu.append("      command : 'openLink',");
        scriptAddMenu.append("\t      group : 'link',");
        scriptAddMenu.append("\t      order : 1");
        scriptAddMenu.append("\t   }});");
        scriptAddMenu.append("});");
        if (!widget.executeScript(scriptAddMenu.toString())) {
            Activator.getDefault().getLog().log((IStatus)new Status(2, "org.polarsys.kitalpha.richtext.widget", "Rich text widget cannot install the open link command"));
        }
    }

    protected void createSaveListener(final MDENebulaBasedRichTextWidget widget) {
        new BrowserFunction(widget.getBrowser(), "saveContent"){

            public Object function(Object[] arguments) {
                widget.saveContent();
                return null;
            }
        };
    }

    protected void installSaveListener(MDENebulaBasedRichTextWidget widget) {
        StringBuilder script = new StringBuilder();
        script.append("CKEDITOR.instances.editor.on('blur', function () {");
        script.append("saveContent();");
        script.append("});");
        if (!widget.executeScript(script.toString())) {
            Activator.getDefault().getLog().log((IStatus)new Status(2, "org.polarsys.kitalpha.richtext.widget", "Rich text widget cannot install the save handler"));
        }
    }

    protected void createChangeNotificationHandlerListener(final MDENebulaBasedRichTextWidget widget) {
        new BrowserFunction(widget.getBrowser(), "changeHandler"){

            public Object function(Object[] arguments) {
                if (arguments != null && arguments.length > 0) {
                    PropertyChangeEvent event = new PropertyChangeEvent(widget, "widgetContent", null, arguments[0]);
                    widget.firePropertyChangeEvent(event);
                }
                return null;
            }
        };
    }

    protected void installChangeNotificationHandlerListener(MDENebulaBasedRichTextWidget widget) {
        StringBuilder script = new StringBuilder();
        script.append("CKEDITOR.instances.editor.on('blur', function () {");
        script.append("changeHandler(CKEDITOR.instances.editor.getData());");
        script.append("});");
        if (!widget.executeScript(script.toString())) {
            Activator.getDefault().getLog().log((IStatus)new Status(2, "org.polarsys.kitalpha.richtext.widget", "Rich text widget cannot install the notification handler"));
        }
    }

    protected void createChangeContentListener(final MDENebulaBasedRichTextWidget widget) {
        new BrowserFunction(widget.getBrowser(), "firePropertyChangeEvent"){

            public Object function(Object[] arguments) {
                if (!widget.isDirtyStateUpdated() && widget.isDirty()) {
                    widget.saveContent();
                    widget.setDirtyStateUpdated(true);
                }
                return null;
            }
        };
    }

    protected void installChangeContentListener(MDENebulaBasedRichTextWidget widget) {
        StringBuilder script = new StringBuilder();
        script.append("CKEDITOR.instances.editor.on('key', function () {");
        script.append("firePropertyChangeEvent();");
        script.append("});");
        if (!widget.executeScript(script.toString())) {
            Activator.getDefault().getLog().log((IStatus)new Status(2, "org.polarsys.kitalpha.richtext.widget", "Rich text widget cannot install firePropertyChangeEvent handler"));
        }
    }

    protected void createFocusEventListener(final MDENebulaBasedRichTextWidget widget) {
        new BrowserFunction(widget.getBrowser(), "resetDirtyState"){

            public Object function(Object[] arguments) {
                widget.setDirtyStateUpdated(false);
                return null;
            }
        };
    }

    protected void installFocusEventListener(MDENebulaBasedRichTextWidget widget) {
        StringBuilder script = new StringBuilder();
        script.append("CKEDITOR.instances.editor.on('focus', function () {");
        script.append("resetDirtyState();");
        script.append("});");
        if (!widget.executeScript(script.toString())) {
            Activator.getDefault().getLog().log((IStatus)new Status(2, "org.polarsys.kitalpha.richtext.widget", "Rich text widget cannot install resetDirtyState handler"));
        }
    }

    protected void createWorkspaceResourceSaveListener(MDERichTextWidget widget) {
        IConfigurationElement[] contributions = Platform.getExtensionRegistry().getConfigurationElementsFor("org.polarsys.kitalpha.richtext.widget.saveResourceCallback");
        if (contributions != null && contributions.length > 0) {
            IConfigurationElement[] iConfigurationElementArray = contributions;
            int n = contributions.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement c = iConfigurationElementArray[n2];
                try {
                    MDERichTextEditorCallback callback = (MDERichTextEditorCallback)c.createExecutableExtension("class");
                    callback.registerWorkspaceResourceSaveListener(widget);
                }
                catch (CoreException e) {
                    Status status = new Status(4, "org.polarsys.kitalpha.richtext.widget", e.getMessage(), (Throwable)e);
                    Activator.getDefault().getLog().log((IStatus)status);
                }
                ++n2;
            }
        }
    }
}

