/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.metadata.helpers;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.polarsys.kitalpha.ad.metadata.helpers.Contribution;
import org.polarsys.kitalpha.ad.metadata.helpers.ViewpointMetadata;
import org.polarsys.kitalpha.resourcereuse.emfscheme.helpers.ModelReuseHelper;

public class MetadataHelper {
    private static final Map<ResourceSet, ViewpointMetadata> instances = new HashMap<ResourceSet, ViewpointMetadata>();

    public static ViewpointMetadata getViewpointMetadata(final ResourceSet context) {
        ViewpointMetadata result = instances.get(context);
        if (result == null) {
            result = new ViewpointMetadata(context);
            instances.put(context, result);
            context.eAdapters().add((Object)new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    if (msg.getEventType() == 4 && context.getResources().isEmpty()) {
                        instances.remove(context);
                    }
                }
            });
        }
        return result;
    }

    public static boolean isMetadataResource(Resource resource) {
        return "afm".equals(resource.getURI().fileExtension());
    }

    public static boolean isMetadataResource(IResource resource) {
        return "afm".equals(resource.getFileExtension());
    }

    public static Resource initMetadata(Resource modelResource) {
        ResourceSet ctx = modelResource.getResourceSet();
        ViewpointMetadata metadata = MetadataHelper.getViewpointMetadata(ctx);
        Resource initMetadataStorage = metadata.initMetadataStorage();
        List<Contribution> contributions = Contribution.getContributions();
        for (Contribution contrib : contributions) {
            contrib.preUpdate(ctx);
        }
        for (Contribution contrib : contributions) {
            contrib.update(ctx);
        }
        for (Contribution contrib : contributions) {
            contrib.postUpdate(ctx);
        }
        return initMetadataStorage;
    }

    public static URI getExpectedMetadataStorageURI(URI uri) {
        if (uri.isPlatformResource()) {
            String path = uri.toPlatformString(true);
            if (path.contains(".")) {
                int index = path.lastIndexOf(46);
                path = String.valueOf(path.substring(0, index)) + "." + "afm";
            }
            return URI.createPlatformResourceURI((String)path, (boolean)true);
        }
        if (ModelReuseHelper.hasModelReuseScheme((URI)uri)) {
            return ModelReuseHelper.createMetatadaURI((URI)uri);
        }
        return uri.trimFileExtension().appendFileExtension("afm");
    }
}

