/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.composer.ui.launch;

import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchManager;
import org.polarsys.kitalpha.composer.extension.points.CodeManagerExtensions;

public final class CodeManagerLaunchConfigurationHelper {
    private static final String BINDING_MM_URI_CHILD = "businessMetamodelNsUriDeclaration";

    private CodeManagerLaunchConfigurationHelper() {
    }

    public static ILaunchConfiguration[] getAllCodeManagerLaunchConfigurations() throws CoreException {
        LinkedList<ILaunchConfiguration> result = new LinkedList<ILaunchConfiguration>();
        ILaunchConfiguration[] iLaunchConfigurationArray = CodeManagerLaunchConfigurationHelper.getLaunchManager().getLaunchConfigurations();
        int n = iLaunchConfigurationArray.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunchConfiguration launchConfiguration = iLaunchConfigurationArray[n2];
            if (launchConfiguration.getType() != null && launchConfiguration.getType().getIdentifier() != null && launchConfiguration.getType().getIdentifier().equals("org.polarsys.kitalpha.code.generation.manager.ui.launch.CodeManagerConfigurationType")) {
                result.add(launchConfiguration);
            }
            ++n2;
        }
        return result.toArray(new ILaunchConfiguration[result.size()]);
    }

    public static ILaunchConfiguration[] getAllCodeManagerLaunchConfigurations(String bindingId) throws CoreException {
        String bindingName = CodeManagerExtensions.getBindingConfigElementFromId((String)bindingId).getAttribute("Name");
        LinkedList<ILaunchConfiguration> result = new LinkedList<ILaunchConfiguration>();
        ILaunchConfiguration[] iLaunchConfigurationArray = CodeManagerLaunchConfigurationHelper.getAllCodeManagerLaunchConfigurations();
        int n = iLaunchConfigurationArray.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunchConfiguration configuration = iLaunchConfigurationArray[n2];
            String currentBindingName = configuration.getAttribute("generation_name", "");
            if (currentBindingName != null && currentBindingName.equals(bindingName)) {
                result.add(configuration);
            }
            ++n2;
        }
        return result.toArray(new ILaunchConfiguration[result.size()]);
    }

    public static ILaunchConfiguration[] getAllCodeManagerLaunchConfigurationsWithMMUri(String mmUri) throws CoreException {
        HashSet<ILaunchConfiguration> launchConfigurations = new HashSet<ILaunchConfiguration>();
        HashSet<String> bindingIds = new HashSet<String>();
        IConfigurationElement[] iConfigurationElementArray = CodeManagerExtensions.getAllBindingExtensions();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement binding = iConfigurationElementArray[n2];
            IConfigurationElement[] iConfigurationElementArray2 = binding.getChildren(BINDING_MM_URI_CHILD);
            int n3 = iConfigurationElementArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement businessMMUriDeclaration = iConfigurationElementArray2[n4];
                String uri = businessMMUriDeclaration.getAttribute("NsUri");
                if (uri != null && uri.equals(mmUri)) {
                    bindingIds.add(binding.getAttribute("Id"));
                }
                ++n4;
            }
            ++n2;
        }
        for (String id : bindingIds) {
            launchConfigurations.addAll(Arrays.asList(CodeManagerLaunchConfigurationHelper.getAllCodeManagerLaunchConfigurations(id)));
        }
        return launchConfigurations.toArray(new ILaunchConfiguration[launchConfigurations.size()]);
    }

    private static ILaunchManager getLaunchManager() {
        return DebugPlugin.getDefault().getLaunchManager();
    }
}

