/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.asserts;

import java.util.Arrays;
import org.eclipse.january.dataset.DTypeUtils;
import org.eclipse.january.dataset.Dataset;
import org.eclipse.january.dataset.IndexIterator;
import org.eclipse.january.dataset.ObjectDataset;
import org.eclipse.january.dataset.StringDataset;
import org.junit.Assert;
import org.junit.runner.Description;
import org.junit.runner.notification.RunListener;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.Suite;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.RunnerBuilder;

public class TestUtils {
    static RunListener listener = new RunListener(){

        public void testStarted(Description description) throws Exception {
            if (verbosity != Verbosity.QUIET) {
                System.out.println("Starting: " + description.getMethodName());
            }
            super.testStarted(description);
        }

        public void testFinished(Description description) throws Exception {
            super.testFinished(description);
            if (verbosity != Verbosity.QUIET) {
                System.out.println("Finished: " + description.getMethodName());
            }
        }
    };
    private static Verbosity verbosity = Verbosity.QUIET;

    public static void assertDatasetEquals(Dataset expected, Dataset actual) {
        TestUtils.assertDatasetEquals(expected, actual, true, 1.0E-12, 1.0E-12);
    }

    public static void assertDatasetEquals(Dataset expected, Dataset actual, boolean testDTypeAndItemSize) {
        TestUtils.assertDatasetEquals(expected, actual, testDTypeAndItemSize, 1.0E-12, 1.0E-12);
    }

    public static void assertDatasetEquals(Dataset expected, Dataset actual, double relTolerance, double absTolerance) {
        TestUtils.assertDatasetEquals(expected, actual, false, relTolerance, absTolerance);
    }

    public static void assertDatasetEquals(Dataset expected, Dataset actual, boolean testDTypeAndItemSize, double relTolerance, double absTolerance) {
        int dtype = expected.getDType();
        int eis = expected.getElementsPerItem();
        int ais = actual.getElementsPerItem();
        if (testDTypeAndItemSize) {
            Assert.assertEquals((String)"Type", (long)dtype, (long)actual.getDType());
            Assert.assertEquals((String)"Itemsize", (long)eis, (long)ais);
        }
        Assert.assertEquals((String)"Size", (long)expected.getSize(), (long)actual.getSize());
        try {
            Assert.assertArrayEquals((String)"Shape", (int[])expected.getShapeRef(), (int[])actual.getShapeRef());
        }
        catch (AssertionError e) {
            if (actual.getSize() == 1) {
                Assert.assertArrayEquals((String)"Shape", (int[])new int[0], (int[])actual.getShapeRef());
            }
            throw e;
        }
        IndexIterator et = expected.getIterator(true);
        IndexIterator at = actual.getIterator();
        int is = Math.max(eis, ais);
        int n = 0;
        if (DTypeUtils.isDTypeInteger((int)dtype)) {
            while (et.hasNext() && at.hasNext()) {
                int j = 0;
                while (j < is) {
                    long e = j >= eis ? 0L : expected.getElementLongAbs(et.index + j);
                    long a = j >= ais ? 0L : actual.getElementLongAbs(at.index + j);
                    Assert.assertEquals((String)("Value does not match at " + Arrays.toString(et.getPos()) + "; " + j + ": "), (long)e, (long)a);
                    ++j;
                }
                ++n;
            }
        } else if (DTypeUtils.isDTypeFloating((int)dtype)) {
            while (et.hasNext() && at.hasNext()) {
                int j = 0;
                while (j < is) {
                    double e = j >= eis ? 0.0 : expected.getElementDoubleAbs(et.index + j);
                    double a = j >= ais ? 0.0 : actual.getElementDoubleAbs(at.index + j);
                    TestUtils.assertEquals("Value does not match at " + Arrays.toString(et.getPos()) + "; " + j + ": ", e, a, relTolerance, absTolerance);
                    ++j;
                }
                ++n;
            }
        } else if (dtype == 0) {
            while (et.hasNext() && at.hasNext()) {
                int j = 0;
                while (j < is) {
                    boolean e = j >= eis ? false : expected.getElementBooleanAbs(et.index + j);
                    boolean a = j >= ais ? false : actual.getElementBooleanAbs(at.index + j);
                    Assert.assertEquals((String)("Value does not match at " + Arrays.toString(et.getPos()) + "; " + j + ": "), (Object)e, (Object)a);
                    ++j;
                }
                ++n;
            }
        } else if (dtype == 9) {
            StringDataset es = (StringDataset)expected;
            StringDataset as = (StringDataset)actual;
            while (et.hasNext() && at.hasNext()) {
                Assert.assertEquals((String)("Value does not match at " + Arrays.toString(et.getPos()) + ": "), (Object)es.getAbs(et.index), (Object)as.getAbs(at.index));
                ++n;
            }
        } else if (dtype == 10) {
            ObjectDataset eo = (ObjectDataset)expected;
            ObjectDataset ao = (ObjectDataset)actual;
            while (et.hasNext() && at.hasNext()) {
                Assert.assertEquals((String)("Value does not match at " + Arrays.toString(et.getPos()) + ": "), (Object)eo.getAbs(et.index), (Object)ao.getAbs(at.index));
                ++n;
            }
        } else {
            throw new IllegalArgumentException("Unknown or unsupported dataset type");
        }
        Assert.assertEquals((String)"Total items checked", (long)expected.getSize(), (long)n);
    }

    public static void assertEquals(String s, double e, double a) {
        TestUtils.assertEquals(s, e, a, 1.0E-14, 1.0E-20);
    }

    public static void assertEquals(String s, double e, double a, double relTol, double absTol) {
        double t = Math.max(absTol, relTol * Math.max(Math.abs(e), Math.abs(a)));
        Assert.assertEquals((String)s, (double)e, (double)a, (double)t);
    }

    public static void setVerbosity(Verbosity verbosity) {
        TestUtils.verbosity = verbosity;
    }

    public static void verbosePrintf(String fmt, Object ... args) {
        if (verbosity == Verbosity.VERBOSE) {
            System.out.printf(fmt, args);
        }
    }

    public static void verbosePrintln(String arg) {
        if (verbosity == Verbosity.VERBOSE) {
            System.out.println(arg);
        }
    }

    public static class VerboseSuite
    extends Suite {
        public VerboseSuite(Class<?> klass, RunnerBuilder builder) throws InitializationError {
            super(klass, builder);
        }

        public void run(RunNotifier notifier) {
            notifier.removeListener(listener);
            notifier.addListener(listener);
            super.run(notifier);
            notifier.removeListener(listener);
        }
    }

    public static enum Verbosity {
        QUIET,
        TEST_METHOD,
        VERBOSE;

    }
}

