/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.dataset;

import org.eclipse.january.dataset.IndexIterator;
import org.eclipse.january.dataset.ShapeUtils;
import org.eclipse.january.dataset.Slice;
import org.eclipse.january.dataset.SliceND;

public class PositionIterator
extends IndexIterator {
    private int offset;
    private final int[] shape;
    private final int[] start;
    private final int[] stop;
    private final int[] step;
    private final int endrank;
    private final boolean[] omit;
    private final int[] pos;
    private boolean once;
    private final boolean zero;

    public PositionIterator(int[] shape) {
        this(new SliceND(shape), null);
    }

    public PositionIterator(int offset, int[] shape) {
        this(offset, new SliceND(shape), null);
    }

    public PositionIterator(int[] shape, int ... axes) {
        this(new SliceND(shape), axes);
    }

    public PositionIterator(int[] shape, Slice[] slice, int[] axes) {
        this(new SliceND(shape, slice), axes);
    }

    public PositionIterator(int[] shape, int[] start, int[] stop, int[] step, int[] axes) {
        this(new SliceND(shape, start, stop, step), axes);
    }

    public PositionIterator(SliceND slice, int ... axes) {
        this(0, slice, axes);
    }

    public PositionIterator(int offset, SliceND slice, int ... axes) {
        this.offset = offset;
        int[] oshape = slice.getShape();
        this.start = slice.getStart();
        this.stop = slice.getStop();
        int[] nArray = this.step = slice.getStep();
        int n = this.step.length;
        int n2 = 0;
        while (n2 < n) {
            int s = nArray[n2];
            if (s < 0) {
                throw new UnsupportedOperationException("Negative steps not implemented");
            }
            ++n2;
        }
        int rank = oshape.length;
        this.endrank = rank - 1;
        this.omit = new boolean[rank];
        this.shape = (int[])oshape.clone();
        if (axes != null) {
            int[] nArray2 = axes;
            int n3 = axes.length;
            n = 0;
            while (n < n3) {
                int a = nArray2[n];
                if ((a = ShapeUtils.checkAxis(rank, a)) >= 0 && a <= this.endrank) {
                    this.omit[a] = true;
                    this.shape[a] = 1;
                } else if (a > this.endrank) {
                    throw new IllegalArgumentException("Specified axis exceeds dataset rank");
                }
                ++n;
            }
        }
        this.pos = new int[rank];
        this.zero = ShapeUtils.calcSize(this.shape) == 0;
        this.reset();
    }

    @Override
    public boolean hasNext() {
        if (this.zero) {
            return false;
        }
        if (this.once) {
            this.once = false;
            return true;
        }
        int j = this.endrank;
        while (j >= 0) {
            if (!this.omit[j]) {
                int n = j;
                this.pos[n] = this.pos[n] + this.step[j];
                if (this.pos[j] >= this.stop[j]) {
                    this.pos[j] = this.start[j];
                } else {
                    return true;
                }
            }
            --j;
        }
        return false;
    }

    @Override
    public int[] getPos() {
        return this.pos;
    }

    public boolean[] getOmit() {
        return this.omit;
    }

    @Override
    public void reset() {
        int i = 0;
        while (i <= this.endrank) {
            this.pos[i] = this.start[i];
            ++i;
        }
        if (this.zero) {
            return;
        }
        int j = 0;
        while (j <= this.endrank) {
            if (!this.omit[j]) break;
            ++j;
        }
        if (j > this.endrank) {
            this.once = true;
            return;
        }
        if (this.omit[this.endrank]) {
            this.pos[this.endrank] = this.start[this.endrank];
            int i2 = this.endrank - 1;
            while (i2 >= 0) {
                if (!this.omit[i2]) {
                    int n = i2;
                    this.pos[n] = this.pos[n] - this.step[i2];
                    break;
                }
                --i2;
            }
        } else {
            int n = this.endrank;
            this.pos[n] = this.pos[n] - this.step[this.endrank];
        }
        this.index = this.offset;
    }

    @Override
    public int[] getShape() {
        return this.shape;
    }

    public int[] getStop() {
        return this.stop;
    }
}

