/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.dataset;

import java.io.IOException;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.january.DatasetException;
import org.eclipse.january.IMonitor;
import org.eclipse.january.dataset.DTypeUtils;
import org.eclipse.january.dataset.Dataset;
import org.eclipse.january.dataset.DatasetUtils;
import org.eclipse.january.dataset.IDataset;
import org.eclipse.january.dataset.ILazyDataset;
import org.eclipse.january.dataset.LazyDatasetBase;
import org.eclipse.january.dataset.ShapeUtils;
import org.eclipse.january.dataset.Slice;
import org.eclipse.january.dataset.SliceND;
import org.eclipse.january.io.ILazyLoader;
import org.eclipse.january.metadata.MetadataFactory;
import org.eclipse.january.metadata.MetadataType;
import org.eclipse.january.metadata.OriginMetadata;
import org.eclipse.january.metadata.Reshapeable;
import org.eclipse.january.metadata.Sliceable;
import org.eclipse.january.metadata.Transposable;

public class LazyDataset
extends LazyDatasetBase
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 2467865859867440242L;
    protected int[] oShape;
    protected long size;
    protected int dtype;
    protected int isize;
    protected ILazyLoader loader;
    protected LazyDataset base = null;
    protected int prepShape = 0;
    protected int postShape = 0;
    protected int[] begSlice = null;
    protected int[] delSlice = null;
    protected int[] map;
    protected Map<Class<? extends MetadataType>, List<MetadataType>> oMetadata = null;

    public LazyDataset(String name, int dtype, int elements, int[] shape, ILazyLoader loader) {
        this.name = name;
        this.shape = (int[])shape.clone();
        this.oShape = this.shape;
        this.loader = loader;
        this.dtype = dtype;
        this.isize = elements;
        try {
            this.size = ShapeUtils.calcLongSize(shape);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.size = Long.MAX_VALUE;
        }
    }

    public LazyDataset(String name, int dtype, int[] shape, ILazyLoader loader) {
        this(name, dtype, 1, shape, loader);
    }

    public static LazyDataset createLazyDataset(Dataset dataset) {
        return new LazyDataset(dataset.getName(), dataset.getDType(), dataset.getElementsPerItem(), dataset.getShape(), new ILazyLoader(dataset){
            private static final long serialVersionUID = -6725268922780517523L;
            final Dataset d;
            {
                this.d = dataset;
            }

            @Override
            public boolean isFileReadable() {
                return true;
            }

            @Override
            public Dataset getDataset(IMonitor mon, SliceND slice) throws IOException {
                return this.d.getSlice(mon, slice);
            }
        });
    }

    @Override
    public int getDType() {
        return this.dtype;
    }

    @Override
    public int getElementsPerItem() {
        return this.isize;
    }

    @Override
    public int getSize() {
        return (int)this.size;
    }

    public String toString() {
        int rank;
        StringBuilder out = new StringBuilder();
        if (this.name != null && this.name.length() > 0) {
            out.append("Lazy dataset '");
            out.append(this.name);
            out.append("' has shape [");
        } else {
            out.append("Lazy dataset shape is [");
        }
        int n = rank = this.shape == null ? 0 : this.shape.length;
        if (rank > 0 && this.shape[0] >= 0) {
            out.append(this.shape[0]);
        }
        int i = 1;
        while (i < rank) {
            out.append(", " + this.shape[i]);
            ++i;
        }
        out.append(']');
        return out.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        LazyDataset other = (LazyDataset)obj;
        if (this.dtype != other.dtype) {
            return false;
        }
        if (this.isize != other.isize) {
            return false;
        }
        if (!Arrays.equals(this.shape, other.shape)) {
            return false;
        }
        if (this.loader != other.loader) {
            return false;
        }
        if (this.prepShape != other.prepShape) {
            return false;
        }
        if (this.postShape != other.postShape) {
            return false;
        }
        if (!Arrays.equals(this.begSlice, other.begSlice)) {
            return false;
        }
        if (!Arrays.equals(this.delSlice, other.delSlice)) {
            return false;
        }
        return Arrays.equals(this.map, other.map);
    }

    @Override
    public LazyDataset clone() {
        LazyDataset ret = new LazyDataset(new String(this.name), this.dtype, this.isize, this.oShape, this.loader);
        ret.shape = this.shape;
        ret.size = this.size;
        ret.prepShape = this.prepShape;
        ret.postShape = this.postShape;
        ret.begSlice = this.begSlice;
        ret.delSlice = this.delSlice;
        ret.map = this.map;
        ret.base = this.base;
        ret.metadata = this.copyMetadata();
        ret.oMetadata = this.oMetadata;
        return ret;
    }

    @Override
    public void setShape(int ... shape) {
        this.setShapeInternal(shape);
    }

    @Override
    public LazyDataset squeezeEnds() {
        this.setShapeInternal(ShapeUtils.squeezeShape(this.shape, true));
        return this;
    }

    @Override
    public Dataset getSlice(int[] start, int[] stop, int[] step) throws DatasetException {
        return this.getSlice(null, start, stop, step);
    }

    @Override
    public Dataset getSlice(Slice ... slice) throws DatasetException {
        if (slice == null || slice.length == 0) {
            return this.getSlice(null, new SliceND(this.shape));
        }
        return this.getSlice(null, new SliceND(this.shape, slice));
    }

    @Override
    public Dataset getSlice(SliceND slice) throws DatasetException {
        return this.getSlice(null, slice);
    }

    @Override
    public Dataset getSlice(IMonitor monitor, Slice ... slice) throws DatasetException {
        if (slice == null || slice.length == 0) {
            return this.getSlice(monitor, new SliceND(this.shape));
        }
        return this.getSlice(monitor, new SliceND(this.shape, slice));
    }

    @Override
    public LazyDataset getSliceView(Slice ... slice) {
        if (slice == null || slice.length == 0) {
            return this.getSliceView(new SliceND(this.shape));
        }
        return this.getSliceView(new SliceND(this.shape, slice));
    }

    private void setShapeInternal(int ... nShape) {
        long nsize = ShapeUtils.calcLongSize(nShape);
        if (nsize != this.size) {
            throw new IllegalArgumentException("Size of new shape is not equal to current size");
        }
        if (nsize == 1L) {
            this.shape = (int[])nShape.clone();
            return;
        }
        int ob = -1;
        int or = this.shape.length;
        int i = 0;
        while (i < or) {
            if (this.shape[i] != 1) {
                ob = i;
                break;
            }
            ++i;
        }
        assert (ob >= 0);
        int oe = -1;
        int i2 = or - 1;
        while (i2 >= ob) {
            if (this.shape[i2] != 1) {
                oe = i2;
                break;
            }
            --i2;
        }
        assert (oe >= 0);
        ++oe;
        int nb = -1;
        int nr = nShape.length;
        int i3 = 0;
        while (i3 < nr) {
            if (nShape[i3] != 1) {
                nb = i3;
                break;
            }
            ++i3;
        }
        i3 = ob;
        int j = nb;
        if (this.begSlice == null) {
            while (i3 < oe && j < nr) {
                if (this.shape[i3] != nShape[j]) {
                    throw new IllegalArgumentException("New shape not allowed - can only change shape by adding or removing ones to ends of old shape");
                }
                ++i3;
                ++j;
            }
        } else {
            int[] nBegSlice = new int[nr];
            int[] nDelSlice = new int[nr];
            Arrays.fill(nDelSlice, 1);
            while (i3 < oe && j < nr) {
                if (this.shape[i3] != nShape[j]) {
                    throw new IllegalArgumentException("New shape not allowed - can only change shape by adding or removing ones to ends of old shape");
                }
                nBegSlice[j] = this.begSlice[i3];
                nDelSlice[j] = this.delSlice[i3];
                ++i3;
                ++j;
            }
            this.begSlice = nBegSlice;
            this.delSlice = nDelSlice;
        }
        this.prepShape += nb - ob;
        this.postShape += nr - oe;
        this.storeMetadata(this.metadata, Reshapeable.class);
        this.metadata = this.copyMetadata();
        this.reshapeMetadata(this.shape, nShape);
        this.shape = nShape;
    }

    @Override
    public LazyDataset getSliceView(int[] start, int[] stop, int[] step) {
        return this.getSliceView(new SliceND(this.shape, start, stop, step));
    }

    @Override
    public LazyDataset getSliceView(SliceND slice) {
        LazyDataset view = this.clone();
        if (slice.isAll()) {
            return view;
        }
        int[] lstart = slice.getStart();
        int[] lstep = slice.getStep();
        int rank = this.shape.length;
        int[] nShape = slice.getShape();
        view.shape = nShape;
        view.size = ShapeUtils.calcLongSize(nShape);
        if (this.begSlice == null) {
            view.begSlice = (int[])lstart.clone();
            view.delSlice = (int[])lstep.clone();
        } else {
            view.begSlice = new int[rank];
            view.delSlice = new int[rank];
            int i = 0;
            while (i < rank) {
                view.begSlice[i] = this.begSlice[i] + lstart[i] * this.delSlice[i];
                view.delSlice[i] = this.delSlice[i] * lstep[i];
                ++i;
            }
        }
        view.storeMetadata(this.metadata, Sliceable.class);
        view.sliceMetadata(true, slice);
        return view;
    }

    @Override
    public LazyDataset getTransposedView(int ... axes) {
        LazyDataset view = this.clone();
        if ((axes = LazyDataset.checkPermutatedAxes(this.shape, axes)) == null) {
            return view;
        }
        int r = this.shape.length;
        view.shape = new int[r];
        int i = 0;
        while (i < r) {
            view.shape[i] = this.shape[axes[i]];
            ++i;
        }
        view.prepShape = 0;
        view.postShape = 0;
        view.begSlice = null;
        view.delSlice = null;
        view.map = axes;
        view.base = this;
        view.storeMetadata(this.metadata, Transposable.class);
        view.transposeMetadata(axes);
        return view;
    }

    @Override
    public Dataset getSlice(IMonitor monitor, int[] start, int[] stop, int[] step) throws DatasetException {
        return this.getSlice(monitor, new SliceND(this.shape, start, stop, step));
    }

    @Override
    public Dataset getSlice(IMonitor monitor, SliceND slice) throws DatasetException {
        Dataset a;
        if (this.loader != null && !this.loader.isFileReadable()) {
            return null;
        }
        SliceND nslice = this.calcTrueSlice(slice);
        if (this.base != null) {
            a = this.base.getSlice(monitor, nslice);
        } else {
            try {
                a = DatasetUtils.convertToDataset(this.loader.getDataset(monitor, nslice));
            }
            catch (IOException e) {
                logger.error("Problem getting {}: {}", (Object)String.format("slice %s %s %s from %s", Arrays.toString(slice.getStart()), Arrays.toString(slice.getStop()), Arrays.toString(slice.getStep()), this.loader), (Object)e);
                throw new DatasetException(e);
            }
            a.setName(String.valueOf(this.name) + '[' + nslice.toString() + ']');
            if (this.metadata != null && a instanceof LazyDatasetBase) {
                LazyDatasetBase ba = (LazyDatasetBase)((Object)a);
                ba.metadata = this.copyMetadata();
                if (this.oMetadata != null) {
                    ba.restoreMetadata(this.oMetadata);
                }
                if (!nslice.isAll() || nslice.getMaxShape() != nslice.getShape()) {
                    ba.sliceMetadata(true, nslice);
                }
            }
        }
        if (this.map != null) {
            a = a.getTransposedView(this.map);
        }
        if (slice != null) {
            a.setShape(slice.getShape());
        }
        a.addMetadata(MetadataFactory.createMetadata(OriginMetadata.class, this, nslice.convertToSlice(), this.oShape, null, this.name));
        return a;
    }

    private int[] getOriginal(int[] values) {
        if (values == null) {
            return null;
        }
        int r = values.length;
        if (this.map == null || r < 2) {
            return values;
        }
        int[] ovalues = new int[r];
        int i = 0;
        while (i < r) {
            ovalues[this.map[i]] = values[i];
            ++i;
        }
        return ovalues;
    }

    /*
     * Unable to fully structure code
     */
    protected final SliceND calcTrueSlice(SliceND slice) {
        block9: {
            if (slice == null) {
                slice = new SliceND(this.shape);
            }
            lstart = slice.getStart();
            lstop = slice.getStop();
            lstep = slice.getStep();
            r = this.base == null ? this.oShape.length : this.base.shape.length;
            nstart = new int[r];
            nstop = new int[r];
            nstep = new int[r];
            Arrays.fill(nstop, 1);
            Arrays.fill(nstep, 1);
            i = 0;
            j = 0;
            if (this.prepShape < 0) {
                i = -this.prepShape;
            } else if (this.prepShape > 0) {
                j = this.prepShape;
            }
            if (this.begSlice != null) ** GOTO lbl44
            while (i < r && j < this.shape.length) {
                nstart[i] = lstart[j];
                nstop[i] = lstop[j];
                d = lstep[j];
                if (d < 0 && nstop[i] < 0) {
                    l = this.base == null ? this.oShape[j] : this.base.shape[j];
                    v0 = i;
                    nstop[v0] = nstop[v0] - l;
                }
                nstep[i] = d;
                ++i;
                ++j;
            }
            break block9;
lbl-1000:
            // 1 sources

            {
                b = this.begSlice[j];
                d = this.delSlice[j];
                nstart[i] = b + lstart[j] * d;
                nstop[i] = b + (lstop[j] - 1) * d + (d >= 0 ? 1 : -1);
                if (d < 0 && nstop[i] < 0) {
                    l = this.base == null ? this.oShape[j] : this.base.shape[j];
                    v1 = i;
                    nstop[v1] = nstop[v1] - l;
                }
                nstep[i] = lstep[j] * d;
                ++i;
                ++j;
lbl44:
                // 2 sources

                ** while (i < r && j < this.shape.length)
            }
        }
        if (this.map != null) {
            nstart = this.getOriginal(nstart);
            nstop = this.getOriginal(nstop);
            nstep = this.getOriginal(nstep);
        }
        return this.createSlice(nstart, nstop, nstep);
    }

    protected final IDataset transformInput(IDataset data) {
        if (this.map == null) {
            return data;
        }
        return data.getTransposedView(this.map);
    }

    protected SliceND createSlice(int[] nstart, int[] nstop, int[] nstep) {
        return new SliceND(this.base == null ? this.oShape : this.base.shape, nstart, nstop, nstep);
    }

    private void storeMetadata(Map<Class<? extends MetadataType>, List<MetadataType>> origMetadata, Class<? extends Annotation> aclazz) {
        List<Class<? extends MetadataType>> mclazzes = this.findAnnotatedMetadata(aclazz);
        if (mclazzes.size() == 0) {
            return;
        }
        if (this.oMetadata == null) {
            this.oMetadata = new HashMap<Class<? extends MetadataType>, List<MetadataType>>();
        }
        for (Class<? extends MetadataType> mc : mclazzes) {
            if (this.oMetadata.containsKey(mc)) continue;
            List<MetadataType> l = origMetadata.get(mc);
            ArrayList<MetadataType> nl = new ArrayList<MetadataType>(l.size());
            for (MetadataType m : l) {
                nl.add(m.clone());
            }
            this.oMetadata.put(mc, nl);
        }
    }

    private List<Class<? extends MetadataType>> findAnnotatedMetadata(Class<? extends Annotation> aclazz) {
        ArrayList<Class<? extends MetadataType>> mclazzes = new ArrayList<Class<? extends MetadataType>>();
        if (this.metadata == null) {
            return mclazzes;
        }
        for (Class c : this.metadata.keySet()) {
            boolean hasAnn = false;
            for (MetadataType m : (List)this.metadata.get(c)) {
                if (m == null) continue;
                Class<?> mc = m.getClass();
                do {
                    Field[] fieldArray = mc.getDeclaredFields();
                    int n = fieldArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Field f = fieldArray[n2];
                        if (f.isAnnotationPresent(aclazz)) {
                            hasAnn = true;
                            break;
                        }
                        ++n2;
                    }
                    Class<?> sclazz = mc.getSuperclass();
                    if (!MetadataType.class.isAssignableFrom(sclazz)) break;
                    mc = sclazz;
                } while (!hasAnn);
                if (hasAnn) break;
            }
            if (!hasAnn) continue;
            mclazzes.add(c);
        }
        return mclazzes;
    }

    public static int getMaxSliceLength(ILazyDataset lazySet, int dimension) {
        double size = DTypeUtils.getItemBytes(DTypeUtils.getDTypeFromClass(lazySet.getElementClass()), lazySet.getElementsPerItem());
        double max = Math.max(Runtime.getRuntime().totalMemory(), Runtime.getRuntime().maxMemory());
        double space = max / (double)lazySet.getSize();
        int[] shape = lazySet.getShape();
        if (space >= size) {
            return shape[dimension];
        }
        double sizeOneSlice = size;
        int dim = 0;
        while (dim < shape.length) {
            if (dim != dimension) {
                sizeOneSlice *= (double)shape[dim];
            }
            ++dim;
        }
        double avail = max / sizeOneSlice;
        if (avail < 1.0) {
            return 1;
        }
        return (int)Math.floor(avail / 4.0);
    }
}

