/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.javamail.ee.internetaddress;

import com.sun.ts.lib.harness.Status;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.common.base.ServiceEETest;
import com.sun.ts.tests.javamail.ee.common.MailTestUtil;
import jakarta.mail.Session;
import jakarta.mail.internet.ContentType;
import jakarta.mail.internet.HeaderTokenizer;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.internet.ParameterList;
import java.io.Serializable;
import java.util.Properties;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Tags;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
@Tags(value={@Tag(value="mail"), @Tag(value="platform")})
public class internetaddress_Test
extends ServiceEETest
implements Serializable {
    private String mailTo = null;
    private int errors;
    private transient Status status;
    private transient Session session;
    private String[] addrlist = new String[]{"ksnijjar@eng", "ksnijjar@eng.sun.com", "French@physicists", "cannot@waste", "us/@mhs-mci.ebay", "it@is", "tower@ihug.co.nz", "root@mxrelay.lanminds.com", "javaworld", "xx.zzz12@fea.net", "javamail-api-eng@icdev", "ksnijjar@java-test.Eng.Sun.COM"};
    private transient TestCase[] testCases = new TestCase[]{new TestCase(';', "a=b c", "b c"), new TestCase(';', "a=b c; d=e f", "b c"), new TestCase(';', "a=\"b c\"; d=e f", "b c")};
    private transient TestCase[] testCasesEsc = new TestCase[]{new TestCase(';', "a=b \\c", "b \\c"), new TestCase(';', "a=b c; d=e f", "b c"), new TestCase(';', "a=\"b \\c\"; d=e f", "b \\c")};
    static boolean return_comments = false;
    static boolean mime = false;
    public String value = "ggere, /tmp/mail.out, +mailbox, ~user/mailbox, ~/mailbox, /PN=x400.address/PRMD=ibmmail/ADMD=ibmx400/C=us/@mhs-mci.ebay, C'est bien moche <paris@france>, Mad Genius <george@boole>, two@weeks (It Will Take), /tmp/mail.out, laborious (But Bug Free), cannot@waste (My, Intellectual, Cycles), users:get,what,they,deserve;, it (takes, no (time, at) all), if@you (could, see (almost, as, (badly, you) would) agree), famous <French@physicists>, it@is (brilliant (genius, and) superb), confused (about, being, french)";

    public void setup(String[] args, Properties props) throws Exception {
        try {
            this.mailTo = props.getProperty("mailuser1");
            if (this.mailTo.length() == 0) {
                throw new Exception("Invalid mailuser1 - the mail to property");
            }
            String protocol = TestUtil.getProperty((String)"javamail.protocol");
            String host = TestUtil.getProperty((String)"javamail.server");
            String user = TestUtil.getProperty((String)"javamail.username");
            String password = TestUtil.getProperty((String)"javamail.password");
            String mailbox = TestUtil.getProperty((String)"javamail.mailbox");
            String rootPath = TestUtil.getProperty((String)"javamail.root.path");
            String smtpPortStr = TestUtil.getProperty((String)"smtp.port");
            int smtpPort = Integer.parseInt(smtpPortStr);
            TestUtil.logTrace((String)("SMTP Port = " + smtpPort));
            String imapPortStr = TestUtil.getProperty((String)"imap.port");
            int imapPort = Integer.parseInt(imapPortStr);
            TestUtil.logTrace((String)("IMAP Port = " + imapPort));
            MailTestUtil mailTestUtil = new MailTestUtil();
            this.session = mailTestUtil.createSession(host, smtpPortStr, user, password);
        }
        catch (Exception e) {
            this.logErr("Exception : " + e.getMessage());
            this.logErr("Setup Failed!");
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    public void testUtilMethods1() throws Exception {
        try {
            InternetAddress addr = new InternetAddress(this.mailTo);
            TestUtil.logTrace((String)"\nUNIT TEST 1:  toString()");
            TestUtil.logTrace((String)addr.toString());
            if (addr.toString() == null) {
                TestUtil.logTrace((String)"UNIT TEST 1:  failed\n");
                throw new Exception("toString returned null");
            }
            TestUtil.logTrace((String)"UNIT TEST 1:  passed\n");
        }
        catch (Exception e) {
            this.logErr("Unexpected Exception " + e.getMessage());
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("Call to testUtilMethods1() Failed!", e);
        }
    }

    public void testUtilMethods2() throws Exception {
        try {
            InternetAddress addr = new InternetAddress(this.mailTo);
            TestUtil.logTrace((String)"UNIT TEST 1:  equals()\n");
            if (!addr.toString().equals(addr.toString())) {
                TestUtil.logTrace((String)"UNIT TEST 1:  FAILED\n");
                throw new Exception("equals util method failed");
            }
            TestUtil.logTrace((String)"UNIT TEST 1:  passed\n");
        }
        catch (Exception e) {
            this.logErr("Unexpected Exception " + e.getMessage());
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("Call to testUtilMethods2() Failed!", e);
        }
    }

    public void testgetAddress() throws Exception {
        try {
            for (int i = 0; i < this.addrlist.length; ++i) {
                InternetAddress addr = new InternetAddress(this.addrlist[i]);
                if (addr == null) {
                    throw new Exception("Invalid/Null InternetAddress object!");
                }
                TestUtil.logTrace((String)("\nUNIT TEST :" + (i + 1) + " getAddress()"));
                String strname = addr.getAddress();
                if (strname == null) continue;
                if (strname.equals(this.addrlist[i])) {
                    TestUtil.logTrace((String)("Address = " + strname));
                    TestUtil.logTrace((String)("UNIT TEST " + (i + 1) + ": passed\n"));
                    continue;
                }
                throw new Exception("UNIT TEST " + (i + 1) + ": FAILED\n");
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected Exception " + e.getMessage());
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("Call to testgetAddress() Failed!", e);
        }
    }

    public void testgetPersonal() throws Exception {
        try {
            TestUtil.logTrace((String)"\nUNIT TEST 1:  getPersonal()");
            InternetAddress addr = new InternetAddress();
            addr.setPersonal("the quick fox jumped over the lazy cow.");
            String personal1 = addr.getPersonal();
            addr.setPersonal("hotmail ~!@,#$%^&*.+=,<.>?", "US-ASCII");
            String personal2 = addr.getPersonal();
            if (personal1 == null || personal2 == null) {
                TestUtil.logTrace((String)"UNIT TEST 1: FAILED\n");
                throw new Exception("Failed!");
            }
            TestUtil.logTrace((String)personal1);
            TestUtil.logTrace((String)personal2);
            TestUtil.logTrace((String)"UNIT TEST 1: passed\n");
        }
        catch (Exception e) {
            this.logErr("Unexpected Exception " + e.getMessage());
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("Call to testgetPersonal() Failed!", e);
        }
    }

    public void contentTypeTest() throws Exception {
        TestUtil.logMsg((String)"\nTesting class ContentType: ContentType(void|String|ParameterList)\n");
        try {
            TestUtil.logMsg((String)"UNIT TEST 1:  ContentType()");
            ContentType ct1 = new ContentType();
            if (ct1.toString() != null) {
                TestUtil.logMsg((String)"UNIT TEST 1: passed");
            } else {
                TestUtil.logMsg((String)"UNIT TEST 1: FAILED");
                ++this.errors;
            }
            String pattern = "text/plain;charset=us-ascii;i18set=ISO-9000-2";
            TestUtil.logMsg((String)("UNIT TEST 2:  ContentType(" + pattern + ")"));
            ContentType ct2 = new ContentType(pattern);
            if (ct2.toString() != null) {
                TestUtil.logMsg((String)"UNIT TEST 2: passed");
            } else {
                TestUtil.logMsg((String)"UNIT TEST 2: FAILED");
                ++this.errors;
            }
            String primaryType = "text";
            String subType = "plain";
            TestUtil.logMsg((String)("UNIT TEST 3:  ContentType(" + primaryType + "," + subType + ")"));
            ContentType ct3 = new ContentType(primaryType, subType, null);
            if (ct3.toString().equals(primaryType + "/" + subType)) {
                TestUtil.logMsg((String)"UNIT TEST 3: passed");
            } else {
                TestUtil.logMsg((String)"UNIT TEST 3: FAILED");
                ++this.errors;
            }
            ParameterList pl = new ParameterList(";charset=uscii");
            TestUtil.logMsg((String)("UNIT TEST 4:  ContentType(" + primaryType + "," + subType + "," + pl + ")"));
            ContentType ct4 = new ContentType(primaryType, subType, pl);
            if (ct4.toString() != null) {
                TestUtil.logMsg((String)"UNIT TEST 4: passed");
            } else {
                TestUtil.logMsg((String)"UNIT TEST 4: FAILED");
                ++this.errors;
            }
            this.checkStatus();
            if (this.errors > 0) {
                throw new Exception("contentType_Test Failed: No of unit test failed = " + this.errors);
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected Exception " + e.getMessage());
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("contentType_Test() Failed!", e);
        }
    }

    public void nextTest() throws Exception {
        TestUtil.logMsg((String)"\nTesting class HeaderTokenizer: next()\n");
        try {
            HeaderTokenizer.Token tok;
            HeaderTokenizer ht = new HeaderTokenizer(this.value, mime ? "()<>@,;:\\\"\t []/?=" : "()<>@,;:\\\"\t .[]", !return_comments);
            TestUtil.logMsg((String)"UNIT TEST 1: next()");
            while ((tok = ht.next()).getType() != -4) {
                if (tok.getType() != 0 && tok.getValue() != null) continue;
                TestUtil.logMsg((String)("\t" + internetaddress_Test.type(tok.getType()) + "\t" + tok.getValue()));
                TestUtil.logMsg((String)"UNIT TEST 1: Failed.\n");
                ++this.errors;
                break;
            }
            if (this.errors == 0) {
                TestUtil.logMsg((String)"UNIT TEST 1: passed.\n");
            }
            TestUtil.logMsg((String)"UNIT TEST 2: next(endOfAtom)");
            int start = this.errors;
            for (TestCase tc : this.testCases) {
                ht = new HeaderTokenizer(tc.test, "()<>@,;:\\\"\t []/?=", true);
                tok = ht.next();
                if (tok.getType() != -1 || !tok.getValue().equals("a")) {
                    TestUtil.logMsg((String)("\t" + internetaddress_Test.type(tok.getType()) + "\t" + tok.getValue()));
                    TestUtil.logMsg((String)"UNIT TEST 2: Failed.\n");
                    ++this.errors;
                    break;
                }
                tok = ht.next();
                if (tok.getType() != 61) {
                    TestUtil.logMsg((String)("\t" + internetaddress_Test.type(tok.getType()) + "\t" + tok.getValue()));
                    TestUtil.logMsg((String)"UNIT TEST 2: Failed.\n");
                    ++this.errors;
                    break;
                }
                tok = ht.next(tc.endOfAtom);
                if (tok.getType() == -2 && tok.getValue().equals(tc.expected)) continue;
                TestUtil.logMsg((String)("\t" + internetaddress_Test.type(tok.getType()) + "\t" + tok.getValue()));
                TestUtil.logMsg((String)"UNIT TEST 2: Failed.\n");
                ++this.errors;
                break;
            }
            if (this.errors == start) {
                TestUtil.logMsg((String)"UNIT TEST 2: passed.\n");
            }
            TestUtil.logMsg((String)"UNIT TEST 3: next(endOfAtom, true)");
            start = this.errors;
            for (TestCase tc : this.testCasesEsc) {
                ht = new HeaderTokenizer(tc.test, "()<>@,;:\\\"\t []/?=", true);
                tok = ht.next();
                if (tok.getType() != -1 || !tok.getValue().equals("a")) {
                    TestUtil.logMsg((String)("\t" + internetaddress_Test.type(tok.getType()) + "\t" + tok.getValue()));
                    TestUtil.logMsg((String)"UNIT TEST 3: Failed.\n");
                    ++this.errors;
                    break;
                }
                tok = ht.next();
                if (tok.getType() != 61) {
                    TestUtil.logMsg((String)("\t" + internetaddress_Test.type(tok.getType()) + "\t" + tok.getValue()));
                    TestUtil.logMsg((String)"UNIT TEST 3: Failed.\n");
                    ++this.errors;
                    break;
                }
                tok = ht.next(tc.endOfAtom, true);
                if (tok.getType() == -2 && tok.getValue().equals(tc.expected)) continue;
                TestUtil.logMsg((String)("\t" + internetaddress_Test.type(tok.getType()) + "\t" + tok.getValue()));
                TestUtil.logMsg((String)"UNIT TEST 3: Failed.\n");
                ++this.errors;
                break;
            }
            if (this.errors == start) {
                TestUtil.logMsg((String)"UNIT TEST 3: passed.\n");
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected Exception " + e.getMessage());
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("next_Test() Failed!", e);
        }
        this.checkStatus();
        if (this.errors > 0) {
            throw new Exception("contentType_Test Failed: No of unit test failed = " + this.errors);
        }
    }

    public void combineSegmentsTest() throws Exception {
        String pattern = ";i18set=ISO-8859-1;charset=us-acii;abc=xyz";
        TestUtil.logMsg((String)"\nTesting method ParameterList.combineSegments()\n");
        try {
            TestUtil.logMsg((String)"UNIT TEST 1:  ParameterList.combineSegments()");
            System.setProperty("mail.mime.decodeparameters", "true");
            ParameterList parmlist1 = new ParameterList();
            parmlist1.set("p*0", "abc");
            parmlist1.set("p*1", "def");
            parmlist1.combineSegments();
            if (parmlist1.get("p").equals("abcdef") && parmlist1.get("p*0") == null && parmlist1.get("p*1") == null) {
                TestUtil.logMsg((String)"UNIT TEST 1: passed");
            } else {
                TestUtil.logMsg((String)("ParameterList: " + parmlist1));
                TestUtil.logMsg((String)"UNIT TEST 1: FAILED");
                ++this.errors;
            }
            this.checkStatus();
        }
        catch (Exception e) {
            this.logErr("Unexpected Exception " + e.getMessage());
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("combineSegments_Test() Failed!", e);
        }
        if (this.errors > 0) {
            throw new Exception("contentType_Test Failed: No of unit test failed = " + this.errors);
        }
    }

    public void checkStatus() {
        this.status = this.errors == 0 ? Status.passed((String)"OKAY") : Status.failed((String)"");
    }

    public void cleanup() throws Exception {
        try {
            this.logMsg("Cleanup ;");
        }
        catch (Exception e) {
            this.logErr("An error occurred in cleanup!", e);
        }
    }

    private static String type(int t) {
        if (t == -1) {
            return "ATOM";
        }
        if (t == -2) {
            return "QUOTEDSTRING";
        }
        if (t == -3) {
            return "COMMENT";
        }
        if (t == -4) {
            return "EOF";
        }
        if (t < 0) {
            return "UNKNOWN";
        }
        return "SPECIAL";
    }

    private static int type(String s) {
        if (s.equals("ATOM")) {
            return -1;
        }
        if (s.equals("QUOTEDSTRING")) {
            return -2;
        }
        if (s.equals("COMMENT")) {
            return -3;
        }
        if (s.equals("EOF")) {
            return -4;
        }
        return 0;
    }

    static class TestCase {
        public char endOfAtom;
        public String test;
        public String expected;

        public TestCase(char endOfAtom, String test, String expected) {
            this.endOfAtom = endOfAtom;
            this.test = test;
            this.expected = expected;
        }
    }
}

