/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.types.generator;

import ee.jakarta.tck.persistence.core.types.generator.Client;
import ee.jakarta.tck.persistence.core.types.generator.DataTypes4;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class Client4
extends Client {
    private static final System.Logger logger = System.getLogger(Client4.class.getName());
    private DataTypes4 d12;
    private boolean supports_sequence = false;

    public JavaArchive createDeployment() throws Exception {
        String pkgNameWithoutSuffix = Client4.class.getPackageName();
        String pkgName = pkgNameWithoutSuffix + ".";
        String[] classes = new String[]{pkgName + "DataTypes", pkgName + "DataTypes2", pkgName + "DataTypes3", pkgName + "DataTypes4"};
        return this.createDeploymentJar("jpa_core_types_generator4.jar", pkgNameWithoutSuffix, classes);
    }

    @BeforeEach
    public void setupDataTypes4() throws Exception {
        block4: {
            logger.log(System.Logger.Level.TRACE, "setupDataTypes4");
            try {
                super.setup();
                this.createDeployment();
                String s = System.getProperty("db.supports.sequence");
                if (s != null) {
                    this.supports_sequence = Boolean.parseBoolean(s);
                    logger.log(System.Logger.Level.INFO, "db.supports.sequence:" + this.supports_sequence);
                    if (this.supports_sequence) {
                        this.createSequenceGenerator();
                        this.removeTestData();
                        this.createDataTypes4Data();
                    }
                    break block4;
                }
                logger.log(System.Logger.Level.ERROR, "The property db.supports.sequence is not defined in the ts.jte, this must be corrected before running tests");
                throw new Exception("setupDataTypes4 failed");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Exception: ", (Throwable)e);
                throw new Exception("setupDataTypes4 failed:", e);
            }
        }
    }

    @Test
    public void sequenceGeneratorOnPropertyTest() throws Exception {
        boolean pass;
        block10: {
            pass = true;
            if (this.supports_sequence) {
                Integer newInt = 1000;
                try {
                    this.getEntityTransaction().begin();
                    this.clearCache();
                    logger.log(System.Logger.Level.INFO, "Doing a find of id: " + this.d12.getId());
                    DataTypes4 d = (DataTypes4)this.getEntityManager().find(DataTypes4.class, (Object)this.d12.getId());
                    if (d != null) {
                        Integer i = d.getIntegerData();
                        if (i.equals(this.d12.getIntegerData())) {
                            logger.log(System.Logger.Level.TRACE, "find returned correct Integer value:" + i);
                            d.setIntegerData(newInt);
                        } else {
                            logger.log(System.Logger.Level.ERROR, "find did not return correct Integer value, expected: " + this.d12.getIntegerData() + ", actual:" + i);
                            pass = false;
                        }
                        this.getEntityManager().merge((Object)d);
                        this.getEntityManager().flush();
                        this.clearCache();
                        logger.log(System.Logger.Level.INFO, "Doing a find of merged data for id: " + d.getId());
                        DataTypes4 d2 = (DataTypes4)this.getEntityManager().find(DataTypes4.class, (Object)d.getId());
                        i = d2.getIntegerData();
                        if (i.equals(d2.getIntegerData())) {
                            logger.log(System.Logger.Level.TRACE, "find returned correct merged Integer value:" + i);
                        } else {
                            logger.log(System.Logger.Level.ERROR, "find did not return correct Integer value, expected: " + d.getIntegerData() + ", actual:" + i);
                            pass = false;
                        }
                        this.getEntityTransaction().commit();
                        break block10;
                    }
                    logger.log(System.Logger.Level.ERROR, "find returned null result");
                    pass = false;
                }
                catch (Exception e) {
                    logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
                    pass = false;
                }
            } else {
                logger.log(System.Logger.Level.INFO, "WARNING: Test not run because db.supports.sequence set to false in ts.jte");
            }
        }
        if (!pass) {
            throw new Exception("sequenceGeneratorOnEntityTest failed");
        }
    }

    public void createDataTypes4Data() {
        try {
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.TRACE, "in createDataTypes4Data");
            logger.log(System.Logger.Level.TRACE, "new DataType4");
            this.d12 = new DataTypes4(500);
            logger.log(System.Logger.Level.TRACE, "Persist DataType4");
            this.getEntityManager().persist((Object)this.d12);
            logger.log(System.Logger.Level.TRACE, "DataType4 id:" + this.d12.getId());
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
    }
}

