/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.types.generator;

import ee.jakarta.tck.persistence.core.types.generator.Client;
import ee.jakarta.tck.persistence.core.types.generator.DataTypes2;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class Client2
extends Client {
    private static final System.Logger logger = System.getLogger(Client2.class.getName());
    private DataTypes2 d10;

    public JavaArchive createDeployment() throws Exception {
        String pkgNameWithoutSuffix = Client2.class.getPackageName();
        String pkgName = pkgNameWithoutSuffix + ".";
        String[] classes = new String[]{pkgName + "DataTypes", pkgName + "DataTypes2", pkgName + "DataTypes3", pkgName + "DataTypes4"};
        return this.createDeploymentJar("jpa_core_types_generator2.jar", pkgNameWithoutSuffix, classes);
    }

    @BeforeEach
    public void setupDataTypes2() throws Exception {
        block4: {
            logger.log(System.Logger.Level.TRACE, "setupDataTypes2");
            try {
                super.setup();
                this.createDeployment();
                String s = System.getProperty("db.supports.sequence");
                if (s != null) {
                    this.supports_sequence = Boolean.parseBoolean(s);
                    logger.log(System.Logger.Level.INFO, "db.supports.sequence:" + this.supports_sequence);
                    if (this.supports_sequence) {
                        this.createSequenceGenerator();
                        this.removeTestData();
                        this.createDataTypes2Data();
                    }
                    break block4;
                }
                logger.log(System.Logger.Level.ERROR, "The property db.supports.sequence is not defined in the ts.jte, this must be corrected before running tests");
                throw new Exception("setupDataTypes2 failed");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Exception: ", (Throwable)e);
                throw new Exception("setupDataTypes2 failed:", e);
            }
        }
    }

    @Test
    public void generatorTypeSequenceTest() throws Exception {
        boolean pass;
        block10: {
            pass = true;
            if (this.supports_sequence) {
                Float newFloat = Float.valueOf(3.0f);
                try {
                    this.getEntityTransaction().begin();
                    int id = this.d10.getId();
                    logger.log(System.Logger.Level.TRACE, "Doing a find of id: " + id);
                    DataTypes2 d = (DataTypes2)this.getEntityManager().find(DataTypes2.class, (Object)id);
                    if (null != d) {
                        Float f = d.getFloatData();
                        if (f.equals(this.d10.getFloatData())) {
                            logger.log(System.Logger.Level.TRACE, "find returned correct float value:" + f);
                            d.setFloatData(newFloat);
                        } else {
                            logger.log(System.Logger.Level.ERROR, "find did not return correct float value, expected: 1.0, actual:" + f);
                            pass = false;
                        }
                        this.getEntityManager().merge((Object)d);
                        this.getEntityManager().flush();
                        f = d.getFloatData();
                        if (f.equals(newFloat)) {
                            logger.log(System.Logger.Level.TRACE, "Successfully set float value to:" + newFloat);
                        } else {
                            logger.log(System.Logger.Level.ERROR, "Could not update float value, expected: " + newFloat + ", actual:" + f);
                            pass = false;
                        }
                        this.getEntityTransaction().commit();
                        break block10;
                    }
                    logger.log(System.Logger.Level.ERROR, "find returned null result");
                    pass = false;
                }
                catch (Exception e) {
                    logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
                    pass = false;
                }
            } else {
                logger.log(System.Logger.Level.INFO, "WARNING: Test not run because db.supports.sequence set to false in ts.jte");
            }
        }
        if (!pass) {
            throw new Exception("generatorTypeSequenceTest failed");
        }
    }

    public void createDataTypes2Data() {
        try {
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.TRACE, "in createDataTypes2Data");
            logger.log(System.Logger.Level.TRACE, "new DataType2");
            this.d10 = new DataTypes2(Character.valueOf('a'), (short)100, 500, 300L, 50.0, Float.valueOf(1.0f));
            logger.log(System.Logger.Level.TRACE, "Persist DataType2");
            this.getEntityManager().persist((Object)this.d10);
            logger.log(System.Logger.Level.TRACE, "DataType2 id:" + this.d10.getId());
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
    }
}

