/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.relationship.unimanyxmany;

import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.relationship.unimanyxmany.UniMXMPerson;
import ee.jakarta.tck.persistence.core.relationship.unimanyxmany.UniMXMProject;
import java.util.Collection;
import java.util.Vector;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class Client
extends PMClientBase {
    private static final System.Logger logger = System.getLogger(Client.class.getName());

    public JavaArchive createDeployment() throws Exception {
        String pkgNameWithoutSuffix = Client.class.getPackageName();
        String pkgName = pkgNameWithoutSuffix + ".";
        String[] classes = new String[]{pkgName + "UniMXMPerson", pkgName + "UniMXMProject"};
        return this.createDeploymentJar("jpa_core_relationship_unimanyxmany.jar", pkgNameWithoutSuffix, classes);
    }

    @BeforeEach
    public void setup() throws Exception {
        logger.log(System.Logger.Level.TRACE, "setup");
        try {
            super.setup();
            this.createDeployment();
            this.removeTestData();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception: ", (Throwable)e);
            throw new Exception("Setup failed:", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void uniMXMTest1() throws Exception {
        logger.log(System.Logger.Level.TRACE, "Begin uniMXMTest1");
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            UniMXMProject project1 = new UniMXMProject(1L, "JavaEE", Float.valueOf(500.0f));
            UniMXMProject project2 = new UniMXMProject(2L, "Identity", Float.valueOf(300.0f));
            UniMXMPerson person1 = new UniMXMPerson(1L, "Duke");
            UniMXMPerson person2 = new UniMXMPerson(2L, "Foo");
            this.getEntityManager().persist((Object)project1);
            this.getEntityManager().persist((Object)project2);
            this.getEntityManager().persist((Object)person1);
            this.getEntityManager().persist((Object)person2);
            Vector<UniMXMProject> projects = new Vector<UniMXMProject>();
            projects.add(project1);
            projects.add(project2);
            person1.setProjects(projects);
            Vector<UniMXMProject> projects2 = new Vector<UniMXMProject>();
            projects2.add(project2);
            person2.setProjects(projects2);
            this.getEntityManager().merge((Object)person1);
            this.getEntityManager().merge((Object)person2);
            logger.log(System.Logger.Level.TRACE, "persisted Persons and Project");
            boolean pass1 = false;
            boolean pass2 = false;
            UniMXMPerson newPerson = (UniMXMPerson)this.getEntityManager().find(UniMXMPerson.class, (Object)1L);
            if (newPerson != null) {
                Collection<UniMXMProject> newProjects = newPerson.getProjects();
                for (UniMXMProject prj : newProjects) {
                    if (prj.getName().equals("Identity")) {
                        pass1 = true;
                        continue;
                    }
                    if (!prj.getName().equals("JavaEE")) continue;
                    pass2 = true;
                }
            }
            boolean pass3 = false;
            UniMXMPerson newPerson2 = (UniMXMPerson)this.getEntityManager().find(UniMXMPerson.class, (Object)2L);
            if (newPerson2 != null) {
                Collection<UniMXMProject> newProjects2 = newPerson2.getProjects();
                for (UniMXMProject prj : newProjects2) {
                    if (!prj.getName().equals("Identity")) continue;
                    pass3 = true;
                }
            }
            if (pass1 && pass2 && pass3) {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Unexpected results received");
                pass = false;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in rollback:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new Exception("uniMXMTest1 failed");
        }
    }

    @AfterEach
    public void cleanup() throws Exception {
        try {
            logger.log(System.Logger.Level.TRACE, "cleanup");
            this.removeTestData();
            logger.log(System.Logger.Level.TRACE, "cleanup complete, calling super.cleanup");
            super.cleanup();
        }
        finally {
            this.removeTestJarFromCP();
        }
    }

    private void removeTestData() {
        logger.log(System.Logger.Level.TRACE, "removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM UNIMXMPERSON_UNIMXMPROJECT").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM UNIMXMPROJECT").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM UNIMXMPERSON").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

