/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.query.parameter;

import com.sun.ts.lib.util.TestUtil;
import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.query.parameter.Employee;
import jakarta.persistence.Parameter;
import jakarta.persistence.Query;
import jakarta.persistence.TypedQuery;
import java.util.ArrayList;
import java.util.Set;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class Client1
extends PMClientBase {
    private static final System.Logger logger = System.getLogger(Client1.class.getName());
    protected final Employee[] empRef = new Employee[5];

    public JavaArchive createDeployment() throws Exception {
        String pkgNameWithoutSuffix = Client1.class.getPackageName();
        String pkgName = pkgNameWithoutSuffix + ".";
        String[] classes = new String[]{pkgName + "Employee"};
        return this.createDeploymentJar("jpa_core_relationship_annotations1.jar", pkgNameWithoutSuffix, classes);
    }

    @BeforeEach
    public void setup() throws Exception {
        logger.log(System.Logger.Level.TRACE, "setup");
        try {
            super.setup();
            this.createDeployment();
            this.getEntityManager();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception: ", (Throwable)e);
            throw new Exception("Setup failed:", e);
        }
    }

    @Test
    public void parameterTest1() throws Exception {
        String sExpected;
        Parameter p1;
        boolean pass1 = false;
        boolean pass2 = false;
        boolean pass3 = false;
        boolean pass4 = false;
        boolean pass5 = false;
        boolean pass6 = false;
        boolean pass7 = false;
        boolean pass8 = false;
        Query query = this.getEntityManager().createQuery("SELECT e FROM Employee e WHERE e.firstName = :first or e.lastName = :last");
        if (TestUtil.traceflag) {
            Set sParameters = query.getParameters();
            for (Parameter p : sParameters) {
                logger.log(System.Logger.Level.TRACE, "Parameter name = " + p.getName());
                logger.log(System.Logger.Level.TRACE, "Parameter position = " + p.getPosition());
                logger.log(System.Logger.Level.TRACE, "Parameter type =" + p.getParameterType());
            }
        }
        if (query.isBound(p1 = query.getParameter(sExpected = "first"))) {
            logger.log(System.Logger.Level.ERROR, "isBound believes there is a value bound to the parameter:" + sExpected);
        } else {
            pass1 = true;
        }
        String sActual = p1.getName();
        if (!sActual.equals(sExpected)) {
            logger.log(System.Logger.Level.ERROR, "p1.getName() - Expected: " + sExpected + ", actual:" + sActual);
        } else {
            pass2 = true;
        }
        sExpected = null;
        Integer iActual = p1.getPosition();
        if (iActual != null) {
            logger.log(System.Logger.Level.ERROR, "p1.getPosition() - Expected: " + sExpected + ", actual:" + iActual);
        } else {
            pass3 = true;
        }
        try {
            sExpected = "java.lang.String";
            sActual = p1.getParameterType().getName();
            if (!sActual.equals(sExpected)) {
                logger.log(System.Logger.Level.ERROR, "p1.getParameterType() - Expected: " + sExpected + ", actual:" + sActual);
            } else {
                pass4 = true;
            }
        }
        catch (IllegalStateException ise) {
            logger.log(System.Logger.Level.INFO, "warning: p1.getParameterType() threw IllegalStateException, this is not considered a failure");
        }
        sExpected = "last";
        Parameter p2 = query.getParameter(sExpected);
        if (query.isBound(p2)) {
            logger.log(System.Logger.Level.ERROR, "isBound believes there is a value bound to the parameter:" + sExpected);
        } else {
            pass5 = true;
        }
        sActual = p2.getName();
        if (!sActual.equals(sExpected)) {
            logger.log(System.Logger.Level.ERROR, "p2.getName() - Expected: " + sExpected + ", actual:" + sActual);
        } else {
            pass6 = true;
        }
        sExpected = null;
        iActual = p2.getPosition();
        if (iActual != null) {
            logger.log(System.Logger.Level.ERROR, "p2.getPosition() - Expected: " + sExpected + ", actual:" + iActual);
        } else {
            pass7 = true;
        }
        try {
            sExpected = "java.lang.String";
            sActual = p2.getParameterType().getName();
            if (!sActual.equals(sExpected)) {
                logger.log(System.Logger.Level.ERROR, "p2.getParameterType() - Expected: " + sExpected + ", actual:" + sActual);
            } else {
                pass8 = true;
            }
        }
        catch (IllegalStateException ise) {
            logger.log(System.Logger.Level.INFO, "warning: p2.getParameterType() threw IllegalStateException, this is not considered a failure");
        }
        if (!(pass1 && pass2 && pass3 && pass4 && pass5 && pass6 && pass7 && pass8)) {
            throw new Exception("parameterTest1 failed");
        }
    }

    @Test
    public void parameterTestTQ1() throws Exception {
        String sExpected;
        Parameter p1;
        boolean pass1 = false;
        boolean pass2 = false;
        boolean pass3 = false;
        boolean pass4 = false;
        boolean pass5 = false;
        boolean pass6 = false;
        boolean pass7 = false;
        boolean pass8 = false;
        TypedQuery query = this.getEntityManager().createQuery("SELECT e FROM Employee e WHERE e.firstName = :first or e.lastName = :last", Employee.class);
        if (TestUtil.traceflag) {
            Set sParameters = query.getParameters();
            for (Parameter p : sParameters) {
                logger.log(System.Logger.Level.TRACE, "Parameter name = " + p.getName());
                logger.log(System.Logger.Level.TRACE, "Parameter position = " + p.getPosition());
                logger.log(System.Logger.Level.TRACE, "Parameter type =" + p.getParameterType());
            }
        }
        if (query.isBound(p1 = query.getParameter(sExpected = "first"))) {
            logger.log(System.Logger.Level.ERROR, "isBound believes there is a value bound to the parameter:" + sExpected);
        } else {
            pass1 = true;
        }
        String sActual = p1.getName();
        if (!sActual.equals(sExpected)) {
            logger.log(System.Logger.Level.ERROR, "p1.getName() - Expected: " + sExpected + ", actual:" + sActual);
        } else {
            pass2 = true;
        }
        sExpected = null;
        Integer iActual = p1.getPosition();
        if (iActual != null) {
            logger.log(System.Logger.Level.ERROR, "p1.getPosition() - Expected: " + sExpected + ", actual:" + iActual);
        } else {
            pass3 = true;
        }
        try {
            sExpected = "java.lang.String";
            sActual = p1.getParameterType().getName();
            if (!sActual.equals(sExpected)) {
                logger.log(System.Logger.Level.ERROR, "p1.getParameterType() - Expected: " + sExpected + ", actual:" + sActual);
            } else {
                pass4 = true;
            }
        }
        catch (IllegalStateException ise) {
            logger.log(System.Logger.Level.INFO, "warning: p1.getParameterType() threw IllegalStateException, this is not considered a failure");
        }
        sExpected = "last";
        Parameter p2 = query.getParameter(sExpected);
        if (query.isBound(p2)) {
            logger.log(System.Logger.Level.ERROR, "isBound believes there is a value bound to the parameter:" + sExpected);
        } else {
            pass5 = true;
        }
        sActual = p2.getName();
        if (!sActual.equals(sExpected)) {
            logger.log(System.Logger.Level.ERROR, "p2.getName() - Expected: " + sExpected + ", actual:" + sActual);
        } else {
            pass6 = true;
        }
        sExpected = null;
        iActual = p2.getPosition();
        if (iActual != null) {
            logger.log(System.Logger.Level.ERROR, "p2.getPosition() - Expected: " + sExpected + ", actual:" + iActual);
        } else {
            pass7 = true;
        }
        try {
            sExpected = "java.lang.String";
            sActual = p2.getParameterType().getName();
            if (!sActual.equals(sExpected)) {
                logger.log(System.Logger.Level.ERROR, "p2.getParameterType() - Expected: " + sExpected + ", actual:" + sActual);
            } else {
                pass8 = true;
            }
        }
        catch (IllegalStateException ise) {
            logger.log(System.Logger.Level.INFO, "warning: p2.getParameterType() threw IllegalStateException, this is not considered a failure");
        }
        if (!(pass1 && pass2 && pass3 && pass4 && pass5 && pass6 && pass7 && pass8)) {
            throw new Exception("parameterTestTQ1 failed");
        }
    }

    @Test
    public void parameterTest2() throws Exception {
        int pass1 = 0;
        int pass2 = 0;
        int pass3 = 0;
        Query query = this.getEntityManager().createQuery("SELECT e FROM Employee e WHERE e.firstName = ?1 or e.lastName = ?2");
        Set sParameters = query.getParameters();
        if (sParameters.size() == 2) {
            for (Parameter p : sParameters) {
                if (TestUtil.traceflag) {
                    logger.log(System.Logger.Level.TRACE, "parameter name = " + p.getName());
                    logger.log(System.Logger.Level.TRACE, "parameter position = " + p.getPosition());
                    logger.log(System.Logger.Level.TRACE, "parameter type =" + p.getParameterType());
                }
                if (query.isBound(p)) {
                    logger.log(System.Logger.Level.ERROR, "isBound believes there is a value bound to the parameter:" + p);
                } else {
                    logger.log(System.Logger.Level.TRACE, "query isBound = " + query.isBound(p));
                    ++pass1;
                }
                Integer pos = p.getPosition();
                if (pos != null) {
                    if (pos == 1 || pos == 2) {
                        String sActual = p.getName();
                        if (sActual != null) {
                            logger.log(System.Logger.Level.ERROR, "getName() - Expected: null, actual:" + sActual);
                        } else {
                            ++pass2;
                        }
                        try {
                            String sExpected = "java.lang.String";
                            sActual = p.getParameterType().getName();
                            if (!sActual.equals(sExpected)) {
                                logger.log(System.Logger.Level.ERROR, "getParameterType().getName() - Expected: " + sExpected + ", actual:" + sActual);
                                continue;
                            }
                            ++pass3;
                        }
                        catch (IllegalStateException ise) {
                            logger.log(System.Logger.Level.INFO, "warning: getParameterType().getName() threw IllegalStateException, this is not considered a failure");
                        }
                        continue;
                    }
                    logger.log(System.Logger.Level.ERROR, "getPosition() returned an invalid position:" + pos);
                    continue;
                }
                logger.log(System.Logger.Level.ERROR, "getPosition() returned null");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "query.getParameters(): Expected: 2 parameters, actual: " + sParameters.size());
        }
        if (pass1 != 2 || pass2 != 2 || pass3 != 2) {
            throw new Exception("parameterTest2 failed");
        }
    }

    @Test
    public void parameterTQTest2() throws Exception {
        int pass1 = 0;
        int pass2 = 0;
        int pass3 = 0;
        TypedQuery query = this.getEntityManager().createQuery("SELECT e FROM Employee e WHERE e.firstName = ?1 or e.lastName = ?2", Employee.class);
        Set sParameters = query.getParameters();
        if (sParameters.size() == 2) {
            for (Parameter p : sParameters) {
                if (TestUtil.traceflag) {
                    logger.log(System.Logger.Level.TRACE, "parameter name = " + p.getName());
                    logger.log(System.Logger.Level.TRACE, "parameter position = " + p.getPosition());
                    logger.log(System.Logger.Level.TRACE, "parameter type =" + p.getParameterType());
                }
                if (query.isBound(p)) {
                    logger.log(System.Logger.Level.ERROR, "isBound believes there is a value bound to the parameter:" + p);
                } else {
                    logger.log(System.Logger.Level.TRACE, "query isBound = " + query.isBound(p));
                    ++pass1;
                }
                Integer pos = p.getPosition();
                if (pos != null) {
                    if (pos == 1 || pos == 2) {
                        String sActual = p.getName();
                        if (sActual != null) {
                            logger.log(System.Logger.Level.ERROR, "getName() - Expected: null, actual:" + sActual);
                        } else {
                            ++pass2;
                        }
                        try {
                            String sExpected = "java.lang.String";
                            sActual = p.getParameterType().getName();
                            if (!sActual.equals(sExpected)) {
                                logger.log(System.Logger.Level.ERROR, "getParameterType().getName() - Expected: " + sExpected + ", actual:" + sActual);
                                continue;
                            }
                            ++pass3;
                        }
                        catch (IllegalStateException ise) {
                            logger.log(System.Logger.Level.INFO, "warning: getParameterType().getName() threw IllegalStateException, this is not considered a failure");
                        }
                        continue;
                    }
                    logger.log(System.Logger.Level.ERROR, "getPosition() returned an invalid position:" + pos);
                    continue;
                }
                logger.log(System.Logger.Level.ERROR, "getPosition() returned null");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "query.getParameters(): Expected: 2 parameters, actual: " + sParameters.size());
        }
        if (pass1 != 2 || pass2 != 2 || pass3 != 2) {
            throw new Exception("parameterTQTest2 failed");
        }
    }

    @Test
    public void parameterTest4() throws Exception {
        String sExpected;
        Parameter p1;
        String sActual;
        boolean pass1 = false;
        boolean pass2 = false;
        boolean pass3 = false;
        Query query = this.getEntityManager().createQuery("SELECT e FROM Employee e WHERE e.hireDate = :hDate ");
        if (TestUtil.traceflag) {
            Set sParameters = query.getParameters();
            for (Parameter p : sParameters) {
                logger.log(System.Logger.Level.TRACE, "Parameter name = " + p.getName());
                logger.log(System.Logger.Level.TRACE, "Parameter position = " + p.getPosition());
            }
        }
        if (!(sActual = (p1 = query.getParameter(sExpected = "hDate")).getName()).equals(sExpected)) {
            logger.log(System.Logger.Level.ERROR, "p1.getName() - Expected: " + sExpected + ", actual:" + sActual);
        } else {
            pass1 = true;
        }
        sExpected = null;
        Integer iActual = p1.getPosition();
        if (iActual != null) {
            logger.log(System.Logger.Level.ERROR, "p1.getPosition() - Expected: " + sExpected + ", actual:" + iActual);
        } else {
            pass2 = true;
        }
        if (!pass1 || !pass2) {
            throw new Exception("parameterTest4 failed");
        }
    }

    @Test
    public void parameterTest5() throws Exception {
        String sExpected;
        Parameter p1;
        String sActual;
        boolean pass1 = false;
        boolean pass2 = false;
        boolean pass3 = false;
        Query query = this.getEntityManager().createQuery("SELECT e FROM Employee e WHERE e.salary = :salary ");
        if (TestUtil.traceflag) {
            Set sParameters = query.getParameters();
            for (Parameter p : sParameters) {
                logger.log(System.Logger.Level.TRACE, "Parameter name = " + p.getName());
                logger.log(System.Logger.Level.TRACE, "Parameter position = " + p.getPosition());
            }
        }
        if (!(sActual = (p1 = query.getParameter(sExpected = "salary")).getName()).equals(sExpected)) {
            logger.log(System.Logger.Level.ERROR, "p1.getName() - Expected: " + sExpected + ", actual:" + sActual);
        } else {
            pass1 = true;
        }
        sExpected = null;
        Integer iActual = p1.getPosition();
        if (iActual != null) {
            logger.log(System.Logger.Level.ERROR, "p1.getPosition() - Expected: " + sExpected + ", actual:" + iActual);
        } else {
            pass2 = true;
        }
        if (!pass1 || !pass2) {
            throw new Exception("parameterTest5 failed");
        }
    }

    @Test
    public void getParametersTest() throws Exception {
        boolean pass = false;
        logger.log(System.Logger.Level.TRACE, "Starting getParametersTest");
        try {
            Query query = this.getEntityManager().createQuery("SELECT e FROM Employee e WHERE e.firstName = :first or e.lastName = :last");
            if (TestUtil.traceflag) {
                Set sParameters = query.getParameters();
                for (Parameter p : sParameters) {
                    logger.log(System.Logger.Level.TRACE, "Parameter name = " + p.getName());
                    logger.log(System.Logger.Level.TRACE, "Parameter position = " + p.getPosition());
                    logger.log(System.Logger.Level.TRACE, "Parameter type =" + p.getParameterType());
                }
            }
            boolean foundFirstName = false;
            boolean foundLastName = false;
            int found = 0;
            ArrayList list = new ArrayList(query.getParameters());
            for (int i = 0; i < list.size(); ++i) {
                Parameter p = (Parameter)list.get(i);
                logger.log(System.Logger.Level.TRACE, "Parameter name = " + p.getName());
                if (p.getName().equals("first")) {
                    foundFirstName = true;
                    ++found;
                }
                if (!p.getName().equals("last")) continue;
                foundLastName = true;
                ++found;
            }
            if (found == 2 && foundFirstName && foundLastName) {
                pass = true;
            } else {
                if (found != 2) {
                    logger.log(System.Logger.Level.ERROR, "Wrong number of parameters returned, expected:2, actual:" + found);
                }
                if (!foundFirstName) {
                    logger.log(System.Logger.Level.ERROR, "Parameter 'first' was not returned");
                }
                if (!foundLastName) {
                    logger.log(System.Logger.Level.ERROR, "Parameter 'last' was not returned");
                }
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("getParametersTest failed");
        }
    }

    @Test
    public void getParametersTQTest() throws Exception {
        boolean pass = false;
        logger.log(System.Logger.Level.TRACE, "Starting getParametersTest");
        try {
            TypedQuery query = this.getEntityManager().createQuery("SELECT e FROM Employee e WHERE e.firstName = :first or e.lastName = :last", Employee.class);
            if (TestUtil.traceflag) {
                Set sParameters = query.getParameters();
                for (Parameter p : sParameters) {
                    logger.log(System.Logger.Level.TRACE, "Parameter name = " + p.getName());
                    logger.log(System.Logger.Level.TRACE, "Parameter position = " + p.getPosition());
                    logger.log(System.Logger.Level.TRACE, "Parameter type =" + p.getParameterType());
                }
            }
            boolean foundFirstName = false;
            boolean foundLastName = false;
            int found = 0;
            ArrayList list = new ArrayList(query.getParameters());
            for (int i = 0; i < list.size(); ++i) {
                Parameter p = (Parameter)list.get(i);
                logger.log(System.Logger.Level.TRACE, "Parameter name = " + p.getName());
                if (p.getName().equals("first")) {
                    foundFirstName = true;
                    ++found;
                }
                if (!p.getName().equals("last")) continue;
                foundLastName = true;
                ++found;
            }
            if (found == 2 && foundFirstName && foundLastName) {
                pass = true;
            } else {
                if (found != 2) {
                    logger.log(System.Logger.Level.ERROR, "Wrong number of parameters returned, expected:2, actual:" + found);
                }
                if (!foundFirstName) {
                    logger.log(System.Logger.Level.ERROR, "Parameter 'first' was not returned");
                }
                if (!foundLastName) {
                    logger.log(System.Logger.Level.ERROR, "Parameter 'last' was not returned");
                }
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("getParametersTQTest failed");
        }
    }

    @Test
    public void getParametersNoParametersTest() throws Exception {
        boolean pass = false;
        try {
            logger.log(System.Logger.Level.TRACE, "Starting getParametersTest");
            Query query = this.getEntityManager().createQuery("SELECT e FROM Employee e");
            if (TestUtil.traceflag) {
                Set sParameters = query.getParameters();
                for (Parameter p : sParameters) {
                    logger.log(System.Logger.Level.TRACE, "parameter name = " + p.getName());
                    logger.log(System.Logger.Level.TRACE, "parameter position = " + p.getPosition());
                    logger.log(System.Logger.Level.TRACE, "pParameter type =" + p.getParameterType());
                }
            }
            if (query.getParameters().size() != 0) {
                ArrayList list = new ArrayList(query.getParameters());
                for (int i = 0; i < list.size(); ++i) {
                    Parameter p;
                    p = (Parameter)list.get(i);
                    logger.log(System.Logger.Level.ERROR, "parameter name = " + p.getName());
                }
            } else {
                pass = true;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("getParametersNoParametersTest failed");
        }
    }

    @AfterEach
    public void cleanup() throws Exception {
        try {
            logger.log(System.Logger.Level.TRACE, "calling super.cleanup");
            super.cleanup();
        }
        finally {
            this.removeTestJarFromCP();
        }
    }
}

