/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.metamodelapi.pluralattribute;

import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.metamodelapi.pluralattribute.Uni1XMPerson;
import ee.jakarta.tck.persistence.core.metamodelapi.pluralattribute.Uni1XMProject;
import jakarta.persistence.metamodel.Attribute;
import jakarta.persistence.metamodel.Bindable;
import jakarta.persistence.metamodel.CollectionAttribute;
import jakarta.persistence.metamodel.ManagedType;
import jakarta.persistence.metamodel.Metamodel;
import jakarta.persistence.metamodel.PluralAttribute;
import java.lang.reflect.Member;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class Client
extends PMClientBase {
    private static final System.Logger logger = System.getLogger(Client.class.getName());

    public JavaArchive createDeployment() throws Exception {
        String pkgNameWithoutSuffix = Client.class.getPackageName();
        String pkgName = pkgNameWithoutSuffix + ".";
        String[] classes = new String[]{pkgName + "Uni1XMPerson", pkgName + "Uni1XMProject"};
        return this.createDeploymentJar("jpa_core_metamodelapi_pluralattribute.jar", pkgNameWithoutSuffix, classes);
    }

    @BeforeEach
    public void setup() throws Exception {
        logger.log(System.Logger.Level.TRACE, "setup");
        try {
            super.setup();
            this.createDeployment();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception: ", (Throwable)e);
            throw new Exception("Setup failed:", e);
        }
    }

    @Test
    public void getCollectionType() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            ManagedType mType = metaModel.managedType(Uni1XMPerson.class);
            if (mType != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null ManagedType");
                CollectionAttribute pluralAttrib = mType.getCollection("projects", Uni1XMProject.class);
                PluralAttribute.CollectionType pluralColType = pluralAttrib.getCollectionType();
                logger.log(System.Logger.Level.TRACE, "collection Type = " + pluralAttrib.getCollectionType());
                if (pluralColType == PluralAttribute.CollectionType.COLLECTION) {
                    logger.log(System.Logger.Level.TRACE, "Received Expected Collection type = " + pluralColType);
                    pass = true;
                } else {
                    logger.log(System.Logger.Level.TRACE, "Received UnExpected Collection type = " + pluralColType);
                }
            }
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getCollectionType Test  failed");
        }
    }

    @Test
    public void getElementType() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            ManagedType mType = metaModel.managedType(Uni1XMPerson.class);
            if (mType != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null ManagedType");
                CollectionAttribute pluralAttrib = mType.getCollection("projects", Uni1XMProject.class);
                logger.log(System.Logger.Level.TRACE, "collection Element Type = " + pluralAttrib.getElementType().getJavaType().getName());
                String elementTypeName = pluralAttrib.getElementType().getJavaType().getName();
                if (elementTypeName.equals("ee.jakarta.tck.persistence.core.metamodelapi.pluralattribute.Uni1XMProject")) {
                    logger.log(System.Logger.Level.TRACE, "Received Expected Element type = " + elementTypeName);
                    pass = true;
                } else {
                    logger.log(System.Logger.Level.TRACE, "Received UnExpected Element type = " + elementTypeName);
                }
            }
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getElementType Test  failed");
        }
    }

    @Test
    public void isCollection() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            ManagedType mTypeUni1XMPerson = metaModel.managedType(Uni1XMPerson.class);
            if (mTypeUni1XMPerson != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null ManagedType");
                CollectionAttribute pluralAttrib = mTypeUni1XMPerson.getCollection("projects", Uni1XMProject.class);
                boolean b = pluralAttrib.isCollection();
                if (b) {
                    logger.log(System.Logger.Level.TRACE, "Received expected result:" + b);
                    pass = true;
                } else {
                    logger.log(System.Logger.Level.ERROR, "Expected: true, actual: " + b);
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "managedType() returned null");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("isCollection Test failed");
        }
    }

    @Test
    public void isAssociation() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            ManagedType mTypeUni1XMPerson = metaModel.managedType(Uni1XMPerson.class);
            if (mTypeUni1XMPerson != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null ManagedType");
                CollectionAttribute pluralAttrib = mTypeUni1XMPerson.getCollection("projects", Uni1XMProject.class);
                boolean b = pluralAttrib.isAssociation();
                if (b) {
                    logger.log(System.Logger.Level.TRACE, "Received expected result:" + b);
                    pass = true;
                } else {
                    logger.log(System.Logger.Level.ERROR, "Expected: true, actual: " + b);
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "managedType() returned null");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("isAssociation Test failed");
        }
    }

    @Test
    public void getPersistentAttributeType() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            ManagedType mTypeUni1XMPerson = metaModel.managedType(Uni1XMPerson.class);
            if (mTypeUni1XMPerson != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null ManagedType");
                CollectionAttribute pluralAttrib = mTypeUni1XMPerson.getCollection("projects", Uni1XMProject.class);
                if (pluralAttrib != null) {
                    Attribute.PersistentAttributeType pAttribType = pluralAttrib.getPersistentAttributeType();
                    if (pAttribType == Attribute.PersistentAttributeType.ONE_TO_MANY) {
                        logger.log(System.Logger.Level.TRACE, "Received expected result " + pAttribType);
                        pass = true;
                    } else {
                        logger.log(System.Logger.Level.ERROR, "Expected: " + Attribute.PersistentAttributeType.ONE_TO_MANY.toString() + ", actual:" + pAttribType);
                    }
                }
            }
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getPersistentAttributeType Test failed");
        }
    }

    @Test
    public void getName() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            ManagedType mTypeUni1XMPerson = metaModel.managedType(Uni1XMPerson.class);
            if (mTypeUni1XMPerson != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null ManagedType");
                CollectionAttribute pluralAttrib = mTypeUni1XMPerson.getCollection("projects", Uni1XMProject.class);
                if (pluralAttrib != null) {
                    String name = pluralAttrib.getName();
                    if (name.equals("projects")) {
                        logger.log(System.Logger.Level.TRACE, "Received expected result" + name);
                        pass = true;
                    } else {
                        logger.log(System.Logger.Level.ERROR, "Expected: projects, actual:" + name);
                    }
                }
            }
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getName Test failed");
        }
    }

    @Test
    public void getJavaType() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            ManagedType mTypeUni1XMPerson = metaModel.managedType(Uni1XMPerson.class);
            if (mTypeUni1XMPerson != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null ManagedType");
                CollectionAttribute pluralAttrib = mTypeUni1XMPerson.getCollection("projects", Uni1XMProject.class);
                if (pluralAttrib != null) {
                    Class pPluralAttribJavaType = pluralAttrib.getJavaType();
                    if (pPluralAttribJavaType.getName().equals("java.util.Collection")) {
                        logger.log(System.Logger.Level.TRACE, "Received expected result " + pPluralAttribJavaType);
                        pass = true;
                    } else {
                        logger.log(System.Logger.Level.ERROR, "Expected: java.util.Collection, actual:" + pPluralAttribJavaType);
                    }
                }
            }
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getJavaType Test failed");
        }
    }

    @Test
    public void getJavaMember() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            ManagedType mTypeUni1XMPerson = metaModel.managedType(Uni1XMPerson.class);
            if (mTypeUni1XMPerson != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null ManagedType");
                CollectionAttribute pluralAttrib = mTypeUni1XMPerson.getCollection("projects", Uni1XMProject.class);
                if (pluralAttrib != null) {
                    logger.log(System.Logger.Level.TRACE, "Singular attribute JavaMember = " + pluralAttrib.getJavaMember().getName());
                    Member javaMember = pluralAttrib.getJavaMember();
                    if (javaMember.getName().equals("projects")) {
                        logger.log(System.Logger.Level.TRACE, "Received expected result " + javaMember.getName());
                        pass = true;
                    } else {
                        logger.log(System.Logger.Level.ERROR, "Expected: projects, actual:" + javaMember.getName());
                    }
                }
            }
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getJavaMember Test  failed");
        }
    }

    @Test
    public void getBindableType() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            ManagedType mTypeUni1XMPerson = metaModel.managedType(Uni1XMPerson.class);
            if (mTypeUni1XMPerson != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null ManagedType");
                CollectionAttribute pluralAttrib = mTypeUni1XMPerson.getCollection("projects", Uni1XMProject.class);
                if (pluralAttrib != null) {
                    logger.log(System.Logger.Level.TRACE, "attribute Name = " + pluralAttrib.getName());
                    Bindable.BindableType bType = pluralAttrib.getBindableType();
                    if (bType != null) {
                        if (bType.name().equals(Bindable.BindableType.PLURAL_ATTRIBUTE.name())) {
                            logger.log(System.Logger.Level.TRACE, "Received expected result:" + bType.name());
                            pass = true;
                        } else {
                            logger.log(System.Logger.Level.ERROR, "Expected: " + Bindable.BindableType.PLURAL_ATTRIBUTE.name() + ", actual:" + bType.name());
                        }
                    }
                }
            }
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getBindableType Test  failed");
        }
    }

    @Test
    public void getBindableJavaType() throws Exception {
        boolean pass = false;
        String expected = "ee.jakarta.tck.persistence.core.metamodelapi.pluralattribute.Uni1XMProject";
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            ManagedType mTypeUni1XMPerson = metaModel.managedType(Uni1XMPerson.class);
            if (mTypeUni1XMPerson != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null ManagedType");
                CollectionAttribute pluralAttrib = mTypeUni1XMPerson.getCollection("projects", Uni1XMProject.class);
                if (pluralAttrib != null) {
                    logger.log(System.Logger.Level.TRACE, "attribute Name = " + pluralAttrib.getName());
                    Class cType = pluralAttrib.getBindableJavaType();
                    if (cType != null) {
                        if (cType.getName().equals(expected)) {
                            logger.log(System.Logger.Level.TRACE, "Received expected result:" + cType.getName());
                            pass = true;
                        } else {
                            logger.log(System.Logger.Level.ERROR, "Expected: " + expected + ", actual:" + cType.getName());
                        }
                    }
                }
            }
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getBindableJavaType Test  failed");
        }
    }

    @Test
    public void getDeclaringType() throws Exception {
        boolean pass = false;
        String expected = "ee.jakarta.tck.persistence.core.metamodelapi.pluralattribute.Uni1XMPerson";
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            ManagedType mTypeUni1XMPerson = metaModel.managedType(Uni1XMPerson.class);
            if (mTypeUni1XMPerson != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null ManagedType");
                CollectionAttribute pluralAttrib = mTypeUni1XMPerson.getCollection("projects", Uni1XMProject.class);
                if (pluralAttrib != null) {
                    ManagedType type = pluralAttrib.getDeclaringType();
                    if (type != null) {
                        String name = type.getJavaType().getName();
                        if (name.equals(expected)) {
                            logger.log(System.Logger.Level.TRACE, "Received expected result:" + name);
                            pass = true;
                        } else {
                            logger.log(System.Logger.Level.ERROR, "Expected: " + expected + ", actual:" + name);
                        }
                    } else {
                        logger.log(System.Logger.Level.ERROR, "getDeclaringType() returned null");
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "getCollection(...) returned null");
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "managedType() returned null");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getDeclaringType Test  failed");
        }
    }

    @AfterEach
    public void cleanup() throws Exception {
        try {
            logger.log(System.Logger.Level.TRACE, "Cleanup data");
            this.removeTestData();
            logger.log(System.Logger.Level.TRACE, "cleanup complete, calling super.cleanup");
            super.cleanup();
        }
        finally {
            this.removeTestJarFromCP();
        }
    }

    private void removeTestData() {
        logger.log(System.Logger.Level.TRACE, "removeTestData");
        try {
            if (this.getEntityTransaction().isActive()) {
                this.getEntityTransaction().rollback();
            }
        }
        catch (Exception re) {
            logger.log(System.Logger.Level.ERROR, "Unexpected Exception in removeTestData:", (Throwable)re);
        }
    }
}

