/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.metamodelapi.metamodel;

import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.metamodelapi.metamodel.Address;
import ee.jakarta.tck.persistence.core.metamodelapi.metamodel.Employee;
import ee.jakarta.tck.persistence.core.metamodelapi.metamodel.Order;
import jakarta.persistence.metamodel.Attribute;
import jakarta.persistence.metamodel.EmbeddableType;
import jakarta.persistence.metamodel.EntityType;
import jakarta.persistence.metamodel.ManagedType;
import jakarta.persistence.metamodel.Metamodel;
import java.util.ArrayList;
import java.util.Set;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class Client
extends PMClientBase {
    private static final System.Logger logger = System.getLogger(Client.class.getName());

    public JavaArchive createDeployment() throws Exception {
        String pkgNameWithoutSuffix = Client.class.getPackageName();
        String pkgName = pkgNameWithoutSuffix + ".";
        String[] classes = new String[]{pkgName + "Address", pkgName + "B", pkgName + "Employee", pkgName + "FullTimeEmployee", pkgName + "Order", pkgName + "ZipCode"};
        return this.createDeploymentJar("jpa_core_metamodelapi_metamodel.jar", pkgNameWithoutSuffix, classes);
    }

    @BeforeEach
    public void setup() throws Exception {
        logger.log(System.Logger.Level.TRACE, "setup");
        try {
            super.setup();
            this.createDeployment();
            this.removeTestData();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception: ", (Throwable)e);
            throw new Exception("Setup failed:", e);
        }
    }

    @Test
    public void getMetamodel() throws Exception {
        boolean pass = false;
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            pass = true;
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
        }
        if (!pass) {
            throw new Exception("getMetamodeltest failed");
        }
    }

    @Test
    public void getEntities() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            Set orderSet = metaModel.getEntities();
            if (orderSet != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null Set of EntityType");
                for (EntityType eType : orderSet) {
                    logger.log(System.Logger.Level.TRACE, "entityType Name = " + eType.getName());
                    pass = true;
                }
            }
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getEntities Test  failed");
        }
    }

    @Test
    public void getManagedTypes() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            Set orderSet = metaModel.getManagedTypes();
            if (orderSet != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null Set of ManagedType");
                for (ManagedType mType : orderSet) {
                    Set attribSet = mType.getDeclaredAttributes();
                    if (attribSet == null) continue;
                    for (Attribute attrib : attribSet) {
                        logger.log(System.Logger.Level.TRACE, "attribute Name = " + attrib.getName());
                    }
                    pass = true;
                }
            }
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getManagedTypes Test  failed");
        }
    }

    @Test
    public void getEmbeddables() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            Set addrSet = metaModel.getEmbeddables();
            if (addrSet != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null Set of EmbeddableType");
                for (EmbeddableType eType : addrSet) {
                    Set attribSet = eType.getDeclaredAttributes();
                    if (attribSet == null) continue;
                    for (Attribute attrib : attribSet) {
                        logger.log(System.Logger.Level.TRACE, "attribute Name = " + attrib.getName());
                    }
                    pass = true;
                }
            }
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getEmbeddables Test  failed");
        }
    }

    @Test
    public void managedType() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        boolean pass3 = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            Set attribSet;
            String cActual;
            logger.log(System.Logger.Level.INFO, "Test entity");
            String expected = "ee.jakarta.tck.persistence.core.metamodelapi.metamodel.Order";
            ManagedType mType = metaModel.managedType(Order.class);
            if (mType != null) {
                ManagedType mTypeOrder = mType;
                cActual = mType.getJavaType().getName();
                if (cActual.equals(expected)) {
                    attribSet = mTypeOrder.getDeclaredAttributes();
                    if (attribSet != null) {
                        for (Attribute attrib : attribSet) {
                            logger.log(System.Logger.Level.TRACE, "attribute Name = " + attrib.getName());
                        }
                        pass1 = true;
                    } else {
                        logger.log(System.Logger.Level.ERROR, "getDeclaredAttributes() returned null");
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "Expected:" + expected + ", actual:" + cActual);
                }
            }
            logger.log(System.Logger.Level.INFO, "Test embeddable");
            expected = "ee.jakarta.tck.persistence.core.metamodelapi.metamodel.Address";
            mType = metaModel.managedType(Address.class);
            if (mType != null) {
                ManagedType mTypeAddress = mType;
                cActual = mType.getJavaType().getName();
                if (cActual.equals(expected)) {
                    attribSet = mTypeAddress.getDeclaredAttributes();
                    if (attribSet != null) {
                        for (Attribute attrib : attribSet) {
                            logger.log(System.Logger.Level.TRACE, "attribute Name = " + attrib.getName());
                        }
                        pass2 = true;
                    } else {
                        logger.log(System.Logger.Level.ERROR, "getDeclaredAttributes() returned null");
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "Expected:" + expected + ", actual:" + cActual);
                }
            }
            logger.log(System.Logger.Level.INFO, "Test superclass");
            expected = "ee.jakarta.tck.persistence.core.metamodelapi.metamodel.Employee";
            mType = metaModel.managedType(Employee.class);
            if (mType != null) {
                ManagedType mTypeEmployee = mType;
                cActual = mType.getJavaType().getName();
                if (cActual.equals(expected)) {
                    attribSet = mTypeEmployee.getDeclaredAttributes();
                    if (attribSet != null) {
                        for (Attribute attrib : attribSet) {
                            logger.log(System.Logger.Level.TRACE, "attribute Name = " + attrib.getName());
                        }
                        pass3 = true;
                    } else {
                        logger.log(System.Logger.Level.ERROR, "getDeclaredAttributes() returned null");
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "Expected:" + expected + ", actual:" + cActual);
                }
            }
        }
        this.getEntityTransaction().commit();
        if (!(pass1 && pass2 && pass3)) {
            throw new Exception("managedType Test failed");
        }
    }

    @Test
    public void managedTypeIllegalArgumentException() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            try {
                metaModel.managedType(Client.class);
                logger.log(System.Logger.Level.ERROR, "Did not throw IllegalArgumentException");
            }
            catch (IllegalArgumentException iae) {
                logger.log(System.Logger.Level.TRACE, "Received expected IllegalArgumentException");
                pass = true;
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Received unexpected exception", (Throwable)e);
            }
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("managedTypeIllegalArgumentException failed");
        }
    }

    @Test
    public void entity() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            EntityType eTypeOrder = metaModel.entity(Order.class);
            if (eTypeOrder != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null EntityType");
                Set attribSet = eTypeOrder.getDeclaredAttributes();
                if (attribSet != null) {
                    for (Attribute attrib : attribSet) {
                        logger.log(System.Logger.Level.TRACE, "attribute Name = " + attrib.getName());
                    }
                    pass = true;
                }
            }
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("entity Test  failed");
        }
    }

    @Test
    public void entityIllegalArgumentException() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            try {
                metaModel.entity(Client.class);
                logger.log(System.Logger.Level.ERROR, "Did not throw IllegalArgumentException");
            }
            catch (IllegalArgumentException iae) {
                logger.log(System.Logger.Level.TRACE, "Received expected IllegalArgumentException");
                pass = true;
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Received unexpected exception", (Throwable)e);
            }
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("entityIllegalArgumentException  failed");
        }
    }

    @Test
    public void embeddable() throws Exception {
        boolean pass = true;
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("zipcode");
        expected.add("street");
        expected.add("state");
        expected.add("city");
        try {
            this.getEntityTransaction().begin();
            Metamodel metaModel = this.getEntityManager().getMetamodel();
            if (metaModel != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
                EmbeddableType eTypeOrder = metaModel.embeddable(Address.class);
                if (eTypeOrder != null) {
                    logger.log(System.Logger.Level.TRACE, "Obtained Non-null EmbeddableType");
                    Set attribSet = eTypeOrder.getDeclaredAttributes();
                    if (attribSet != null) {
                        if (attribSet.size() != expected.size()) {
                            pass = false;
                            logger.log(System.Logger.Level.ERROR, "Received wrong number of results");
                        }
                        for (Attribute attrib : attribSet) {
                            String name = attrib.getName();
                            if (expected.contains(name)) {
                                logger.log(System.Logger.Level.TRACE, "received attribute Name = " + name);
                                continue;
                            }
                            logger.log(System.Logger.Level.ERROR, "Received unexpected result" + name);
                            pass = false;
                        }
                    } else {
                        pass = false;
                        logger.log(System.Logger.Level.ERROR, "getDeclaredAttributes() returned null");
                    }
                } else {
                    pass = false;
                    logger.log(System.Logger.Level.ERROR, "embeddable() returned null");
                }
            } else {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            pass = false;
            logger.log(System.Logger.Level.ERROR, "Received unxpected exception", (Throwable)e);
        }
    }

    @Test
    public void embeddableIllegalArgumentException() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            Metamodel metaModel = this.getEntityManager().getMetamodel();
            if (metaModel != null) {
                try {
                    metaModel.embeddable(Client.class);
                    logger.log(System.Logger.Level.ERROR, "Did not throw IllegalArgumentException");
                }
                catch (IllegalArgumentException iae) {
                    logger.log(System.Logger.Level.TRACE, "Received expected IllegalArgumentException");
                    pass = true;
                }
                catch (Exception e) {
                    logger.log(System.Logger.Level.ERROR, "Received unexpected exception", (Throwable)e);
                }
            } else {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            pass = false;
            logger.log(System.Logger.Level.ERROR, "Received unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("embeddableIllegalArgumentException failed");
        }
    }

    @AfterEach
    public void cleanup() throws Exception {
        try {
            logger.log(System.Logger.Level.TRACE, "Cleanup data");
            this.removeTestData();
            logger.log(System.Logger.Level.TRACE, "cleanup complete, calling super.cleanup");
            super.cleanup();
        }
        finally {
            this.removeTestJarFromCP();
        }
    }

    private void removeTestData() {
        logger.log(System.Logger.Level.TRACE, "removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
    }
}

