/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.metamodelapi.collectionattribute;

import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.metamodelapi.collectionattribute.Uni1XMPerson;
import ee.jakarta.tck.persistence.core.metamodelapi.collectionattribute.Uni1XMProject;
import jakarta.persistence.metamodel.CollectionAttribute;
import jakarta.persistence.metamodel.ManagedType;
import jakarta.persistence.metamodel.Metamodel;
import jakarta.persistence.metamodel.PluralAttribute;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class Client
extends PMClientBase {
    private static final System.Logger logger = System.getLogger(Client.class.getName());

    public JavaArchive createDeployment() throws Exception {
        String pkgNameWithoutSuffix = Client.class.getPackageName();
        String pkgName = pkgNameWithoutSuffix + ".";
        String[] classes = new String[]{pkgName + "Uni1XMPerson", pkgName + "Uni1XMProject"};
        return this.createDeploymentJar("jpa_core_metamodelapi_collectionattribute.jar", pkgNameWithoutSuffix, classes);
    }

    @BeforeEach
    public void setup() throws Exception {
        logger.log(System.Logger.Level.TRACE, "setup");
        try {
            super.setup();
            this.createDeployment();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception: ", (Throwable)e);
            throw new Exception("Setup failed:", e);
        }
    }

    @Test
    public void getCollectionType() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            ManagedType mType = metaModel.managedType(Uni1XMPerson.class);
            if (mType != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null ManagedType");
                CollectionAttribute colAttrib = mType.getCollection("projects", Uni1XMProject.class);
                PluralAttribute.CollectionType pluralColType = colAttrib.getCollectionType();
                logger.log(System.Logger.Level.TRACE, "collection Type = " + colAttrib.getCollectionType());
                if (pluralColType == PluralAttribute.CollectionType.COLLECTION) {
                    logger.log(System.Logger.Level.TRACE, "Received Expected Collection type = " + pluralColType);
                    pass = true;
                } else {
                    logger.log(System.Logger.Level.TRACE, "Received UnExpected Collection type = " + pluralColType);
                }
            }
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getCollectionType Test  failed");
        }
    }

    @Test
    public void getElementType() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            ManagedType mType = metaModel.managedType(Uni1XMPerson.class);
            if (mType != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null ManagedType");
                CollectionAttribute colAttrib = mType.getCollection("projects", Uni1XMProject.class);
                logger.log(System.Logger.Level.TRACE, "collection Element Type = " + colAttrib.getElementType().getJavaType().getName());
                String elementTypeName = colAttrib.getElementType().getJavaType().getName();
                if (elementTypeName.equals("ee.jakarta.tck.persistence.core.metamodelapi.collectionattribute.Uni1XMProject")) {
                    logger.log(System.Logger.Level.TRACE, "Received Expected Element type = " + elementTypeName);
                    pass = true;
                } else {
                    logger.log(System.Logger.Level.TRACE, "Received UnExpected Element type = " + elementTypeName);
                }
            }
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getElementType Test  failed");
        }
    }

    @AfterEach
    public void cleanup() throws Exception {
        try {
            logger.log(System.Logger.Level.TRACE, "in cleanup");
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
            logger.log(System.Logger.Level.TRACE, "done cleanup, calling super.cleanup");
            super.cleanup();
        }
        finally {
            this.removeTestJarFromCP();
        }
    }
}

