/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.enums;

import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.enums.Order;
import jakarta.persistence.AccessType;
import jakarta.persistence.CacheRetrieveMode;
import jakarta.persistence.CacheStoreMode;
import jakarta.persistence.CascadeType;
import jakarta.persistence.DiscriminatorType;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityTransaction;
import jakarta.persistence.EnumType;
import jakarta.persistence.FetchType;
import jakarta.persistence.FlushModeType;
import jakarta.persistence.GenerationType;
import jakarta.persistence.InheritanceType;
import jakarta.persistence.LockModeType;
import jakarta.persistence.ParameterMode;
import jakarta.persistence.PersistenceContextType;
import jakarta.persistence.PessimisticLockScope;
import jakarta.persistence.Query;
import jakarta.persistence.SharedCacheMode;
import jakarta.persistence.SynchronizationType;
import jakarta.persistence.TemporalType;
import jakarta.persistence.TypedQuery;
import jakarta.persistence.ValidationMode;
import jakarta.persistence.criteria.JoinType;
import jakarta.persistence.metamodel.Attribute;
import jakarta.persistence.metamodel.Bindable;
import jakarta.persistence.metamodel.PluralAttribute;
import jakarta.persistence.metamodel.Type;
import jakarta.persistence.spi.LoadState;
import jakarta.persistence.spi.PersistenceUnitTransactionType;
import java.util.Arrays;
import java.util.List;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class Client
extends PMClientBase {
    private static final System.Logger logger = System.getLogger(Client.class.getName());

    public JavaArchive createDeployment() throws Exception {
        String pkgNameWithoutSuffix = Client.class.getPackageName();
        String pkgName = pkgNameWithoutSuffix + ".";
        String[] classes = new String[]{pkgName + "Order"};
        return this.createDeploymentJar("jpa_core_enums.jar", pkgNameWithoutSuffix, classes);
    }

    @BeforeEach
    public void setup() throws Exception {
        logger.log(System.Logger.Level.TRACE, "setup");
        try {
            super.setup();
            this.createDeployment();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception: ", (Throwable)e);
            throw new Exception("Setup failed:", e);
        }
    }

    @Test
    public void accessTypeValueOfTest() throws Exception {
        boolean pass = true;
        try {
            AccessType at = AccessType.valueOf((String)AccessType.FIELD.name());
            if (!at.equals((Object)AccessType.FIELD)) {
                logger.log(System.Logger.Level.ERROR, "expected:" + AccessType.FIELD.name() + ", actual:" + at.name());
                pass = false;
            }
            if (!(at = AccessType.valueOf((String)AccessType.PROPERTY.name())).equals((Object)AccessType.PROPERTY)) {
                logger.log(System.Logger.Level.ERROR, "expected:" + AccessType.PROPERTY.name() + ", actual:" + at.name());
                pass = false;
            }
            try {
                AccessType.valueOf((String)"DOESNOTEXIST");
                logger.log(System.Logger.Level.ERROR, "IllegalArgumentException was not thrown");
                pass = false;
            }
            catch (IllegalArgumentException iae) {
                logger.log(System.Logger.Level.TRACE, "Received expected IllegalArgumentException");
            }
            try {
                AccessType.valueOf(null);
                logger.log(System.Logger.Level.ERROR, "NullPointerException was not thrown");
                pass = false;
            }
            catch (NullPointerException iae) {
                logger.log(System.Logger.Level.TRACE, "Received expected NullPointerException");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new Exception("accessTypeValueOfTest failed");
        }
    }

    @Test
    public void accessTypeValuesTest() throws Exception {
        boolean pass = true;
        logger.log(System.Logger.Level.TRACE, "Begin accessTypeValuesTest");
        try {
            List<AccessType> at = Arrays.asList(AccessType.values());
            if (at.size() != 2) {
                logger.log(System.Logger.Level.ERROR, "Number of AccessType expected:2, actual:" + at.size());
                pass = false;
            }
            if (at.contains(AccessType.FIELD)) {
                logger.log(System.Logger.Level.TRACE, "received:" + AccessType.FIELD.name());
            } else {
                logger.log(System.Logger.Level.ERROR, "Expected value:" + AccessType.FIELD.name());
                pass = false;
            }
            if (at.contains(AccessType.PROPERTY)) {
                logger.log(System.Logger.Level.TRACE, "received:" + AccessType.PROPERTY.name());
            } else {
                logger.log(System.Logger.Level.ERROR, "Expected value:" + AccessType.PROPERTY.name());
                pass = false;
            }
            for (AccessType a : at) {
                try {
                    AccessType.valueOf((String)a.name());
                }
                catch (Exception e) {
                    logger.log(System.Logger.Level.ERROR, "Received exception for valueOf", (Throwable)e);
                    pass = false;
                }
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new Exception("accessTypeValuesTest failed");
        }
    }

    @Test
    public void cacheRetrieveModeValueOfTest() throws Exception {
        boolean pass = true;
        logger.log(System.Logger.Level.TRACE, "Begin cacheRetrieveModeValueOfTest");
        try {
            CacheRetrieveMode crm = CacheRetrieveMode.valueOf((String)CacheRetrieveMode.USE.name());
            if (!crm.equals((Object)CacheRetrieveMode.USE)) {
                logger.log(System.Logger.Level.ERROR, "expected:" + CacheRetrieveMode.USE.name() + ", actual:" + crm.name());
                pass = false;
            }
            if (!(crm = CacheRetrieveMode.valueOf((String)CacheRetrieveMode.BYPASS.name())).equals((Object)CacheRetrieveMode.BYPASS)) {
                logger.log(System.Logger.Level.ERROR, "expected:" + CacheRetrieveMode.BYPASS.name() + ", actual:" + crm.name());
                pass = false;
            }
            try {
                CacheRetrieveMode.valueOf((String)"DOESNOTEXIST");
                logger.log(System.Logger.Level.ERROR, "IllegalArgumentException was not thrown");
                pass = false;
            }
            catch (IllegalArgumentException iae) {
                logger.log(System.Logger.Level.TRACE, "Received expected IllegalArgumentException");
            }
            try {
                CacheRetrieveMode.valueOf(null);
                logger.log(System.Logger.Level.ERROR, "NullPointerException was not thrown");
                pass = false;
            }
            catch (NullPointerException iae) {
                logger.log(System.Logger.Level.TRACE, "Received expected NullPointerException");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new Exception("cacheRetrieveModeValueOfTest failed");
        }
    }

    @Test
    public void cacheRetrieveModeValuesTest() throws Exception {
        boolean pass = true;
        logger.log(System.Logger.Level.TRACE, "Begin cacheRetrieveModeValuesTest");
        try {
            List<CacheRetrieveMode> crm = Arrays.asList(CacheRetrieveMode.values());
            if (crm.size() != 2) {
                logger.log(System.Logger.Level.ERROR, "Number of CacheRetrieveMode expected:2, actual:" + crm.size());
                pass = false;
            }
            if (crm.contains(CacheRetrieveMode.USE)) {
                logger.log(System.Logger.Level.TRACE, "received:" + CacheRetrieveMode.USE);
            } else {
                logger.log(System.Logger.Level.ERROR, "Expected value:" + CacheRetrieveMode.USE);
                pass = false;
            }
            if (crm.contains(CacheRetrieveMode.BYPASS)) {
                logger.log(System.Logger.Level.TRACE, "received:" + CacheRetrieveMode.BYPASS);
            } else {
                logger.log(System.Logger.Level.ERROR, "Expected value:" + CacheRetrieveMode.BYPASS);
                pass = false;
            }
            for (CacheRetrieveMode c : crm) {
                try {
                    CacheRetrieveMode.valueOf((String)c.name());
                }
                catch (Exception e) {
                    logger.log(System.Logger.Level.ERROR, "Received exception for valueOf", (Throwable)e);
                    pass = false;
                }
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new Exception("cacheRetrieveModeValuesTest failed");
        }
    }

    @Test
    public void cacheStoreModeValueOfTest() throws Exception {
        boolean pass = true;
        logger.log(System.Logger.Level.TRACE, "Begin cacheStoreModeValueOfTest");
        try {
            CacheStoreMode csm = CacheStoreMode.valueOf((String)CacheStoreMode.USE.name());
            if (!csm.equals((Object)CacheStoreMode.USE)) {
                logger.log(System.Logger.Level.ERROR, "expected:" + CacheStoreMode.USE.name() + ", actual:" + csm.name());
                pass = false;
            }
            if (!(csm = CacheStoreMode.valueOf((String)CacheStoreMode.BYPASS.name())).equals((Object)CacheStoreMode.BYPASS)) {
                logger.log(System.Logger.Level.ERROR, "expected:" + CacheStoreMode.BYPASS.name() + ", actual:" + csm.name());
                pass = false;
            }
            if (!(csm = CacheStoreMode.valueOf((String)CacheStoreMode.REFRESH.name())).equals((Object)CacheStoreMode.REFRESH)) {
                logger.log(System.Logger.Level.ERROR, "expected:" + CacheStoreMode.REFRESH.name() + ", actual:" + csm.name());
                pass = false;
            }
            try {
                CacheStoreMode.valueOf((String)"DOESNOTEXIST");
                logger.log(System.Logger.Level.ERROR, "IllegalArgumentException was not thrown");
                pass = false;
            }
            catch (IllegalArgumentException iae) {
                logger.log(System.Logger.Level.TRACE, "Received expected IllegalArgumentException");
            }
            try {
                CacheStoreMode.valueOf(null);
                logger.log(System.Logger.Level.ERROR, "NullPointerException was not thrown");
                pass = false;
            }
            catch (NullPointerException iae) {
                logger.log(System.Logger.Level.TRACE, "Received expected NullPointerException");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new Exception("cacheStoreModeValueOfTest failed");
        }
    }

    @Test
    public void cacheStoreModeValuesTest() throws Exception {
        boolean pass = true;
        logger.log(System.Logger.Level.TRACE, "Begin cacheStoreModeValuesTest");
        try {
            List<CacheStoreMode> csm = Arrays.asList(CacheStoreMode.values());
            if (csm.size() != 3) {
                logger.log(System.Logger.Level.ERROR, "Number of CacheStoreMode expected:3, actual:" + csm.size());
                pass = false;
            }
            if (csm.contains(CacheStoreMode.USE)) {
                logger.log(System.Logger.Level.TRACE, "received:" + CacheStoreMode.USE);
            } else {
                logger.log(System.Logger.Level.ERROR, "Expected value:" + CacheStoreMode.USE);
                pass = false;
            }
            if (csm.contains(CacheStoreMode.BYPASS)) {
                logger.log(System.Logger.Level.TRACE, "received:" + CacheStoreMode.BYPASS);
            } else {
                logger.log(System.Logger.Level.ERROR, "Expected value:" + CacheStoreMode.BYPASS);
                pass = false;
            }
            if (csm.contains(CacheStoreMode.REFRESH)) {
                logger.log(System.Logger.Level.TRACE, "received:" + CacheStoreMode.REFRESH);
            } else {
                logger.log(System.Logger.Level.ERROR, "Expected value:" + CacheStoreMode.REFRESH);
                pass = false;
            }
            for (CacheStoreMode c : csm) {
                try {
                    CacheStoreMode.valueOf((String)c.name());
                }
                catch (Exception e) {
                    logger.log(System.Logger.Level.ERROR, "Received exception for valueOf", (Throwable)e);
                    pass = false;
                }
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new Exception("cacheStoreModeValuesTest failed");
        }
    }

    @Test
    public void cascadeTypeValueOfTest() throws Exception {
        boolean pass = true;
        logger.log(System.Logger.Level.TRACE, "Begin cascadeTypeValueOfTest");
        try {
            CascadeType ct = CascadeType.valueOf((String)CascadeType.ALL.name());
            if (!ct.equals((Object)CascadeType.ALL)) {
                logger.log(System.Logger.Level.ERROR, "expected:" + CascadeType.ALL.name() + ", actual:" + ct.name());
                pass = false;
            }
            if (!(ct = CascadeType.valueOf((String)CascadeType.DETACH.name())).equals((Object)CascadeType.DETACH)) {
                logger.log(System.Logger.Level.ERROR, "expected:" + CascadeType.DETACH.name() + ", actual:" + ct.name());
                pass = false;
            }
            if (!(ct = CascadeType.valueOf((String)CascadeType.MERGE.name())).equals((Object)CascadeType.MERGE)) {
                logger.log(System.Logger.Level.ERROR, "expected:" + CascadeType.MERGE.name() + ", actual:" + ct.name());
                pass = false;
            }
            if (!(ct = CascadeType.valueOf((String)CascadeType.PERSIST.name())).equals((Object)CascadeType.PERSIST)) {
                logger.log(System.Logger.Level.ERROR, "expected:" + CascadeType.PERSIST.name() + ", actual:" + ct.name());
                pass = false;
            }
            if (!(ct = CascadeType.valueOf((String)CascadeType.REFRESH.name())).equals((Object)CascadeType.REFRESH)) {
                logger.log(System.Logger.Level.ERROR, "expected:" + CascadeType.REFRESH.name() + ", actual:" + ct.name());
                pass = false;
            }
            if (!(ct = CascadeType.valueOf((String)CascadeType.REMOVE.name())).equals((Object)CascadeType.REMOVE)) {
                logger.log(System.Logger.Level.ERROR, "expected:" + CascadeType.REMOVE.name() + ", actual:" + ct.name());
                pass = false;
            }
            try {
                CascadeType.valueOf((String)"DOESNOTEXIST");
                logger.log(System.Logger.Level.ERROR, "IllegalArgumentException was not thrown");
                pass = false;
            }
            catch (IllegalArgumentException iae) {
                logger.log(System.Logger.Level.TRACE, "Received expected IllegalArgumentException");
            }
            try {
                CascadeType.valueOf(null);
                logger.log(System.Logger.Level.ERROR, "NullPointerException was not thrown");
                pass = false;
            }
            catch (NullPointerException iae) {
                logger.log(System.Logger.Level.TRACE, "Received expected NullPointerException");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new Exception("cascadeTypeValueOfTest failed");
        }
    }

    @Test
    public void cascadeTypeValuesTest() throws Exception {
        boolean pass = true;
        logger.log(System.Logger.Level.TRACE, "Begin cascadeTypeValuesTest");
        try {
            List<CascadeType> ct = Arrays.asList(CascadeType.values());
            if (ct.size() != 6) {
                logger.log(System.Logger.Level.ERROR, "Number of CascadeType expected:6, actual:" + ct.size());
                pass = false;
            }
            if (ct.contains(CascadeType.ALL)) {
                logger.log(System.Logger.Level.TRACE, "received:" + CascadeType.ALL);
            } else {
                logger.log(System.Logger.Level.ERROR, "Expected value:" + CascadeType.ALL);
                pass = false;
            }
            if (ct.contains(CascadeType.DETACH)) {
                logger.log(System.Logger.Level.TRACE, "received:" + CascadeType.DETACH);
            } else {
                logger.log(System.Logger.Level.ERROR, "Expected value:" + CascadeType.DETACH);
                pass = false;
            }
            if (ct.contains(CascadeType.MERGE)) {
                logger.log(System.Logger.Level.TRACE, "received:" + CascadeType.MERGE);
            } else {
                logger.log(System.Logger.Level.ERROR, "Expected value:" + CascadeType.MERGE);
                pass = false;
            }
            if (ct.contains(CascadeType.PERSIST)) {
                logger.log(System.Logger.Level.TRACE, "received:" + CascadeType.PERSIST);
            } else {
                logger.log(System.Logger.Level.ERROR, "Expected value:" + CascadeType.PERSIST);
                pass = false;
            }
            if (ct.contains(CascadeType.REFRESH)) {
                logger.log(System.Logger.Level.TRACE, "received:" + CascadeType.REFRESH);
            } else {
                logger.log(System.Logger.Level.ERROR, "Expected value:" + CascadeType.REFRESH);
                pass = false;
            }
            if (ct.contains(CascadeType.REMOVE)) {
                logger.log(System.Logger.Level.TRACE, "received:" + CascadeType.REMOVE);
            } else {
                logger.log(System.Logger.Level.ERROR, "Expected value:" + CascadeType.REMOVE);
                pass = false;
            }
            for (CascadeType c : ct) {
                try {
                    CascadeType.valueOf((String)c.name());
                }
                catch (Exception e) {
                    logger.log(System.Logger.Level.ERROR, "Received exception for valueOf", (Throwable)e);
                    pass = false;
                }
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new Exception("cascadeTypeValuesTest failed");
        }
    }

    @Test
    public void discriminatorTypeValueOfTest() throws Exception {
        boolean pass = true;
        logger.log(System.Logger.Level.TRACE, "Begin discriminatorTypeValueOfTest");
        try {
            DiscriminatorType dt = DiscriminatorType.valueOf((String)DiscriminatorType.CHAR.name());
            if (!dt.equals((Object)DiscriminatorType.CHAR)) {
                logger.log(System.Logger.Level.ERROR, "expected:" + DiscriminatorType.CHAR.name() + ", actual:" + dt.name());
                pass = false;
            }
            if (!(dt = DiscriminatorType.valueOf((String)DiscriminatorType.INTEGER.name())).equals((Object)DiscriminatorType.INTEGER)) {
                logger.log(System.Logger.Level.ERROR, "expected:" + DiscriminatorType.INTEGER.name() + ", actual:" + dt.name());
                pass = false;
            }
            if (!(dt = DiscriminatorType.valueOf((String)DiscriminatorType.STRING.name())).equals((Object)DiscriminatorType.STRING)) {
                logger.log(System.Logger.Level.ERROR, "expected:" + DiscriminatorType.STRING.name() + ", actual:" + dt.name());
                pass = false;
            }
            try {
                DiscriminatorType.valueOf((String)"DOESNOTEXIST");
                logger.log(System.Logger.Level.ERROR, "IllegalArgumentException was not thrown");
                pass = false;
            }
            catch (IllegalArgumentException iae) {
                logger.log(System.Logger.Level.TRACE, "Received expected IllegalArgumentException");
            }
            try {
                DiscriminatorType.valueOf(null);
                logger.log(System.Logger.Level.ERROR, "NullPointerException was not thrown");
                pass = false;
            }
            catch (NullPointerException iae) {
                logger.log(System.Logger.Level.TRACE, "Received expected NullPointerException");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new Exception("discriminatorTypeValueOfTest failed");
        }
    }

    @Test
    public void discriminatorTypeValuesTest() throws Exception {
        boolean pass = true;
        logger.log(System.Logger.Level.TRACE, "Begin discriminatorTypeValuesTest");
        try {
            List<DiscriminatorType> dt = Arrays.asList(DiscriminatorType.values());
            if (dt.size() != 3) {
                logger.log(System.Logger.Level.ERROR, "Number of DiscriminatorType expected:3, actual:" + dt.size());
                pass = false;
            }
            if (dt.contains(DiscriminatorType.CHAR)) {
                logger.log(System.Logger.Level.TRACE, "received:" + DiscriminatorType.CHAR);
            } else {
                logger.log(System.Logger.Level.ERROR, "Expected value:" + DiscriminatorType.CHAR);
                pass = false;
            }
            if (dt.contains(DiscriminatorType.INTEGER)) {
                logger.log(System.Logger.Level.TRACE, "received:" + DiscriminatorType.INTEGER);
            } else {
                logger.log(System.Logger.Level.ERROR, "Expected value:" + DiscriminatorType.INTEGER);
                pass = false;
            }
            if (dt.contains(DiscriminatorType.STRING)) {
                logger.log(System.Logger.Level.TRACE, "received:" + DiscriminatorType.STRING);
            } else {
                logger.log(System.Logger.Level.ERROR, "Expected value:" + DiscriminatorType.STRING);
                pass = false;
            }
            for (DiscriminatorType d : dt) {
                try {
                    DiscriminatorType.valueOf((String)d.name());
                }
                catch (Exception e) {
                    logger.log(System.Logger.Level.ERROR, "Received exception for valueOf", (Throwable)e);
                    pass = false;
                }
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new Exception("discriminatorTypeValuesTest failed");
        }
    }

    @Test
    public void enumTypeValueOfTest() throws Exception {
        boolean pass = true;
        logger.log(System.Logger.Level.TRACE, "Begin enumTypeValueOfTest");
        try {
            EnumType et = EnumType.valueOf((String)EnumType.ORDINAL.name());
            if (!et.equals((Object)EnumType.ORDINAL)) {
                logger.log(System.Logger.Level.ERROR, "expected:" + EnumType.ORDINAL.name() + ", actual:" + et.name());
                pass = false;
            }
            if (!(et = EnumType.valueOf((String)EnumType.STRING.name())).equals((Object)EnumType.STRING)) {
                logger.log(System.Logger.Level.ERROR, "expected:" + EnumType.STRING.name() + ", actual:" + et.name());
                pass = false;
            }
            try {
                EnumType.valueOf((String)"DOESNOTEXIST");
                logger.log(System.Logger.Level.ERROR, "IllegalArgumentException was not thrown");
                pass = false;
            }
            catch (IllegalArgumentException iae) {
                logger.log(System.Logger.Level.TRACE, "Received expected IllegalArgumentException");
            }
            try {
                EnumType.valueOf(null);
                logger.log(System.Logger.Level.ERROR, "NullPointerException was not thrown");
                pass = false;
            }
            catch (NullPointerException iae) {
                logger.log(System.Logger.Level.TRACE, "Received expected NullPointerException");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new Exception("enumTypeValueOfTest failed");
        }
    }

    @Test
    public void enumTypeValuesTest() throws Exception {
        boolean pass = true;
        logger.log(System.Logger.Level.TRACE, "Begin enumTypeValuesTest");
        try {
            List<EnumType> et = Arrays.asList(EnumType.values());
            if (et.size() != 2) {
                logger.log(System.Logger.Level.ERROR, "Number of EnumType expected:2, actual:" + et.size());
                pass = false;
            }
            if (et.contains(EnumType.ORDINAL)) {
                logger.log(System.Logger.Level.TRACE, "received:" + EnumType.ORDINAL);
            } else {
                logger.log(System.Logger.Level.ERROR, "Expected value:" + EnumType.ORDINAL);
                pass = false;
            }
            if (et.contains(EnumType.STRING)) {
                logger.log(System.Logger.Level.TRACE, "received:" + EnumType.STRING);
            } else {
                logger.log(System.Logger.Level.ERROR, "Expected value:" + EnumType.STRING);
                pass = false;
            }
            for (EnumType e : et) {
                try {
                    EnumType.valueOf((String)e.name());
                }
                catch (Exception ex) {
                    logger.log(System.Logger.Level.ERROR, "Received exception for valueOf", (Throwable)ex);
                    pass = false;
                }
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new Exception("enumTypeValuesTest failed");
        }
    }

    @Test
    public void fetchTypeValueOfTest() throws Exception {
        boolean pass = true;
        logger.log(System.Logger.Level.TRACE, "Begin fetchTypeValueOfTest");
        try {
            FetchType ft = FetchType.valueOf((String)FetchType.EAGER.name());
            if (!ft.equals((Object)FetchType.EAGER)) {
                logger.log(System.Logger.Level.ERROR, "expected:" + FetchType.EAGER.name() + ", actual:" + ft.name());
                pass = false;
            }
            if (!(ft = FetchType.valueOf((String)FetchType.LAZY.name())).equals((Object)FetchType.LAZY)) {
                logger.log(System.Logger.Level.ERROR, "expected:" + FetchType.LAZY.name() + ", actual:" + ft.name());
                pass = false;
            }
            try {
                FetchType.valueOf((String)"DOESNOTEXIST");
                logger.log(System.Logger.Level.ERROR, "IllegalArgumentException was not thrown");
                pass = false;
            }
            catch (IllegalArgumentException iae) {
                logger.log(System.Logger.Level.TRACE, "Received expected IllegalArgumentException");
            }
            try {
                FetchType.valueOf(null);
                logger.log(System.Logger.Level.ERROR, "NullPointerException was not thrown");
                pass = false;
            }
            catch (NullPointerException iae) {
                logger.log(System.Logger.Level.TRACE, "Received expected NullPointerException");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new Exception("fetchTypeValueOfTest failed");
        }
    }

    @Test
    public void fetchTypeValuesTest() throws Exception {
        boolean pass = true;
        logger.log(System.Logger.Level.TRACE, "Begin fetchTypeValuesTest");
        try {
            List<FetchType> ft = Arrays.asList(FetchType.values());
            if (ft.size() != 2) {
                logger.log(System.Logger.Level.ERROR, "Number of FetchType expected:2, actual:" + ft.size());
                pass = false;
            }
            if (ft.contains(FetchType.EAGER)) {
                logger.log(System.Logger.Level.TRACE, "received:" + FetchType.EAGER);
            } else {
                logger.log(System.Logger.Level.ERROR, "Expected value:" + FetchType.EAGER);
                pass = false;
            }
            if (ft.contains(FetchType.LAZY)) {
                logger.log(System.Logger.Level.TRACE, "received:" + FetchType.LAZY);
            } else {
                logger.log(System.Logger.Level.ERROR, "Expected value:" + FetchType.LAZY);
                pass = false;
            }
            for (FetchType f : ft) {
                try {
                    FetchType.valueOf((String)f.name());
                }
                catch (Exception e) {
                    logger.log(System.Logger.Level.ERROR, "Received exception for valueOf", (Throwable)e);
                    pass = false;
                }
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new Exception("fetchTypeValuesTest failed");
        }
    }

    @Test
    public void flushModeTypeValueOfTest() throws Exception {
        boolean pass = true;
        try {
            FlushModeType fmt = FlushModeType.valueOf((String)FlushModeType.AUTO.name());
            if (!fmt.equals((Object)FlushModeType.AUTO)) {
                logger.log(System.Logger.Level.ERROR, "expected:" + FlushModeType.AUTO.name() + ", actual:" + fmt.name());
                pass = false;
            }
            if (!(fmt = FlushModeType.valueOf((String)FlushModeType.COMMIT.name())).equals((Object)FlushModeType.COMMIT)) {
                logger.log(System.Logger.Level.ERROR, "expected:" + FlushModeType.COMMIT.name() + ", actual:" + fmt.name());
                pass = false;
            }
            try {
                FlushModeType.valueOf((String)"DOESNOTEXIST");
                logger.log(System.Logger.Level.ERROR, "IllegalArgumentException was not thrown");
                pass = false;
            }
            catch (IllegalArgumentException iae) {
                logger.log(System.Logger.Level.TRACE, "Received expected IllegalArgumentException");
            }
            try {
                FlushModeType.valueOf(null);
                logger.log(System.Logger.Level.ERROR, "NullPointerException was not thrown");
                pass = false;
            }
            catch (NullPointerException iae) {
                logger.log(System.Logger.Level.TRACE, "Received expected NullPointerException");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception: ", (Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new Exception("flushModeTypeValueOfTest failed");
        }
    }

    @Test
    public void flushModeTypeValuesTest() throws Exception {
        boolean pass = true;
        boolean count = false;
        try {
            List<FlushModeType> fmt = Arrays.asList(FlushModeType.values());
            if (fmt.size() != 2) {
                logger.log(System.Logger.Level.ERROR, "Number of FlushModeType expected:2, actual:" + fmt.size());
                pass = false;
            }
            if (fmt.contains(FlushModeType.COMMIT)) {
                logger.log(System.Logger.Level.TRACE, "received:" + FlushModeType.COMMIT);
            } else {
                logger.log(System.Logger.Level.ERROR, "Expected value:" + FlushModeType.COMMIT);
                pass = false;
            }
            if (fmt.contains(FlushModeType.AUTO)) {
                logger.log(System.Logger.Level.TRACE, "received:" + FlushModeType.AUTO);
            } else {
                logger.log(System.Logger.Level.ERROR, "Expected value:" + FlushModeType.AUTO);
                pass = false;
            }
            for (FlushModeType f : fmt) {
                try {
                    FlushModeType.valueOf((String)f.name());
                }
                catch (Exception e) {
                    logger.log(System.Logger.Level.ERROR, "Received exception for valueOf", (Throwable)e);
                    pass = false;
                }
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception: ", (Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new Exception("flushModeTypeValuesTest failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void setgetFlushModeEntityManagerTest() throws Exception {
        boolean pass = true;
        try {
            EntityTransaction t = this.getEntityTransaction();
            t.begin();
            EntityManager em = this.getEntityManager();
            logger.log(System.Logger.Level.TRACE, "Checking Default mode");
            FlushModeType fmt = em.getFlushMode();
            if (fmt.equals((Object)FlushModeType.AUTO)) {
                logger.log(System.Logger.Level.TRACE, "Checking COMMIT");
                em.setFlushMode(FlushModeType.COMMIT);
                fmt = em.getFlushMode();
                if (fmt.equals((Object)FlushModeType.COMMIT)) {
                    logger.log(System.Logger.Level.TRACE, "Checking AUTO");
                    em.setFlushMode(FlushModeType.AUTO);
                    fmt = em.getFlushMode();
                    if (!fmt.equals((Object)FlushModeType.AUTO)) {
                        logger.log(System.Logger.Level.ERROR, "Expected a value of:" + FlushModeType.AUTO.name() + ", actual:" + fmt.name());
                        pass = false;
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "Expected a value of:" + FlushModeType.COMMIT.name() + ", actual:" + fmt.name());
                    pass = false;
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "Expected a default value of:" + FlushModeType.AUTO.name() + ", actual:" + fmt.name());
                pass = false;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: ", (Throwable)e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("setgetFlushModeEntityManagerTest failed");
        }
    }

    @Test
    public void setgetFlushModeTest() throws Exception {
        boolean pass = true;
        try {
            EntityManager em = this.getEntityManager();
            Query q = em.createQuery("SELECT o FROM Order o WHERE o.id = 1");
            logger.log(System.Logger.Level.TRACE, "Getting mode from query");
            FlushModeType fmt = q.getFlushMode();
            if (fmt.equals((Object)em.getFlushMode())) {
                logger.log(System.Logger.Level.TRACE, "Setting mode to return default mode");
                q.setFlushMode(fmt);
                logger.log(System.Logger.Level.TRACE, "Setting mode to FlushModeType.COMMIT");
                q.setFlushMode(FlushModeType.COMMIT);
                fmt = q.getFlushMode();
                if (fmt.equals((Object)FlushModeType.COMMIT)) {
                    logger.log(System.Logger.Level.TRACE, "Setting mode to FlushModeType.AUTO");
                    q.setFlushMode(FlushModeType.AUTO);
                    fmt = q.getFlushMode();
                    if (fmt.equals((Object)FlushModeType.AUTO)) {
                        logger.log(System.Logger.Level.TRACE, "Received expected FlushModeType:" + fmt.name());
                    } else {
                        logger.log(System.Logger.Level.ERROR, "Expected a value of:" + FlushModeType.AUTO.name() + ", actual:" + fmt.name());
                        pass = false;
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "Expected a default value of:" + FlushModeType.COMMIT.name() + ", actual:" + fmt.name());
                    pass = false;
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "Expected EntityManager value of:" + em.getFlushMode() + ", actual:" + fmt.name());
                pass = false;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: ", (Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new Exception("setgetFlushModeTest failed");
        }
    }

    @Test
    public void setgetFlushModeTQTest() throws Exception {
        boolean pass = true;
        try {
            EntityManager em = this.getEntityManager();
            TypedQuery q = em.createQuery("SELECT o FROM Order o WHERE o.id = 1", Order.class);
            FlushModeType fmt = q.getFlushMode();
            if (fmt.equals((Object)em.getFlushMode())) {
                logger.log(System.Logger.Level.TRACE, "Setting mode to returned default mode");
                q.setFlushMode(fmt);
                logger.log(System.Logger.Level.TRACE, "Setting mode to FlushModeType.COMMIT");
                q.setFlushMode(FlushModeType.COMMIT);
                fmt = q.getFlushMode();
                if (fmt.equals((Object)FlushModeType.COMMIT)) {
                    logger.log(System.Logger.Level.TRACE, "Setting mode to FlushModeType.AUTO");
                    q.setFlushMode(FlushModeType.AUTO);
                    fmt = q.getFlushMode();
                    if (!fmt.equals((Object)FlushModeType.AUTO)) {
                        logger.log(System.Logger.Level.ERROR, "Expected a value of:" + FlushModeType.AUTO.name() + ", actual:" + fmt.name());
                        pass = false;
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "Expected a default value of:" + FlushModeType.COMMIT.name() + ", actual:" + fmt.name());
                    pass = false;
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "Expected EntityManager value of:" + em.getFlushMode().name() + ", actual:" + fmt.name());
                pass = false;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: ", (Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new Exception("setgetFlushModeTQTest failed");
        }
    }

    @Test
    public void generationTypeValueOfTest() throws Exception {
        boolean pass = true;
        try {
            GenerationType ft = GenerationType.valueOf((String)GenerationType.AUTO.name());
            if (!ft.equals((Object)GenerationType.AUTO)) {
                logger.log(System.Logger.Level.ERROR, "expected:" + GenerationType.AUTO.name() + ", actual:" + ft.name());
                pass = false;
            }
            if (!(ft = GenerationType.valueOf((String)GenerationType.IDENTITY.name())).equals((Object)GenerationType.IDENTITY)) {
                logger.log(System.Logger.Level.ERROR, "expected:" + GenerationType.IDENTITY.name() + ", actual:" + ft.name());
                pass = false;
            }
            if (!(ft = GenerationType.valueOf((String)GenerationType.SEQUENCE.name())).equals((Object)GenerationType.SEQUENCE)) {
                logger.log(System.Logger.Level.ERROR, "expected:" + GenerationType.SEQUENCE.name() + ", actual:" + ft.name());
                pass = false;
            }
            if (!(ft = GenerationType.valueOf((String)GenerationType.TABLE.name())).equals((Object)GenerationType.TABLE)) {
                logger.log(System.Logger.Level.ERROR, "expected:" + GenerationType.TABLE.name() + ", actual:" + ft.name());
                pass = false;
            }
            if (!(ft = GenerationType.valueOf((String)GenerationType.UUID.name())).equals((Object)GenerationType.UUID)) {
                logger.log(System.Logger.Level.ERROR, "expected:" + GenerationType.UUID.name() + ", actual:" + ft.name());
                pass = false;
            }
            try {
                GenerationType.valueOf((String)"DOESNOTEXIST");
                logger.log(System.Logger.Level.ERROR, "IllegalArgumentException was not thrown");
                pass = false;
            }
            catch (IllegalArgumentException iae) {
                logger.log(System.Logger.Level.TRACE, "Received expected IllegalArgumentException");
            }
            try {
                GenerationType.valueOf(null);
                logger.log(System.Logger.Level.ERROR, "NullPointerException was not thrown");
                pass = false;
            }
            catch (NullPointerException iae) {
                logger.log(System.Logger.Level.TRACE, "Received expected NullPointerException");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new Exception("generationTypeValueOfTest failed");
        }
    }

    @Test
    public void generationTypeValuesTest() throws Exception {
        boolean pass = true;
        try {
            List<GenerationType> gt = Arrays.asList(GenerationType.values());
            if (gt.size() != 5) {
                logger.log(System.Logger.Level.ERROR, "Number of GenerationType expected:5, actual:" + gt.size());
                pass = false;
            }
            if (gt.contains(GenerationType.AUTO)) {
                logger.log(System.Logger.Level.TRACE, "received:" + GenerationType.AUTO);
            } else {
                logger.log(System.Logger.Level.ERROR, "Expected value:" + GenerationType.AUTO);
                pass = false;
            }
            if (gt.contains(GenerationType.IDENTITY)) {
                logger.log(System.Logger.Level.TRACE, "received:" + GenerationType.IDENTITY);
            } else {
                logger.log(System.Logger.Level.ERROR, "Expected value:" + GenerationType.IDENTITY);
                pass = false;
            }
            if (gt.contains(GenerationType.SEQUENCE)) {
                logger.log(System.Logger.Level.TRACE, "received:" + GenerationType.SEQUENCE);
            } else {
                logger.log(System.Logger.Level.ERROR, "Expected value:" + GenerationType.SEQUENCE);
                pass = false;
            }
            if (gt.contains(GenerationType.TABLE)) {
                logger.log(System.Logger.Level.TRACE, "received:" + GenerationType.TABLE);
            } else {
                logger.log(System.Logger.Level.ERROR, "Expected value:" + GenerationType.TABLE);
                pass = false;
            }
            if (gt.contains(GenerationType.UUID)) {
                logger.log(System.Logger.Level.TRACE, "received:" + GenerationType.UUID);
            } else {
                logger.log(System.Logger.Level.ERROR, "Expected value:" + GenerationType.UUID);
                pass = false;
            }
            for (GenerationType g : gt) {
                try {
                    GenerationType.valueOf((String)g.name());
                }
                catch (Exception e) {
                    logger.log(System.Logger.Level.ERROR, "Received exception for valueOf", (Throwable)e);
                    pass = false;
                }
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new Exception("generationTypeValuesTest failed");
        }
    }

    @Test
    public void inheritanceTypeValueOfTest() throws Exception {
        boolean pass = true;
        try {
            InheritanceType ft = InheritanceType.valueOf((String)InheritanceType.JOINED.name());
            if (!ft.equals((Object)InheritanceType.JOINED)) {
                logger.log(System.Logger.Level.ERROR, "expected:" + InheritanceType.JOINED.name() + ", actual:" + ft.name());
                pass = false;
            }
            if (!(ft = InheritanceType.valueOf((String)InheritanceType.SINGLE_TABLE.name())).equals((Object)InheritanceType.SINGLE_TABLE)) {
                logger.log(System.Logger.Level.ERROR, "expected:" + InheritanceType.SINGLE_TABLE.name() + ", actual:" + ft.name());
                pass = false;
            }
            if (!(ft = InheritanceType.valueOf((String)InheritanceType.TABLE_PER_CLASS.name())).equals((Object)InheritanceType.TABLE_PER_CLASS)) {
                logger.log(System.Logger.Level.ERROR, "expected:" + InheritanceType.TABLE_PER_CLASS.name() + ", actual:" + ft.name());
                pass = false;
            }
            try {
                InheritanceType.valueOf((String)"DOESNOTEXIST");
                logger.log(System.Logger.Level.ERROR, "IllegalArgumentException was not thrown");
                pass = false;
            }
            catch (IllegalArgumentException iae) {
                logger.log(System.Logger.Level.TRACE, "Received expected IllegalArgumentException");
            }
            try {
                InheritanceType.valueOf(null);
                logger.log(System.Logger.Level.ERROR, "NullPointerException was not thrown");
                pass = false;
            }
            catch (NullPointerException iae) {
                logger.log(System.Logger.Level.TRACE, "Received expected NullPointerException");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new Exception("inheritanceTypeValueOfTest failed");
        }
    }

    @Test
    public void inheritanceTypeValuesTest() throws Exception {
        boolean pass = true;
        try {
            List<InheritanceType> it = Arrays.asList(InheritanceType.values());
            if (it.size() != 3) {
                logger.log(System.Logger.Level.ERROR, "Number of InheritanceType expected:3, actual:" + it.size());
                pass = false;
            }
            if (it.contains(InheritanceType.JOINED)) {
                logger.log(System.Logger.Level.TRACE, "received:" + InheritanceType.JOINED);
            } else {
                logger.log(System.Logger.Level.ERROR, "Expected value:" + InheritanceType.JOINED);
                pass = false;
            }
            if (it.contains(InheritanceType.SINGLE_TABLE)) {
                logger.log(System.Logger.Level.TRACE, "received:" + InheritanceType.SINGLE_TABLE);
            } else {
                logger.log(System.Logger.Level.ERROR, "Expected value:" + InheritanceType.SINGLE_TABLE);
                pass = false;
            }
            if (it.contains(InheritanceType.TABLE_PER_CLASS)) {
                logger.log(System.Logger.Level.TRACE, "received:" + InheritanceType.TABLE_PER_CLASS);
            } else {
                logger.log(System.Logger.Level.ERROR, "Expected value:" + InheritanceType.TABLE_PER_CLASS);
                pass = false;
            }
            for (InheritanceType i : it) {
                try {
                    InheritanceType.valueOf((String)i.name());
                }
                catch (Exception e) {
                    logger.log(System.Logger.Level.ERROR, "Received exception for valueOf", (Throwable)e);
                    pass = false;
                }
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new Exception("inheritanceTypeValuesTest failed");
        }
    }

    @Test
    public void lockModeTypeValueOfTest() throws Exception {
        boolean pass = true;
        try {
            LockModeType lm = LockModeType.valueOf((String)LockModeType.NONE.name());
            if (!lm.equals((Object)LockModeType.NONE)) {
                logger.log(System.Logger.Level.ERROR, "expected:" + LockModeType.NONE + ", actual:" + lm.name());
                pass = false;
            }
            if (!(lm = LockModeType.valueOf((String)LockModeType.OPTIMISTIC.name())).equals((Object)LockModeType.OPTIMISTIC)) {
                logger.log(System.Logger.Level.ERROR, "expected:" + LockModeType.OPTIMISTIC.name() + ", actual:" + lm.name());
                pass = false;
            }
            if (!(lm = LockModeType.valueOf((String)LockModeType.OPTIMISTIC_FORCE_INCREMENT.name())).equals((Object)LockModeType.OPTIMISTIC_FORCE_INCREMENT)) {
                logger.log(System.Logger.Level.ERROR, "expected:" + LockModeType.OPTIMISTIC_FORCE_INCREMENT.name() + ", actual:" + lm.name());
                pass = false;
            }
            if (!(lm = LockModeType.valueOf((String)LockModeType.PESSIMISTIC_READ.name())).equals((Object)LockModeType.PESSIMISTIC_READ)) {
                logger.log(System.Logger.Level.ERROR, "expected:" + LockModeType.PESSIMISTIC_READ.name() + ", actual:" + lm.name());
                pass = false;
            }
            if (!(lm = LockModeType.valueOf((String)LockModeType.PESSIMISTIC_WRITE.name())).equals((Object)LockModeType.PESSIMISTIC_WRITE)) {
                logger.log(System.Logger.Level.ERROR, "expected:" + LockModeType.PESSIMISTIC_WRITE.name() + ", actual:" + lm.name());
                pass = false;
            }
            if (!(lm = LockModeType.valueOf((String)LockModeType.READ.name())).equals((Object)LockModeType.READ)) {
                logger.log(System.Logger.Level.ERROR, "expected:" + LockModeType.READ.name() + ", actual:" + lm.name());
                pass = false;
            }
            if (!(lm = LockModeType.valueOf((String)LockModeType.WRITE.name())).equals((Object)LockModeType.WRITE)) {
                logger.log(System.Logger.Level.ERROR, "expected:" + LockModeType.WRITE.name() + ", actual:" + lm.name());
                pass = false;
            }
            try {
                LockModeType.valueOf((String)"DOESNOTEXIST");
                logger.log(System.Logger.Level.ERROR, "IllegalArgumentException was not thrown");
                pass = false;
            }
            catch (IllegalArgumentException iae) {
                logger.log(System.Logger.Level.TRACE, "Received expected IllegalArgumentException");
            }
            try {
                LockModeType.valueOf(null);
                logger.log(System.Logger.Level.ERROR, "NullPointerException was not thrown");
                pass = false;
            }
            catch (NullPointerException iae) {
                logger.log(System.Logger.Level.TRACE, "Received expected NullPointerException");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new Exception("lockModeTypeValueOfTest failed");
        }
    }

    @Test
    public void lockModeTypeValuesTest() throws Exception {
        boolean pass = true;
        try {
            List<LockModeType> lm = Arrays.asList(LockModeType.values());
            if (lm.size() != 8) {
                logger.log(System.Logger.Level.ERROR, "Number of LockModeTypes expected:8, actual:" + lm.size());
                pass = false;
            }
            if (lm.contains(LockModeType.NONE)) {
                logger.log(System.Logger.Level.TRACE, "received:" + LockModeType.NONE);
            } else {
                logger.log(System.Logger.Level.ERROR, "Expected value:" + LockModeType.NONE);
                pass = false;
            }
            if (lm.contains(LockModeType.OPTIMISTIC)) {
                logger.log(System.Logger.Level.TRACE, "received:" + LockModeType.OPTIMISTIC);
            } else {
                logger.log(System.Logger.Level.ERROR, "Expected value:" + LockModeType.OPTIMISTIC);
                pass = false;
            }
            if (lm.contains(LockModeType.OPTIMISTIC_FORCE_INCREMENT)) {
                logger.log(System.Logger.Level.TRACE, "received:" + LockModeType.OPTIMISTIC_FORCE_INCREMENT);
            } else {
                logger.log(System.Logger.Level.ERROR, "Expected value:" + LockModeType.OPTIMISTIC_FORCE_INCREMENT);
                pass = false;
            }
            if (lm.contains(LockModeType.PESSIMISTIC_FORCE_INCREMENT)) {
                logger.log(System.Logger.Level.TRACE, "received:" + LockModeType.PESSIMISTIC_FORCE_INCREMENT);
            } else {
                logger.log(System.Logger.Level.ERROR, "Expected value:" + LockModeType.PESSIMISTIC_FORCE_INCREMENT);
                pass = false;
            }
            if (lm.contains(LockModeType.PESSIMISTIC_READ)) {
                logger.log(System.Logger.Level.TRACE, "received:" + LockModeType.PESSIMISTIC_READ);
            } else {
                logger.log(System.Logger.Level.ERROR, "Expected value:" + LockModeType.PESSIMISTIC_READ);
                pass = false;
            }
            if (lm.contains(LockModeType.PESSIMISTIC_WRITE)) {
                logger.log(System.Logger.Level.TRACE, "received:" + LockModeType.PESSIMISTIC_WRITE);
            } else {
                logger.log(System.Logger.Level.ERROR, "Expected value:" + LockModeType.PESSIMISTIC_WRITE);
                pass = false;
            }
            if (lm.contains(LockModeType.READ)) {
                logger.log(System.Logger.Level.TRACE, "received:" + LockModeType.READ);
            } else {
                logger.log(System.Logger.Level.ERROR, "Expected value:" + LockModeType.READ);
                pass = false;
            }
            if (lm.contains(LockModeType.WRITE)) {
                logger.log(System.Logger.Level.TRACE, "received:" + LockModeType.WRITE);
            } else {
                logger.log(System.Logger.Level.ERROR, "Expected value:" + LockModeType.WRITE);
                pass = false;
            }
            for (LockModeType l : lm) {
                try {
                    LockModeType.valueOf((String)l.name());
                }
                catch (Exception e) {
                    logger.log(System.Logger.Level.ERROR, "Received exception for valueOf", (Throwable)e);
                    pass = false;
                }
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new Exception("lockModeTypeValuesTest failed");
        }
    }

    @Test
    public void persistenceContextTypeValueOfTest() throws Exception {
        boolean pass = true;
        try {
            PersistenceContextType pct = PersistenceContextType.valueOf((String)PersistenceContextType.EXTENDED.name());
            if (!pct.equals((Object)PersistenceContextType.EXTENDED)) {
                logger.log(System.Logger.Level.ERROR, "expected:" + PersistenceContextType.EXTENDED.name() + ", actual:" + pct.name());
                pass = false;
            }
            if (!(pct = PersistenceContextType.valueOf((String)PersistenceContextType.TRANSACTION.name())).equals((Object)PersistenceContextType.TRANSACTION)) {
                logger.log(System.Logger.Level.ERROR, "expected:" + PersistenceContextType.TRANSACTION.name() + ", actual:" + pct.name());
                pass = false;
            }
            try {
                PersistenceContextType.valueOf((String)"DOESNOTEXIST");
                logger.log(System.Logger.Level.ERROR, "IllegalArgumentException was not thrown");
                pass = false;
            }
            catch (IllegalArgumentException iae) {
                logger.log(System.Logger.Level.TRACE, "Received expected IllegalArgumentException");
            }
            try {
                PersistenceContextType.valueOf(null);
                logger.log(System.Logger.Level.ERROR, "NullPointerException was not thrown");
                pass = false;
            }
            catch (NullPointerException iae) {
                logger.log(System.Logger.Level.TRACE, "Received expected NullPointerException");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new Exception("persistenceContextTypeValueOfTest failed");
        }
    }

    @Test
    public void persistenceContextTypeValuesTest() throws Exception {
        boolean pass = true;
        try {
            List<PersistenceContextType> pct = Arrays.asList(PersistenceContextType.values());
            if (pct.size() != 2) {
                logger.log(System.Logger.Level.ERROR, "Number of PersistenceContextType expected:2, actual:" + pct.size());
                pass = false;
            }
            if (pct.contains(PersistenceContextType.EXTENDED)) {
                logger.log(System.Logger.Level.TRACE, "received:" + PersistenceContextType.EXTENDED);
            } else {
                logger.log(System.Logger.Level.ERROR, "Expected value:" + PersistenceContextType.EXTENDED);
                pass = false;
            }
            if (pct.contains(PersistenceContextType.TRANSACTION)) {
                logger.log(System.Logger.Level.TRACE, "received:" + PersistenceContextType.TRANSACTION);
            } else {
                logger.log(System.Logger.Level.ERROR, "Expected value:" + PersistenceContextType.TRANSACTION);
                pass = false;
            }
            for (PersistenceContextType p : pct) {
                try {
                    PersistenceContextType.valueOf((String)p.name());
                }
                catch (Exception e) {
                    logger.log(System.Logger.Level.ERROR, "Received exception for valueOf", (Throwable)e);
                    pass = false;
                }
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new Exception("persistenceContextTypeValuesTest failed");
        }
    }

    @Test
    public void pessimisticLockScopeValueOfTest() throws Exception {
        boolean pass = true;
        try {
            PessimisticLockScope pls = PessimisticLockScope.valueOf((String)PessimisticLockScope.EXTENDED.name());
            if (!pls.equals((Object)PessimisticLockScope.EXTENDED)) {
                logger.log(System.Logger.Level.ERROR, "expected:" + PessimisticLockScope.EXTENDED.name() + ", actual:" + pls.name());
                pass = false;
            }
            if (!(pls = PessimisticLockScope.valueOf((String)PessimisticLockScope.NORMAL.name())).equals((Object)PessimisticLockScope.NORMAL)) {
                logger.log(System.Logger.Level.ERROR, "expected:" + PessimisticLockScope.NORMAL.name() + ", actual:" + pls.name());
                pass = false;
            }
            try {
                PessimisticLockScope.valueOf((String)"DOESNOTEXIST");
                logger.log(System.Logger.Level.ERROR, "IllegalArgumentException was not thrown");
                pass = false;
            }
            catch (IllegalArgumentException iae) {
                logger.log(System.Logger.Level.TRACE, "Received expected IllegalArgumentException");
            }
            try {
                PessimisticLockScope.valueOf(null);
                logger.log(System.Logger.Level.ERROR, "NullPointerException was not thrown");
                pass = false;
            }
            catch (NullPointerException iae) {
                logger.log(System.Logger.Level.TRACE, "Received expected NullPointerException");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new Exception("pessimisticLockScopeValueOfTest failed");
        }
    }

    @Test
    public void pessimisticLockScopeValuesTest() throws Exception {
        boolean pass = true;
        try {
            List<PessimisticLockScope> pls = Arrays.asList(PessimisticLockScope.values());
            if (pls.size() != 2) {
                logger.log(System.Logger.Level.ERROR, "Number of PessimisticLockScope expected:2, actual:" + pls.size());
                pass = false;
            }
            if (pls.contains(PessimisticLockScope.EXTENDED)) {
                logger.log(System.Logger.Level.TRACE, "received:" + PessimisticLockScope.EXTENDED);
            } else {
                logger.log(System.Logger.Level.ERROR, "Expected value:" + PessimisticLockScope.EXTENDED);
                pass = false;
            }
            if (pls.contains(PessimisticLockScope.NORMAL)) {
                logger.log(System.Logger.Level.TRACE, "received:" + PessimisticLockScope.NORMAL);
            } else {
                logger.log(System.Logger.Level.ERROR, "Expected value:" + PessimisticLockScope.NORMAL);
                pass = false;
            }
            for (PessimisticLockScope p : pls) {
                try {
                    PessimisticLockScope.valueOf((String)p.name());
                }
                catch (Exception e) {
                    logger.log(System.Logger.Level.ERROR, "Received exception for valueOf", (Throwable)e);
                    pass = false;
                }
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new Exception("pessimisticLockScopeValuesTest failed");
        }
    }

    @Test
    public void sharedCacheModeValueOfTest() throws Exception {
        boolean pass = true;
        try {
            SharedCacheMode scm = SharedCacheMode.valueOf((String)SharedCacheMode.ALL.name());
            if (!scm.equals((Object)SharedCacheMode.ALL)) {
                logger.log(System.Logger.Level.ERROR, "expected:" + SharedCacheMode.ALL.name() + ", actual:" + scm.name());
                pass = false;
            }
            if (!(scm = SharedCacheMode.valueOf((String)SharedCacheMode.DISABLE_SELECTIVE.name())).equals((Object)SharedCacheMode.DISABLE_SELECTIVE)) {
                logger.log(System.Logger.Level.ERROR, "expected:" + SharedCacheMode.DISABLE_SELECTIVE.name() + ", actual:" + scm.name());
                pass = false;
            }
            if (!(scm = SharedCacheMode.valueOf((String)SharedCacheMode.ENABLE_SELECTIVE.name())).equals((Object)SharedCacheMode.ENABLE_SELECTIVE)) {
                logger.log(System.Logger.Level.ERROR, "expected:" + SharedCacheMode.ENABLE_SELECTIVE.name() + ", actual:" + scm.name());
                pass = false;
            }
            if (!(scm = SharedCacheMode.valueOf((String)SharedCacheMode.NONE.name())).equals((Object)SharedCacheMode.NONE)) {
                logger.log(System.Logger.Level.ERROR, "expected:" + SharedCacheMode.NONE.name() + ", actual:" + scm.name());
                pass = false;
            }
            if (!(scm = SharedCacheMode.valueOf((String)SharedCacheMode.UNSPECIFIED.name())).equals((Object)SharedCacheMode.UNSPECIFIED)) {
                logger.log(System.Logger.Level.ERROR, "expected:" + SharedCacheMode.UNSPECIFIED.name() + ", actual:" + scm.name());
                pass = false;
            }
            try {
                SharedCacheMode.valueOf((String)"DOESNOTEXIST");
                logger.log(System.Logger.Level.ERROR, "IllegalArgumentException was not thrown");
                pass = false;
            }
            catch (IllegalArgumentException iae) {
                logger.log(System.Logger.Level.TRACE, "Received expected IllegalArgumentException");
            }
            try {
                SharedCacheMode.valueOf(null);
                logger.log(System.Logger.Level.ERROR, "NullPointerException was not thrown");
                pass = false;
            }
            catch (NullPointerException iae) {
                logger.log(System.Logger.Level.TRACE, "Received expected NullPointerException");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new Exception("sharedCacheModeValueOfTest failed");
        }
    }

    @Test
    public void sharedCacheModeValuesTest() throws Exception {
        boolean pass = true;
        try {
            List<SharedCacheMode> scm = Arrays.asList(SharedCacheMode.values());
            if (scm.size() != 5) {
                logger.log(System.Logger.Level.ERROR, "Number of SharedCacheMode expected:5, actual:" + scm.size());
                pass = false;
            }
            if (scm.contains(SharedCacheMode.ALL)) {
                logger.log(System.Logger.Level.TRACE, "received:" + SharedCacheMode.ALL);
            } else {
                logger.log(System.Logger.Level.ERROR, "Expected value:" + SharedCacheMode.ALL);
                pass = false;
            }
            if (scm.contains(SharedCacheMode.DISABLE_SELECTIVE)) {
                logger.log(System.Logger.Level.TRACE, "received:" + SharedCacheMode.DISABLE_SELECTIVE);
            } else {
                logger.log(System.Logger.Level.ERROR, "Expected value:" + SharedCacheMode.DISABLE_SELECTIVE);
                pass = false;
            }
            if (scm.contains(SharedCacheMode.ENABLE_SELECTIVE)) {
                logger.log(System.Logger.Level.TRACE, "received:" + SharedCacheMode.ENABLE_SELECTIVE);
            } else {
                logger.log(System.Logger.Level.ERROR, "Expected value:" + SharedCacheMode.ENABLE_SELECTIVE);
                pass = false;
            }
            if (scm.contains(SharedCacheMode.NONE)) {
                logger.log(System.Logger.Level.TRACE, "received:" + SharedCacheMode.NONE);
            } else {
                logger.log(System.Logger.Level.ERROR, "Expected value:" + SharedCacheMode.NONE);
                pass = false;
            }
            if (scm.contains(SharedCacheMode.UNSPECIFIED)) {
                logger.log(System.Logger.Level.TRACE, "received:" + SharedCacheMode.UNSPECIFIED);
            } else {
                logger.log(System.Logger.Level.ERROR, "Expected value:" + SharedCacheMode.UNSPECIFIED);
                pass = false;
            }
            for (SharedCacheMode s : scm) {
                try {
                    SharedCacheMode.valueOf((String)s.name());
                }
                catch (Exception e) {
                    logger.log(System.Logger.Level.ERROR, "Received exception for valueOf", (Throwable)e);
                    pass = false;
                }
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new Exception("sharedCacheModeValuesTest failed");
        }
    }

    @Test
    public void validationModeValueOfTest() throws Exception {
        boolean pass = true;
        try {
            ValidationMode vm = ValidationMode.valueOf((String)ValidationMode.CALLBACK.name());
            if (!vm.equals((Object)ValidationMode.CALLBACK)) {
                logger.log(System.Logger.Level.ERROR, "expected:" + ValidationMode.CALLBACK.name() + ", actual:" + vm.name());
                pass = false;
            }
            if (!(vm = ValidationMode.valueOf((String)ValidationMode.AUTO.name())).equals((Object)ValidationMode.AUTO)) {
                logger.log(System.Logger.Level.ERROR, "expected:" + ValidationMode.AUTO.name() + ", actual:" + vm.name());
                pass = false;
            }
            if (!(vm = ValidationMode.valueOf((String)ValidationMode.NONE.name())).equals((Object)ValidationMode.NONE)) {
                logger.log(System.Logger.Level.ERROR, "expected:" + ValidationMode.NONE.name() + ", actual:" + vm.name());
                pass = false;
            }
            try {
                ValidationMode.valueOf((String)"DOESNOTEXIST");
                logger.log(System.Logger.Level.ERROR, "IllegalArgumentException was not thrown");
                pass = false;
            }
            catch (IllegalArgumentException iae) {
                logger.log(System.Logger.Level.TRACE, "Received expected IllegalArgumentException");
            }
            try {
                ValidationMode.valueOf(null);
                logger.log(System.Logger.Level.ERROR, "NullPointerException was not thrown");
                pass = false;
            }
            catch (NullPointerException iae) {
                logger.log(System.Logger.Level.TRACE, "Received expected NullPointerException");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new Exception("validationModeValueOfTest failed");
        }
    }

    @Test
    public void validationModeValuesTest() throws Exception {
        boolean pass = true;
        try {
            List<ValidationMode> vm = Arrays.asList(ValidationMode.values());
            if (vm.size() != 3) {
                logger.log(System.Logger.Level.ERROR, "Number of ValidationMode expected:3, actual:" + vm.size());
                pass = false;
            }
            if (vm.contains(ValidationMode.CALLBACK)) {
                logger.log(System.Logger.Level.TRACE, "received:" + ValidationMode.CALLBACK);
            } else {
                logger.log(System.Logger.Level.ERROR, "Expected value:" + ValidationMode.CALLBACK);
                pass = false;
            }
            if (vm.contains(ValidationMode.AUTO)) {
                logger.log(System.Logger.Level.TRACE, "received:" + ValidationMode.AUTO);
            } else {
                logger.log(System.Logger.Level.ERROR, "Expected value:" + ValidationMode.AUTO);
                pass = false;
            }
            if (vm.contains(ValidationMode.NONE)) {
                logger.log(System.Logger.Level.TRACE, "received:" + ValidationMode.NONE);
            } else {
                logger.log(System.Logger.Level.ERROR, "Expected value:" + ValidationMode.NONE);
                pass = false;
            }
            for (ValidationMode v : vm) {
                try {
                    ValidationMode.valueOf((String)v.name());
                }
                catch (Exception e) {
                    logger.log(System.Logger.Level.ERROR, "Received exception for valueOf", (Throwable)e);
                    pass = false;
                }
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new Exception("validationModeValuesTest failed");
        }
    }

    @Test
    public void temporalTypeValuesTest() throws Exception {
        boolean pass = true;
        List<TemporalType> tt = Arrays.asList(TemporalType.values());
        if (tt.size() != 3) {
            logger.log(System.Logger.Level.ERROR, "Number of TemporalType expected:3, actual:" + tt.size());
            pass = false;
        }
        if (tt.contains(TemporalType.DATE)) {
            logger.log(System.Logger.Level.TRACE, "received:" + TemporalType.DATE);
        } else {
            logger.log(System.Logger.Level.ERROR, "Expected value:" + TemporalType.DATE);
            pass = false;
        }
        if (tt.contains(TemporalType.TIME)) {
            logger.log(System.Logger.Level.TRACE, "received:" + TemporalType.TIME);
        } else {
            logger.log(System.Logger.Level.ERROR, "Expected value:" + TemporalType.TIME);
            pass = false;
        }
        if (tt.contains(TemporalType.TIMESTAMP)) {
            logger.log(System.Logger.Level.TRACE, "received:" + TemporalType.TIMESTAMP);
        } else {
            logger.log(System.Logger.Level.ERROR, "Expected value:" + TemporalType.TIMESTAMP);
            pass = false;
        }
        for (TemporalType t : tt) {
            try {
                TemporalType.valueOf((String)t.name());
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Received exception for valueOf", (Throwable)e);
                pass = false;
            }
        }
        if (!pass) {
            throw new Exception("temporalTypeValuesTest failed");
        }
    }

    @Test
    public void temporalTypeValueOfTest() throws Exception {
        boolean pass = true;
        try {
            TemporalType tt = TemporalType.valueOf((String)TemporalType.DATE.name());
            if (!tt.equals((Object)TemporalType.DATE)) {
                logger.log(System.Logger.Level.ERROR, "expected:" + TemporalType.DATE.name() + ", actual:" + tt.name());
                pass = false;
            }
            if (!(tt = TemporalType.valueOf((String)TemporalType.TIME.name())).equals((Object)TemporalType.TIME)) {
                logger.log(System.Logger.Level.ERROR, "expected:" + TemporalType.TIME.name() + ", actual:" + tt.name());
                pass = false;
            }
            if (!(tt = TemporalType.valueOf((String)TemporalType.TIMESTAMP.name())).equals((Object)TemporalType.TIMESTAMP)) {
                logger.log(System.Logger.Level.ERROR, "expected:" + TemporalType.TIMESTAMP.name() + ", actual:" + tt.name());
                pass = false;
            }
            try {
                TemporalType.valueOf((String)"DOESNOTEXIST");
                logger.log(System.Logger.Level.ERROR, "IllegalArgumentException was not thrown");
                pass = false;
            }
            catch (IllegalArgumentException iae) {
                logger.log(System.Logger.Level.TRACE, "Received expected IllegalArgumentException");
            }
            try {
                TemporalType.valueOf(null);
                logger.log(System.Logger.Level.ERROR, "NullPointerException was not thrown");
                pass = false;
            }
            catch (NullPointerException iae) {
                logger.log(System.Logger.Level.TRACE, "Received expected NullPointerException");
            }
        }
        catch (Exception e) {
            pass = false;
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("temporalTypeValueOfTest failed");
        }
    }

    @Test
    public void joinTypeValuesTest() throws Exception {
        boolean pass = true;
        List<JoinType> jt = Arrays.asList(JoinType.values());
        if (jt.size() != 3) {
            logger.log(System.Logger.Level.ERROR, "Number of TemporalType expected:3, actual:" + jt.size());
            pass = false;
        }
        if (jt.contains(JoinType.LEFT)) {
            logger.log(System.Logger.Level.TRACE, "received:" + JoinType.LEFT);
        } else {
            logger.log(System.Logger.Level.ERROR, "Expected value:" + JoinType.LEFT);
            pass = false;
        }
        if (jt.contains(JoinType.INNER)) {
            logger.log(System.Logger.Level.TRACE, "received:" + JoinType.INNER);
        } else {
            logger.log(System.Logger.Level.ERROR, "Expected value:" + JoinType.INNER);
            pass = false;
        }
        if (jt.contains(JoinType.RIGHT)) {
            logger.log(System.Logger.Level.TRACE, "received:" + JoinType.RIGHT);
        } else {
            logger.log(System.Logger.Level.ERROR, "Expected value:" + JoinType.RIGHT);
            pass = false;
        }
        for (JoinType j : jt) {
            try {
                JoinType.valueOf((String)j.name());
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Received exception for valueOf", (Throwable)e);
                pass = false;
            }
        }
        if (!pass) {
            throw new Exception("joinTypeValuesTest failed");
        }
    }

    @Test
    public void joinTypeValueOfTest() throws Exception {
        boolean pass = true;
        try {
            JoinType jt = JoinType.valueOf((String)JoinType.LEFT.name());
            if (!jt.equals((Object)JoinType.LEFT)) {
                logger.log(System.Logger.Level.ERROR, "expected:" + JoinType.LEFT.name() + ", actual:" + jt.name());
                pass = false;
            }
            if (!(jt = JoinType.valueOf((String)JoinType.INNER.name())).equals((Object)JoinType.INNER)) {
                logger.log(System.Logger.Level.ERROR, "expected:" + JoinType.INNER.name() + ", actual:" + jt.name());
                pass = false;
            }
            if (!(jt = JoinType.valueOf((String)JoinType.RIGHT.name())).equals((Object)JoinType.RIGHT)) {
                logger.log(System.Logger.Level.ERROR, "expected:" + JoinType.RIGHT.name() + ", actual:" + jt.name());
                pass = false;
            }
            try {
                JoinType.valueOf((String)"DOESNOTEXIST");
                logger.log(System.Logger.Level.ERROR, "IllegalArgumentException was not thrown");
                pass = false;
            }
            catch (IllegalArgumentException iae) {
                logger.log(System.Logger.Level.TRACE, "Received expected IllegalArgumentException");
            }
            try {
                JoinType.valueOf(null);
                logger.log(System.Logger.Level.ERROR, "NullPointerException was not thrown");
                pass = false;
            }
            catch (NullPointerException iae) {
                logger.log(System.Logger.Level.TRACE, "Received expected NullPointerException");
            }
        }
        catch (Exception e) {
            pass = false;
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("joinTypeValueOfTest failed");
        }
    }

    @Test
    public void persistentAttributeTypeValuesTest() throws Exception {
        boolean pass = true;
        List<Attribute.PersistentAttributeType> pat = Arrays.asList(Attribute.PersistentAttributeType.values());
        if (pat.size() != 7) {
            logger.log(System.Logger.Level.ERROR, "Number of TemporalType expected:7, actual:" + pat.size());
            pass = false;
        }
        if (pat.contains(Attribute.PersistentAttributeType.BASIC)) {
            logger.log(System.Logger.Level.TRACE, "received:" + Attribute.PersistentAttributeType.BASIC);
        } else {
            logger.log(System.Logger.Level.ERROR, "Expected value:" + Attribute.PersistentAttributeType.BASIC);
            pass = false;
        }
        if (pat.contains(Attribute.PersistentAttributeType.ELEMENT_COLLECTION)) {
            logger.log(System.Logger.Level.TRACE, "received:" + Attribute.PersistentAttributeType.ELEMENT_COLLECTION);
        } else {
            logger.log(System.Logger.Level.ERROR, "Expected value:" + Attribute.PersistentAttributeType.ELEMENT_COLLECTION);
            pass = false;
        }
        if (pat.contains(Attribute.PersistentAttributeType.EMBEDDED)) {
            logger.log(System.Logger.Level.TRACE, "received:" + Attribute.PersistentAttributeType.EMBEDDED);
        } else {
            logger.log(System.Logger.Level.ERROR, "Expected value:" + Attribute.PersistentAttributeType.EMBEDDED);
            pass = false;
        }
        if (pat.contains(Attribute.PersistentAttributeType.MANY_TO_MANY)) {
            logger.log(System.Logger.Level.TRACE, "received:" + Attribute.PersistentAttributeType.MANY_TO_MANY);
        } else {
            logger.log(System.Logger.Level.ERROR, "Expected value:" + Attribute.PersistentAttributeType.MANY_TO_MANY);
            pass = false;
        }
        if (pat.contains(Attribute.PersistentAttributeType.MANY_TO_ONE)) {
            logger.log(System.Logger.Level.TRACE, "received:" + Attribute.PersistentAttributeType.MANY_TO_ONE);
        } else {
            logger.log(System.Logger.Level.ERROR, "Expected value:" + Attribute.PersistentAttributeType.MANY_TO_ONE);
            pass = false;
        }
        if (pat.contains(Attribute.PersistentAttributeType.ONE_TO_MANY)) {
            logger.log(System.Logger.Level.TRACE, "received:" + Attribute.PersistentAttributeType.ONE_TO_MANY);
        } else {
            logger.log(System.Logger.Level.ERROR, "Expected value:" + Attribute.PersistentAttributeType.ONE_TO_MANY);
            pass = false;
        }
        if (pat.contains(Attribute.PersistentAttributeType.ONE_TO_ONE)) {
            logger.log(System.Logger.Level.TRACE, "received:" + Attribute.PersistentAttributeType.ONE_TO_ONE);
        } else {
            logger.log(System.Logger.Level.ERROR, "Expected value:" + Attribute.PersistentAttributeType.ONE_TO_ONE);
            pass = false;
        }
        for (Attribute.PersistentAttributeType p : pat) {
            try {
                Attribute.PersistentAttributeType.valueOf((String)p.name());
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Received exception for valueOf", (Throwable)e);
                pass = false;
            }
        }
        if (!pass) {
            throw new Exception("persistentAttributeTypeValuesTest failed");
        }
    }

    @Test
    public void persistentAttributeTypeValueOfTest() throws Exception {
        boolean pass = true;
        try {
            Attribute.PersistentAttributeType pat = Attribute.PersistentAttributeType.valueOf((String)Attribute.PersistentAttributeType.BASIC.name());
            if (!pat.equals((Object)Attribute.PersistentAttributeType.BASIC)) {
                logger.log(System.Logger.Level.ERROR, "expected:" + Attribute.PersistentAttributeType.BASIC.name() + ", actual:" + pat.name());
                pass = false;
            }
            if (!(pat = Attribute.PersistentAttributeType.valueOf((String)Attribute.PersistentAttributeType.ELEMENT_COLLECTION.name())).equals((Object)Attribute.PersistentAttributeType.ELEMENT_COLLECTION)) {
                logger.log(System.Logger.Level.ERROR, "expected:" + Attribute.PersistentAttributeType.ELEMENT_COLLECTION.name() + ", actual:" + pat.name());
                pass = false;
            }
            if (!(pat = Attribute.PersistentAttributeType.valueOf((String)Attribute.PersistentAttributeType.EMBEDDED.name())).equals((Object)Attribute.PersistentAttributeType.EMBEDDED)) {
                logger.log(System.Logger.Level.ERROR, "expected:" + Attribute.PersistentAttributeType.EMBEDDED.name() + ", actual:" + pat.name());
                pass = false;
            }
            if (!(pat = Attribute.PersistentAttributeType.valueOf((String)Attribute.PersistentAttributeType.MANY_TO_MANY.name())).equals((Object)Attribute.PersistentAttributeType.MANY_TO_MANY)) {
                logger.log(System.Logger.Level.ERROR, "expected:" + Attribute.PersistentAttributeType.MANY_TO_MANY.name() + ", actual:" + pat.name());
                pass = false;
            }
            if (!(pat = Attribute.PersistentAttributeType.valueOf((String)Attribute.PersistentAttributeType.MANY_TO_ONE.name())).equals((Object)Attribute.PersistentAttributeType.MANY_TO_ONE)) {
                logger.log(System.Logger.Level.ERROR, "expected:" + Attribute.PersistentAttributeType.MANY_TO_ONE.name() + ", actual:" + pat.name());
                pass = false;
            }
            if (!(pat = Attribute.PersistentAttributeType.valueOf((String)Attribute.PersistentAttributeType.ONE_TO_MANY.name())).equals((Object)Attribute.PersistentAttributeType.ONE_TO_MANY)) {
                logger.log(System.Logger.Level.ERROR, "expected:" + Attribute.PersistentAttributeType.ONE_TO_MANY.name() + ", actual:" + pat.name());
                pass = false;
            }
            if (!(pat = Attribute.PersistentAttributeType.valueOf((String)Attribute.PersistentAttributeType.ONE_TO_ONE.name())).equals((Object)Attribute.PersistentAttributeType.ONE_TO_ONE)) {
                logger.log(System.Logger.Level.ERROR, "expected:" + Attribute.PersistentAttributeType.ONE_TO_ONE.name() + ", actual:" + pat.name());
                pass = false;
            }
            try {
                Attribute.PersistentAttributeType.valueOf((String)"DOESNOTEXIST");
                logger.log(System.Logger.Level.ERROR, "IllegalArgumentException was not thrown");
                pass = false;
            }
            catch (IllegalArgumentException iae) {
                logger.log(System.Logger.Level.TRACE, "Received expected IllegalArgumentException");
            }
            try {
                Attribute.PersistentAttributeType.valueOf(null);
                logger.log(System.Logger.Level.ERROR, "NullPointerException was not thrown");
                pass = false;
            }
            catch (NullPointerException iae) {
                logger.log(System.Logger.Level.TRACE, "Received expected NullPointerException");
            }
        }
        catch (Exception e) {
            pass = false;
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("persistentAttributeTypeValueOfTest failed");
        }
    }

    @Test
    public void bindableTypeValuesTest() throws Exception {
        boolean pass = true;
        List<Bindable.BindableType> bt = Arrays.asList(Bindable.BindableType.values());
        if (bt.size() != 3) {
            logger.log(System.Logger.Level.ERROR, "Number of TemporalType expected:3, actual:" + bt.size());
            pass = false;
        }
        if (bt.contains(Bindable.BindableType.ENTITY_TYPE)) {
            logger.log(System.Logger.Level.TRACE, "received:" + Bindable.BindableType.ENTITY_TYPE.name());
        } else {
            logger.log(System.Logger.Level.ERROR, "Expected value:" + Bindable.BindableType.ENTITY_TYPE.name());
            pass = false;
        }
        if (bt.contains(Bindable.BindableType.PLURAL_ATTRIBUTE)) {
            logger.log(System.Logger.Level.TRACE, "received:" + Bindable.BindableType.PLURAL_ATTRIBUTE.name());
        } else {
            logger.log(System.Logger.Level.ERROR, "Expected value:" + Bindable.BindableType.PLURAL_ATTRIBUTE.name());
            pass = false;
        }
        if (bt.contains(Bindable.BindableType.SINGULAR_ATTRIBUTE)) {
            logger.log(System.Logger.Level.TRACE, "received:" + Bindable.BindableType.SINGULAR_ATTRIBUTE.name());
        } else {
            logger.log(System.Logger.Level.ERROR, "Expected value:" + Bindable.BindableType.SINGULAR_ATTRIBUTE.name());
            pass = false;
        }
        for (Bindable.BindableType b : bt) {
            try {
                Bindable.BindableType.valueOf((String)b.name());
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Received exception for valueOf", (Throwable)e);
                pass = false;
            }
        }
        if (!pass) {
            throw new Exception("bindableTypeValuesTest failed");
        }
    }

    @Test
    public void bindableTypeValueOfTest() throws Exception {
        boolean pass = true;
        try {
            Bindable.BindableType bt = Bindable.BindableType.valueOf((String)Bindable.BindableType.ENTITY_TYPE.name());
            if (!bt.equals((Object)Bindable.BindableType.ENTITY_TYPE)) {
                logger.log(System.Logger.Level.ERROR, "expected:" + Bindable.BindableType.ENTITY_TYPE.name() + ", actual:" + bt.name());
                pass = false;
            }
            if (!(bt = Bindable.BindableType.valueOf((String)Bindable.BindableType.PLURAL_ATTRIBUTE.name())).equals((Object)Bindable.BindableType.PLURAL_ATTRIBUTE)) {
                logger.log(System.Logger.Level.ERROR, "expected:" + Bindable.BindableType.PLURAL_ATTRIBUTE.name() + ", actual:" + bt.name());
                pass = false;
            }
            if (!(bt = Bindable.BindableType.valueOf((String)Bindable.BindableType.SINGULAR_ATTRIBUTE.name())).equals((Object)Bindable.BindableType.SINGULAR_ATTRIBUTE)) {
                logger.log(System.Logger.Level.ERROR, "expected:" + Bindable.BindableType.SINGULAR_ATTRIBUTE.name() + ", actual:" + bt.name());
                pass = false;
            }
            try {
                Bindable.BindableType.valueOf((String)"DOESNOTEXIST");
                logger.log(System.Logger.Level.ERROR, "IllegalArgumentException was not thrown");
                pass = false;
            }
            catch (IllegalArgumentException iae) {
                logger.log(System.Logger.Level.TRACE, "Received expected IllegalArgumentException");
            }
            try {
                Bindable.BindableType.valueOf(null);
                logger.log(System.Logger.Level.ERROR, "NullPointerException was not thrown");
                pass = false;
            }
            catch (NullPointerException iae) {
                logger.log(System.Logger.Level.TRACE, "Received expected NullPointerException");
            }
        }
        catch (Exception e) {
            pass = false;
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("bindableTypeValueOfTest failed");
        }
    }

    @Test
    public void collectionTypeValuesTest() throws Exception {
        boolean pass = true;
        List<PluralAttribute.CollectionType> ct = Arrays.asList(PluralAttribute.CollectionType.values());
        if (ct.size() != 4) {
            logger.log(System.Logger.Level.ERROR, "Number of TemporalType expected:4, actual:" + ct.size());
            pass = false;
        }
        if (ct.contains(PluralAttribute.CollectionType.COLLECTION)) {
            logger.log(System.Logger.Level.TRACE, "received:" + PluralAttribute.CollectionType.COLLECTION);
        } else {
            logger.log(System.Logger.Level.ERROR, "Expected value:" + PluralAttribute.CollectionType.COLLECTION);
            pass = false;
        }
        if (ct.contains(PluralAttribute.CollectionType.LIST)) {
            logger.log(System.Logger.Level.TRACE, "received:" + PluralAttribute.CollectionType.LIST);
        } else {
            logger.log(System.Logger.Level.ERROR, "Expected value:" + PluralAttribute.CollectionType.LIST);
            pass = false;
        }
        if (ct.contains(PluralAttribute.CollectionType.MAP)) {
            logger.log(System.Logger.Level.TRACE, "received:" + PluralAttribute.CollectionType.MAP);
        } else {
            logger.log(System.Logger.Level.ERROR, "Expected value:" + PluralAttribute.CollectionType.MAP);
            pass = false;
        }
        if (ct.contains(PluralAttribute.CollectionType.SET)) {
            logger.log(System.Logger.Level.TRACE, "received:" + PluralAttribute.CollectionType.SET);
        } else {
            logger.log(System.Logger.Level.ERROR, "Expected value:" + PluralAttribute.CollectionType.SET);
            pass = false;
        }
        for (PluralAttribute.CollectionType c : ct) {
            try {
                PluralAttribute.CollectionType.valueOf((String)c.name());
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Received exception for valueOf", (Throwable)e);
                pass = false;
            }
        }
        if (!pass) {
            throw new Exception("collectionTypeValuesTest failed");
        }
    }

    @Test
    public void collectionTypeValueOfTest() throws Exception {
        boolean pass = true;
        try {
            PluralAttribute.CollectionType ct = PluralAttribute.CollectionType.valueOf((String)PluralAttribute.CollectionType.COLLECTION.name());
            if (!ct.equals((Object)PluralAttribute.CollectionType.COLLECTION)) {
                logger.log(System.Logger.Level.ERROR, "expected:" + PluralAttribute.CollectionType.COLLECTION.name() + ", actual:" + ct.name());
                pass = false;
            }
            if (!(ct = PluralAttribute.CollectionType.valueOf((String)PluralAttribute.CollectionType.LIST.name())).equals((Object)PluralAttribute.CollectionType.LIST)) {
                logger.log(System.Logger.Level.ERROR, "expected:" + PluralAttribute.CollectionType.LIST.name() + ", actual:" + ct.name());
                pass = false;
            }
            if (!(ct = PluralAttribute.CollectionType.valueOf((String)PluralAttribute.CollectionType.MAP.name())).equals((Object)PluralAttribute.CollectionType.MAP)) {
                logger.log(System.Logger.Level.ERROR, "expected:" + PluralAttribute.CollectionType.MAP.name() + ", actual:" + ct.name());
                pass = false;
            }
            if (!(ct = PluralAttribute.CollectionType.valueOf((String)PluralAttribute.CollectionType.SET.name())).equals((Object)PluralAttribute.CollectionType.SET)) {
                logger.log(System.Logger.Level.ERROR, "expected:" + PluralAttribute.CollectionType.SET.name() + ", actual:" + ct.name());
                pass = false;
            }
            try {
                PluralAttribute.CollectionType.valueOf((String)"DOESNOTEXIST");
                logger.log(System.Logger.Level.ERROR, "IllegalArgumentException was not thrown");
                pass = false;
            }
            catch (IllegalArgumentException iae) {
                logger.log(System.Logger.Level.TRACE, "Received expected IllegalArgumentException");
            }
            try {
                PluralAttribute.CollectionType.valueOf(null);
                logger.log(System.Logger.Level.ERROR, "NullPointerException was not thrown");
                pass = false;
            }
            catch (NullPointerException iae) {
                logger.log(System.Logger.Level.TRACE, "Received expected NullPointerException");
            }
        }
        catch (Exception e) {
            pass = false;
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("collectionTypeValueOfTest failed");
        }
    }

    @Test
    public void persistenceTypeValuesTest() throws Exception {
        boolean pass = true;
        List<Type.PersistenceType> pt = Arrays.asList(Type.PersistenceType.values());
        if (pt.size() != 4) {
            logger.log(System.Logger.Level.ERROR, "Number of TemporalType expected:4, actual:" + pt.size());
            pass = false;
        }
        if (pt.contains(Type.PersistenceType.BASIC)) {
            logger.log(System.Logger.Level.TRACE, "received:" + Type.PersistenceType.BASIC);
        } else {
            logger.log(System.Logger.Level.ERROR, "Expected value:" + Type.PersistenceType.BASIC);
            pass = false;
        }
        if (pt.contains(Type.PersistenceType.EMBEDDABLE)) {
            logger.log(System.Logger.Level.TRACE, "received:" + Type.PersistenceType.EMBEDDABLE);
        } else {
            logger.log(System.Logger.Level.ERROR, "Expected value:" + Type.PersistenceType.EMBEDDABLE);
            pass = false;
        }
        if (pt.contains(Type.PersistenceType.ENTITY)) {
            logger.log(System.Logger.Level.TRACE, "received:" + Type.PersistenceType.ENTITY);
        } else {
            logger.log(System.Logger.Level.ERROR, "Expected value:" + Type.PersistenceType.ENTITY);
            pass = false;
        }
        if (pt.contains(Type.PersistenceType.MAPPED_SUPERCLASS)) {
            logger.log(System.Logger.Level.TRACE, "received:" + Type.PersistenceType.MAPPED_SUPERCLASS);
        } else {
            logger.log(System.Logger.Level.ERROR, "Expected value:" + Type.PersistenceType.MAPPED_SUPERCLASS);
            pass = false;
        }
        for (Type.PersistenceType p : pt) {
            try {
                Type.PersistenceType.valueOf((String)p.name());
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Received exception for valueOf", (Throwable)e);
                pass = false;
            }
        }
        if (!pass) {
            throw new Exception("persistenceTypeValuesTest failed");
        }
    }

    @Test
    public void persistenceTypeValueOfTest() throws Exception {
        boolean pass = true;
        try {
            Type.PersistenceType pt = Type.PersistenceType.valueOf((String)Type.PersistenceType.BASIC.name());
            if (!pt.equals((Object)Type.PersistenceType.BASIC)) {
                logger.log(System.Logger.Level.ERROR, "expected:" + Type.PersistenceType.BASIC.name() + ", actual:" + pt.name());
                pass = false;
            }
            if (!(pt = Type.PersistenceType.valueOf((String)Type.PersistenceType.EMBEDDABLE.name())).equals((Object)Type.PersistenceType.EMBEDDABLE)) {
                logger.log(System.Logger.Level.ERROR, "expected:" + Type.PersistenceType.EMBEDDABLE.name() + ", actual:" + pt.name());
                pass = false;
            }
            if (!(pt = Type.PersistenceType.valueOf((String)Type.PersistenceType.ENTITY.name())).equals((Object)Type.PersistenceType.ENTITY)) {
                logger.log(System.Logger.Level.ERROR, "expected:" + Type.PersistenceType.ENTITY.name() + ", actual:" + pt.name());
                pass = false;
            }
            if (!(pt = Type.PersistenceType.valueOf((String)Type.PersistenceType.MAPPED_SUPERCLASS.name())).equals((Object)Type.PersistenceType.MAPPED_SUPERCLASS)) {
                logger.log(System.Logger.Level.ERROR, "expected:" + Type.PersistenceType.MAPPED_SUPERCLASS.name() + ", actual:" + pt.name());
                pass = false;
            }
            try {
                Type.PersistenceType.valueOf((String)"DOESNOTEXIST");
                logger.log(System.Logger.Level.ERROR, "IllegalArgumentException was not thrown");
                pass = false;
            }
            catch (IllegalArgumentException iae) {
                logger.log(System.Logger.Level.TRACE, "Received expected IllegalArgumentException");
            }
            try {
                Type.PersistenceType.valueOf(null);
                logger.log(System.Logger.Level.ERROR, "NullPointerException was not thrown");
                pass = false;
            }
            catch (NullPointerException iae) {
                logger.log(System.Logger.Level.TRACE, "Received expected NullPointerException");
            }
        }
        catch (Exception e) {
            pass = false;
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("persistenceTypeValueOfTest failed");
        }
    }

    @Test
    public void loadStateValuesTest() throws Exception {
        boolean pass = true;
        List<LoadState> ls = Arrays.asList(LoadState.values());
        if (ls.size() != 3) {
            logger.log(System.Logger.Level.ERROR, "Number of TemporalType expected:3, actual:" + ls.size());
            pass = false;
        }
        if (ls.contains(LoadState.LOADED)) {
            logger.log(System.Logger.Level.TRACE, "received:" + LoadState.LOADED);
        } else {
            logger.log(System.Logger.Level.ERROR, "Expected value:" + LoadState.LOADED);
            pass = false;
        }
        if (ls.contains(LoadState.NOT_LOADED)) {
            logger.log(System.Logger.Level.TRACE, "received:" + LoadState.NOT_LOADED);
        } else {
            logger.log(System.Logger.Level.ERROR, "Expected value:" + LoadState.NOT_LOADED);
            pass = false;
        }
        if (ls.contains(LoadState.UNKNOWN)) {
            logger.log(System.Logger.Level.TRACE, "received:" + LoadState.UNKNOWN);
        } else {
            logger.log(System.Logger.Level.ERROR, "Expected value:" + LoadState.UNKNOWN);
            pass = false;
        }
        for (LoadState l : ls) {
            try {
                LoadState.valueOf((String)l.name());
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Received exception for valueOf", (Throwable)e);
                pass = false;
            }
        }
        if (!pass) {
            throw new Exception("loadStateValuesTest failed");
        }
    }

    @Test
    public void loadStateValueOfTest() throws Exception {
        boolean pass = true;
        try {
            LoadState ls = LoadState.valueOf((String)LoadState.LOADED.name());
            if (!ls.equals((Object)LoadState.LOADED)) {
                logger.log(System.Logger.Level.ERROR, "expected:" + LoadState.LOADED.name() + ", actual:" + ls.name());
                pass = false;
            }
            if (!(ls = LoadState.valueOf((String)LoadState.NOT_LOADED.name())).equals((Object)LoadState.NOT_LOADED)) {
                logger.log(System.Logger.Level.ERROR, "expected:" + LoadState.NOT_LOADED.name() + ", actual:" + ls.name());
                pass = false;
            }
            if (!(ls = LoadState.valueOf((String)LoadState.UNKNOWN.name())).equals((Object)LoadState.UNKNOWN)) {
                logger.log(System.Logger.Level.ERROR, "expected:" + LoadState.UNKNOWN.name() + ", actual:" + ls.name());
                pass = false;
            }
            try {
                LoadState.valueOf((String)"DOESNOTEXIST");
                logger.log(System.Logger.Level.ERROR, "IllegalArgumentException was not thrown");
                pass = false;
            }
            catch (IllegalArgumentException iae) {
                logger.log(System.Logger.Level.TRACE, "Received expected IllegalArgumentException");
            }
            try {
                LoadState.valueOf(null);
                logger.log(System.Logger.Level.ERROR, "NullPointerException was not thrown");
                pass = false;
            }
            catch (NullPointerException iae) {
                logger.log(System.Logger.Level.TRACE, "Received expected NullPointerException");
            }
        }
        catch (Exception e) {
            pass = false;
            logger.log(System.Logger.Level.ERROR, "Unexpected Exception occurred", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("loadStateValueOfTest failed");
        }
    }

    @Test
    public void persistenceUnitTransactionTypeValuesTest() throws Exception {
        boolean pass = true;
        List<PersistenceUnitTransactionType> putt = Arrays.asList(PersistenceUnitTransactionType.values());
        if (putt.size() != 2) {
            logger.log(System.Logger.Level.ERROR, "Number of TemporalType expected:2, actual:" + putt.size());
            pass = false;
        }
        if (putt.contains(PersistenceUnitTransactionType.JTA)) {
            logger.log(System.Logger.Level.TRACE, "received:" + PersistenceUnitTransactionType.JTA);
        } else {
            logger.log(System.Logger.Level.ERROR, "Expected value:" + PersistenceUnitTransactionType.JTA);
            pass = false;
        }
        if (putt.contains(PersistenceUnitTransactionType.RESOURCE_LOCAL)) {
            logger.log(System.Logger.Level.TRACE, "received:" + PersistenceUnitTransactionType.RESOURCE_LOCAL);
        } else {
            logger.log(System.Logger.Level.ERROR, "Expected value:" + PersistenceUnitTransactionType.RESOURCE_LOCAL);
            pass = false;
        }
        for (PersistenceUnitTransactionType p : putt) {
            try {
                PersistenceUnitTransactionType.valueOf((String)p.name());
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Received exception for valueOf", (Throwable)e);
                pass = false;
            }
        }
        if (!pass) {
            throw new Exception("persistenceUnitTransactionTypeValuesTest failed");
        }
    }

    @Test
    public void persistenceUnitTransactionTypeValueOfTest() throws Exception {
        boolean pass = true;
        try {
            PersistenceUnitTransactionType putt = PersistenceUnitTransactionType.valueOf((String)PersistenceUnitTransactionType.JTA.name());
            if (!putt.equals((Object)PersistenceUnitTransactionType.JTA)) {
                logger.log(System.Logger.Level.ERROR, "expected:" + PersistenceUnitTransactionType.JTA.name() + ", actual:" + putt.name());
                pass = false;
            }
            if (!(putt = PersistenceUnitTransactionType.valueOf((String)PersistenceUnitTransactionType.RESOURCE_LOCAL.name())).equals((Object)PersistenceUnitTransactionType.RESOURCE_LOCAL)) {
                logger.log(System.Logger.Level.ERROR, "expected:" + PersistenceUnitTransactionType.RESOURCE_LOCAL.name() + ", actual:" + putt.name());
                pass = false;
            }
            try {
                PersistenceUnitTransactionType.valueOf((String)"DOESNOTEXIST");
                logger.log(System.Logger.Level.ERROR, "IllegalArgumentException was not thrown");
                pass = false;
            }
            catch (IllegalArgumentException iae) {
                logger.log(System.Logger.Level.TRACE, "Received expected IllegalArgumentException");
            }
            try {
                PersistenceUnitTransactionType.valueOf(null);
                logger.log(System.Logger.Level.ERROR, "NullPointerException was not thrown");
                pass = false;
            }
            catch (NullPointerException iae) {
                logger.log(System.Logger.Level.TRACE, "Received expected NullPointerException");
            }
        }
        catch (Exception e) {
            pass = false;
            logger.log(System.Logger.Level.ERROR, "Unexpected Exception occurred", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("persistenceUnitTransactionTypeValueOfTest failed");
        }
    }

    @Test
    public void parameterModeValuesTest() throws Exception {
        boolean pass = true;
        List<ParameterMode> cpm = Arrays.asList(ParameterMode.values());
        if (cpm.size() != 4) {
            logger.log(System.Logger.Level.ERROR, "Number of TemporalType expected:4, actual:" + cpm.size());
            pass = false;
        }
        if (cpm.contains(ParameterMode.IN)) {
            logger.log(System.Logger.Level.TRACE, "received:" + ParameterMode.IN);
        } else {
            logger.log(System.Logger.Level.ERROR, "Expected value:" + ParameterMode.IN);
            pass = false;
        }
        if (cpm.contains(ParameterMode.INOUT)) {
            logger.log(System.Logger.Level.TRACE, "received:" + ParameterMode.INOUT);
        } else {
            logger.log(System.Logger.Level.ERROR, "Expected value:" + ParameterMode.INOUT);
            pass = false;
        }
        if (cpm.contains(ParameterMode.OUT)) {
            logger.log(System.Logger.Level.TRACE, "received:" + ParameterMode.OUT);
        } else {
            logger.log(System.Logger.Level.ERROR, "Expected value:" + ParameterMode.OUT);
            pass = false;
        }
        if (cpm.contains(ParameterMode.REF_CURSOR)) {
            logger.log(System.Logger.Level.TRACE, "received:" + ParameterMode.REF_CURSOR);
        } else {
            logger.log(System.Logger.Level.ERROR, "Expected value:" + ParameterMode.REF_CURSOR);
            pass = false;
        }
        for (ParameterMode pm : cpm) {
            try {
                ParameterMode.valueOf((String)pm.name());
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Received Exception for valueOf", (Throwable)e);
                pass = false;
            }
        }
        if (!pass) {
            throw new Exception("parameterModeValuesTest failed");
        }
    }

    @Test
    public void parameterModeValueOfTest() throws Exception {
        boolean pass = true;
        try {
            ParameterMode pm = ParameterMode.valueOf((String)ParameterMode.IN.name());
            if (!pm.equals((Object)ParameterMode.IN)) {
                logger.log(System.Logger.Level.ERROR, "expected:" + ParameterMode.IN.name() + ", actual:" + pm.name());
                pass = false;
            }
            if (!(pm = ParameterMode.valueOf((String)ParameterMode.INOUT.name())).equals((Object)ParameterMode.INOUT)) {
                logger.log(System.Logger.Level.ERROR, "expected:" + ParameterMode.INOUT.name() + ", actual:" + pm.name());
                pass = false;
            }
            if (!(pm = ParameterMode.valueOf((String)ParameterMode.OUT.name())).equals((Object)ParameterMode.OUT)) {
                logger.log(System.Logger.Level.ERROR, "expected:" + ParameterMode.OUT.name() + ", actual:" + pm.name());
                pass = false;
            }
            if (!(pm = ParameterMode.valueOf((String)ParameterMode.REF_CURSOR.name())).equals((Object)ParameterMode.REF_CURSOR)) {
                logger.log(System.Logger.Level.ERROR, "expected:" + ParameterMode.REF_CURSOR.name() + ", actual:" + pm.name());
                pass = false;
            }
            try {
                ParameterMode.valueOf((String)"DOESNOTEXIST");
                logger.log(System.Logger.Level.ERROR, "IllegalArgumentException was not thrown");
                pass = false;
            }
            catch (IllegalArgumentException iae) {
                logger.log(System.Logger.Level.TRACE, "Received expected IllegalArgumentException");
            }
            try {
                ParameterMode.valueOf(null);
                logger.log(System.Logger.Level.ERROR, "NullPointerException was not thrown");
                pass = false;
            }
            catch (NullPointerException npe) {
                logger.log(System.Logger.Level.TRACE, "Received expected NullPointerException");
            }
        }
        catch (Exception e) {
            pass = false;
            logger.log(System.Logger.Level.ERROR, "Unexpected Exception occurred", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("parameterModeValueOfTest failed");
        }
    }

    @Test
    public void synchronizationTypeValueOfTest() throws Exception {
        boolean pass = true;
        try {
            SynchronizationType st = SynchronizationType.valueOf((String)SynchronizationType.SYNCHRONIZED.name());
            if (!st.equals((Object)SynchronizationType.SYNCHRONIZED)) {
                logger.log(System.Logger.Level.ERROR, "expected:" + SynchronizationType.SYNCHRONIZED.name() + ", actual:" + st.name());
                pass = false;
            }
            if (!(st = SynchronizationType.valueOf((String)SynchronizationType.UNSYNCHRONIZED.name())).equals((Object)SynchronizationType.UNSYNCHRONIZED)) {
                logger.log(System.Logger.Level.ERROR, "expected:" + SynchronizationType.UNSYNCHRONIZED.name() + ", actual:" + st.name());
                pass = false;
            }
            try {
                SynchronizationType.valueOf((String)"DOESNOTEXIST");
                logger.log(System.Logger.Level.ERROR, "IllegalArgumentException was not thrown");
                pass = false;
            }
            catch (IllegalArgumentException iae) {
                logger.log(System.Logger.Level.TRACE, "Received expected IllegalArgumentException");
            }
            try {
                SynchronizationType.valueOf(null);
                logger.log(System.Logger.Level.ERROR, "NullPointerException was not thrown");
                pass = false;
            }
            catch (NullPointerException iae) {
                logger.log(System.Logger.Level.TRACE, "Received expected NullPointerException");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new Exception("synchronizationTypeValueOfTest failed");
        }
    }

    @Test
    public void synchronizationTypeValuesTest() throws Exception {
        boolean pass = true;
        try {
            List<SynchronizationType> st = Arrays.asList(SynchronizationType.values());
            if (st.size() != 2) {
                logger.log(System.Logger.Level.ERROR, "Number of SynchronizationType expected:2, actual:" + st.size());
                pass = false;
            }
            if (st.contains(SynchronizationType.SYNCHRONIZED)) {
                logger.log(System.Logger.Level.TRACE, "received:" + SynchronizationType.SYNCHRONIZED);
            } else {
                logger.log(System.Logger.Level.ERROR, "Expected value:" + SynchronizationType.SYNCHRONIZED);
                pass = false;
            }
            if (st.contains(SynchronizationType.UNSYNCHRONIZED)) {
                logger.log(System.Logger.Level.TRACE, "received:" + SynchronizationType.UNSYNCHRONIZED);
            } else {
                logger.log(System.Logger.Level.ERROR, "Expected value:" + SynchronizationType.UNSYNCHRONIZED);
                pass = false;
            }
            for (SynchronizationType s : st) {
                try {
                    SynchronizationType.valueOf((String)s.name());
                }
                catch (Exception e) {
                    logger.log(System.Logger.Level.ERROR, "Received exception for valueOf", (Throwable)e);
                    pass = false;
                }
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new Exception("synchronizationTypeValuesTest failed");
        }
    }

    @AfterEach
    public void cleanup() throws Exception {
        try {
            logger.log(System.Logger.Level.TRACE, "Cleanup data");
            if (this.getEntityManager().isOpen()) {
                this.removeTestData();
            }
            logger.log(System.Logger.Level.TRACE, "cleanup complete, calling super.cleanup");
            super.cleanup();
        }
        finally {
            this.removeTestJarFromCP();
        }
    }

    private void removeTestData() {
        logger.log(System.Logger.Level.TRACE, "removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM PURCHASE_ORDER").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

