/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.entityManagerFactory;

import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.entityManagerFactory.Order;
import ee.jakarta.tck.persistence.core.entityManagerFactory.Order_;
import jakarta.persistence.FlushModeType;
import jakarta.persistence.Query;
import jakarta.persistence.TypedQuery;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class Client1
extends PMClientBase {
    private static final System.Logger logger = System.getLogger(Client1.class.getName());
    Properties props = null;

    public JavaArchive createDeployment() throws Exception {
        String pkgNameWithoutSuffix = Client1.class.getPackageName();
        String pkgName = pkgNameWithoutSuffix + ".";
        String[] classes = new String[]{pkgName + "Member_", pkgName + "Member", pkgName + "Order_", pkgName + "Order"};
        return this.createDeploymentJar("jpa_core_entityManagerFactory1.jar", pkgNameWithoutSuffix, classes);
    }

    @BeforeEach
    public void setup() throws Exception {
        logger.log(System.Logger.Level.TRACE, "setup");
        try {
            super.setup();
            this.createDeployment();
            this.removeTestData();
            this.createOrderTestData();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception: ", (Throwable)e);
            throw new Exception("Setup failed:", e);
        }
    }

    @AfterEach
    public void cleanup() throws Exception {
        try {
            this.removeTestData();
            logger.log(System.Logger.Level.TRACE, "done cleanup, calling super.cleanup");
            super.cleanup();
        }
        finally {
            this.removeTestJarFromCP();
        }
    }

    @Test
    public void addNamedQueryMaxResultTest() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        boolean pass3 = false;
        boolean pass4 = false;
        boolean pass5 = false;
        boolean pass6 = false;
        boolean pass7 = false;
        try {
            TypedQuery namedTypeQuery;
            ArrayList<Integer> iList;
            block94: {
                block93: {
                    block92: {
                        boolean foundOne;
                        List lResult;
                        boolean configOK;
                        Query namedQuery;
                        block91: {
                            int i;
                            block90: {
                                block89: {
                                    CriteriaBuilder cbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
                                    logger.log(System.Logger.Level.TRACE, "Defining queries");
                                    Query nativeQuery = this.getEntityManager().createNativeQuery("Select o.ID from PURCHASE_ORDER o ORDER BY o.ID ASC");
                                    nativeQuery.setMaxResults(1);
                                    this.getEntityManagerFactory().addNamedQuery("native_query", nativeQuery);
                                    Query query = this.getEntityManager().createQuery("Select o.id from Order o ORDER BY o.id ASC");
                                    query.setMaxResults(1);
                                    this.getEntityManagerFactory().addNamedQuery("query", query);
                                    CriteriaQuery cquery = cbuilder.createQuery(Integer.class);
                                    Root order = cquery.from(Order.class);
                                    cquery.select((Selection)order.get(Order_.id));
                                    cquery.orderBy(new jakarta.persistence.criteria.Order[]{cbuilder.asc((Expression)order.get("id"))});
                                    TypedQuery typedQuery = this.getEntityManager().createQuery(cquery);
                                    typedQuery.setMaxResults(1);
                                    this.getEntityManagerFactory().addNamedQuery("typed_query", (Query)typedQuery);
                                    try {
                                        this.getEntityTransaction().begin();
                                        logger.log(System.Logger.Level.INFO, "*********************************");
                                        logger.log(System.Logger.Level.INFO, "Testing native query with different max result than the original");
                                        namedQuery = this.getEntityManager().createNamedQuery("native_query");
                                        configOK = true;
                                        if (namedQuery.getMaxResults() == 1) {
                                            logger.log(System.Logger.Level.TRACE, "Received expected Max Result before change:" + namedQuery.getMaxResults());
                                        } else {
                                            logger.log(System.Logger.Level.ERROR, "Expected Max Result before change:1, actual:" + namedQuery.getMaxResults());
                                            configOK = false;
                                        }
                                        namedQuery.setMaxResults(2);
                                        if (namedQuery.getMaxResults() == 2) {
                                            logger.log(System.Logger.Level.TRACE, "Received expected Max Result after change:" + namedQuery.getMaxResults());
                                        } else {
                                            logger.log(System.Logger.Level.ERROR, "Expected Max Result after change:2, actual:" + namedQuery.getMaxResults());
                                            configOK = false;
                                        }
                                        lResult = namedQuery.getResultList();
                                        iList = new ArrayList();
                                        for (Object o : lResult) {
                                            iList.add(this.convertToInt(o));
                                        }
                                        foundOne = false;
                                        boolean foundTwo = false;
                                        if (iList.size() == 2) {
                                            Iterator iterator = iList.iterator();
                                            while (iterator.hasNext()) {
                                                i = (Integer)iterator.next();
                                                if (i == 1) {
                                                    foundOne = true;
                                                    logger.log(System.Logger.Level.TRACE, "Found expected id:1");
                                                    continue;
                                                }
                                                if (i == 2) {
                                                    foundTwo = true;
                                                    logger.log(System.Logger.Level.TRACE, "Found expected id:2");
                                                    continue;
                                                }
                                                logger.log(System.Logger.Level.ERROR, "Received unexpected result:" + i);
                                            }
                                        } else {
                                            logger.log(System.Logger.Level.ERROR, "Did not get expected number of results, expected:2, actual:" + iList.size());
                                            for (Integer i2 : iList) {
                                                logger.log(System.Logger.Level.ERROR, "Ids received:" + i2);
                                            }
                                        }
                                        if (foundOne && foundTwo && configOK) {
                                            pass1 = true;
                                        }
                                        this.getEntityTransaction().commit();
                                    }
                                    catch (Exception e) {
                                        logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
                                        if (!this.getEntityTransaction().isActive()) break block89;
                                        this.getEntityTransaction().rollback();
                                    }
                                }
                                try {
                                    this.getEntityTransaction().begin();
                                    logger.log(System.Logger.Level.INFO, "*********************************");
                                    logger.log(System.Logger.Level.INFO, "Testing native query verify original max result is still active");
                                    namedQuery = this.getEntityManager().createNamedQuery("native_query");
                                    configOK = true;
                                    if (namedQuery.getMaxResults() == 1) {
                                        logger.log(System.Logger.Level.TRACE, "Received expected Max Result before change:" + namedQuery.getMaxResults());
                                    } else {
                                        logger.log(System.Logger.Level.ERROR, "Expected Max Result before change:1, actual:" + namedQuery.getMaxResults());
                                        configOK = false;
                                    }
                                    lResult = namedQuery.getResultList();
                                    iList = new ArrayList<Integer>();
                                    for (Object o : lResult) {
                                        iList.add(this.convertToInt(o));
                                    }
                                    foundOne = false;
                                    if (iList.size() == 1) {
                                        int result = (Integer)iList.get(0);
                                        if (result == 1) {
                                            logger.log(System.Logger.Level.TRACE, "Received expected Order");
                                            foundOne = true;
                                        } else {
                                            logger.log(System.Logger.Level.ERROR, "Expected id:1, actual:" + result);
                                        }
                                    } else {
                                        logger.log(System.Logger.Level.ERROR, "Did not get correct number of results, expected:1, actual:" + iList.size());
                                        Iterator result = iList.iterator();
                                        while (result.hasNext()) {
                                            int i3 = (Integer)result.next();
                                            logger.log(System.Logger.Level.ERROR, "Ids received:" + i3);
                                        }
                                    }
                                    if (foundOne && configOK) {
                                        pass2 = true;
                                    }
                                    this.getEntityTransaction().commit();
                                }
                                catch (Exception e) {
                                    logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
                                    if (!this.getEntityTransaction().isActive()) break block90;
                                    this.getEntityTransaction().rollback();
                                }
                            }
                            try {
                                this.getEntityTransaction().begin();
                                logger.log(System.Logger.Level.INFO, "*********************************");
                                logger.log(System.Logger.Level.INFO, "Testing query with different max result than the original");
                                namedQuery = this.getEntityManager().createNamedQuery("query");
                                configOK = true;
                                if (namedQuery.getMaxResults() == 1) {
                                    logger.log(System.Logger.Level.TRACE, "Received expected Max Result before change:" + namedQuery.getMaxResults());
                                } else {
                                    logger.log(System.Logger.Level.ERROR, "Expected Max Result before change:1, actual:" + namedQuery.getMaxResults());
                                    configOK = false;
                                }
                                namedQuery.setMaxResults(2);
                                if (namedQuery.getMaxResults() == 2) {
                                    logger.log(System.Logger.Level.TRACE, "Received expected Max Result after change:" + namedQuery.getMaxResults());
                                } else {
                                    logger.log(System.Logger.Level.ERROR, "Expected Max Result after change:2, actual:" + namedQuery.getMaxResults());
                                    configOK = false;
                                }
                                lResult = namedQuery.getResultList();
                                iList = new ArrayList();
                                for (Object o : lResult) {
                                    iList.add(this.convertToInt(o));
                                }
                                foundOne = false;
                                boolean foundTwo = false;
                                if (iList.size() == 2) {
                                    Iterator i3 = iList.iterator();
                                    while (i3.hasNext()) {
                                        i = (Integer)i3.next();
                                        if (i == 1) {
                                            foundOne = true;
                                            logger.log(System.Logger.Level.TRACE, "Found expected id:1");
                                            continue;
                                        }
                                        if (i == 2) {
                                            foundTwo = true;
                                            logger.log(System.Logger.Level.TRACE, "Found expected id:2");
                                            continue;
                                        }
                                        logger.log(System.Logger.Level.ERROR, "Received unexpected result:" + i);
                                    }
                                } else {
                                    logger.log(System.Logger.Level.ERROR, "Did not get expected number of results, expected:2, actual:" + iList.size());
                                    for (Integer i4 : iList) {
                                        logger.log(System.Logger.Level.ERROR, "Ids received:" + i4);
                                    }
                                }
                                if (foundOne && foundTwo && configOK) {
                                    pass3 = true;
                                }
                                this.getEntityTransaction().commit();
                            }
                            catch (Exception e) {
                                logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
                                if (!this.getEntityTransaction().isActive()) break block91;
                                this.getEntityTransaction().rollback();
                            }
                        }
                        try {
                            this.getEntityTransaction().begin();
                            logger.log(System.Logger.Level.INFO, "*********************************");
                            logger.log(System.Logger.Level.INFO, "Testing query verify original max result is active");
                            namedQuery = this.getEntityManager().createNamedQuery("query");
                            configOK = true;
                            if (namedQuery.getMaxResults() == 1) {
                                logger.log(System.Logger.Level.TRACE, "Received expected Max Result before change:" + namedQuery.getMaxResults());
                            } else {
                                logger.log(System.Logger.Level.ERROR, "Expected Max Result before change:1, actual:" + namedQuery.getMaxResults());
                                configOK = false;
                            }
                            lResult = namedQuery.getResultList();
                            iList = new ArrayList();
                            for (Object o : lResult) {
                                iList.add(this.convertToInt(o));
                            }
                            foundOne = false;
                            if (iList.size() == 1) {
                                int result = (Integer)iList.get(0);
                                if (result == 1) {
                                    logger.log(System.Logger.Level.TRACE, "Received expected id:" + result);
                                    foundOne = true;
                                } else {
                                    logger.log(System.Logger.Level.ERROR, "Expected id:1, actual:" + result);
                                }
                            } else {
                                logger.log(System.Logger.Level.ERROR, "Did not get correct number of results, expected:1, actual:" + iList.size());
                                Iterator result = iList.iterator();
                                while (result.hasNext()) {
                                    int i = (Integer)result.next();
                                    logger.log(System.Logger.Level.ERROR, "Ids received:" + i);
                                }
                            }
                            if (foundOne && configOK) {
                                pass4 = true;
                            }
                            this.getEntityTransaction().commit();
                        }
                        catch (Exception e) {
                            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
                            if (!this.getEntityTransaction().isActive()) break block92;
                            this.getEntityTransaction().rollback();
                        }
                    }
                    try {
                        this.getEntityTransaction().begin();
                        logger.log(System.Logger.Level.INFO, "*********************************");
                        logger.log(System.Logger.Level.INFO, "Testing query definition can be replaced ");
                        Query query2 = this.getEntityManager().createQuery("Select o.id from Order o where o.id in (1,2) ");
                        query2.setMaxResults(2);
                        this.getEntityManagerFactory().addNamedQuery("query", query2);
                        Query namedQuery = this.getEntityManager().createNamedQuery("query");
                        boolean configOK = true;
                        if (namedQuery.getMaxResults() == 2) {
                            logger.log(System.Logger.Level.TRACE, "Received expected Max Result before change:" + namedQuery.getMaxResults());
                        } else {
                            logger.log(System.Logger.Level.ERROR, "Expected Max Result before change:2, actual:" + namedQuery.getMaxResults());
                            configOK = false;
                        }
                        List lResult = namedQuery.getResultList();
                        ArrayList<Integer> iList2 = new ArrayList<Integer>();
                        for (Object o : lResult) {
                            iList2.add(this.convertToInt(o));
                        }
                        ArrayList<Integer> lExpected = new ArrayList<Integer>();
                        lExpected.add(1);
                        lExpected.add(2);
                        if (iList2.containsAll(lExpected) && lExpected.containsAll(iList2) && iList2.size() == lExpected.size()) {
                            logger.log(System.Logger.Level.TRACE, "Received expected ids");
                            if (configOK) {
                                pass5 = true;
                            }
                        } else {
                            logger.log(System.Logger.Level.ERROR, "Did not receive expected results:");
                            for (Integer i : lExpected) {
                                logger.log(System.Logger.Level.ERROR, "Expected:" + i);
                            }
                            for (Integer i : iList2) {
                                logger.log(System.Logger.Level.ERROR, "Expected:" + i);
                            }
                        }
                        this.getEntityTransaction().commit();
                    }
                    catch (Exception e) {
                        logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
                        if (!this.getEntityTransaction().isActive()) break block93;
                        this.getEntityTransaction().rollback();
                    }
                }
                try {
                    this.getEntityTransaction().begin();
                    logger.log(System.Logger.Level.INFO, "*********************************");
                    logger.log(System.Logger.Level.INFO, "Testing TypedQuery with max result different than the original");
                    namedTypeQuery = this.getEntityManager().createNamedQuery("typed_query", Integer.class);
                    boolean configOK = true;
                    if (namedTypeQuery.getMaxResults() == 1) {
                        logger.log(System.Logger.Level.TRACE, "Received expected Max Result before change:" + namedTypeQuery.getMaxResults());
                    } else {
                        logger.log(System.Logger.Level.ERROR, "Expected Max Result before change:1, actual:" + namedTypeQuery.getMaxResults());
                        configOK = false;
                    }
                    namedTypeQuery.setMaxResults(2);
                    if (namedTypeQuery.getMaxResults() == 2) {
                        logger.log(System.Logger.Level.TRACE, "Received expected Max Result after change:" + namedTypeQuery.getMaxResults());
                    } else {
                        logger.log(System.Logger.Level.ERROR, "Expected Max Result after change:2, actual:" + namedTypeQuery.getMaxResults());
                        configOK = false;
                    }
                    List lResult = namedTypeQuery.getResultList();
                    iList = new ArrayList();
                    for (Object o : lResult) {
                        iList.add(this.convertToInt(o));
                    }
                    boolean foundOne = false;
                    boolean foundTwo = false;
                    if (iList.size() == 2) {
                        Iterator o = iList.iterator();
                        while (o.hasNext()) {
                            int i = (Integer)o.next();
                            if (i == 1) {
                                foundOne = true;
                                logger.log(System.Logger.Level.TRACE, "Found expected id:1");
                                continue;
                            }
                            if (i == 2) {
                                foundTwo = true;
                                logger.log(System.Logger.Level.TRACE, "Found expected id:2");
                                continue;
                            }
                            logger.log(System.Logger.Level.ERROR, "Received unexpected result:" + i);
                        }
                    } else {
                        logger.log(System.Logger.Level.ERROR, "Did not get expected number of results, expected:2, actual:" + iList.size());
                        for (Integer i : iList) {
                            logger.log(System.Logger.Level.ERROR, "Ids received:" + i);
                        }
                    }
                    if (foundOne && foundTwo && configOK) {
                        pass6 = true;
                    }
                    this.getEntityTransaction().commit();
                }
                catch (Exception e) {
                    logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
                    if (!this.getEntityTransaction().isActive()) break block94;
                    this.getEntityTransaction().rollback();
                }
            }
            try {
                this.getEntityTransaction().begin();
                logger.log(System.Logger.Level.INFO, "*********************************");
                logger.log(System.Logger.Level.INFO, "Testing TypedQuery verify original max result is active");
                namedTypeQuery = this.getEntityManager().createNamedQuery("typed_query", Integer.class);
                boolean configOK = true;
                if (namedTypeQuery.getMaxResults() == 1) {
                    logger.log(System.Logger.Level.TRACE, "Received expected Max Result before change:" + namedTypeQuery.getMaxResults());
                } else {
                    logger.log(System.Logger.Level.ERROR, "Expected Max Result before change:1, actual:" + namedTypeQuery.getMaxResults());
                    configOK = false;
                }
                List lResult = namedTypeQuery.getResultList();
                iList = new ArrayList();
                for (Object o : lResult) {
                    iList.add(this.convertToInt(o));
                }
                boolean foundOne = false;
                if (iList.size() == 1) {
                    int result = (Integer)iList.get(0);
                    if (result == 1) {
                        logger.log(System.Logger.Level.TRACE, "Received expected id:" + result);
                        foundOne = true;
                    } else {
                        logger.log(System.Logger.Level.ERROR, "Expected id:1, actual:" + result);
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "Did not get correct number of results, expected:1, actual:" + iList.size());
                    Iterator iterator = iList.iterator();
                    while (iterator.hasNext()) {
                        int i = (Integer)iterator.next();
                        logger.log(System.Logger.Level.ERROR, "Ids received:" + i);
                    }
                }
                if (foundOne && configOK) {
                    pass7 = true;
                }
                this.getEntityTransaction().commit();
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        if (!(pass1 && pass2 && pass3 && pass4 && pass5 && pass6 && pass7)) {
            throw new Exception("addNamedQueryMaxResultTest failed");
        }
    }

    @Test
    public void addNamedQueryFlushModeTest() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        boolean pass3 = false;
        boolean pass4 = false;
        boolean pass5 = false;
        boolean pass6 = false;
        boolean pass7 = false;
        try {
            TypedQuery namedTypeQuery;
            block85: {
                block84: {
                    block83: {
                        int i;
                        boolean foundOne;
                        List lResult;
                        boolean configOK;
                        Query namedQuery;
                        block82: {
                            block81: {
                                int result3;
                                block80: {
                                    CriteriaBuilder cbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
                                    logger.log(System.Logger.Level.TRACE, "Defining queries");
                                    Query nativeQuery = this.getEntityManager().createNativeQuery("Select ID from PURCHASE_ORDER where ID=1");
                                    nativeQuery.setFlushMode(FlushModeType.AUTO);
                                    this.getEntityManagerFactory().addNamedQuery("native_query", nativeQuery);
                                    Query query = this.getEntityManager().createQuery("select o.id from Order o where o.id=1");
                                    query.setFlushMode(FlushModeType.AUTO);
                                    this.getEntityManagerFactory().addNamedQuery("query", query);
                                    CriteriaQuery cquery = cbuilder.createQuery(Integer.class);
                                    Root order = cquery.from(Order.class);
                                    cquery.select((Selection)order.get(Order_.id));
                                    cquery.where((Expression)cbuilder.equal((Expression)order.get(Order_.id), (Object)1));
                                    TypedQuery typedQuery = this.getEntityManager().createQuery(cquery);
                                    typedQuery.setFlushMode(FlushModeType.AUTO);
                                    this.getEntityManagerFactory().addNamedQuery("typed_query", (Query)typedQuery);
                                    try {
                                        this.getEntityTransaction().begin();
                                        logger.log(System.Logger.Level.INFO, "*********************************");
                                        logger.log(System.Logger.Level.INFO, "Testing native query with different flush mode than the original");
                                        namedQuery = this.getEntityManager().createNamedQuery("native_query");
                                        configOK = true;
                                        if (namedQuery.getFlushMode().equals((Object)FlushModeType.AUTO)) {
                                            logger.log(System.Logger.Level.TRACE, "Received expected flush mode before change:" + namedQuery.getFlushMode());
                                        } else {
                                            logger.log(System.Logger.Level.ERROR, "Expected flush mode before change:" + FlushModeType.AUTO + ", actual:" + namedQuery.getFlushMode());
                                            configOK = false;
                                        }
                                        namedQuery.setFlushMode(FlushModeType.COMMIT);
                                        if (namedQuery.getFlushMode().equals((Object)FlushModeType.COMMIT)) {
                                            logger.log(System.Logger.Level.TRACE, "Received expected flush mode after change:" + namedQuery.getFlushMode());
                                        } else {
                                            logger.log(System.Logger.Level.ERROR, "Expected flush mode after change:" + FlushModeType.AUTO + ", actual:" + namedQuery.getFlushMode());
                                            configOK = false;
                                        }
                                        lResult = namedQuery.getResultList();
                                        foundOne = false;
                                        if (lResult.size() == 1) {
                                            result3 = this.convertToInt(lResult.get(0));
                                            if (result3 == 1) {
                                                logger.log(System.Logger.Level.TRACE, "Received expected id:" + result3);
                                                foundOne = true;
                                            } else {
                                                logger.log(System.Logger.Level.ERROR, "Expected id:1, actual:" + result3);
                                            }
                                        } else {
                                            logger.log(System.Logger.Level.ERROR, "Did not get correct number of results, expected:1, actual:" + lResult.size());
                                            Iterator result2 = lResult.iterator();
                                            while (result2.hasNext()) {
                                                i = (Integer)result2.next();
                                                logger.log(System.Logger.Level.ERROR, "Ids received:" + i);
                                            }
                                        }
                                        if (foundOne && configOK) {
                                            pass1 = true;
                                        }
                                        this.getEntityTransaction().commit();
                                    }
                                    catch (Exception e) {
                                        logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
                                        if (!this.getEntityTransaction().isActive()) break block80;
                                        this.getEntityTransaction().rollback();
                                    }
                                }
                                try {
                                    this.getEntityTransaction().begin();
                                    logger.log(System.Logger.Level.INFO, "*********************************");
                                    logger.log(System.Logger.Level.INFO, "Testing native query verify original flush mode is still active");
                                    namedQuery = this.getEntityManager().createNamedQuery("native_query");
                                    configOK = true;
                                    if (namedQuery.getFlushMode().equals((Object)FlushModeType.AUTO)) {
                                        logger.log(System.Logger.Level.TRACE, "Received expected flush mode before change:" + namedQuery.getFlushMode());
                                    } else {
                                        logger.log(System.Logger.Level.ERROR, "Expected flush mode before change:" + FlushModeType.AUTO.name() + ", actual:" + namedQuery.getFlushMode());
                                        configOK = false;
                                    }
                                    lResult = namedQuery.getResultList();
                                    foundOne = false;
                                    if (lResult.size() == 1) {
                                        result3 = this.convertToInt(lResult.get(0));
                                        if (result3 == 1) {
                                            logger.log(System.Logger.Level.TRACE, "Received expected id:" + result3);
                                            foundOne = true;
                                        } else {
                                            logger.log(System.Logger.Level.ERROR, "Expected id:1, actual:" + result3);
                                        }
                                    } else {
                                        logger.log(System.Logger.Level.ERROR, "Did not get correct number of results, expected:1, actual:" + lResult.size());
                                        Iterator result3 = lResult.iterator();
                                        while (result3.hasNext()) {
                                            i = (Integer)result3.next();
                                            logger.log(System.Logger.Level.ERROR, "Ids received:" + i);
                                        }
                                    }
                                    if (foundOne && configOK) {
                                        pass2 = true;
                                    }
                                    this.getEntityTransaction().commit();
                                }
                                catch (Exception e) {
                                    logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
                                    if (!this.getEntityTransaction().isActive()) break block81;
                                    this.getEntityTransaction().rollback();
                                }
                            }
                            try {
                                this.getEntityTransaction().begin();
                                logger.log(System.Logger.Level.INFO, "*********************************");
                                logger.log(System.Logger.Level.INFO, "Testing query with different flush mode than the original");
                                namedQuery = this.getEntityManager().createNamedQuery("query");
                                configOK = true;
                                if (namedQuery.getFlushMode().equals((Object)FlushModeType.AUTO)) {
                                    logger.log(System.Logger.Level.TRACE, "Received expected flush mode before change:" + namedQuery.getFlushMode());
                                } else {
                                    logger.log(System.Logger.Level.ERROR, "Expected flush mode before change:" + FlushModeType.AUTO + ", actual:" + namedQuery.getFlushMode());
                                    configOK = false;
                                }
                                namedQuery.setFlushMode(FlushModeType.COMMIT);
                                if (namedQuery.getFlushMode().equals((Object)FlushModeType.COMMIT)) {
                                    logger.log(System.Logger.Level.TRACE, "Received expected flush mode after change:" + namedQuery.getFlushMode());
                                } else {
                                    logger.log(System.Logger.Level.ERROR, "Expected flush mode after change:" + FlushModeType.AUTO + ", actual:" + namedQuery.getFlushMode());
                                    configOK = false;
                                }
                                lResult = namedQuery.getResultList();
                                foundOne = false;
                                if (lResult.size() == 1) {
                                    int result = (Integer)lResult.get(0);
                                    if (result == 1) {
                                        logger.log(System.Logger.Level.TRACE, "Received expected id:" + result);
                                        foundOne = true;
                                    } else {
                                        logger.log(System.Logger.Level.ERROR, "Expected id:1, actual:" + result);
                                    }
                                } else {
                                    logger.log(System.Logger.Level.ERROR, "Did not get correct number of results, expected:1, actual:" + lResult.size());
                                    Iterator result = lResult.iterator();
                                    while (result.hasNext()) {
                                        i = (Integer)result.next();
                                        logger.log(System.Logger.Level.ERROR, "Ids received:" + i);
                                    }
                                }
                                if (foundOne && configOK) {
                                    pass3 = true;
                                }
                                this.getEntityTransaction().commit();
                            }
                            catch (Exception e) {
                                logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
                                if (!this.getEntityTransaction().isActive()) break block82;
                                this.getEntityTransaction().rollback();
                            }
                        }
                        try {
                            this.getEntityTransaction().begin();
                            logger.log(System.Logger.Level.INFO, "*********************************");
                            logger.log(System.Logger.Level.INFO, "Testing query verify original flush mode is active");
                            namedQuery = this.getEntityManager().createNamedQuery("query");
                            configOK = true;
                            if (namedQuery.getFlushMode().equals((Object)FlushModeType.AUTO)) {
                                logger.log(System.Logger.Level.TRACE, "Received expected flush mode before change:" + namedQuery.getFlushMode());
                            } else {
                                logger.log(System.Logger.Level.ERROR, "Expected flush mode before change:" + FlushModeType.AUTO.name() + ", actual:" + namedQuery.getFlushMode());
                                configOK = false;
                            }
                            lResult = namedQuery.getResultList();
                            foundOne = false;
                            if (lResult.size() == 1) {
                                int result = (Integer)lResult.get(0);
                                if (result == 1) {
                                    logger.log(System.Logger.Level.TRACE, "Received expected id:" + result);
                                    foundOne = true;
                                } else {
                                    logger.log(System.Logger.Level.ERROR, "Expected id:1, actual:" + result);
                                }
                            } else {
                                logger.log(System.Logger.Level.ERROR, "Did not get correct number of results, expected:1, actual:" + lResult.size());
                                Iterator result = lResult.iterator();
                                while (result.hasNext()) {
                                    i = (Integer)result.next();
                                    logger.log(System.Logger.Level.ERROR, "Ids received:" + i);
                                }
                            }
                            if (foundOne && configOK) {
                                pass4 = true;
                            }
                            this.getEntityTransaction().commit();
                        }
                        catch (Exception e) {
                            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
                            if (!this.getEntityTransaction().isActive()) break block83;
                            this.getEntityTransaction().rollback();
                        }
                    }
                    try {
                        this.getEntityTransaction().begin();
                        logger.log(System.Logger.Level.INFO, "*********************************");
                        logger.log(System.Logger.Level.INFO, "Testing query definition can be replaced ");
                        Query query2 = this.getEntityManager().createQuery("Select o.id from Order o where o.id = 2").setFlushMode(FlushModeType.COMMIT);
                        this.getEntityManagerFactory().addNamedQuery("query", query2);
                        Query namedQuery = this.getEntityManager().createNamedQuery("query");
                        boolean configOK = true;
                        if (namedQuery.getFlushMode().equals((Object)FlushModeType.COMMIT)) {
                            logger.log(System.Logger.Level.TRACE, "Received expected flush mode before change:" + namedQuery.getFlushMode());
                        } else {
                            logger.log(System.Logger.Level.ERROR, "Expected flush mode before change:" + FlushModeType.COMMIT.name() + ", actual:" + namedQuery.getFlushMode());
                            configOK = false;
                        }
                        List lResult = namedQuery.getResultList();
                        boolean foundOne = false;
                        if (lResult.size() == 1) {
                            int result = (Integer)lResult.get(0);
                            if (result == 2) {
                                logger.log(System.Logger.Level.TRACE, "Received expected id:" + result);
                                foundOne = true;
                            } else {
                                logger.log(System.Logger.Level.ERROR, "Expected id:2, actual:" + result);
                            }
                        } else {
                            logger.log(System.Logger.Level.ERROR, "Did not get correct number of results, expected:1, actual:" + lResult.size());
                            Iterator result = lResult.iterator();
                            while (result.hasNext()) {
                                int i = (Integer)result.next();
                                logger.log(System.Logger.Level.ERROR, "Ids received:" + i);
                            }
                        }
                        if (foundOne && configOK) {
                            pass5 = true;
                        }
                        this.getEntityTransaction().commit();
                    }
                    catch (Exception e) {
                        logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
                        if (!this.getEntityTransaction().isActive()) break block84;
                        this.getEntityTransaction().rollback();
                    }
                }
                try {
                    this.getEntityTransaction().begin();
                    logger.log(System.Logger.Level.INFO, "*********************************");
                    logger.log(System.Logger.Level.INFO, "Testing TypedQuery with flush mode different than the original");
                    namedTypeQuery = this.getEntityManager().createNamedQuery("typed_query", Integer.class);
                    boolean configOK = true;
                    if (namedTypeQuery.getFlushMode().equals((Object)FlushModeType.AUTO)) {
                        logger.log(System.Logger.Level.TRACE, "Received expected flush mode before change:" + namedTypeQuery.getFlushMode());
                    } else {
                        logger.log(System.Logger.Level.ERROR, "Expected flush mode before change:" + FlushModeType.AUTO + ", actual:" + namedTypeQuery.getFlushMode());
                        configOK = false;
                    }
                    namedTypeQuery.setFlushMode(FlushModeType.COMMIT);
                    if (namedTypeQuery.getFlushMode().equals((Object)FlushModeType.COMMIT)) {
                        logger.log(System.Logger.Level.TRACE, "Received expected flush mode after change:" + namedTypeQuery.getFlushMode());
                    } else {
                        logger.log(System.Logger.Level.ERROR, "Expected flush mode after change:" + FlushModeType.AUTO + ", actual:" + namedTypeQuery.getFlushMode());
                        configOK = false;
                    }
                    List lResult = namedTypeQuery.getResultList();
                    boolean foundOne = false;
                    if (lResult.size() == 1) {
                        int result = (Integer)lResult.get(0);
                        if (result == 1) {
                            logger.log(System.Logger.Level.TRACE, "Received expected id:" + result);
                            foundOne = true;
                        } else {
                            logger.log(System.Logger.Level.ERROR, "Expected id:1, actual:" + result);
                        }
                    } else {
                        logger.log(System.Logger.Level.ERROR, "Did not get correct number of results, expected:1, actual:" + lResult.size());
                        Iterator result = lResult.iterator();
                        while (result.hasNext()) {
                            int i = (Integer)result.next();
                            logger.log(System.Logger.Level.ERROR, "Ids received:" + i);
                        }
                    }
                    if (foundOne && configOK) {
                        pass6 = true;
                    }
                    this.getEntityTransaction().commit();
                }
                catch (Exception e) {
                    logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
                    if (!this.getEntityTransaction().isActive()) break block85;
                    this.getEntityTransaction().rollback();
                }
            }
            try {
                this.getEntityTransaction().begin();
                logger.log(System.Logger.Level.INFO, "*********************************");
                logger.log(System.Logger.Level.INFO, "Testing TypedQuery verify original flush mode is active");
                namedTypeQuery = this.getEntityManager().createNamedQuery("typed_query", Integer.class);
                boolean configOK = true;
                if (namedTypeQuery.getFlushMode().equals((Object)FlushModeType.AUTO)) {
                    logger.log(System.Logger.Level.TRACE, "Received expected flush mode before change:" + namedTypeQuery.getFlushMode());
                } else {
                    logger.log(System.Logger.Level.ERROR, "Expected flush mode before change:" + FlushModeType.AUTO.name() + ", actual:" + namedTypeQuery.getFlushMode());
                    configOK = false;
                }
                List lResult = namedTypeQuery.getResultList();
                boolean foundOne = false;
                if (lResult.size() == 1) {
                    int result = (Integer)lResult.get(0);
                    if (result == 1) {
                        logger.log(System.Logger.Level.TRACE, "Received expected id:" + result);
                        foundOne = true;
                    } else {
                        logger.log(System.Logger.Level.ERROR, "Expected id:1, actual:" + result);
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "Did not get correct number of results, expected:1, actual:" + lResult.size());
                    Iterator iterator = lResult.iterator();
                    while (iterator.hasNext()) {
                        int i = (Integer)iterator.next();
                        logger.log(System.Logger.Level.ERROR, "Ids received:" + i);
                    }
                }
                if (foundOne && configOK) {
                    pass7 = true;
                }
                this.getEntityTransaction().commit();
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        if (!(pass1 && pass2 && pass3 && pass4 && pass5 && pass6 && pass7)) {
            throw new Exception("addNamedQueryFlushModeTest failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createOrderTestData() {
        try {
            this.getEntityTransaction().begin();
            Order[] orders = new Order[]{new Order(1, 111), new Order(2, 222), new Order(3, 333), new Order(4, 444), new Order(5, 555)};
            for (Order o : orders) {
                logger.log(System.Logger.Level.TRACE, "Persisting order:" + o.toString());
                this.getEntityManager().persist((Object)o);
            }
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
    }

    private void removeTestData() {
        logger.log(System.Logger.Level.TRACE, "removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.clearCache();
            this.getEntityManager().createNativeQuery("DELETE FROM PURCHASE_ORDER").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM MEMBER").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

