/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.entityManager2;

import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.entityManager2.Order;
import jakarta.persistence.CacheRetrieveMode;
import jakarta.persistence.CacheStoreMode;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityNotFoundException;
import jakarta.persistence.FindOption;
import jakarta.persistence.LockModeType;
import jakarta.persistence.RefreshOption;
import jakarta.persistence.Timeout;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.HashMap;
import java.util.Map;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class Client3
extends PMClientBase {
    private static final System.Logger logger = System.getLogger(Client3.class.getName());
    Order[] orders = new Order[5];
    Map map = new HashMap();
    String dataBaseName = null;

    public JavaArchive createDeployment() throws Exception {
        String pkgNameWithoutSuffix = Client3.class.getPackageName();
        String pkgName = pkgNameWithoutSuffix + ".";
        String[] classes = new String[]{pkgName + "DoesNotExist", pkgName + "Employee", pkgName + "Order"};
        return this.createDeploymentJar("jpa_core_entityManager3.jar", pkgNameWithoutSuffix, classes);
    }

    @BeforeEach
    public void setupOrderData() throws Exception {
        logger.log(System.Logger.Level.TRACE, "setupOrderData");
        try {
            super.setup();
            this.createDeployment();
            this.removeTestData();
            this.createOrderData();
            this.map.putAll(this.getEntityManager().getProperties());
            this.map.put("foo", "bar");
            this.displayMap(this.map);
            this.dataBaseName = System.getProperty("jdbc.db");
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception: ", (Throwable)e);
            throw new Exception("Setup failed:", e);
        }
    }

    @AfterEach
    public void cleanupData() throws Exception {
        try {
            logger.log(System.Logger.Level.TRACE, "Cleanup data");
            this.removeTestData();
            this.cleanup();
        }
        finally {
            this.removeTestJarFromCP();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void getReferenceForExistingEntityTest() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        try {
            this.getEntityTransaction().begin();
            Order order = new Order(1, 111, "desc1");
            Order reference = (Order)this.getEntityManager().getReference((Object)order);
            String orderDescription = reference.getdescription();
            this.getEntityTransaction().commit();
            if (reference instanceof Order) {
                pass1 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Fetched entity is not same as expected.");
            }
            if (orderDescription != null) {
                pass2 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Access to entity attribute doesn't work.");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass1 || !pass2) {
            throw new Exception("getReferenceForExistingEntityTest failed");
        }
    }

    @Test
    public void getReferenceForNonExistingEntityTest() throws Exception {
        boolean pass = false;
        try {
            Order order = new Order(0, 0, "desc0");
            Order referenceOrder = (Order)this.getEntityManager().getReference((Object)order);
            String string = referenceOrder.getdescription();
        }
        catch (EntityNotFoundException enfe) {
            pass = true;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("getReferenceForNonExistingEntityTest failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void runWithConnectionTest() throws Exception {
        boolean pass = false;
        Order newOrder = new Order(50, 5555, "desc55");
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().runWithConnection(connection -> {
                try (PreparedStatement stmt = connection.prepareStatement("INSERT INTO PURCHASE_ORDER(ID, TOTAL, DESCRIPTION) VALUES(?, ?, ?)");){
                    stmt.setInt(1, newOrder.getId());
                    stmt.setInt(2, newOrder.getTotal());
                    stmt.setString(3, newOrder.getdescription());
                    stmt.executeUpdate();
                }
            });
            this.getEntityTransaction().commit();
            Order foundOrder = (Order)this.getEntityManager().find(Order.class, (Object)newOrder.getId());
            if (foundOrder.equals(newOrder)) {
                pass = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Fetched entity is not same as expected.");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("runWithConnectionTest failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void callWithConnectionTest() throws Exception {
        boolean pass = false;
        Order newOrder = new Order(60, 6666, "desc66");
        try {
            this.getEntityTransaction().begin();
            Order selectedOrder = (Order)this.getEntityManager().callWithConnection(connection -> {
                try (PreparedStatement stmt = connection.prepareStatement("INSERT INTO PURCHASE_ORDER(ID, TOTAL, DESCRIPTION) VALUES(?, ?, ?)");){
                    stmt.setInt(1, newOrder.getId());
                    stmt.setInt(2, newOrder.getTotal());
                    stmt.setString(3, newOrder.getdescription());
                    stmt.executeUpdate();
                }
                Order order = new Order();
                try (PreparedStatement stmt = connection.prepareStatement("SELECT * FROM PURCHASE_ORDER WHERE ID = ?");){
                    stmt.setInt(1, newOrder.getId());
                    stmt.execute();
                    ResultSet rSet = stmt.getResultSet();
                    rSet.next();
                    order.setId(rSet.getInt(1));
                    order.setTotal(rSet.getInt(2));
                    order.setdescription(rSet.getString(3));
                    rSet.close();
                }
                return order;
            });
            this.getEntityTransaction().commit();
            Order foundOrder = (Order)this.getEntityManager().find(Order.class, (Object)newOrder.getId());
            if (foundOrder.equals(selectedOrder)) {
                pass = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Fetched entity is not same as expected.");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("callWithConnectionTest failed");
        }
    }

    @Test
    public void findOptionsTest() throws Exception {
        boolean pass = false;
        try {
            FindOption[] findOptions = new FindOption[]{CacheRetrieveMode.BYPASS, CacheStoreMode.BYPASS, LockModeType.NONE};
            Order foundOrder = (Order)this.getEntityManager().find(Order.class, (Object)this.orders[0].getId(), findOptions);
            if (foundOrder.equals(this.orders[0])) {
                pass = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Fetched entity is not same as expected.");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("findOptionsTest failed");
        }
    }

    @Test
    public void refreshOptionsTest() throws Exception {
        boolean pass = false;
        try {
            Order order = (Order)this.getEntityManager().find(Order.class, (Object)this.orders[0].getId());
            RefreshOption[] refreshOptions = new RefreshOption[]{CacheStoreMode.BYPASS, LockModeType.NONE, Timeout.seconds((int)10)};
            this.getEntityManager().refresh((Object)order, refreshOptions);
            if (order.equals(this.orders[0])) {
                pass = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Fetched entity is not same as expected.");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("refreshOptionsTest failed");
        }
    }

    @Test
    public void setCacheRetrieveModeTest() throws Exception {
        boolean pass = false;
        try {
            EntityManager em = this.getEntityManager();
            em.setCacheRetrieveMode(CacheRetrieveMode.USE);
            if (CacheRetrieveMode.USE == em.getCacheRetrieveMode()) {
                pass = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "CacheRetrieveMode property is not set.");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("setCacheRetrieveModeTest failed");
        }
    }

    @Test
    public void setCacheStoreModeTest() throws Exception {
        boolean pass = false;
        try {
            EntityManager em = this.getEntityManager();
            em.setCacheStoreMode(CacheStoreMode.BYPASS);
            if (CacheStoreMode.BYPASS == em.getCacheStoreMode()) {
                pass = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "CacheStoreMode property is not set.");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("setCacheStoreModeTest failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createOrderData() {
        try {
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.INFO, "Creating Orders");
            this.orders[0] = new Order(1, 111, "desc1");
            this.orders[1] = new Order(2, 222, "desc2");
            this.orders[2] = new Order(3, 333, "desc3");
            this.orders[3] = new Order(4, 444, "desc4");
            this.orders[4] = new Order(5, 555, "desc5");
            for (Order o : this.orders) {
                logger.log(System.Logger.Level.TRACE, "Persisting order:" + o.toString());
                this.getEntityManager().persist((Object)o);
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
    }

    private void removeTestData() {
        logger.log(System.Logger.Level.TRACE, "removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM PURCHASE_ORDER").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

