/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.entityManager;

import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.entityManager.Employee;
import ee.jakarta.tck.persistence.core.entityManager.Order;
import jakarta.persistence.CacheRetrieveMode;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.EntityTransaction;
import jakarta.persistence.LockModeType;
import jakarta.persistence.Persistence;
import jakarta.persistence.PersistenceException;
import jakarta.persistence.Query;
import jakarta.persistence.StoredProcedureQuery;
import jakarta.persistence.TypedQuery;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.metamodel.Metamodel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class Client1
extends PMClientBase {
    private static final System.Logger logger = System.getLogger(Client1.class.getName());
    List<Employee> empRef = new ArrayList<Employee>();
    Employee emp0 = null;
    Order[] orders = new Order[5];
    Properties props = null;
    Map map = new HashMap();
    String dataBaseName = null;
    static final String ORACLE = "oracle";
    static final String POSTGRESQL = "postgresql";

    public JavaArchive createDeployment() throws Exception {
        String pkgNameWithoutSuffix = Client1.class.getPackageName();
        String pkgName = pkgNameWithoutSuffix + ".";
        String[] classes = new String[]{pkgName + "Employee", pkgName + "Order"};
        return this.createDeploymentJar("jpa_core_entityManager1.jar", pkgNameWithoutSuffix, classes);
    }

    @BeforeEach
    public void setup() throws Exception {
        logger.log(System.Logger.Level.TRACE, "setup");
        try {
            super.setup();
            this.createDeployment();
            this.map.putAll(this.getEntityManager().getProperties());
            this.map.put("foo", "bar");
            this.displayMap(this.map);
            this.dataBaseName = System.getProperty("jdbc.db");
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception: ", (Throwable)e);
            throw new Exception("Setup failed:", e);
        }
    }

    @AfterEach
    public void cleanup() throws Exception {
        try {
            logger.log(System.Logger.Level.TRACE, "cleanup complete, calling super.cleanup");
            super.cleanup();
        }
        finally {
            this.removeTestJarFromCP();
        }
    }

    public List<List> getResultSetsFromStoredProcedure(StoredProcedureQuery spq) {
        logger.log(System.Logger.Level.TRACE, "in getResultSetsFromStoredProcedure");
        boolean results = true;
        ArrayList<List> listOfList = new ArrayList<List>();
        int rsnum = 1;
        int rowsAffected = 0;
        do {
            if (results) {
                logger.log(System.Logger.Level.TRACE, "Processing set:" + rsnum);
                ArrayList<Employee> empList = new ArrayList<Employee>();
                List list = spq.getResultList();
                if (list != null) {
                    logger.log(System.Logger.Level.TRACE, "Getting result set: " + rsnum + ", size:" + list.size());
                    for (Object o : list) {
                        if (o instanceof Employee) {
                            Employee e = (Employee)o;
                            logger.log(System.Logger.Level.TRACE, "Saving:" + e);
                            empList.add(e);
                            continue;
                        }
                        logger.log(System.Logger.Level.ERROR, "Did not get instance of Employee, instead got:" + o.getClass().getName());
                    }
                    if (empList.size() > 0) {
                        listOfList.add(empList);
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "Result set[" + rsnum + "] returned was null");
                }
                ++rsnum;
            } else {
                rowsAffected = spq.getUpdateCount();
                if (rowsAffected >= 0) {
                    logger.log(System.Logger.Level.TRACE, "rowsAffected:" + rowsAffected);
                }
            }
            results = spq.hasMoreResults();
            logger.log(System.Logger.Level.TRACE, "Results:" + results);
        } while (results || rowsAffected != -1);
        return listOfList;
    }

    public boolean verifyListOfListEmployeeIds(List<Integer> expected, List<List> listOfList) {
        boolean result = false;
        int count = 0;
        for (List lEmp : listOfList) {
            if (lEmp.size() > 0) {
                ArrayList<Integer> actual = new ArrayList<Integer>();
                for (Employee employee : lEmp) {
                    actual.add(employee.getId());
                }
                if (expected.containsAll(actual) && actual.containsAll(expected) && expected.size() == actual.size()) {
                    logger.log(System.Logger.Level.TRACE, "Received expected result:");
                    for (Integer n : actual) {
                        logger.log(System.Logger.Level.TRACE, "id:" + n);
                    }
                    ++count;
                    continue;
                }
                logger.log(System.Logger.Level.ERROR, "Did not receive expected result:");
                for (Integer n : expected) {
                    logger.log(System.Logger.Level.ERROR, " Expected id:" + n);
                }
                for (Integer n : actual) {
                    logger.log(System.Logger.Level.ERROR, "Actual id:" + n);
                }
                continue;
            }
            logger.log(System.Logger.Level.ERROR, "Result set that was returned had 0 length");
        }
        if (count == listOfList.size()) {
            result = true;
        }
        return result;
    }

    public boolean verifyListOfListEmployees(List<Employee> expected, List<List> listOfList) {
        boolean result = false;
        int count = 0;
        for (List lEmp : listOfList) {
            if (lEmp.size() > 0) {
                ArrayList<Employee> actual = new ArrayList<Employee>();
                for (Employee e : lEmp) {
                    actual.add(e);
                }
                if (!this.verifyListEmployees(expected, actual)) continue;
                ++count;
                continue;
            }
            logger.log(System.Logger.Level.ERROR, "Result set that was returned had 0 length");
        }
        if (count == listOfList.size()) {
            result = true;
        }
        return result;
    }

    public boolean verifyListEmployees(List<Employee> expected, List<Employee> actual) {
        boolean result = false;
        if (expected.containsAll(actual) && actual.containsAll(expected) && expected.size() == actual.size()) {
            for (Employee e : expected) {
                logger.log(System.Logger.Level.TRACE, "Received expected result:" + e);
            }
            result = true;
        } else {
            logger.log(System.Logger.Level.ERROR, "Did not receive expected result:");
            for (Employee e : expected) {
                logger.log(System.Logger.Level.ERROR, "expected employee:" + e);
            }
            for (Employee e : actual) {
                logger.log(System.Logger.Level.ERROR, "actual employee :" + e);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Test
    public void autoCloseableTest() throws Exception {
        EntityManager em = null;
        try (EntityManagerFactory emfLocal = Persistence.createEntityManagerFactory((String)this.getPersistenceUnitName(), (Map)this.getPersistenceUnitProperties());){
            try {
                block18: {
                    try (EntityManager emLocal = emfLocal.createEntityManager();){
                        em = emLocal;
                        if (em == null) {
                            throw new Exception("autoCloseableTest failed: createEntityManager() returned null");
                        }
                        if (!em.isOpen()) {
                            throw new Exception("autoCloseableTest failed: EntityManager isOpen() returned false in try block");
                        }
                        if (emLocal == null) break block18;
                    }
                }
            }
            finally {
                if (em == null) return;
                if (!em.isOpen()) return;
                throw new Exception("autoCloseableTest failed: EntityManager isOpen() returned true outside try block");
            }
        }
        catch (Exception f) {
            throw f;
        }
        catch (Throwable t) {
            throw new Exception("autoCloseableTest failed with Exception", t);
        }
    }

    @Test
    public void mergeTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            Order o1 = (Order)this.getEntityManager().merge((Object)new Order(9, 999, "desc999"));
            this.getEntityTransaction().commit();
            this.clearCache();
            Order o2 = (Order)this.getEntityManager().find(Order.class, (Object)9);
            if (o1.equals(o2)) {
                logger.log(System.Logger.Level.TRACE, "Received expected results");
                pass = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results - expected:" + o1.toString() + ", actual:" + o2.toString());
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("mergeTest failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void mergeExceptionsTest() throws Exception {
        boolean pass = false;
        logger.log(System.Logger.Level.INFO, "Testing merge(Object");
        logger.log(System.Logger.Level.INFO, "Testing invalid object ");
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().merge((Object)this);
            this.getEntityTransaction().commit();
            logger.log(System.Logger.Level.ERROR, "IllegalStateException not thrown");
        }
        catch (IllegalArgumentException e) {
            logger.log(System.Logger.Level.TRACE, "IllegalStateException Caught as Expected.");
            pass = true;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        logger.log(System.Logger.Level.INFO, "Testing removed entity ");
        try {
            this.getEntityTransaction().begin();
            Order o = (Order)this.getEntityManager().find(Order.class, (Object)1);
            this.getEntityManager().remove((Object)o);
            this.getEntityTransaction().commit();
            this.getEntityTransaction().begin();
            this.getEntityManager().merge((Object)o);
            this.getEntityTransaction().commit();
            logger.log(System.Logger.Level.ERROR, "IllegalStateException not thrown");
        }
        catch (IllegalArgumentException e) {
            logger.log(System.Logger.Level.TRACE, "IllegalStateException Caught as Expected.");
            pass = true;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("mergeExceptionsTest failed");
        }
    }

    @Test
    public void removeExceptionsTest() throws Exception {
        boolean pass = false;
        logger.log(System.Logger.Level.INFO, "Testing findClassObjectIllegalStateException");
        logger.log(System.Logger.Level.INFO, "Invalid Object test");
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().remove((Object)this);
            this.getEntityTransaction().commit();
            logger.log(System.Logger.Level.ERROR, "IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException e) {
            logger.log(System.Logger.Level.TRACE, "IllegalArgumentException Caught as Expected.");
            pass = true;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("removeExceptionsTest failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void lockIllegalStateExceptionTest() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        HashMap<String, String> myMap = new HashMap<String, String>();
        myMap.put("some.cts.specific.property", "nothing.in.particular");
        logger.log(System.Logger.Level.INFO, "Testing invalid object for lock(Object, LockModeType)");
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().lock((Object)this, LockModeType.WRITE);
            this.getEntityTransaction().commit();
            logger.log(System.Logger.Level.ERROR, "IllegalStateException not thrown");
        }
        catch (IllegalArgumentException e) {
            logger.log(System.Logger.Level.TRACE, "IllegalStateException Caught as Expected.");
            pass1 = true;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        logger.log(System.Logger.Level.INFO, "Testing invalid object for lock(Object, LockModeType, Map)");
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().lock((Object)this, LockModeType.WRITE, myMap);
            this.getEntityTransaction().commit();
            logger.log(System.Logger.Level.ERROR, "IllegalStateException not thrown");
        }
        catch (IllegalArgumentException e) {
            logger.log(System.Logger.Level.TRACE, "IllegalStateException Caught as Expected.");
            pass2 = true;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass1 || !pass2) {
            throw new Exception("lockIllegalStateExceptionTest failed");
        }
    }

    @Test
    public void refreshInvalidObjectIllegalArgumentExceptionTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().refresh((Object)this);
            this.getEntityTransaction().commit();
            logger.log(System.Logger.Level.ERROR, "IllegalStateException not thrown");
        }
        catch (IllegalArgumentException e) {
            logger.log(System.Logger.Level.TRACE, "IllegalStateException Caught as Expected.");
            pass = true;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("refreshInvalidObjectIllegalArgumentExceptionTest failed");
        }
    }

    @Test
    public void refreshNonManagedObjectIllegalArgumentExceptionTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().refresh((Object)new Order(99, 999));
            this.getEntityTransaction().commit();
            logger.log(System.Logger.Level.ERROR, "IllegalStateException not thrown");
        }
        catch (IllegalArgumentException e) {
            logger.log(System.Logger.Level.TRACE, "IllegalStateException Caught as Expected.");
            pass = true;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("refreshNonManagedObjectIllegalArgumentExceptionTest failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void refreshInvalidObjectMapIllegalArgumentExceptionTest() throws Exception {
        boolean pass = false;
        HashMap<String, String> myMap = new HashMap<String, String>();
        myMap.put("some.cts.specific.property", "nothing.in.particular");
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().refresh((Object)this, myMap);
            this.getEntityTransaction().commit();
            logger.log(System.Logger.Level.ERROR, "IllegalStateException not thrown");
        }
        catch (IllegalArgumentException e) {
            logger.log(System.Logger.Level.TRACE, "IllegalStateException Caught as Expected.");
            pass = true;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("refreshInvalidObjectMapIllegalArgumentExceptionTest failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void refreshNonManagedObjectMapIllegalArgumentExceptionTest() throws Exception {
        boolean pass = false;
        HashMap<String, String> myMap = new HashMap<String, String>();
        myMap.put("some.cts.specific.property", "nothing.in.particular");
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().refresh((Object)new Order(99, 999), myMap);
            this.getEntityTransaction().commit();
            logger.log(System.Logger.Level.ERROR, "IllegalStateException not thrown");
        }
        catch (IllegalArgumentException e) {
            logger.log(System.Logger.Level.TRACE, "IllegalStateException Caught as Expected.");
            pass = true;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("refreshNonManagedObjectMapIllegalArgumentExceptionTest failed");
        }
    }

    @Test
    public void refreshInvalidObjectLockModeTypeIllegalArgumentExceptionTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().refresh((Object)this, LockModeType.WRITE);
            this.getEntityTransaction().commit();
            logger.log(System.Logger.Level.ERROR, "IllegalStateException not thrown");
        }
        catch (IllegalArgumentException e) {
            logger.log(System.Logger.Level.TRACE, "IllegalStateException Caught as Expected.");
            pass = true;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("refreshInvalidObjectLockModeTypeIllegalArgumentExceptionTest failed");
        }
    }

    @Test
    public void refreshNonManagedObjectLockModeTypeIllegalArgumentExceptionTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().refresh((Object)new Order(99, 999), LockModeType.WRITE);
            this.getEntityTransaction().commit();
            logger.log(System.Logger.Level.ERROR, "IllegalStateException not thrown");
        }
        catch (IllegalArgumentException e) {
            logger.log(System.Logger.Level.TRACE, "IllegalStateException Caught as Expected.");
            pass = true;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("refreshNonManagedObjectLockModeTypeIllegalArgumentExceptionTest failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void refreshInvalidObjectLockModeTypeMapIllegalArgumentExceptionTest() throws Exception {
        boolean pass = false;
        HashMap<String, String> myMap = new HashMap<String, String>();
        myMap.put("some.cts.specific.property", "nothing.in.particular");
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().refresh((Object)this, LockModeType.WRITE, myMap);
            this.getEntityTransaction().commit();
            logger.log(System.Logger.Level.ERROR, "IllegalStateException not thrown");
        }
        catch (IllegalArgumentException e) {
            logger.log(System.Logger.Level.TRACE, "IllegalStateException Caught as Expected.");
            pass = true;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("refreshInvalidObjectLockModeTypeMapIllegalArgumentExceptionTest failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void refreshNonManagedObjectLockModeTypeMapIllegalArgumentExceptionTest() throws Exception {
        boolean pass = false;
        HashMap<String, String> myMap = new HashMap<String, String>();
        myMap.put("some.cts.specific.property", "nothing.in.particular");
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().refresh((Object)new Order(99, 999), LockModeType.WRITE, myMap);
            this.getEntityTransaction().commit();
            logger.log(System.Logger.Level.ERROR, "IllegalStateException not thrown");
        }
        catch (IllegalArgumentException e) {
            logger.log(System.Logger.Level.TRACE, "IllegalStateException Caught as Expected.");
            pass = true;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("refreshNonManagedObjectLockModeTypeMapIllegalArgumentExceptionTest failed");
        }
    }

    @Test
    public void containsIllegalArgumentException() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().contains((Object)"notanentity");
            logger.log(System.Logger.Level.ERROR, "IllegalArgumentException not thrown");
            this.getEntityTransaction().commit();
        }
        catch (IllegalArgumentException e) {
            logger.log(System.Logger.Level.TRACE, "IllegalArgumentException Caught as Expected.");
            pass = true;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("containsIllegalArgumentException failed");
        }
    }

    @Test
    public void createNamedQueryIllegalArgumentExceptionTest() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        logger.log(System.Logger.Level.INFO, "Testing TypedQuery version");
        try {
            this.getEntityManager().createNamedQuery("CTS NamedQuery");
            logger.log(System.Logger.Level.ERROR, "IllegalArgumentException was not thrown");
        }
        catch (IllegalArgumentException e) {
            logger.log(System.Logger.Level.TRACE, "IllegalArgumentException Caught as Expected.");
            pass1 = true;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        logger.log(System.Logger.Level.INFO, "Testing TypedQuery version");
        try {
            this.getEntityManager().createNamedQuery("CTS NamedQuery", Order.class);
            logger.log(System.Logger.Level.ERROR, "IllegalArgumentException was not thrown");
        }
        catch (IllegalArgumentException e) {
            logger.log(System.Logger.Level.TRACE, "IllegalArgumentException Caught as Expected.");
            pass2 = true;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        logger.log(System.Logger.Level.INFO, "Testing TypedQuery with incorrect result type version");
        try {
            this.getEntityManager().createNamedQuery("SELECT o from ORDER o", String.class);
            logger.log(System.Logger.Level.ERROR, "IllegalArgumentException was not thrown");
        }
        catch (IllegalArgumentException e) {
            logger.log(System.Logger.Level.TRACE, "IllegalArgumentException Caught as Expected.");
            pass2 = true;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        if (!pass1 || !pass2) {
            throw new Exception("createNamedQueryIllegalArgumentExceptionTest failed");
        }
    }

    @Test
    public void createQueryIllegalArgumentExceptionTest() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        boolean pass3 = false;
        logger.log(System.Logger.Level.TRACE, "Testing String version");
        try {
            Query q = this.getEntityManager().createQuery("CTS Query");
            logger.log(System.Logger.Level.INFO, "IllegalArgumentException was not thrown");
            try {
                q.getResultList();
                logger.log(System.Logger.Level.ERROR, "Neither IllegalArgumentException nor PersistenceException was thrown");
            }
            catch (PersistenceException e) {
                logger.log(System.Logger.Level.TRACE, "PersistenceException Caught during execution.");
                pass1 = true;
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred during execution", (Throwable)e);
            }
        }
        catch (IllegalArgumentException e) {
            logger.log(System.Logger.Level.TRACE, "IllegalArgumentException Caught as Expected.");
            pass1 = true;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        logger.log(System.Logger.Level.INFO, "Testing String, Class version");
        try {
            this.getEntityManager().createQuery("SELECT o from ORDER o", String.class);
            logger.log(System.Logger.Level.ERROR, "IllegalArgumentException was not thrown");
        }
        catch (IllegalArgumentException e) {
            logger.log(System.Logger.Level.TRACE, "IllegalArgumentException Caught as Expected.");
            pass2 = true;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        logger.log(System.Logger.Level.INFO, "Testing CriteriaQuery version");
        try {
            CriteriaBuilder qbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
            CriteriaQuery cquery = qbuilder.createQuery(null);
            TypedQuery q = this.getEntityManager().createQuery(cquery);
            logger.log(System.Logger.Level.INFO, "IllegalArgumentException was not thrown");
            try {
                q.getResultList();
                logger.log(System.Logger.Level.ERROR, "Neither IllegalArgumentException nor PersistenceException was thrown");
            }
            catch (PersistenceException e) {
                logger.log(System.Logger.Level.TRACE, "PersistenceException Caught during execution.");
                pass3 = true;
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred during execution", (Throwable)e);
            }
        }
        catch (IllegalArgumentException e) {
            logger.log(System.Logger.Level.TRACE, "IllegalArgumentException Caught as Expected.");
            pass3 = true;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        if (!(pass1 && pass2 && pass3)) {
            throw new Exception("createQueryIllegalArgumentExceptionTest failed");
        }
    }

    @Test
    public void detachIllegalArgumentExceptionTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().detach(Client1.class);
            logger.log(System.Logger.Level.ERROR, "IllegalArgumentException was not thrown");
        }
        catch (IllegalArgumentException e) {
            logger.log(System.Logger.Level.TRACE, "IllegalArgumentException Caught as Expected.");
            pass = true;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception", (Throwable)re);
            }
        }
        if (!pass) {
            throw new Exception("detachIllegalArgumentExceptionTest failed");
        }
    }

    @Test
    public void getEntityManagerFactoryTest() throws Exception {
        boolean pass = false;
        try {
            EntityManager em = this.getEntityManager();
            EntityManagerFactory emf = em.getEntityManagerFactory();
            if (emf == null) {
                logger.log(System.Logger.Level.ERROR, "getEntityManagerFactory() returned a null result");
            } else {
                pass = true;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("getEntityManagerFactoryTest failed");
        }
    }

    @Test
    public void emGetMetamodelTest() throws Exception {
        boolean pass = false;
        try {
            EntityManager em = this.getEntityManager();
            Metamodel mm = em.getMetamodel();
            if (mm == null) {
                logger.log(System.Logger.Level.ERROR, "getMetamodel() returned a null result");
            } else {
                pass = true;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("emGetMetamodelTest failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void setPropertyTest() throws Exception {
        boolean foundKey = false;
        boolean foundValue = false;
        try {
            EntityTransaction t = this.getEntityTransaction();
            t.begin();
            EntityManager em = this.getEntityManager();
            String expectedKey = "jakarta.persistence.cache.retrieveMode";
            CacheRetrieveMode expectedValue = CacheRetrieveMode.USE;
            logger.log(System.Logger.Level.TRACE, "Setting property:" + expectedKey + "," + expectedValue.toString());
            em.setProperty(expectedKey, (Object)expectedValue);
            logger.log(System.Logger.Level.TRACE, "Retrieve all EntityManger properties:");
            Map em_entry = em.getProperties();
            for (Map.Entry entry : em_entry.entrySet()) {
                String key = (String)entry.getKey();
                logger.log(System.Logger.Level.INFO, "Key = " + key);
                if (!key.contains(expectedKey)) continue;
                foundKey = true;
                Object oValue = entry.getValue();
                if (oValue instanceof CacheRetrieveMode) {
                    CacheRetrieveMode value = (CacheRetrieveMode)oValue;
                    if (value.equals((Object)expectedValue)) {
                        logger.log(System.Logger.Level.INFO, "Received expected value:" + value.toString());
                        foundValue = true;
                        continue;
                    }
                    logger.log(System.Logger.Level.ERROR, "Key:" + expectedKey + " -  expected value:" + expectedKey + ", actual value" + value);
                    continue;
                }
                logger.log(System.Logger.Level.ERROR, "The value for Key:" + expectedKey + "was not an instance of String:" + oValue);
            }
            if (!foundKey) {
                logger.log(System.Logger.Level.ERROR, "Property key:" + expectedKey + ", not found in EntityManager");
            }
            if (!foundValue) {
                logger.log(System.Logger.Level.ERROR, "The value for Key:" + expectedKey + ", was not found in EntityManager");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!foundKey || !foundValue) {
            throw new Exception("setPropertyTest failed");
        }
    }

    @Test
    public void getCriteriaBuilderTest() throws Exception {
        boolean pass = false;
        try {
            CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
            if (cbuilder != null) {
                this.getEntityTransaction().begin();
                CriteriaQuery cquery = cbuilder.createQuery();
                if (cquery != null) {
                    logger.log(System.Logger.Level.TRACE, "Obtained Non-null Criteria Query");
                    pass = true;
                } else {
                    logger.log(System.Logger.Level.ERROR, "Failed to get Non-null Criteria Query");
                }
                this.getEntityTransaction().commit();
            } else {
                logger.log(System.Logger.Level.ERROR, "getCriteriaBuilder() returned null");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("getCriteriaBuilderTest failed");
        }
    }

    @Test
    public void isJoinedToTransactionTest() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        logger.log(System.Logger.Level.INFO, "Test when no transaction active");
        if (!this.getEntityManager().isJoinedToTransaction()) {
            logger.log(System.Logger.Level.TRACE, "Received expected result:false");
            pass1 = true;
        } else {
            logger.log(System.Logger.Level.ERROR, "Returned true when not in a transaction");
        }
        logger.log(System.Logger.Level.INFO, "Test when transaction active");
        this.getEntityTransaction().begin();
        if (this.getEntityManager().isJoinedToTransaction()) {
            logger.log(System.Logger.Level.TRACE, "Received expected result:true");
            pass2 = true;
        } else {
            logger.log(System.Logger.Level.ERROR, "Returned false when in a transaction");
        }
        this.getEntityTransaction().commit();
        if (!pass1 || !pass2) {
            throw new Exception("isJoinedToTransactionTest failed");
        }
    }

    @Test
    public void createStoredProcedureQueryStringIllegalArgumentExceptionTest() throws Exception {
        boolean pass = false;
        StringBuilder msg = new StringBuilder();
        try {
            StoredProcedureQuery spq = this.getEntityManager().createStoredProcedureQuery("DOESNOTEXIST");
            msg.append("Did not throw IllegalArgumentException");
            try {
                spq.execute();
                msg.append("or a PersistenceException from execute()");
            }
            catch (PersistenceException pe) {
                logger.log(System.Logger.Level.TRACE, "Received PersistenceException");
                pass = true;
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Received unexpected exception after execute()", (Throwable)e);
            }
        }
        catch (IllegalArgumentException iae) {
            logger.log(System.Logger.Level.TRACE, "Received expected IllegalArgumentException");
            pass = true;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Received unexpected exception", (Throwable)e);
        }
        if (!pass) {
            logger.log(System.Logger.Level.ERROR, msg.toString());
            throw new Exception("createStoredProcedureQueryStringIllegalArgumentExceptionTest failed");
        }
    }

    @Test
    public void createStoredProcedureQueryStringClassArrayIllegalArgumentExceptionTest() throws Exception {
        boolean pass = false;
        Class[] cArray = new Class[]{Integer.class};
        StringBuilder msg = new StringBuilder();
        try {
            StoredProcedureQuery spq = this.getEntityManager().createStoredProcedureQuery("DOESNOTEXIST", cArray);
            msg.append("Did not throw IllegalArgumentException");
            try {
                spq.execute();
                msg.append("or a PersistenceException after execute()");
            }
            catch (PersistenceException pe) {
                logger.log(System.Logger.Level.TRACE, "Received PersistenceException");
                pass = true;
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Received unexpected exception from execute()", (Throwable)e);
            }
        }
        catch (IllegalArgumentException iae) {
            logger.log(System.Logger.Level.TRACE, "Received expected IllegalArgumentException");
            pass = true;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Received unexpected exception", (Throwable)e);
        }
        if (!pass) {
            logger.log(System.Logger.Level.ERROR, msg.toString());
            throw new Exception("createStoredProcedureQueryStringClassArrayIllegalArgumentExceptionTest failed");
        }
    }

    @Test
    public void createStoredProcedureQueryStringStringArrayIllegalArgumentExceptionTest() throws Exception {
        boolean pass = false;
        StringBuilder msg = new StringBuilder();
        try {
            String[] sArray = new String[]{"doesnotexist"};
            StoredProcedureQuery spq = this.getEntityManager().createStoredProcedureQuery("DOESNOTEXIST", sArray);
            msg.append("Did not throw IllegalArgumentException");
            try {
                spq.execute();
                msg.append("or a PersistenceException from execute()");
            }
            catch (PersistenceException pe) {
                logger.log(System.Logger.Level.TRACE, "Received PersistenceException");
                pass = true;
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Received unexpected exception after execute()", (Throwable)e);
            }
        }
        catch (IllegalArgumentException iae) {
            logger.log(System.Logger.Level.TRACE, "Received expected IllegalArgumentException");
            pass = true;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Received unexpected exception", (Throwable)e);
        }
        if (!pass) {
            logger.log(System.Logger.Level.ERROR, msg.toString());
            throw new Exception("createStoredProcedureQueryStringStringArrayIllegalArgumentExceptionTest failed");
        }
    }

    @Test
    public void createNamedStoredProcedureQueryStringIllegalArgumentExceptionTest() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        try {
            this.getEntityManager().createNamedStoredProcedureQuery("DOESNOTEXIST");
            logger.log(System.Logger.Level.ERROR, "Did not throw IllegalArgumentException");
        }
        catch (IllegalArgumentException iae) {
            logger.log(System.Logger.Level.TRACE, "Received expected IllegalArgumentException");
            pass = true;
        }
        this.getEntityTransaction().rollback();
        if (!pass) {
            throw new Exception("createNamedStoredProcedureQueryStringIllegalArgumentExceptionTest failed");
        }
    }
}

