/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.criteriaapi.Root;

import com.sun.ts.lib.harness.SetupMethod;
import ee.jakarta.tck.persistence.common.schema30.Department;
import ee.jakarta.tck.persistence.common.schema30.Department_;
import ee.jakarta.tck.persistence.common.schema30.UtilDepartmentEmployeeData;
import jakarta.persistence.TypedQuery;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.JoinType;
import jakarta.persistence.criteria.MapJoin;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import java.util.List;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.Test;

public class Client4
extends UtilDepartmentEmployeeData {
    private static final System.Logger logger = System.getLogger(Client4.class.getName());

    public JavaArchive createDeployment() throws Exception {
        String pkgNameWithoutSuffix = Client4.class.getPackageName();
        String pkgName = pkgNameWithoutSuffix + ".";
        String[] classes = this.getSchema30classes();
        return this.createDeploymentJar("jpa_core_criteriaapi_root4.jar", pkgNameWithoutSuffix, classes);
    }

    @SetupMethod(name="setupDepartmentEmployeeData")
    @Test
    public void joinMapAttributeTest() throws Exception {
        boolean pass = false;
        try {
            CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Department.class);
            Root department = cquery.from(Department.class);
            MapJoin employee = department.join(Department_.lastNameEmployees);
            cquery.where((Expression)cbuilder.equal((Expression)employee.get("id"), (Object)"1")).select((Selection)department);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List clist = tquery.getResultList();
            String[] expectedPKs = new String[]{"1"};
            if (!this.checkEntityPK(clist, expectedPKs)) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results.  Expected 1 reference, got: " + clist.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("joinMapAttributeTest failed");
        }
    }

    @SetupMethod(name="setupDepartmentEmployeeData")
    @Test
    public void joinMapAttributeJoinTypeTest() throws Exception {
        boolean pass = false;
        try {
            CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Department.class);
            Root department = cquery.from(Department.class);
            MapJoin employee = department.join(Department_.lastNameEmployees, JoinType.INNER);
            cquery.where((Expression)cbuilder.equal((Expression)employee.get("id"), (Object)"1")).select((Selection)department);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List clist = tquery.getResultList();
            String[] expectedPKs = new String[]{"1"};
            if (!this.checkEntityPK(clist, expectedPKs)) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results.  Expected 1 reference, got: " + clist.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("joinMapAttributeJoinTypeTest failed");
        }
    }

    @SetupMethod(name="setupDepartmentEmployeeData")
    @Test
    public void joinMapStringTest() throws Exception {
        boolean pass = false;
        try {
            CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Department.class);
            Root department = cquery.from(Department.class);
            MapJoin employee = department.joinMap("lastNameEmployees");
            cquery.where((Expression)cbuilder.equal((Expression)employee.get("id"), (Object)"1")).select((Selection)department);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List clist = tquery.getResultList();
            String[] expectedPKs = new String[]{"1"};
            if (!this.checkEntityPK(clist, expectedPKs)) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results.  Expected 1 reference, got: " + clist.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("joinMapStringTest failed");
        }
    }

    @SetupMethod(name="setupDepartmentEmployeeData")
    @Test
    public void joinMapStringJoinTypeTest() throws Exception {
        boolean pass = false;
        try {
            CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Department.class);
            Root department = cquery.from(Department.class);
            MapJoin employee = department.joinMap("lastNameEmployees", JoinType.INNER);
            cquery.where((Expression)cbuilder.equal((Expression)employee.get("id"), (Object)"1")).select((Selection)department);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List clist = tquery.getResultList();
            String[] expectedPKs = new String[]{"1"};
            if (!this.checkEntityPK(clist, expectedPKs)) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results.  Expected 1 reference, got: " + clist.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("joinMapStringJoinTypeTest failed");
        }
    }
}

