/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.criteriaapi.CriteriaDelete;

import ee.jakarta.tck.persistence.common.schema30.Product;
import ee.jakarta.tck.persistence.common.schema30.SoftwareProduct;
import ee.jakarta.tck.persistence.common.schema30.UtilProductData;
import jakarta.persistence.Query;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaDelete;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Path;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Subquery;
import jakarta.persistence.metamodel.EntityType;
import jakarta.persistence.metamodel.Metamodel;
import java.util.ArrayList;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.Test;

public class Client
extends UtilProductData {
    private static final System.Logger logger = System.getLogger(Client.class.getName());

    public JavaArchive createDeployment() throws Exception {
        String pkgNameWithoutSuffix = Client.class.getPackageName();
        String[] classes = this.getSchema30classes();
        return this.createDeploymentJar("jpa_core_criteriaapi_CriteriaDelete.jar", pkgNameWithoutSuffix, classes);
    }

    @Test
    public void fromClassTest() throws Exception {
        boolean pass1 = false;
        boolean pass2 = true;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaDelete cd = cbuilder.createCriteriaDelete(Product.class);
        Root root = cd.from(Product.class);
        if (root != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null root");
            int actual = this.getEntityManager().createQuery(cd).executeUpdate();
            if (actual == this.productRef.length + this.softwareRef.length + this.hardwareRef.length) {
                logger.log(System.Logger.Level.TRACE, "Received expected number deleted:" + actual);
                this.clearCache();
                logger.log(System.Logger.Level.INFO, "Make sure items were deleted by looking up the Products id");
                for (Product p : this.productRef) {
                    pass1 = true;
                    if (this.getEntityManager().find(Product.class, (Object)p.getId()) == null) continue;
                    logger.log(System.Logger.Level.ERROR, "Expected product:" + p.getId() + " to have been deleted");
                    pass2 = false;
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "Expected:" + this.productRef.length + ", actual:" + actual);
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "Failed to get Non-null root");
        }
        this.getEntityTransaction().commit();
        if (!pass1 || !pass2) {
            throw new Exception("fromClassTest failed");
        }
    }

    @Test
    public void fromEntityTypeTest() throws Exception {
        boolean pass1 = false;
        boolean pass2 = true;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaDelete cd = cbuilder.createCriteriaDelete(Product.class);
        Metamodel mm = this.getEntityManager().getMetamodel();
        EntityType Product_ = mm.entity(Product.class);
        Root root = cd.from(Product_);
        if (root != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null root");
            int actual = this.getEntityManager().createQuery(cd).executeUpdate();
            if (actual == this.productRef.length + this.softwareRef.length + this.hardwareRef.length) {
                logger.log(System.Logger.Level.TRACE, "Received expected number deleted:" + actual);
                this.clearCache();
                logger.log(System.Logger.Level.INFO, "Make sure items were deleted by looking up the Products id");
                for (Product p : this.productRef) {
                    pass1 = true;
                    if (this.getEntityManager().find(Product.class, (Object)p.getId()) == null) continue;
                    logger.log(System.Logger.Level.ERROR, "Expected product:" + p.getId() + " to have been deleted");
                    pass2 = false;
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "Expected:" + this.productRef.length + ", actual:" + actual);
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "Failed to get Non-null root");
        }
        this.getEntityTransaction().commit();
        if (!pass1 || !pass2) {
            throw new Exception("fromEntityTypeTest failed");
        }
    }

    @Test
    public void getRootTest() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        CriteriaDelete cd = cbuilder.createCriteriaDelete(Product.class);
        Root root = cd.from(Product.class);
        if (root != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null root");
            if (root.getModel().getName().equals(cd.getRoot().getModel().getName())) {
                logger.log(System.Logger.Level.TRACE, "Obtained expected root");
                pass = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Failed to get expected root");
                logger.log(System.Logger.Level.ERROR, "Expected:" + cd.getRoot() + ", actual:" + root);
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "Failed to get Non-null root");
        }
        if (!pass) {
            throw new Exception("getRootTest failed");
        }
    }

    @Test
    public void whereExpressionTest() throws Exception {
        boolean pass2 = false;
        boolean pass3 = true;
        boolean pass4 = true;
        boolean pass5 = true;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaDelete cd = cbuilder.createCriteriaDelete(Product.class);
        Root root = cd.from(Product.class);
        if (root != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null root");
            Path exp = root.get("id");
            ArrayList<String> col = new ArrayList<String>();
            col.add("1");
            col.add("2");
            col.add("3");
            cd.where((Expression)exp.in(col));
            int actual = this.getEntityManager().createQuery(cd).executeUpdate();
            if (actual == col.size()) {
                Product pp;
                logger.log(System.Logger.Level.TRACE, "Received expected number deleted:" + actual);
                this.clearCache();
                pass2 = true;
                for (Product product : this.productRef) {
                    pp = (Product)this.getEntityManager().find(Product.class, (Object)product.getId());
                    if (product.getId().equals("1") || product.getId().equals("2") || product.getId().equals("3")) {
                        if (pp != null) {
                            logger.log(System.Logger.Level.ERROR, "Expected product:" + product.getId() + " to have been deleted");
                            pass3 = false;
                            continue;
                        }
                        logger.log(System.Logger.Level.TRACE, "Product:" + product.getId() + " was successfully deleted");
                        continue;
                    }
                    if (pp == null) {
                        logger.log(System.Logger.Level.ERROR, "Product:" + product.getId() + " was incorrectly deleted");
                        pass3 = false;
                        continue;
                    }
                    logger.log(System.Logger.Level.TRACE, "Found Product:" + pp.getId());
                }
                for (Product product : this.softwareRef) {
                    pp = (Product)this.getEntityManager().find(Product.class, (Object)product.getId());
                    if (pp == null) {
                        logger.log(System.Logger.Level.ERROR, "Software Product:" + product.getId() + " was incorrectly deleted");
                        pass4 = false;
                        continue;
                    }
                    logger.log(System.Logger.Level.TRACE, "Found Software Product:" + pp.getId());
                }
                for (Product product : this.hardwareRef) {
                    pp = (Product)this.getEntityManager().find(Product.class, (Object)product.getId());
                    if (pp == null) {
                        logger.log(System.Logger.Level.ERROR, "Harware Product:" + product.getId() + " was incorrectly deleted");
                        pass5 = false;
                        continue;
                    }
                    logger.log(System.Logger.Level.TRACE, "Found Harware Product:" + pp.getId());
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "Expected:" + col.size() + ", actual:" + actual);
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "Failed to get Non-null root");
        }
        this.getEntityTransaction().commit();
        if (!(pass2 && pass3 && pass4 && pass5)) {
            throw new Exception("whereExpressionTest failed");
        }
    }

    @Test
    public void wherePredicateArrayTest() throws Exception {
        boolean pass1 = false;
        boolean pass2 = true;
        boolean pass3 = true;
        boolean pass4 = true;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaDelete cd = cbuilder.createCriteriaDelete(Product.class);
        Root root = cd.from(Product.class);
        if (root != null) {
            Product pp;
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null root");
            Predicate[] predArray = new Predicate[]{cbuilder.equal((Expression)root.get("id"), (Object)"2")};
            cd.where(predArray);
            int actual = this.getEntityManager().createQuery(cd).executeUpdate();
            if (actual == predArray.length) {
                logger.log(System.Logger.Level.TRACE, "Received expected number deleted:" + actual);
                pass1 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Expected deleted:" + predArray.length + ", actual:" + actual);
            }
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
            this.clearCache();
            this.getEntityTransaction().begin();
            for (Product product : this.productRef) {
                pp = (Product)this.getEntityManager().find(Product.class, (Object)product.getId());
                if (product.getId().equals("2")) {
                    if (pp != null) {
                        logger.log(System.Logger.Level.ERROR, "Expected product:" + product.getId() + " to have been deleted");
                        pass2 = false;
                        continue;
                    }
                    logger.log(System.Logger.Level.TRACE, "Product:" + product.getId() + " was successfully deleted");
                    continue;
                }
                if (pp == null) {
                    logger.log(System.Logger.Level.ERROR, "Product:" + product.getId() + " was incorrectly deleted");
                    pass2 = false;
                    continue;
                }
                logger.log(System.Logger.Level.TRACE, "Found Product:" + pp.getId());
            }
            for (Product product : this.softwareRef) {
                pp = (Product)this.getEntityManager().find(Product.class, (Object)product.getId());
                if (pp != null) continue;
                logger.log(System.Logger.Level.ERROR, "Software product:" + product.getId() + " should not have been deleted");
                pass3 = false;
            }
            for (Product product : this.hardwareRef) {
                pp = (Product)this.getEntityManager().find(Product.class, (Object)product.getId());
                if (pp != null) continue;
                logger.log(System.Logger.Level.ERROR, "Hardware product:" + product.getId() + " should not have been deleted");
                pass4 = false;
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "Failed to get Non-null root");
        }
        this.getEntityTransaction().commit();
        if (!(pass1 && pass2 && pass3 && pass4)) {
            throw new Exception("wherePredicateArrayTest failed");
        }
    }

    @Test
    public void subquery() throws Exception {
        boolean pass1 = false;
        boolean pass2 = true;
        ArrayList<Integer> expected = new ArrayList<Integer>();
        expected.add(19);
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaDelete cd = cbuilder.createCriteriaDelete(Product.class);
        if (cd != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Criteria Query");
            Root product = cd.from(Product.class);
            EntityType Product_ = product.getModel();
            Subquery sq = cd.subquery(Product.class);
            Root hardProd = sq.from(Product.class);
            sq.where((Expression)cbuilder.equal((Expression)product.get(Product_.getSingularAttribute("id", String.class)), (Object)"1")).select((Expression)hardProd);
            cd.where((Expression)cbuilder.exists(sq));
            int actual = this.getEntityManager().createQuery(cd).executeUpdate();
            if (actual == 1) {
                logger.log(System.Logger.Level.TRACE, "Received expected number deleted:" + actual);
                this.clearCache();
                for (Product p : this.productRef) {
                    pass1 = true;
                    Product pp = (Product)this.getEntityManager().find(Product.class, (Object)p.getId());
                    if (p.getId().equals("1")) {
                        if (pp != null) {
                            logger.log(System.Logger.Level.ERROR, "Expected product:" + p.getId() + " to have been deleted:" + p.toString());
                            pass2 = false;
                            continue;
                        }
                        logger.log(System.Logger.Level.TRACE, "Product:" + p.getId() + " was successfully deleted");
                        continue;
                    }
                    if (pp == null) {
                        logger.log(System.Logger.Level.ERROR, "Product:" + p.getId() + " was incorrectly deleted");
                        pass2 = false;
                        continue;
                    }
                    logger.log(System.Logger.Level.TRACE, "Found product:" + pp.getId());
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "Expected:1, actual:" + actual);
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass1 || !pass2) {
            throw new Exception("exists test failed");
        }
    }

    @Test
    public void modifiedQueryTest() throws Exception {
        int passDeletedCount1 = 0;
        int passUnDeletedCount1 = 0;
        int passDeletedCount2 = 0;
        int passUnDeletedCount2 = 0;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        logger.log(System.Logger.Level.INFO, "Testing initial query");
        CriteriaDelete cd = cbuilder.createCriteriaDelete(SoftwareProduct.class);
        Root softwareproduct = cd.from(SoftwareProduct.class);
        if (softwareproduct != null) {
            Product pp;
            EntityType softwareproduct_ = softwareproduct.getModel();
            cd.where((Expression)cbuilder.lt((Expression)softwareproduct.get(softwareproduct_.getSingularAttribute("quantity", Integer.class)), (Number)35));
            Query q = this.getEntityManager().createQuery(cd);
            logger.log(System.Logger.Level.INFO, "Modify CriteriaDelete object");
            cd.where((Expression)cbuilder.lt((Expression)softwareproduct.get(softwareproduct_.getSingularAttribute("quantity", Integer.class)), (Number)500));
            int actual = q.executeUpdate();
            if (actual == 4) {
                logger.log(System.Logger.Level.TRACE, "Received expected number of deletes:" + actual);
                this.clearCache();
                for (SoftwareProduct p : this.softwareRef) {
                    pp = (Product)this.getEntityManager().find(SoftwareProduct.class, (Object)p.getId());
                    if (p.getId().equals("30") || p.getId().equals("31") || p.getId().equals("36") || p.getId().equals("37")) {
                        if (pp != null) {
                            logger.log(System.Logger.Level.ERROR, "Expected product:" + p.getId() + " to have been deleted");
                            continue;
                        }
                        logger.log(System.Logger.Level.TRACE, "id:" + p.getId() + " was successfully deleted");
                        ++passDeletedCount1;
                        continue;
                    }
                    if (pp == null) {
                        logger.log(System.Logger.Level.ERROR, "id:" + p.getId() + " was incorrectly deleted");
                        continue;
                    }
                    logger.log(System.Logger.Level.TRACE, "Found product:" + pp.getId());
                    ++passUnDeletedCount1;
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "Expected: 4 deletes [30,31,36,37], actual:" + actual);
                for (SoftwareProduct p : this.softwareRef) {
                    pp = (Product)this.getEntityManager().find(Product.class, (Object)p.getId());
                    if (pp != null) {
                        logger.log(System.Logger.Level.ERROR, "id:" + p.getId() + ", quantity:" + pp.getQuantity() + " exists");
                        continue;
                    }
                    logger.log(System.Logger.Level.ERROR, "id:" + p.getId() + " was deleted");
                }
            }
            logger.log(System.Logger.Level.INFO, "Testing modified CriteriaQuery");
            cd.where((Expression)cbuilder.gt((Expression)softwareproduct.get(softwareproduct_.getSingularAttribute("quantity", Integer.class)), (Number)100));
            actual = this.getEntityManager().createQuery(cd).executeUpdate();
            if (actual == 3) {
                logger.log(System.Logger.Level.TRACE, "Received expected number of deletes:" + actual);
                this.clearCache();
                for (SoftwareProduct p : this.softwareRef) {
                    pp = (Product)this.getEntityManager().find(SoftwareProduct.class, (Object)p.getId());
                    if (p.getId().equals("29") || p.getId().equals("34") || p.getId().equals("38") || p.getId().equals("30") || p.getId().equals("31") || p.getId().equals("36") || p.getId().equals("37")) {
                        if (pp != null) {
                            logger.log(System.Logger.Level.ERROR, "Expected product:" + p.getId() + " to have been deleted");
                            continue;
                        }
                        logger.log(System.Logger.Level.TRACE, "id:" + p.getId() + " was successfully deleted");
                        ++passDeletedCount2;
                        continue;
                    }
                    if (pp == null) {
                        logger.log(System.Logger.Level.ERROR, "id:" + p.getId() + " was incorrectly deleted");
                        continue;
                    }
                    logger.log(System.Logger.Level.TRACE, "Found id:" + pp.getId());
                    ++passUnDeletedCount2;
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "Expected: 3 additional deletes [29,34,38] total deletes [29,30,31,34,36,37,38], actual:" + actual);
                for (SoftwareProduct p : this.softwareRef) {
                    pp = (Product)this.getEntityManager().find(Product.class, (Object)p.getId());
                    logger.log(System.Logger.Level.ERROR, "id:" + p.getId() + ", quantity:" + pp.getQuantity());
                }
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "Failed to get Non-null root");
        }
        this.getEntityTransaction().commit();
        if (passDeletedCount1 != 4 || passUnDeletedCount1 != 6 || passDeletedCount2 != 7 || passUnDeletedCount2 != 3) {
            throw new Exception("modifiedQueryTest failed");
        }
    }

    public void removeTestData() {
        logger.log(System.Logger.Level.TRACE, "removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM PRODUCT_DETAILS").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM PRODUCT_TABLE").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

