/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.annotations.mapkeytemporal;

import com.sun.ts.lib.util.TestUtil;
import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.annotations.mapkeytemporal.Department;
import ee.jakarta.tck.persistence.core.annotations.mapkeytemporal.Department2;
import ee.jakarta.tck.persistence.core.annotations.mapkeytemporal.Department4;
import ee.jakarta.tck.persistence.core.annotations.mapkeytemporal.EmbeddedEmployee;
import ee.jakarta.tck.persistence.core.annotations.mapkeytemporal.Employee;
import ee.jakarta.tck.persistence.core.annotations.mapkeytemporal.Employee2;
import ee.jakarta.tck.persistence.core.annotations.mapkeytemporal.Employee4;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class Client
extends PMClientBase {
    private static final System.Logger logger = System.getLogger(Client.class.getName());
    private static final long serialVersionUID = 20L;
    final Date d1 = this.getUtilDate("2000-02-14");
    final Date d2 = this.getUtilDate("2001-06-27");
    final Date d3 = this.getUtilDate("2002-07-07");
    final Date d4 = this.getUtilDate("2003-03-03");
    final Date d5 = this.getSQLDate();
    final Date d6 = this.getUtilDate("2000-10-14");
    final Date d7 = this.getUtilDate("2001-11-27");
    private static Employee[] empRef = new Employee[5];
    private static Employee2[] empRef2 = new Employee2[5];
    private static Employee4[] empRef3 = new Employee4[5];

    public JavaArchive createDeployment() throws Exception {
        String pkgNameWithoutSuffix = Client.class.getPackageName();
        String pkgName = pkgNameWithoutSuffix + ".";
        String[] classes = new String[]{pkgName + "Department", pkgName + "Department2", pkgName + "Department4", pkgName + "EmbeddedEmployee", pkgName + "Employee", pkgName + "Employee2", pkgName + "Employee4"};
        return this.createDeploymentJar("jpa_core_annotations_mapkeytemporal.jar", pkgNameWithoutSuffix, classes);
    }

    @BeforeEach
    public void setup() throws Exception {
        logger.log(System.Logger.Level.TRACE, "setup");
        try {
            super.setup();
            this.createDeployment();
            this.removeTestData();
            this.createTestData();
            logger.log(System.Logger.Level.TRACE, "Done creating test data");
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception: ", (Throwable)e);
            throw new Exception("Setup failed:", e);
        }
    }

    @Test
    public void mapKeyTemporalTest() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        HashSet<Date> expected = new HashSet<Date>();
        expected.add(this.d1);
        expected.add(this.d2);
        expected.add(this.d3);
        try {
            this.getEntityTransaction().begin();
            Employee emp = (Employee)this.getEntityManager().find(Employee.class, (Object)1);
            logger.log(System.Logger.Level.TRACE, "Name:" + emp.getLastName());
            Department dept = emp.getDepartment();
            logger.log(System.Logger.Level.TRACE, "Dept=" + dept.getName());
            Map<Date, Employee> emps = dept.getLastNameEmployees();
            if (TestUtil.traceflag) {
                for (Map.Entry<Date, Employee> entry : emps.entrySet()) {
                    logger.log(System.Logger.Level.TRACE, "map:" + entry.getKey() + ", " + entry.getValue().getId() + " " + entry.getValue().getLastName());
                }
            }
            Set<Date> keys = emps.keySet();
            for (Date key : keys) {
                logger.log(System.Logger.Level.TRACE, "key:" + key);
            }
            if (expected.containsAll(keys) && keys.containsAll(expected) && expected.size() == keys.size()) {
                logger.log(System.Logger.Level.TRACE, "Received expected keys");
                pass1 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Did not received expected keys");
                logger.log(System.Logger.Level.ERROR, "Expected:");
                for (Date key : expected) {
                    logger.log(System.Logger.Level.TRACE, "key:" + key);
                }
                logger.log(System.Logger.Level.ERROR, "Actual:");
                for (Date key : keys) {
                    logger.log(System.Logger.Level.TRACE, "key:" + key);
                }
            }
            HashSet<Employee> hashSet = new HashSet<Employee>();
            hashSet.add(empRef[0]);
            hashSet.add(empRef[1]);
            hashSet.add(empRef[2]);
            Collection<Employee> employees = emps.values();
            for (Employee e : employees) {
                logger.log(System.Logger.Level.TRACE, "values:" + e.getId() + " " + e.getLastName());
            }
            if (hashSet.containsAll(employees) && employees.containsAll(hashSet) && hashSet.size() == employees.size()) {
                logger.log(System.Logger.Level.TRACE, "Received expected values");
                pass2 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Did not received expected values");
                logger.log(System.Logger.Level.ERROR, "Expected:");
                for (Employee e : hashSet) {
                    logger.log(System.Logger.Level.TRACE, "Employee:" + e.getId() + " " + e.getLastName());
                }
                logger.log(System.Logger.Level.ERROR, "Actual:");
                for (Employee e : employees) {
                    logger.log(System.Logger.Level.TRACE, "Employee:" + e.getId() + " " + e.getLastName());
                }
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception ex) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)ex);
        }
        if (!pass1 || !pass2) {
            throw new Exception("mapKeyTemporalTest failed");
        }
    }

    @Test
    public void mapKeyEnumeratedWithMayKeyClassAnnotationTest() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        HashSet<Date> expected = new HashSet<Date>();
        expected.add(this.d4);
        expected.add(this.d5);
        try {
            this.getEntityTransaction().begin();
            Employee2 emp = (Employee2)this.getEntityManager().find(Employee2.class, (Object)2);
            logger.log(System.Logger.Level.TRACE, "Name:" + emp.getLastName());
            Department2 dept = emp.getDepartment();
            logger.log(System.Logger.Level.TRACE, "Dept=" + dept.getName());
            Map emps = dept.getLastNameEmployees();
            if (TestUtil.traceflag) {
                for (Map.Entry entry : emps.entrySet()) {
                    logger.log(System.Logger.Level.TRACE, "map:" + entry.getKey() + ", " + ((Employee2)entry.getValue()).getId() + " " + ((Employee2)entry.getValue()).getLastName());
                }
            }
            Set keys = emps.keySet();
            for (Date key : keys) {
                logger.log(System.Logger.Level.TRACE, "key:" + key);
            }
            if (expected.containsAll(keys) && keys.containsAll(expected) && expected.size() == keys.size()) {
                logger.log(System.Logger.Level.TRACE, "Received expected keys");
                pass1 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Did not received expected keys");
                logger.log(System.Logger.Level.ERROR, "Expected:");
                for (Date key : expected) {
                    logger.log(System.Logger.Level.TRACE, "key:" + key);
                }
                logger.log(System.Logger.Level.ERROR, "Actual:");
                for (Date key : keys) {
                    logger.log(System.Logger.Level.TRACE, "key:" + key);
                }
            }
            HashSet<Employee2> hashSet = new HashSet<Employee2>();
            hashSet.add(empRef2[0]);
            hashSet.add(empRef2[1]);
            Collection employees = emps.values();
            for (Employee2 e : employees) {
                logger.log(System.Logger.Level.TRACE, "values:" + e.getId() + " " + e.getLastName());
            }
            if (hashSet.containsAll(employees) && employees.containsAll(hashSet) && hashSet.size() == employees.size()) {
                logger.log(System.Logger.Level.TRACE, "Received expected values");
                pass2 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Did not received expected values");
                logger.log(System.Logger.Level.ERROR, "Expected:");
                for (Employee2 e : hashSet) {
                    logger.log(System.Logger.Level.TRACE, "Employee:" + e.getId() + " " + e.getLastName());
                }
                logger.log(System.Logger.Level.ERROR, "Actual:");
                for (Employee2 e : employees) {
                    logger.log(System.Logger.Level.TRACE, "Employee:" + e.getId() + " " + e.getLastName());
                }
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception ex) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)ex);
        }
        if (!pass1 || !pass2) {
            throw new Exception("mapKeyEnumeratedWithMayKeyClassAnnotationTest failed");
        }
    }

    @Test
    public void elementCollectionTest() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        HashSet<Date> expected = new HashSet<Date>();
        expected.add(this.d6);
        expected.add(this.d7);
        try {
            this.getEntityTransaction().begin();
            Employee4 emp = (Employee4)this.getEntityManager().find(Employee4.class, (Object)6);
            logger.log(System.Logger.Level.TRACE, "Name:" + emp.getLastName());
            Department4 dept = emp.getDepartment();
            logger.log(System.Logger.Level.TRACE, "Dept=" + dept.getName());
            Map<Date, EmbeddedEmployee> emps = dept.getLastNameEmployees();
            if (TestUtil.traceflag) {
                for (Map.Entry<Date, EmbeddedEmployee> entry : emps.entrySet()) {
                    logger.log(System.Logger.Level.TRACE, "set:" + entry.getKey() + ", " + entry.getValue().employeeId + " " + entry.getValue().employeeName);
                }
            }
            Set<Date> keys = emps.keySet();
            for (Date key : keys) {
                logger.log(System.Logger.Level.TRACE, "key:" + key);
            }
            if (expected.containsAll(keys) && keys.containsAll(expected) && expected.size() == keys.size()) {
                logger.log(System.Logger.Level.TRACE, "Received expected keys");
                pass1 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Did not received expected keys");
                logger.log(System.Logger.Level.ERROR, "Expected:");
                for (Date key : expected) {
                    logger.log(System.Logger.Level.TRACE, "key:" + key);
                }
                logger.log(System.Logger.Level.ERROR, "Actual:");
                for (Date key : keys) {
                    logger.log(System.Logger.Level.TRACE, "key:" + key);
                }
            }
            HashSet<Employee4> hashSet = new HashSet<Employee4>();
            hashSet.add(empRef3[0]);
            hashSet.add(empRef3[1]);
            Collection employees = emps.values().stream().flatMap(a -> Stream.of(new Employee4(a.employeeId, a.employeeName))).collect(Collectors.toList());
            for (Employee4 e : employees) {
                logger.log(System.Logger.Level.TRACE, "values:" + e.getId() + " " + e.getLastName());
            }
            if (hashSet.containsAll(employees) && employees.containsAll(hashSet) && hashSet.size() == employees.size()) {
                logger.log(System.Logger.Level.TRACE, "Received expected values");
                pass2 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Did not received expected values");
                logger.log(System.Logger.Level.ERROR, "Expected:");
                for (Employee4 e : hashSet) {
                    logger.log(System.Logger.Level.TRACE, "Employee:" + e.getId() + " " + e.getLastName());
                }
                logger.log(System.Logger.Level.ERROR, "Actual:");
                for (Employee4 e : employees) {
                    logger.log(System.Logger.Level.TRACE, "Employee:" + e.getId() + " " + e.getLastName());
                }
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception ex) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)ex);
        }
        if (!pass1 || !pass2) {
            throw new Exception("elementCollectionTest failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createTestData() throws Exception {
        logger.log(System.Logger.Level.TRACE, "createTestData");
        try {
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.TRACE, "Create 2 - Departments");
            Department[] deptRef = new Department[]{new Department(1, "Marketing"), new Department(2, "Administration")};
            logger.log(System.Logger.Level.TRACE, "Persist departments ");
            for (Department dept : deptRef) {
                if (dept == null) continue;
                this.getEntityManager().persist((Object)dept);
                logger.log(System.Logger.Level.TRACE, "persisted department " + dept.getName());
            }
            logger.log(System.Logger.Level.TRACE, "Create 2 - Department2");
            Department2[] deptRef2 = new Department2[]{new Department2(3, "Development"), new Department2(4, "Release")};
            logger.log(System.Logger.Level.TRACE, "Persist Department2 ");
            for (Department2 dept : deptRef2) {
                if (dept == null) continue;
                this.getEntityManager().persist((Object)dept);
                logger.log(System.Logger.Level.TRACE, "persisted department2 " + dept.getName());
            }
            logger.log(System.Logger.Level.TRACE, "Create 2 - Department3");
            Department4[] deptRef3 = new Department4[]{new Department4(5, "Shipping"), new Department4(6, "Receiving")};
            logger.log(System.Logger.Level.TRACE, "Persist Department2s ");
            for (Department4 dept : deptRef3) {
                if (dept == null) continue;
                this.getEntityManager().persist((Object)dept);
                logger.log(System.Logger.Level.TRACE, "persisted department3 " + dept.getName());
            }
            logger.log(System.Logger.Level.TRACE, "Create 5 - Employee");
            Client.empRef[0] = new Employee(1, "Frechette");
            empRef[0].setDepartment(deptRef[0]);
            Client.empRef[1] = new Employee(3, "McGowan");
            empRef[1].setDepartment(deptRef[0]);
            Client.empRef[2] = new Employee(5, "DMilla");
            empRef[2].setDepartment(deptRef[0]);
            Client.empRef2[0] = new Employee2(2, "Smith");
            empRef2[0].setDepartment(deptRef2[0]);
            Client.empRef2[1] = new Employee2(4, "Bissett");
            empRef2[1].setDepartment(deptRef2[0]);
            Client.empRef3[0] = new Employee4(6, "Donahue");
            empRef3[0].setDepartment(deptRef3[0]);
            Client.empRef3[1] = new Employee4(7, "Sanborn");
            empRef3[1].setDepartment(deptRef3[0]);
            HashMap<Date, Employee> link = new HashMap<Date, Employee>();
            link.put(this.d1, empRef[0]);
            link.put(this.d2, empRef[1]);
            link.put(this.d3, empRef[2]);
            deptRef[0].setLastNameEmployees(link);
            HashMap<Date, Employee2> link2 = new HashMap<Date, Employee2>();
            link2.put(this.d4, empRef2[0]);
            link2.put(this.d5, empRef2[1]);
            deptRef2[0].setLastNameEmployees(link2);
            HashMap<Date, EmbeddedEmployee> link3 = new HashMap<Date, EmbeddedEmployee>();
            link3.put(this.d6, new EmbeddedEmployee(empRef3[0]));
            link3.put(this.d7, new EmbeddedEmployee(empRef3[1]));
            deptRef3[0].setLastNameEmployees(link3);
            logger.log(System.Logger.Level.TRACE, "Persist Employee ");
            for (Employee employee : empRef) {
                if (employee == null) continue;
                this.getEntityManager().persist((Object)employee);
                logger.log(System.Logger.Level.TRACE, "persisted Employee " + employee.getId());
            }
            logger.log(System.Logger.Level.TRACE, "Persist Employee2 ");
            for (Serializable serializable : empRef2) {
                if (serializable == null) continue;
                this.getEntityManager().persist((Object)serializable);
                logger.log(System.Logger.Level.TRACE, "persisted Employee2 " + ((Employee2)serializable).getId());
            }
            logger.log(System.Logger.Level.TRACE, "Persist Employee3 ");
            for (Serializable serializable : empRef3) {
                if (serializable == null) continue;
                this.getEntityManager().persist((Object)serializable);
                logger.log(System.Logger.Level.TRACE, "persisted Employee3 " + ((Employee4)serializable).getId());
            }
            logger.log(System.Logger.Level.TRACE, "Merge Department ");
            for (Serializable serializable : deptRef) {
                if (serializable == null) continue;
                this.getEntityManager().merge((Object)serializable);
                logger.log(System.Logger.Level.TRACE, "merged Department " + ((Department)serializable).getName());
            }
            logger.log(System.Logger.Level.TRACE, "Merge Department2 ");
            for (Serializable serializable : deptRef2) {
                if (serializable == null) continue;
                this.getEntityManager().merge((Object)serializable);
                logger.log(System.Logger.Level.TRACE, "merged Department2 " + ((Department2)serializable).getName());
            }
            logger.log(System.Logger.Level.TRACE, "Merge Department3 ");
            for (Serializable serializable : deptRef3) {
                if (serializable == null) continue;
                this.getEntityManager().merge((Object)serializable);
                logger.log(System.Logger.Level.TRACE, "merged Department3 " + ((Department4)serializable).getName());
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected Exception creating test data:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in rollback:", (Throwable)re);
            }
        }
    }

    @AfterEach
    public void cleanupCust() throws Exception {
        try {
            logger.log(System.Logger.Level.TRACE, "cleanup");
            this.removeCustTestData();
            logger.log(System.Logger.Level.TRACE, "cleanup complete, calling super.cleanup");
            super.cleanup();
        }
        finally {
            this.removeTestJarFromCP();
        }
    }

    private void removeTestData() {
        logger.log(System.Logger.Level.TRACE, "removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("Delete from EMP_MAPKEYCOL2").executeUpdate();
            this.getEntityManager().createNativeQuery("Delete from DEPARTMENT2").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }

    private void removeCustTestData() {
        logger.log(System.Logger.Level.TRACE, "removeCustTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM CUST_TABLE").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM DATES_TABLE").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

