/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.annotations.id;

import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.annotations.id.FieldBigDecimalId;
import ee.jakarta.tck.persistence.core.annotations.id.FieldBigIntegerId;
import ee.jakarta.tck.persistence.core.annotations.id.FieldIntId;
import ee.jakarta.tck.persistence.core.annotations.id.FieldIntegerId;
import ee.jakarta.tck.persistence.core.annotations.id.FieldSQLDateId;
import ee.jakarta.tck.persistence.core.annotations.id.FieldStringId;
import ee.jakarta.tck.persistence.core.annotations.id.FieldUtilDateId;
import ee.jakarta.tck.persistence.core.annotations.id.PropertyBigDecimalId;
import ee.jakarta.tck.persistence.core.annotations.id.PropertyBigIntegerId;
import ee.jakarta.tck.persistence.core.annotations.id.PropertyIntId;
import ee.jakarta.tck.persistence.core.annotations.id.PropertyIntegerId;
import ee.jakarta.tck.persistence.core.annotations.id.PropertySQLDateId;
import ee.jakarta.tck.persistence.core.annotations.id.PropertyStringId;
import ee.jakarta.tck.persistence.core.annotations.id.PropertyUtilDateId;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class Client
extends PMClientBase {
    private static final System.Logger logger = System.getLogger(Client.class.getName());

    public JavaArchive createDeployment() throws Exception {
        String pkgNameWithoutSuffix = Client.class.getPackageName();
        String pkgName = pkgNameWithoutSuffix + ".";
        String[] classes = new String[]{pkgName + "FieldBigDecimalId", pkgName + "FieldBigIntegerId", pkgName + "FieldIntId", pkgName + "FieldIntegerId", pkgName + "FieldSQLDateId", pkgName + "FieldStringId", pkgName + "FieldUtilDateId", pkgName + "PropertyBigDecimalId", pkgName + "PropertyBigIntegerId", pkgName + "PropertyIntId", pkgName + "PropertyIntegerId", pkgName + "PropertySQLDateId", pkgName + "PropertyStringId", pkgName + "PropertyUtilDateId"};
        return this.createDeploymentJar("jpa_core_annotations_id.jar", pkgNameWithoutSuffix, classes);
    }

    @BeforeEach
    public void setup() throws Exception {
        logger.log(System.Logger.Level.TRACE, "setup");
        try {
            super.setup();
            this.createDeployment();
            this.removeTestData();
        }
        catch (Exception e) {
            throw new Exception("Setup failed:", e);
        }
    }

    @Test
    public void FieldIntegerIdTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            Integer id = new Integer(1);
            FieldIntegerId expected = new FieldIntegerId(id, id);
            logger.log(System.Logger.Level.TRACE, "Persisting IntegerId");
            this.getEntityManager().persist((Object)expected);
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
            this.clearCache();
            this.getEntityTransaction().begin();
            FieldIntegerId actual = (FieldIntegerId)this.getEntityManager().find(FieldIntegerId.class, (Object)id);
            if (actual != null) {
                if (actual.getIntegerData().equals(id)) {
                    logger.log(System.Logger.Level.TRACE, "Received expected result:" + actual.getIntegerData());
                    pass = true;
                } else {
                    logger.log(System.Logger.Level.ERROR, "Expected Integer:" + id + ", actual: " + actual.getIntegerData());
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "EntityManager.find returned null result");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new Exception("FieldIntegerIdTest failed");
        }
    }

    @Test
    public void FieldIntIdTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            int id = 1;
            FieldIntId expected = new FieldIntId(id, id);
            logger.log(System.Logger.Level.TRACE, "Persisting IntId");
            this.getEntityManager().persist((Object)expected);
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
            this.clearCache();
            this.getEntityTransaction().begin();
            FieldIntId actual = (FieldIntId)this.getEntityManager().find(FieldIntId.class, (Object)id);
            if (actual != null) {
                if (actual.getIntData() == id) {
                    logger.log(System.Logger.Level.TRACE, "Received expected result:" + actual.getIntData());
                    pass = true;
                } else {
                    logger.log(System.Logger.Level.ERROR, "Expected int:" + id + ", actual: " + actual.getIntData());
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "EntityManager.find returned null result");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new Exception("FieldIntIdTest failed");
        }
    }

    @Test
    public void FieldBigIntegerIdTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            BigInteger id = new BigInteger("1");
            FieldBigIntegerId expected = new FieldBigIntegerId(id, id);
            logger.log(System.Logger.Level.TRACE, "Persisting BigIntegerId");
            this.getEntityManager().persist((Object)expected);
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
            this.clearCache();
            this.getEntityTransaction().begin();
            FieldBigIntegerId actual = (FieldBigIntegerId)this.getEntityManager().find(FieldBigIntegerId.class, (Object)id);
            if (actual != null) {
                if (actual.getBigInteger().equals(id)) {
                    logger.log(System.Logger.Level.TRACE, "Received expected result:" + actual.getBigInteger());
                    pass = true;
                } else {
                    logger.log(System.Logger.Level.ERROR, "Expected name:" + id + ", actual: " + actual.getBigInteger());
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "EntityManager.find returned null result");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new Exception("FieldBigIntegerIdTest failed");
        }
    }

    @Test
    public void FieldBigDecimalIdTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            BigDecimal id = new BigDecimal(new BigInteger("1"));
            FieldBigDecimalId expected = new FieldBigDecimalId(id, id);
            logger.log(System.Logger.Level.TRACE, "Persisting BigDecimalId");
            this.getEntityManager().persist((Object)expected);
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
            this.clearCache();
            this.getEntityTransaction().begin();
            FieldBigDecimalId actual = (FieldBigDecimalId)this.getEntityManager().find(FieldBigDecimalId.class, (Object)id);
            if (actual != null) {
                if (actual.getBigDecimal().equals(id)) {
                    logger.log(System.Logger.Level.TRACE, "Received expected result:" + actual.getBigDecimal());
                    pass = true;
                } else {
                    logger.log(System.Logger.Level.ERROR, "Expected value:" + id + ", actual: " + actual.getBigDecimal());
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "EntityManager.find returned null result");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new Exception("FieldBigDecimalIdTest failed");
        }
    }

    @Test
    public void FieldStringIdTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            String id = "1";
            FieldStringId expected = new FieldStringId("1", "1");
            logger.log(System.Logger.Level.TRACE, "Persisting StringId");
            this.getEntityManager().persist((Object)expected);
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
            this.clearCache();
            this.getEntityTransaction().begin();
            FieldStringId actual = (FieldStringId)this.getEntityManager().find(FieldStringId.class, (Object)"1");
            if (actual != null) {
                if (actual.getName().equals("1")) {
                    logger.log(System.Logger.Level.TRACE, "Received expected result:" + actual.getName());
                    pass = true;
                } else {
                    logger.log(System.Logger.Level.ERROR, "Expected name:1, actual: " + actual.getName());
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "EntityManager.find returned null result");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new Exception("FieldStringIdTest failed");
        }
    }

    @Test
    public void FieldSQLDateIdTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            Date id = this.getSQLDate(2006, 4, 15);
            FieldSQLDateId expected = new FieldSQLDateId(id, id);
            logger.log(System.Logger.Level.TRACE, "Persisting StringId");
            this.getEntityManager().persist((Object)expected);
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
            this.clearCache();
            this.getEntityTransaction().begin();
            FieldSQLDateId actual = (FieldSQLDateId)this.getEntityManager().find(FieldSQLDateId.class, (Object)id);
            if (actual != null) {
                if (actual.getDate().equals(id)) {
                    logger.log(System.Logger.Level.TRACE, "Received expected result:" + actual.getDate());
                    pass = true;
                } else {
                    logger.log(System.Logger.Level.ERROR, "Expected name:" + id + ", actual: " + actual.getDate());
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "EntityManager.find returned null result");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new Exception("FieldSQLDateIdTest failed");
        }
    }

    @Test
    public void FieldUtilDateIdTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            java.util.Date id = this.getPKDate(2006, 4, 15);
            FieldUtilDateId expected = new FieldUtilDateId(id, id);
            logger.log(System.Logger.Level.TRACE, "Persisting StringId");
            this.getEntityManager().persist((Object)expected);
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
            this.clearCache();
            this.getEntityTransaction().begin();
            FieldUtilDateId actual = (FieldUtilDateId)this.getEntityManager().find(FieldUtilDateId.class, (Object)id);
            if (actual != null) {
                if (actual.getDate().equals(id)) {
                    logger.log(System.Logger.Level.TRACE, "Received expected result:" + actual.getDate());
                    pass = true;
                } else {
                    logger.log(System.Logger.Level.ERROR, "Expected name:" + id + ", actual: " + actual.getDate());
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "EntityManager.find returned null result");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new Exception("FieldUtilDateIdTest failed");
        }
    }

    @Test
    public void PropertyIntegerIdTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            Integer id = new Integer(1);
            PropertyIntegerId expected = new PropertyIntegerId(id, id);
            logger.log(System.Logger.Level.TRACE, "Persisting IntegerId");
            this.getEntityManager().persist((Object)expected);
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
            this.clearCache();
            this.getEntityTransaction().begin();
            PropertyIntegerId actual = (PropertyIntegerId)this.getEntityManager().find(PropertyIntegerId.class, (Object)id);
            if (actual != null) {
                if (actual.getIntegerData().equals(id)) {
                    logger.log(System.Logger.Level.TRACE, "Received expected result:" + actual.getIntegerData());
                    pass = true;
                } else {
                    logger.log(System.Logger.Level.ERROR, "Expected Integer:" + id + ", actual: " + actual.getIntegerData());
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "EntityManager.find returned null result");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new Exception("PropertyIntegerIdTest failed");
        }
    }

    @Test
    public void PropertyIntIdTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            int id = 1;
            PropertyIntId expected = new PropertyIntId(id, id);
            logger.log(System.Logger.Level.TRACE, "Persisting IntId");
            this.getEntityManager().persist((Object)expected);
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
            this.clearCache();
            this.getEntityTransaction().begin();
            PropertyIntId actual = (PropertyIntId)this.getEntityManager().find(PropertyIntId.class, (Object)id);
            if (actual != null) {
                if (actual.getIntData() == id) {
                    logger.log(System.Logger.Level.TRACE, "Received expected result:" + actual.getIntData());
                    pass = true;
                } else {
                    logger.log(System.Logger.Level.ERROR, "Expected int:" + id + ", actual: " + actual.getIntData());
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "EntityManager.find returned null result");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new Exception("PropertyIntIdTest failed");
        }
    }

    @Test
    public void PropertyBigIntegerIdTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            BigInteger id = new BigInteger("1");
            PropertyBigIntegerId expected = new PropertyBigIntegerId(id, id);
            logger.log(System.Logger.Level.TRACE, "Persisting BigIntegerId");
            this.getEntityManager().persist((Object)expected);
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
            this.clearCache();
            this.getEntityTransaction().begin();
            PropertyBigIntegerId actual = (PropertyBigIntegerId)this.getEntityManager().find(PropertyBigIntegerId.class, (Object)id);
            if (actual != null) {
                if (actual.getBigInteger().equals(id)) {
                    logger.log(System.Logger.Level.TRACE, "Received expected result:" + actual.getBigInteger());
                    pass = true;
                } else {
                    logger.log(System.Logger.Level.ERROR, "Expected name:" + id + ", actual: " + actual.getBigInteger());
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "EntityManager.find returned null result");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new Exception("PropertyBigIntegerIdTest failed");
        }
    }

    @Test
    public void PropertyBigDecimalIdTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            BigDecimal id = new BigDecimal(new BigInteger("1"));
            PropertyBigDecimalId expected = new PropertyBigDecimalId(id, id);
            logger.log(System.Logger.Level.TRACE, "Persisting BigDecimalId");
            this.getEntityManager().persist((Object)expected);
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
            this.clearCache();
            this.getEntityTransaction().begin();
            PropertyBigDecimalId actual = (PropertyBigDecimalId)this.getEntityManager().find(PropertyBigDecimalId.class, (Object)id);
            if (actual != null) {
                if (actual.getBigDecimal().equals(id)) {
                    logger.log(System.Logger.Level.TRACE, "Received expected result:" + actual.getBigDecimal());
                    pass = true;
                } else {
                    logger.log(System.Logger.Level.ERROR, "Expected value:" + id + ", actual: " + actual.getBigDecimal());
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "EntityManager.find returned null result");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new Exception("PropertyBigDecimalIdTest failed");
        }
    }

    @Test
    public void PropertyStringIdTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            String id = "1";
            PropertyStringId expected = new PropertyStringId("1", "1");
            logger.log(System.Logger.Level.TRACE, "Persisting StringId");
            this.getEntityManager().persist((Object)expected);
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
            this.clearCache();
            this.getEntityTransaction().begin();
            PropertyStringId actual = (PropertyStringId)this.getEntityManager().find(PropertyStringId.class, (Object)"1");
            if (actual != null) {
                if (actual.getName().equals("1")) {
                    logger.log(System.Logger.Level.TRACE, "Received expected result:" + actual.getName());
                    pass = true;
                } else {
                    logger.log(System.Logger.Level.ERROR, "Expected name:1, actual: " + actual.getName());
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "EntityManager.find returned null result");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new Exception("PropertyStringIdTest failed");
        }
    }

    @Test
    public void PropertySQLDateIdTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            Date id = this.getSQLDate(2006, 4, 15);
            PropertySQLDateId expected = new PropertySQLDateId(id, id);
            logger.log(System.Logger.Level.TRACE, "Persisting StringId");
            this.getEntityManager().persist((Object)expected);
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
            this.clearCache();
            this.getEntityTransaction().begin();
            PropertySQLDateId actual = (PropertySQLDateId)this.getEntityManager().find(PropertySQLDateId.class, (Object)id);
            if (actual != null) {
                if (actual.getDate().equals(id)) {
                    logger.log(System.Logger.Level.TRACE, "Received expected result:" + actual.getDate());
                    pass = true;
                } else {
                    logger.log(System.Logger.Level.ERROR, "Expected name:" + id + ", actual: " + actual.getDate());
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "EntityManager.find returned null result");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new Exception("PropertySQLDateIdTest failed");
        }
    }

    @Test
    public void PropertyUtilDateIdTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            java.util.Date id = this.getPKDate(2006, 4, 15);
            PropertyUtilDateId expected = new PropertyUtilDateId(id, id);
            logger.log(System.Logger.Level.TRACE, "Persisting StringId");
            this.getEntityManager().persist((Object)expected);
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
            this.clearCache();
            this.getEntityTransaction().begin();
            PropertyUtilDateId actual = (PropertyUtilDateId)this.getEntityManager().find(PropertyUtilDateId.class, (Object)id);
            if (actual != null) {
                if (actual.getDate().equals(id)) {
                    logger.log(System.Logger.Level.TRACE, "Received expected result:" + actual.getDate());
                    pass = true;
                } else {
                    logger.log(System.Logger.Level.ERROR, "Expected name:" + id + ", actual: " + actual.getDate());
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "EntityManager.find returned null result");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new Exception("PropertyUtilDateIdTest failed");
        }
    }

    @AfterEach
    public void cleanup() throws Exception {
        try {
            logger.log(System.Logger.Level.TRACE, "cleanup");
            this.removeTestData();
            logger.log(System.Logger.Level.TRACE, "cleanup complete, calling super.cleanup");
            super.cleanup();
        }
        finally {
            this.removeTestJarFromCP();
        }
    }

    private void removeTestData() {
        logger.log(System.Logger.Level.TRACE, "removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM A_BASIC").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM DATATYPES").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM DATATYPES2").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM DATATYPES3").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

