/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.el.spec.literal;

import com.sun.ts.tests.el.common.util.ExprEval;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;

public class ELClientIT {
    private static final System.Logger logger = System.getLogger(ELClientIT.class.getName());

    @AfterEach
    public void cleanup() throws Exception {
        logger.log(System.Logger.Level.INFO, "Cleanup method called");
    }

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        logger.log(System.Logger.Level.INFO, "STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        logger.log(System.Logger.Level.INFO, "FINISHED TEST : " + testInfo.getDisplayName());
    }

    @Test
    public void elBooleanLiteralTest() throws Exception {
        boolean pass2;
        Object result;
        boolean pass1;
        Boolean expectedResult = Boolean.TRUE;
        try {
            pass1 = false;
            expectedResult = Boolean.TRUE;
            result = ExprEval.evaluateValueExpression("${true}", null, Object.class);
            logger.log(System.Logger.Level.TRACE, "result is " + result.toString());
            pass1 = ExprEval.compareClass(result, Boolean.class) && ExprEval.compareValue(result, (Object)expectedResult);
        }
        catch (Exception e) {
            throw new Exception(e);
        }
        try {
            pass2 = false;
            expectedResult = Boolean.FALSE;
            result = ExprEval.evaluateValueExpression("${false}", null, Object.class);
            logger.log(System.Logger.Level.TRACE, "result is " + result.toString());
            pass2 = ExprEval.compareClass(result, Boolean.class) && ExprEval.compareValue(result, (Object)expectedResult);
        }
        catch (Exception e) {
            throw new Exception(e);
        }
        if (!pass1) {
            throw new Exception("TEST FAILED: Literal true evaluated incorrectly.");
        }
        if (!pass2) {
            throw new Exception("TEST FAILED: Literal false evaluated incorrectly.");
        }
    }

    @Test
    public void elIntegerLiteralTest() throws Exception {
        List ilist = this.getIntegerList();
        for (Integer tInteger : ilist) {
            boolean pass2;
            Object result;
            boolean pass1;
            Long expectedResult = (long)tInteger;
            try {
                pass1 = false;
                result = ExprEval.evaluateValueExpression("${" + tInteger.toString() + "}", null, Object.class);
                logger.log(System.Logger.Level.TRACE, "result is " + result.toString());
                pass1 = ExprEval.compareClass(result, Long.class) && ExprEval.compareValue((Long)result, expectedResult);
            }
            catch (Exception e) {
                throw new Exception(e);
            }
            try {
                pass2 = false;
                result = ExprEval.evaluateValueExpression("#{" + tInteger.toString() + "}", null, Object.class);
                logger.log(System.Logger.Level.TRACE, "result is " + result.toString());
                pass2 = ExprEval.compareClass(result, Long.class) && ExprEval.compareValue((Long)result, expectedResult);
            }
            catch (Exception e) {
                throw new Exception(e);
            }
            if (!pass1) {
                throw new Exception("TEST FAILED: Literal Integer \"$\" evaluated incorrectly.");
            }
            if (pass2) continue;
            throw new Exception("TEST FAILED: Literal Integer \"#\" evaluated incorrectly.");
        }
    }

    @Test
    public void elFloatingPointLiteralTest() throws Exception {
        List flist = this.getFloatList();
        for (Float tFloat : flist) {
            boolean pass2;
            Object result;
            boolean pass1;
            Float expectedResult = Float.valueOf(tFloat.floatValue());
            try {
                pass1 = false;
                result = ExprEval.evaluateValueExpression("${" + tFloat.toString() + "}", null, Object.class);
                logger.log(System.Logger.Level.TRACE, "result is " + result.toString());
                pass1 = ExprEval.compareClass(result, Double.class) && ExprEval.compareValue((Double)result, expectedResult, 1);
            }
            catch (Exception e) {
                throw new Exception(e);
            }
            try {
                pass2 = false;
                result = ExprEval.evaluateValueExpression("#{" + tFloat.toString() + "}", null, Object.class);
                logger.log(System.Logger.Level.TRACE, "result is " + result.toString());
                pass2 = ExprEval.compareClass(result, Double.class) && ExprEval.compareValue((Double)result, expectedResult, 1);
            }
            catch (Exception e) {
                throw new Exception(e);
            }
            if (!pass1) {
                throw new Exception("TEST FAILED: Literal Float \"$\" evaluated incorrectly.");
            }
            if (pass2) continue;
            throw new Exception("TEST FAILED: Literal Float \"#\" evaluated incorrectly.");
        }
    }

    @Test
    public void elStringLiteralTest() throws Exception {
        Hashtable sMap = this.getStringTable();
        Enumeration keys = sMap.keys();
        while (keys.hasMoreElements()) {
            boolean pass2;
            Object result;
            boolean pass1;
            String expectedResult = keys.nextElement().toString();
            String testString = sMap.get(expectedResult).toString();
            try {
                pass1 = false;
                result = ExprEval.evaluateValueExpression("${" + testString + "}", null, Object.class);
                logger.log(System.Logger.Level.TRACE, "result is " + result.toString());
                pass1 = ExprEval.compareClass(result, String.class) && ExprEval.compareValue((String)result, expectedResult);
            }
            catch (Exception e) {
                throw new Exception(e);
            }
            try {
                pass2 = false;
                result = ExprEval.evaluateValueExpression("#{" + testString + "}", null, Object.class);
                logger.log(System.Logger.Level.TRACE, "result is " + result.toString());
                pass2 = ExprEval.compareClass(result, String.class) && ExprEval.compareValue((String)result, expectedResult);
            }
            catch (Exception e) {
                throw new Exception(e);
            }
            if (!pass1) {
                throw new Exception("TEST FAILED: Literal String \"$\" evaluated incorrectly.");
            }
            if (pass2) continue;
            throw new Exception("TEST FAILED: Literal String \"#\" evaluated incorrectly.");
        }
    }

    @Test
    public void elNullLiteralTest() throws Exception {
        boolean pass2;
        boolean pass1;
        Object result;
        try {
            result = ExprEval.evaluateValueExpression("${null}", null, Object.class);
            pass1 = result == null;
        }
        catch (Exception e) {
            throw new Exception(e);
        }
        try {
            result = ExprEval.evaluateValueExpression("#{null}", null, Object.class);
            pass2 = result == null;
        }
        catch (Exception e) {
            throw new Exception(e);
        }
        if (!pass1) {
            throw new Exception("TEST FAILED: Literal 'null' \"$\" evaluated incorrectly.");
        }
        if (!pass2) {
            throw new Exception("TEST FAILED: Literal 'null \"#\" evaluated incorrectly.");
        }
    }

    @Test
    public void elSyntaxAsLiteralTest() throws Exception {
        boolean pass = false;
        Hashtable<String, String> testValues = new Hashtable<String, String>();
        testValues.put("${foo}", "#{'${'}foo}");
        testValues.put("${foo}", "${'${'}foo}");
        testValues.put("#{foo}", "${'#{'}foo}");
        testValues.put("#{foo}", "#{'#{'}foo}");
        Set tvalue = testValues.keySet();
        for (String expected : tvalue) {
            String exprStr = (String)testValues.get(expected);
            try {
                Object expr = ExprEval.evaluateValueExpression(exprStr, null, String.class);
                pass = ExprEval.compareClass(expr, String.class) && ExprEval.compareValue(expr, expected);
            }
            catch (Exception e) {
                throw new Exception(e);
            }
            if (pass) continue;
            throw new Exception("TEST FAILED!");
        }
    }

    private List getFloatList() {
        ArrayList<Float> floatList = new ArrayList<Float>();
        floatList.add(new Float("8.1F"));
        floatList.add(new Float("-70.2F"));
        floatList.add(new Float("8.1e4F"));
        floatList.add(new Float("8.1E6F"));
        floatList.add(new Float("8.1e-9F"));
        floatList.add(new Float("8.1E+3F"));
        floatList.add(new Float("-.72F"));
        floatList.add(new Float(".999F"));
        floatList.add(new Float("-.1e1F"));
        floatList.add(new Float(".234E22F"));
        floatList.add(new Float("-.3444e-2F"));
        floatList.add(new Float(".5E+7F"));
        floatList.add(new Float("-1e1F"));
        floatList.add(new Float("234E2F"));
        floatList.add(new Float("-3444e-2F"));
        floatList.add(new Float("-3444e+2F"));
        return floatList;
    }

    private List getIntegerList() {
        ArrayList<Integer> integerList = new ArrayList<Integer>();
        integerList.add(1);
        integerList.add(-2);
        integerList.add(Integer.MAX_VALUE);
        integerList.add(-2147483647);
        return integerList;
    }

    private Hashtable getStringTable() {
        Hashtable<String, String> testStrings = new Hashtable<String, String>();
        testStrings.put("string", "'string'");
        testStrings.put("str\\ing", "'str\\\\ing'");
        testStrings.put("\"catstring\"", "'\"catstring\"'");
        testStrings.put("'pullstring'", "'\\'pullstring\\''");
        return testStrings;
    }
}

