/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.el.api.jakarta_el.resourcebundleelresolver;

import com.sun.ts.tests.el.common.api.resolver.ResolverTest;
import com.sun.ts.tests.el.common.elcontext.BareBonesELContext;
import jakarta.el.ELContext;
import jakarta.el.ELResolver;
import jakarta.el.ResourceBundleELResolver;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;

public class ELClientIT {
    private static final System.Logger logger = System.getLogger(ELClientIT.class.getName());
    private TckResourceBundle tckrb = new TckResourceBundle();

    @AfterEach
    public void cleanup() throws Exception {
        logger.log(System.Logger.Level.INFO, "Cleanup method called");
    }

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        logger.log(System.Logger.Level.INFO, "STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        logger.log(System.Logger.Level.INFO, "FINISHED TEST : " + testInfo.getDisplayName());
    }

    @Test
    public void resourceBundleELResolverTest() throws Exception {
        boolean pass = false;
        StringBuffer buf = new StringBuffer();
        try {
            ResourceBundleELResolver rsbResolver = new ResourceBundleELResolver();
            BareBonesELContext barebonesContext = new BareBonesELContext();
            ELContext context = barebonesContext.getELContext();
            pass = ResolverTest.testELResolver(context, (ELResolver)rsbResolver, this.tckrb, "Dinner", "DINNER", buf, true);
        }
        catch (Exception ex) {
            throw new Exception(ex);
        }
        if (!pass) {
            throw new Exception("Test FAILED" + buf.toString());
        }
        logger.log(System.Logger.Level.TRACE, buf.toString());
    }

    @Test
    public void resourceBundleELResolverNPETest() throws Exception {
        boolean pass = false;
        StringBuffer buf = new StringBuffer();
        ResourceBundleELResolver resolver = new ResourceBundleELResolver();
        try {
            pass = ResolverTest.testELResolverNPE((ELResolver)resolver, this.tckrb, "brunch", "BRUNCH", buf);
        }
        catch (Exception ex) {
            throw new Exception(ex);
        }
        if (!pass) {
            throw new Exception("Test FAILED" + buf.toString());
        }
        logger.log(System.Logger.Level.TRACE, buf.toString());
    }

    @Test
    public void resourceBundleELResolverPNWETest() throws Exception {
        boolean pass = false;
        StringBuffer buf = new StringBuffer();
        BareBonesELContext barebonesContext = new BareBonesELContext();
        ELContext context = barebonesContext.getELContext();
        ResourceBundleELResolver rsbResolver = new ResourceBundleELResolver();
        try {
            pass = ResolverTest.testELResolverPNWE(context, (ELResolver)rsbResolver, this.tckrb, "snack", "SNACK", buf);
        }
        catch (Exception ex) {
            throw new Exception(ex);
        }
        if (!pass) {
            throw new Exception("Test FAILED" + buf.toString());
        }
        logger.log(System.Logger.Level.TRACE, buf.toString());
    }

    private static class TckResourceBundle
    extends ResourceBundle
    implements Serializable {
        private static final String KEYS = "Breakfast Lunch Dinner";

        private TckResourceBundle() {
        }

        @Override
        public Object handleGetObject(String key) {
            if ("Breakfast".equals(key)) {
                return "BREAKFAST";
            }
            if ("Lunch".equals(key)) {
                return "LUNCH";
            }
            if ("Dinner".equals(key)) {
                return "DINNER";
            }
            return null;
        }

        public Enumeration getKeys() {
            StringTokenizer keyTokenizer = new StringTokenizer(KEYS);
            return keyTokenizer;
        }
    }
}

