/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.full.decorators.builtin.conversation;

import jakarta.enterprise.context.Conversation;
import jakarta.inject.Inject;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Set;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.full.decorators.AbstractDecoratorTest;
import org.jboss.cdi.tck.tests.full.decorators.builtin.conversation.ConversationDecorator;
import org.jboss.cdi.tck.tests.full.decorators.builtin.conversation.ConversationObserver;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.impl.BeansXml;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"cdi-full"})
@SpecVersion(spec="cdi", version="2.0")
public class BuiltinConversationDecoratorTest
extends AbstractDecoratorTest {
    @Inject
    ConversationObserver conversationObserver;
    @Inject
    Conversation conversation;

    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(BuiltinConversationDecoratorTest.class)).withClass(AbstractDecoratorTest.class)).withBeansXml(new BeansXml().decorators(ConversationDecorator.class))).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="decorator_invocation", id="ach"), @SpecAssertion(section="decorator_resolution", id="aa")})
    public void testDecoratorIsResolved() {
        this.checkDecorator(this.resolveUniqueDecorator(Collections.singleton(Conversation.class), new Annotation[0]), ConversationDecorator.class, (Set<Type>)Collections.singleton(Conversation.class), (Type)((Object)Conversation.class));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="decorator_invocation", id="ach")})
    public void testDecoratorIsInvoked() {
        String cid = "foo";
        this.conversation.begin(cid);
        Assert.assertFalse((boolean)this.conversation.isTransient());
        Assert.assertEquals((String)this.conversationObserver.getDecoratedConversationId(), (String)cid);
    }
}

