/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.full.extensions.configurators;

import jakarta.enterprise.context.RequestScoped;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.spi.Extension;
import jakarta.enterprise.inject.spi.ProcessAnnotatedType;
import jakarta.enterprise.inject.spi.ProcessBeanAttributes;
import jakarta.enterprise.inject.spi.ProcessInjectionPoint;
import jakarta.enterprise.inject.spi.ProcessObserverMethod;
import jakarta.enterprise.inject.spi.configurator.AnnotatedTypeConfigurator;
import jakarta.enterprise.inject.spi.configurator.BeanAttributesConfigurator;
import jakarta.enterprise.inject.spi.configurator.InjectionPointConfigurator;
import jakarta.enterprise.inject.spi.configurator.ObserverMethodConfigurator;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.cdi.tck.tests.full.extensions.configurators.Bar;
import org.jboss.cdi.tck.tests.full.extensions.configurators.Foo;

public class DummyConfiguringExtension
implements Extension {
    private AtomicBoolean sameATConfiguratorReturned = new AtomicBoolean(false);
    private AtomicBoolean sameIPConfiguratorReturned = new AtomicBoolean(false);
    private AtomicBoolean sameBAConfiguratorReturned = new AtomicBoolean(false);
    private AtomicBoolean sameOMConfiguratorReturned = new AtomicBoolean(false);

    void observesFooPAT(@Observes ProcessAnnotatedType<Foo> event) {
        AnnotatedTypeConfigurator annotatedTypeConfigurator = event.configureAnnotatedType();
        annotatedTypeConfigurator.remove(p -> p.annotationType().equals(RequestScoped.class));
        this.sameATConfiguratorReturned.set(annotatedTypeConfigurator.equals(event.configureAnnotatedType()));
    }

    void observesFooPIP(@Observes ProcessInjectionPoint<Foo, Bar> event) {
        InjectionPointConfigurator injectionPointConfigurator = event.configureInjectionPoint();
        injectionPointConfigurator.transientField(true);
        this.sameIPConfiguratorReturned.set(injectionPointConfigurator.equals(event.configureInjectionPoint()));
    }

    void observesFooPBA(@Observes ProcessBeanAttributes<Foo> event) {
        BeanAttributesConfigurator beanAttributesConfigurator = event.configureBeanAttributes();
        beanAttributesConfigurator.name(Foo.class.getSimpleName());
        this.sameBAConfiguratorReturned.set(beanAttributesConfigurator.equals(event.configureBeanAttributes()));
    }

    void observesFooPOM(@Observes ProcessObserverMethod<Bar, Foo> event) {
        ObserverMethodConfigurator observerMethodConfigurator = event.configureObserverMethod();
        observerMethodConfigurator.priority(1000);
        this.sameOMConfiguratorReturned.set(observerMethodConfigurator.equals(event.configureObserverMethod()));
    }

    public AtomicBoolean isSameATConfiguratorReturned() {
        return this.sameATConfiguratorReturned;
    }

    public AtomicBoolean isSameIPConfiguratorReturned() {
        return this.sameIPConfiguratorReturned;
    }

    public AtomicBoolean isSameBAConfiguratorReturned() {
        return this.sameBAConfiguratorReturned;
    }

    public AtomicBoolean isSameOMConfiguratorReturned() {
        return this.sameOMConfiguratorReturned;
    }
}

