/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.interceptors.definition.inheritance;

import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.interceptors.definition.inheritance.Culinary;
import org.jboss.cdi.tck.tests.interceptors.definition.inheritance.European;
import org.jboss.cdi.tck.tests.interceptors.definition.inheritance.EuropeanLarch;
import org.jboss.cdi.tck.tests.interceptors.definition.inheritance.Herb;
import org.jboss.cdi.tck.tests.interceptors.definition.inheritance.Larch;
import org.jboss.cdi.tck.tests.interceptors.definition.inheritance.Plant;
import org.jboss.cdi.tck.tests.interceptors.definition.inheritance.Rosehip;
import org.jboss.cdi.tck.tests.interceptors.definition.inheritance.Shrub;
import org.jboss.cdi.tck.tests.interceptors.definition.inheritance.SquirrelInterceptor;
import org.jboss.cdi.tck.tests.interceptors.definition.inheritance.Thyme;
import org.jboss.cdi.tck.tests.interceptors.definition.inheritance.WoodpeckerInterceptor;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="2.0")
public class InterceptorBindingInheritanceTest
extends AbstractTest {
    private String squirrel = SquirrelInterceptor.class.getName();
    private String woodpecker = WoodpeckerInterceptor.class.getName();

    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(InterceptorBindingInheritanceTest.class)).build();
    }

    @Test(dataProvider="ARQUILLIAN_DATA_PROVIDER")
    @SpecAssertions(value={@SpecAssertion(section="type_level_inheritance", id="ad"), @SpecAssertion(section="type_level_inheritance", id="ada")})
    public void testInterceptorBindingDirectlyInheritedFromManagedBean(Larch larch) throws Exception {
        larch.pong();
        Assert.assertTrue((boolean)Plant.inspectedBy(larch, this.squirrel));
        Assert.assertFalse((boolean)Plant.inspectedBy(larch, this.woodpecker));
    }

    @Test(dataProvider="ARQUILLIAN_DATA_PROVIDER")
    @SpecAssertions(value={@SpecAssertion(section="type_level_inheritance", id="aj"), @SpecAssertion(section="type_level_inheritance", id="aja")})
    public void testInterceptorBindingIndirectlyInheritedFromManagedBean(@European Larch europeanLarch) throws Exception {
        europeanLarch.pong();
        Assert.assertTrue((boolean)(europeanLarch instanceof EuropeanLarch));
        Assert.assertTrue((boolean)Plant.inspectedBy(europeanLarch, this.squirrel));
        Assert.assertFalse((boolean)Plant.inspectedBy(europeanLarch, this.woodpecker));
    }

    @Test(dataProvider="ARQUILLIAN_DATA_PROVIDER")
    @SpecAssertion(section="member_level_inheritance", id="ka")
    public void testMethodInterceptorBindingDirectlyInheritedFromManagedBean(Herb herb) {
        herb.pong();
        Assert.assertTrue((boolean)Plant.inspectedBy(herb, this.squirrel));
    }

    @Test(dataProvider="ARQUILLIAN_DATA_PROVIDER")
    @SpecAssertion(section="member_level_inheritance", id="kc")
    public void testMethodInterceptorBindingIndirectlyInheritedFromManagedBean(@Culinary Herb thyme) {
        thyme.pong();
        Assert.assertTrue((boolean)(thyme instanceof Thyme));
        Assert.assertTrue((boolean)Plant.inspectedBy(thyme, this.squirrel));
    }

    @Test(dataProvider="ARQUILLIAN_DATA_PROVIDER")
    @SpecAssertion(section="member_level_inheritance", id="ka")
    public void testMethodInterceptorBindingDirectlyNotInheritedFromManagedBean(Shrub shrub) {
        shrub.pong();
        Assert.assertFalse((boolean)Plant.inspectedBy(shrub, this.squirrel));
    }

    @Test(dataProvider="ARQUILLIAN_DATA_PROVIDER")
    @SpecAssertion(section="member_level_inheritance", id="kc")
    public void testMethodInterceptorBindingIndirectlyNotInheritedFromManagedBean(@Culinary Shrub rosehip) {
        rosehip.pong();
        Assert.assertTrue((boolean)(rosehip instanceof Rosehip));
        Assert.assertFalse((boolean)Plant.inspectedBy(rosehip, this.squirrel));
    }
}

