/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.tck.tests.jslxml;

import com.ibm.jbatch.tck.utils.AssertionUtils;
import com.ibm.jbatch.tck.utils.BaseJUnit5Test;
import com.ibm.jbatch.tck.utils.JobOperatorBridge;
import com.ibm.jbatch.tck.utils.TCKJobExecutionWrapper;
import ee.jakarta.tck.batch.util.Reporter;
import jakarta.batch.runtime.BatchStatus;
import jakarta.batch.runtime.JobExecution;
import java.util.Properties;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class StopOrFailOnExitStatusWithRestartTests
extends BaseJUnit5Test {
    private static JobOperatorBridge jobOp;

    private void begin(String str) {
        Reporter.log((String)("Begin test method: " + str + "<p>"));
    }

    @BeforeEach
    public void setUp() throws Exception {
        jobOp = new JobOperatorBridge();
    }

    @Test
    public void testInvokeJobWithUserStopAndRestart() throws Exception {
        String METHOD = "testInvokeJobWithUserStopAndRestart";
        this.begin(METHOD);
        String DEFAULT_SLEEP_TIME = "5000";
        try {
            Reporter.log((String)"Locate job XML file: job_batchlet_longrunning.xml<p>");
            Reporter.log((String)"Create job parameters for execution #1:<p>");
            Properties overrideJobParams = new Properties();
            Reporter.log((String)"run.indefinitely=true<p>");
            overrideJobParams.setProperty("run.indefinitely", "true");
            Reporter.log((String)"Invoke startJobWithoutWaitingForResult for execution #1<p>");
            TCKJobExecutionWrapper execution1 = jobOp.startJobWithoutWaitingForResult("job_batchlet_longrunning", overrideJobParams);
            long execID = execution1.getExecutionId();
            Reporter.log((String)("StopRestart: Started job with execId=" + execID + "<p>"));
            int sleepTime = Integer.parseInt(System.getProperty("StopOrFailOnExitStatusWithRestartTests.testInvokeJobWithUserStop.sleep", "5000"));
            Reporter.log((String)("Sleep " + sleepTime + "<p>"));
            Thread.sleep(sleepTime);
            BatchStatus exec1BatchStatus = execution1.getBatchStatus();
            Reporter.log((String)("execution #1 JobExecution getBatchStatus()=" + exec1BatchStatus + "<p>"));
            boolean startedOrStarting = exec1BatchStatus == BatchStatus.STARTED || exec1BatchStatus == BatchStatus.STARTING;
            AssertionUtils.assertWithMessage("Found BatchStatus of " + exec1BatchStatus.toString() + "; Hopefully job isn't finished already, if it is fail the test and use a longer sleep time within the batch step-related artifact.", startedOrStarting);
            Reporter.log((String)"Invoke stopJobAndWaitForResult");
            jobOp.stopJobAndWaitForResult(execution1);
            JobExecution postStopJobExecution = jobOp.getJobExecution(execution1.getExecutionId());
            Reporter.log((String)("execution #1 JobExecution getBatchStatus()=" + postStopJobExecution.getBatchStatus() + "<p>"));
            AssertionUtils.assertWithMessage("The stop should have taken effect by now, even though the batchlet artifact had control at the time of the stop, it should have returned control by now.", BatchStatus.STOPPED, postStopJobExecution.getBatchStatus());
            Reporter.log((String)("execution #1 JobExecution getBatchStatus()=" + postStopJobExecution.getExitStatus() + "<p>"));
            AssertionUtils.assertWithMessage("If this assert fails with an exit status of STOPPED, try increasing the sleep time. It's possiblethe JobOperator stop is being issued before the Batchlet has a chance to run.", "BATCHLET CANCELED BEFORE COMPLETION", postStopJobExecution.getExitStatus());
            Reporter.log((String)"Create job parameters for execution #2:<p>");
            Reporter.log((String)"run.indefinitely=false<p>");
            overrideJobParams.setProperty("run.indefinitely", "false");
            Reporter.log((String)("Invoke restartJobAndWaitForResult with executionId: " + execution1.getInstanceId() + "<p>"));
            TCKJobExecutionWrapper execution2 = jobOp.restartJobAndWaitForResult(execution1.getExecutionId(), overrideJobParams);
            Reporter.log((String)("execution #2 JobExecution getBatchStatus()=" + execution2.getBatchStatus() + "<p>"));
            AssertionUtils.assertWithMessage("If the restarted job hasn't completed yet then try increasing the sleep time.", BatchStatus.COMPLETED, execution2.getBatchStatus());
            Reporter.log((String)("execution #2 JobExecution getExitStatus()=" + execution2.getExitStatus() + "<p>"));
            AssertionUtils.assertWithMessage("If this fails, the reason could be that step 1 didn't run the second time,though it should since it won't have completed successfully the first time.", "GOOD.STEP.GOOD.STEP", execution2.getExitStatus());
        }
        catch (Exception e) {
            StopOrFailOnExitStatusWithRestartTests.handleException(METHOD, e);
        }
    }

    @Test
    public void testInvokeJobWithUncaughtExceptionFailAndRestart() throws Exception {
        String METHOD = "testInvokeJobWithUncaughtExceptionFailAndRestart";
        this.begin(METHOD);
        try {
            Reporter.log((String)"Locate job XML file: job_batchlet_longrunning.xml<p>");
            Reporter.log((String)"Create job parameters for execution #1:<p>");
            Properties jobParameters = new Properties();
            Reporter.log((String)"throw.exc.on.number.3=true<p>");
            jobParameters.setProperty("throw.exc.on.number.3", "true");
            Reporter.log((String)"Invoke startJobAndWaitForResult");
            TCKJobExecutionWrapper firstJobExecution = jobOp.startJobAndWaitForResult("job_batchlet_longrunning", jobParameters);
            Reporter.log((String)("Started job with execId=" + firstJobExecution.getExecutionId() + "<p>"));
            Reporter.log((String)("execution #1 JobExecution getBatchStatus()=" + firstJobExecution.getBatchStatus() + "<p>"));
            Reporter.log((String)("execution #1 JobExecution getExitStatus()=" + firstJobExecution.getExitStatus() + "<p>"));
            AssertionUtils.assertWithMessage("If the job hasn't failed yet then try increasing the sleep time.", BatchStatus.FAILED, firstJobExecution.getBatchStatus());
            AssertionUtils.assertObjEquals("FAILED", firstJobExecution.getExitStatus());
            Reporter.log((String)"Create job parameters for execution #2:<p>");
            Properties overrideJobParams = new Properties();
            Reporter.log((String)"throw.exc.on.number.3=false<p>");
            Reporter.log((String)"run.indefinitely=false<p>");
            overrideJobParams.setProperty("throw.exc.on.number.3", "false");
            overrideJobParams.setProperty("run.indefinitely", "false");
            Reporter.log((String)("Invoke restartJobAndWaitForResult with executionId: " + firstJobExecution.getInstanceId() + "<p>"));
            TCKJobExecutionWrapper secondJobExecution = jobOp.restartJobAndWaitForResult(firstJobExecution.getExecutionId(), overrideJobParams);
            Reporter.log((String)("execution #2 JobExecution getBatchStatus()=" + secondJobExecution.getBatchStatus() + "<p>"));
            AssertionUtils.assertWithMessage("If the restarted job hasn't completed yet then try increasing the sleep time.", BatchStatus.COMPLETED, secondJobExecution.getBatchStatus());
            Reporter.log((String)("execution #2 JobExecution getExitStatus()=" + secondJobExecution.getExitStatus() + "<p>"));
            AssertionUtils.assertWithMessage("If this fails with only \"GOOD.STEP\", the reason could be that step 1 didn't run the second time,though it should since it won't have completed successfully the first time.", "GOOD.STEP.GOOD.STEP", secondJobExecution.getExitStatus());
        }
        catch (Exception e) {
            StopOrFailOnExitStatusWithRestartTests.handleException(METHOD, e);
        }
    }

    private static void handleException(String methodName, Exception e) throws Exception {
        Reporter.log((String)("Caught exception: " + e.getMessage() + "<p>"));
        Reporter.log((String)(methodName + " failed<p>"));
        throw e;
    }
}

