/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.client.ui.preferences;

import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.ColorFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.mylyn.docs.intent.client.ui.IntentEditorActivator;
import org.eclipse.mylyn.docs.intent.client.ui.editor.IntentEditorDocument;
import org.eclipse.mylyn.docs.intent.client.ui.editor.IntentEditorImpl;
import org.eclipse.mylyn.docs.intent.client.ui.editor.configuration.IntentEditorConfiguration;
import org.eclipse.mylyn.docs.intent.client.ui.editor.scanner.IntentPartitionScanner;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class IntentPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public static final String LINK_DROPPED_ELEMENTS_USING_EXTERNAL_REFERENCES = "Link dropped elements using External References";
    private static final String INTENT_PREVIEW_EXAMPLE = "Section Title {\n\t Default text \n\t\"Strings\"\n\t* lists\n\t!images!\n\t\n\t@M\n\t\tnew Element{}\n\tM@\n}";
    private RefreshPreviewEditorListener refreshPreviewEditorListener;
    private SourceViewer sourceViewer;
    private IntentEditorConfiguration viewerConfiguration;
    private IDocumentPartitioner partitioner;
    private IntentEditorImpl editor;

    protected void createFieldEditors() {
        Composite parent = this.getFieldEditorParent();
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.verticalSpacing = 0;
        parent.setLayout((Layout)gridLayout);
        parent.setLayoutData((Object)new GridData(1808));
        parent.redraw();
        TabFolder folder = new TabFolder(parent, 0);
        folder.setLayout((Layout)new TabFolderLayout());
        folder.setLayoutData((Object)new GridData(1808));
        this.setPreferenceStore(IntentEditorActivator.getDefault().getPreferenceStore());
        TabItem item = new TabItem(folder, 0);
        item.setText("Appearance");
        item.setControl(this.createAppearancePage((Composite)folder));
        item = new TabItem(folder, 0);
        item.setText("Colors");
        item.setControl(this.createColorsPage((Composite)folder));
        item = new TabItem(folder, 0);
        item.setText("Behavior (UI)");
        item.setControl(this.createUIBehaviorPage((Composite)folder));
        item = new TabItem(folder, 0);
        item.setText("Export");
        item.setControl(this.createCodeGenerationPage((Composite)folder));
        item = new TabItem(folder, 0);
        item.setText("Other");
        item.setControl(this.createOtherPage((Composite)folder));
    }

    private Control createAppearancePage(Composite parent) {
        Composite composite = this.createComposite(parent);
        this.addField(this.createBooleanFieldEditor("org.eclipse.mylyn.docs.intent.client.ui.preferences.text_wrap", "Autowrap", "Intent editor should automatically wrap lines", composite));
        this.addField(this.createBooleanFieldEditor("org.eclipse.mylyn.docs.intent.client.ui.preferences.show_preview_page", "Show HTML Preview page", "Intent editor should display a 'Preview' tab to get HTML preview of current editor", composite));
        this.addField(this.createBooleanFieldEditor("org.eclipse.mylyn.docs.intent.client.ui.preferences.collapse_mu", "Collapse ModelingUnits", "Intent editor should collapse Modeling Units at opening", composite));
        this.addField(this.createBooleanFieldEditor("org.eclipse.mylyn.docs.intent.client.ui.preferences.matching_brackets", "Brackets matching", "Intent editor should match brackets", composite));
        return composite;
    }

    private Control createColorsPage(Composite parent) {
        Composite colorComposite = this.createComposite(parent);
        final Link link = new Link(colorComposite, 0);
        link.setText("Note: Intent Font preferences can be configured through the <a href=\"org.eclipse.ui.preferencePages.ColorsAndFonts\">'Colors and Fonts'</a> preference page.");
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if ("org.eclipse.ui.preferencePages.ColorsAndFonts".equals(e.text)) {
                    PreferencesUtil.createPreferenceDialogOn((Shell)link.getShell(), (String)e.text, null, (Object)"selectFont:org.eclipse.jface.textfont");
                }
            }
        });
        Link link2 = new Link(colorComposite, 0);
        link2.setText("See <a href=\"org.eclipse.ui.preferencePages.GeneralTextEditor\">'Text Editors'</a> for general text editor preferences.");
        link2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if ("org.eclipse.ui.preferencePages.GeneralTextEditor".equals(e.text)) {
                    PreferencesUtil.createPreferenceDialogOn((Shell)link.getShell(), (String)e.text, null, null);
                }
            }
        });
        ColorFieldEditor bracketsColor = new ColorFieldEditor("org.eclipse.mylyn.docs.intent.client.ui.preferences.matching_brackets_color", "Brackets color", colorComposite);
        this.addField((FieldEditor)bracketsColor);
        ColorFieldEditor stringColor = new ColorFieldEditor("org.eclipse.mylyn.docs.intent.client.ui.preferences.string_color", "String color", colorComposite);
        this.addField((FieldEditor)stringColor);
        ColorFieldEditor textColor = new ColorFieldEditor("org.eclipse.mylyn.docs.intent.client.ui.preferences.du_default_color", "Text color", colorComposite);
        this.addField((FieldEditor)textColor);
        ColorFieldEditor codeColor = new ColorFieldEditor("org.eclipse.mylyn.docs.intent.client.ui.preferences.code", "Code color", colorComposite);
        this.addField((FieldEditor)codeColor);
        ColorFieldEditor duKeyWordColor = new ColorFieldEditor("org.eclipse.mylyn.docs.intent.client.ui.preferences.du_keyword_color", "Keyword color", colorComposite);
        this.addField((FieldEditor)duKeyWordColor);
        ColorFieldEditor titleColor = new ColorFieldEditor("org.eclipse.mylyn.docs.intent.client.ui.preferences.du_title_color", "Title color", colorComposite);
        this.addField((FieldEditor)titleColor);
        ColorFieldEditor listColor = new ColorFieldEditor("org.eclipse.mylyn.docs.intent.client.ui.preferences.du_list_color", "List color", colorComposite);
        this.addField((FieldEditor)listColor);
        ColorFieldEditor muDefaultColor = new ColorFieldEditor("org.eclipse.mylyn.docs.intent.client.ui.preferences.mu_default_color", "Modeling unit - default color", colorComposite);
        this.addField((FieldEditor)muDefaultColor);
        ColorFieldEditor muKeywordColor = new ColorFieldEditor("org.eclipse.mylyn.docs.intent.client.ui.preferences.mu_keyword_color", "Modeling unit - keyword color", colorComposite);
        this.addField((FieldEditor)muKeywordColor);
        Label infoLabel2 = new Label(colorComposite, 0);
        infoLabel2.setText("Preview: ");
        IntentEditorDocument document = this.createIntentPreviewViewer(colorComposite);
        this.refreshPreviewEditorListener = new RefreshPreviewEditorListener(document);
        this.getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this.refreshPreviewEditorListener);
        return colorComposite;
    }

    private Control createUIBehaviorPage(Composite parent) {
        Composite composite = this.createComposite(parent);
        Group dragAndDropGroup = this.createGroup(composite, "Drag and Drop Support");
        Label fontInfo = new Label((Composite)dragAndDropGroup, 0);
        fontInfo.setText("These preferences allow to specify how should Intent react when dropping elements (e.g. a Java class) inside an Intent editor");
        this.addField(this.createBooleanFieldEditor("org.eclipse.mylyn.docs.intent.client.ui.preferences.dnd_display_popup", "Always ask", "A pop-up should ask the behavior to apply. Otherwise the behavior checked below will be applied automatically.", (Composite)dragAndDropGroup));
        this.addField(this.createBooleanFieldEditor("org.eclipse.mylyn.docs.intent.client.ui.preferences.dnd_use_external_refs", LINK_DROPPED_ELEMENTS_USING_EXTERNAL_REFERENCES, "There are 2 ways of linking dropped elements (see documentation for further details)", (Composite)dragAndDropGroup));
        return composite;
    }

    private Control createCodeGenerationPage(Composite parent) {
        Composite composite = this.createComposite(parent);
        this.addField(this.createBooleanFieldEditor("org.eclipse.mylyn.docs.intent.client.ui.preferences.export_display_references_inline", "Display references inline", "Intent Export should display references to artifacts inline", composite));
        return composite;
    }

    private Control createOtherPage(Composite parent) {
        Composite composite = this.createComposite(parent);
        this.addField(this.createBooleanFieldEditor("org.eclipse.mylyn.docs.intent.client.ui.preferences.activate_backup", "Activate back-up mechanism", "Intent Documents should be backed-up in text files (only in Workspace mode)", composite));
        this.addField(this.createBooleanFieldEditor("org.eclipse.mylyn.docs.intent.client.ui.preferences.advanced_logging", "Advanced logging", "(for Debug only) Each Intent client should log its activity", composite));
        return composite;
    }

    private Composite createComposite(Composite parent) {
        Font font = parent.getFont();
        Composite composite = new Composite(parent, 0);
        composite.setFont(font);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        return composite;
    }

    private Group createGroup(Composite parent, String groupTitle) {
        Group group = new Group(parent, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        group.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 1;
        group.setLayoutData((Object)gridData);
        group.setText(groupTitle);
        return group;
    }

    private IntentEditorDocument createIntentPreviewViewer(Composite parent) {
        this.editor = new IntentEditorImpl();
        IntentEditorDocument document = new IntentEditorDocument(this.editor);
        this.partitioner = new FastPartitioner((IPartitionTokenScanner)new IntentPartitionScanner(), IntentPartitionScanner.LEGAL_CONTENT_TYPES);
        this.partitioner.connect((IDocument)document);
        document.setDocumentPartitioner(this.partitioner);
        this.viewerConfiguration = new IntentEditorConfiguration(this.editor, null);
        int styles = 512;
        styles |= 0x100;
        styles |= 2;
        styles |= 0x800;
        new Label(parent, 0);
        this.sourceViewer = new SourceViewer(parent, null, null, false, styles |= 0x10000);
        StyledText styledText = this.sourceViewer.getTextWidget();
        styledText.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this.sourceViewer.configure((SourceViewerConfiguration)this.viewerConfiguration);
        this.sourceViewer.setEditable(false);
        Cursor arrowCursor = this.sourceViewer.getTextWidget().getDisplay().getSystemCursor(0);
        this.sourceViewer.getTextWidget().setCursor(arrowCursor);
        this.sourceViewer.getTextWidget().setCaret(null);
        this.sourceViewer.getTextWidget().setFont(JFaceResources.getTextFont());
        this.sourceViewer.setDocument((IDocument)document);
        document.set(INTENT_PREVIEW_EXAMPLE);
        return document;
    }

    private FieldEditor createBooleanFieldEditor(String preferenceID, String text, String explanations, Composite composite) {
        BooleanFieldEditor booleanFieldEditor = new BooleanFieldEditor(preferenceID, text, new Composite(composite, 0)){
            private Label labelControl;

            public Label getLabelControl(Composite parent) {
                if (this.labelControl == null) {
                    this.labelControl = super.getLabelControl(parent);
                    FontData fontData = this.labelControl.getFont().getFontData()[0];
                    Font font = new Font((Device)Display.getCurrent(), new FontData(fontData.getName(), fontData.getHeight(), 1));
                    this.labelControl.setFont(font);
                }
                return this.labelControl;
            }
        };
        this.createLabel(composite, explanations);
        return booleanFieldEditor;
    }

    private Label createLabel(Composite composite, String text) {
        Label label = new Label(composite, 131072);
        label.setText("- " + text);
        FontData fontData = label.getFont().getFontData()[0];
        Font font = new Font((Device)Display.getCurrent(), new FontData(fontData.getName(), fontData.getHeight(), 2));
        label.setFont(font);
        return label;
    }

    public void init(IWorkbench workbench) {
    }

    public void dispose() {
        if (this.refreshPreviewEditorListener != null) {
            this.getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this.refreshPreviewEditorListener);
        }
    }

    private class RefreshPreviewEditorListener
    implements IPropertyChangeListener {
        private IntentEditorDocument document;

        public RefreshPreviewEditorListener(IntentEditorDocument document) {
            this.document = document;
        }

        public void propertyChange(PropertyChangeEvent event) {
        }
    }

    public class TabFolderLayout
    extends Layout {
        protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
            if (wHint != -1 && hHint != -1) {
                return new Point(wHint, hHint);
            }
            Control[] children = composite.getChildren();
            int count = children.length;
            int maxWidth = 0;
            int maxHeight = 0;
            int i = 0;
            while (i < count) {
                Control child = children[i];
                Point pt = child.computeSize(-1, -1, flushCache);
                maxWidth = Math.max(maxWidth, pt.x);
                maxHeight = Math.max(maxHeight, pt.y);
                ++i;
            }
            if (wHint != -1) {
                maxWidth = wHint;
            }
            if (hHint != -1) {
                maxHeight = hHint;
            }
            return new Point(maxWidth, maxHeight);
        }

        protected void layout(Composite composite, boolean flushCache) {
            Rectangle rect = composite.getClientArea();
            Control[] children = composite.getChildren();
            int i = 0;
            while (i < children.length) {
                children[i].setBounds(rect);
                ++i;
            }
        }
    }
}

