/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.client.ui.editor.configuration;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.quickassist.IQuickAssistAssistant;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.MonoReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.mylyn.docs.intent.client.ui.editor.IntentDocumentProvider;
import org.eclipse.mylyn.docs.intent.client.ui.editor.IntentEditor;
import org.eclipse.mylyn.docs.intent.client.ui.editor.IntentReconcilingStrategy;
import org.eclipse.mylyn.docs.intent.client.ui.editor.completion.IntentCompletionProcessor;
import org.eclipse.mylyn.docs.intent.client.ui.editor.completion.ModelingUnitCompletionProcessor;
import org.eclipse.mylyn.docs.intent.client.ui.editor.quickfix.IntentQuickAssistant;
import org.eclipse.mylyn.docs.intent.client.ui.editor.scanner.AbstractIntentScanner;
import org.eclipse.mylyn.docs.intent.client.ui.editor.scanner.IntentDescriptionUnitScanner;
import org.eclipse.mylyn.docs.intent.client.ui.editor.scanner.IntentModelingUnitScanner;
import org.eclipse.mylyn.docs.intent.client.ui.editor.scanner.IntentStructuredElementScanner;
import org.eclipse.mylyn.docs.intent.collab.handlers.adapters.RepositoryAdapter;
import org.eclipse.ui.editors.text.TextSourceViewerConfiguration;

public class IntentEditorConfiguration
extends TextSourceViewerConfiguration {
    protected IntentEditor editor;
    private AbstractIntentScanner[] scanners;

    public IntentEditorConfiguration(IntentEditor editor, IPreferenceStore preferenceStore) {
        this.editor = editor;
        this.fPreferenceStore = preferenceStore;
    }

    protected AbstractIntentScanner[] getScanners() {
        if (this.scanners == null) {
            ArrayList<AbstractIntentScanner> list = new ArrayList<AbstractIntentScanner>();
            list.add(new IntentModelingUnitScanner(this.editor.getColorManager()));
            list.add(new IntentDescriptionUnitScanner(this.editor.getColorManager()));
            list.add(new IntentStructuredElementScanner(this.editor.getColorManager()));
            this.scanners = list.toArray(new AbstractIntentScanner[list.size()]);
        }
        return this.scanners;
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        AbstractIntentScanner[] usedScanners = this.getScanners();
        String[] result = new String[usedScanners.length];
        int i = 0;
        while (i < usedScanners.length) {
            AbstractIntentScanner scanner = usedScanners[i];
            result[i] = scanner.getConfiguredContentType();
            ++i;
        }
        return result;
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        PresentationReconciler reconciler = new PresentationReconciler();
        AbstractIntentScanner[] usedScanners = this.getScanners();
        int i = 0;
        while (i < usedScanners.length) {
            AbstractIntentScanner scanner = usedScanners[i];
            DefaultDamagerRepairer dr = new DefaultDamagerRepairer((ITokenScanner)scanner);
            reconciler.setDamager((IPresentationDamager)dr, scanner.getConfiguredContentType());
            reconciler.setRepairer((IPresentationRepairer)dr, scanner.getConfiguredContentType());
            ++i;
        }
        return reconciler;
    }

    public IQuickAssistAssistant getQuickAssistAssistant(ISourceViewer sourceViewer) {
        return new IntentQuickAssistant();
    }

    public IReconciler getReconciler(ISourceViewer sourceViewer) {
        return new MonoReconciler((IReconcilingStrategy)new IntentReconcilingStrategy(this.editor), false);
    }

    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        ContentAssistant ca = new ContentAssistant();
        if (this.editor.getDocumentProvider() instanceof IntentDocumentProvider && ((IntentDocumentProvider)this.editor.getDocumentProvider()).getListenedElementsHandler() != null) {
            RepositoryAdapter repositoryAdapter = ((IntentDocumentProvider)this.editor.getDocumentProvider()).getListenedElementsHandler().getRepositoryAdapter();
            IntentCompletionProcessor intentDefaultCompletionProcessor = new IntentCompletionProcessor(this.editor.getBlockMatcher(), repositoryAdapter);
            ca.setContentAssistProcessor((IContentAssistProcessor)intentDefaultCompletionProcessor, "__Intent__structuralcontent");
            ca.setContentAssistProcessor((IContentAssistProcessor)intentDefaultCompletionProcessor, "__dftl_partition_content_type");
            ModelingUnitCompletionProcessor modelingUnitCompletionProcessor = new ModelingUnitCompletionProcessor(repositoryAdapter);
            ca.setContentAssistProcessor((IContentAssistProcessor)modelingUnitCompletionProcessor, "__Intent__modelingunit");
        }
        ca.setInformationControlCreator(this.getInformationControlCreator(sourceViewer));
        return ca;
    }

    protected Map getHyperlinkDetectorTargets(ISourceViewer sourceViewer) {
        Map targets = super.getHyperlinkDetectorTargets(sourceViewer);
        targets.put("org.eclipse.mylyn.docs.intent.client.ui.editor.IntentEditorSource", this.editor);
        return targets;
    }
}

