/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.client.ui.actions;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Iterator;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.mylyn.docs.intent.client.ui.actions.QuickOutlineAction;
import org.eclipse.mylyn.docs.intent.client.ui.editor.IntentEditor;
import org.eclipse.mylyn.docs.intent.client.ui.editor.hyperlinks.IntentHyperLinkDetector;
import org.eclipse.mylyn.docs.intent.client.ui.editor.hyperlinks.OpenWorkingCopyResourceHyperLink;

public class HyperlinkAction
extends QuickOutlineAction {
    public void run(IAction action) {
        IntentEditor currentEditor = this.getCurrentEditor();
        ISelection selection = currentEditor.getSelectionProvider().getSelection();
        if (selection instanceof TextSelection) {
            Iterator detectedHyperlinks;
            int offset = ((TextSelection)selection).getOffset();
            Region region = new Region(offset, 1);
            IntentHyperLinkDetector intentHyperlinkDetector = new IntentHyperLinkDetector();
            intentHyperlinkDetector.setContext((IAdaptable)currentEditor);
            Object[] hyperlinks = intentHyperlinkDetector.detectHyperlinks((ITextViewer)currentEditor.getProjectionViewer(), (IRegion)region, true);
            if (hyperlinks != null && (detectedHyperlinks = Iterables.filter((Iterable)Lists.newArrayList((Object[])hyperlinks), OpenWorkingCopyResourceHyperLink.class).iterator()).hasNext()) {
                ((OpenWorkingCopyResourceHyperLink)detectedHyperlinks.next()).open();
            }
        }
    }
}

