/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.client.ui.ide.navigator;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.mylyn.docs.intent.client.ui.editor.IntentEditor;
import org.eclipse.mylyn.docs.intent.client.ui.editor.IntentEditorInput;
import org.eclipse.mylyn.docs.intent.client.ui.utils.IntentEditorOpener;
import org.eclipse.mylyn.docs.intent.collab.common.query.IndexQuery;
import org.eclipse.mylyn.docs.intent.collab.common.query.IntentDocumentQuery;
import org.eclipse.mylyn.docs.intent.collab.common.repository.IntentRepositoryManager;
import org.eclipse.mylyn.docs.intent.collab.handlers.adapters.RepositoryAdapter;
import org.eclipse.mylyn.docs.intent.collab.ide.repository.WorkspaceConfig;
import org.eclipse.mylyn.docs.intent.collab.ide.repository.WorkspaceRepository;
import org.eclipse.mylyn.docs.intent.collab.repository.RepositoryConnectionException;
import org.eclipse.mylyn.docs.intent.core.indexer.IntentIndexEntry;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.navigator.ILinkHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntentLinkHelper
implements ILinkHelper {
    public IStructuredSelection findSelection(IEditorInput anInput) {
        ArrayList<? extends Object> elementsToSelect = new ArrayList<Object>();
        RepositoryAdapter repositoryAdapter = ((IntentEditorInput)anInput).getRepositoryAdapter();
        URI editorURI = ((IntentEditorInput)anInput).getURI();
        Object[] index = new IndexQuery(repositoryAdapter).getOrCreateIntentIndex().getEntries().toArray();
        int i = 0;
        while (i < index.length) {
            elementsToSelect.addAll(this.getIndexEntryToSelectionFromEditorURI((IntentIndexEntry)index[i], editorURI));
            ++i;
        }
        if (repositoryAdapter.getRepository() instanceof WorkspaceRepository) {
            WorkspaceConfig workspaceConfig = ((WorkspaceRepository)repositoryAdapter.getRepository()).getWorkspaceConfig();
            String projectName = workspaceConfig.getRepositoryAbsolutePath().replace(workspaceConfig.getRepositoryRelativePath(), "").replaceFirst("/", "");
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            if (project.exists()) {
                elementsToSelect.add(project);
            }
        }
        return new StructuredSelection(elementsToSelect.toArray(new Object[elementsToSelect.size()]));
    }

    private Collection<? extends Object> getIndexEntryToSelectionFromEditorURI(IntentIndexEntry indexEntry, URI editorURI) {
        ArrayList<? extends Object> elementsToSelect = new ArrayList<Object>();
        if (indexEntry.getReferencedElement() != null) {
            if (editorURI.equals((Object)EcoreUtil.getURI((EObject)indexEntry.getReferencedElement()))) {
                elementsToSelect.add(indexEntry);
            } else {
                for (IntentIndexEntry subEntry : indexEntry.getSubEntries()) {
                    elementsToSelect.addAll(this.getIndexEntryToSelectionFromEditorURI(subEntry, editorURI));
                }
            }
        }
        return elementsToSelect;
    }

    public void activateEditor(IWorkbenchPage aPage, IStructuredSelection aSelection) {
        Object selectedElement = aSelection.getFirstElement();
        IntentEditor alreadyOpenedEditor = null;
        if (selectedElement instanceof IntentIndexEntry) {
            alreadyOpenedEditor = IntentEditorOpener.getAlreadyOpenedEditor((EObject)((IntentIndexEntry)selectedElement).getReferencedElement());
        } else if (selectedElement instanceof IProject) {
            try {
                if (((IProject)selectedElement).hasNature("org.eclipse.mylyn.docs.intent.client.ui.ide.intentNature")) {
                    RepositoryAdapter adapter = IntentRepositoryManager.INSTANCE.getRepository(((IProject)selectedElement).getName()).createRepositoryAdapter();
                    alreadyOpenedEditor = IntentEditorOpener.getAlreadyOpenedEditor((EObject)new IntentDocumentQuery(adapter).getOrCreateIntentDocument());
                }
            }
            catch (RepositoryConnectionException repositoryConnectionException) {
            }
            catch (CoreException coreException) {}
        }
        if (alreadyOpenedEditor != null) {
            aPage.bringToTop((IWorkbenchPart)alreadyOpenedEditor);
        }
    }
}

