/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.client.ui.editor.outline;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.ReflectiveItemProvider;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.mylyn.docs.intent.client.ui.IntentEditorActivator;
import org.eclipse.mylyn.docs.intent.client.ui.editor.outline.IntentOutlinePageItemProviderAdapterFactory;
import org.eclipse.mylyn.docs.intent.core.compiler.CompilationMessageType;
import org.eclipse.mylyn.docs.intent.core.compiler.CompilationStatus;
import org.eclipse.mylyn.docs.intent.core.compiler.CompilationStatusSeverity;
import org.eclipse.mylyn.docs.intent.core.descriptionunit.DescriptionBloc;
import org.eclipse.mylyn.docs.intent.core.descriptionunit.DescriptionUnit;
import org.eclipse.mylyn.docs.intent.core.descriptionunit.DescriptionUnitPackage;
import org.eclipse.mylyn.docs.intent.core.document.IntentChapter;
import org.eclipse.mylyn.docs.intent.core.document.IntentDocument;
import org.eclipse.mylyn.docs.intent.core.document.IntentDocumentPackage;
import org.eclipse.mylyn.docs.intent.core.document.IntentGenericElement;
import org.eclipse.mylyn.docs.intent.core.document.IntentSection;
import org.eclipse.mylyn.docs.intent.core.document.IntentStructuredElement;
import org.eclipse.mylyn.docs.intent.core.genericunit.GenericUnitPackage;
import org.eclipse.mylyn.docs.intent.core.genericunit.IntentReferenceInstruction;
import org.eclipse.mylyn.docs.intent.core.genericunit.LabelDeclaration;
import org.eclipse.mylyn.docs.intent.core.genericunit.LabelReferenceInstruction;
import org.eclipse.mylyn.docs.intent.core.modelingunit.ContributionInstruction;
import org.eclipse.mylyn.docs.intent.core.modelingunit.ExternalContentReference;
import org.eclipse.mylyn.docs.intent.core.modelingunit.InstanciationInstruction;
import org.eclipse.mylyn.docs.intent.core.modelingunit.IntentReferenceinModelingUnit;
import org.eclipse.mylyn.docs.intent.core.modelingunit.ModelingUnit;
import org.eclipse.mylyn.docs.intent.core.modelingunit.ModelingUnitInstructionReference;
import org.eclipse.mylyn.docs.intent.core.modelingunit.ModelingUnitPackage;
import org.eclipse.mylyn.docs.intent.core.modelingunit.NativeValueForStructuralFeature;
import org.eclipse.mylyn.docs.intent.core.modelingunit.ReferenceValueForStructuralFeature;
import org.eclipse.mylyn.docs.intent.core.modelingunit.ResourceDeclaration;
import org.eclipse.mylyn.docs.intent.core.modelingunit.StructuralFeatureAffectation;
import org.eclipse.mylyn.docs.intent.core.query.DescriptionUnitHelper;
import org.eclipse.mylyn.docs.intent.core.query.IntentHelper;
import org.eclipse.mylyn.docs.intent.core.query.StructuredElementHelper;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntentOutlinePageItemProvider
extends ReflectiveItemProvider {
    private static final int STRUCTURED_ELEMENT_TITLE_MAXLENGTH = 50;
    private boolean hideDescriptionUnitsContent;

    public IntentOutlinePageItemProvider(IntentOutlinePageItemProviderAdapterFactory adapterFactory) {
        this(adapterFactory, false);
    }

    public IntentOutlinePageItemProvider(IntentOutlinePageItemProviderAdapterFactory adapterFactory, boolean hideDescriptionUnitsContent) {
        super((AdapterFactory)adapterFactory);
        this.hideDescriptionUnitsContent = hideDescriptionUnitsContent;
    }

    public Object getImage(Object object) {
        IItemLabelProvider labeProvider;
        EObject externalContent;
        String imagePath = null;
        Image returnedImage = null;
        if (object instanceof ExternalContentReference && (externalContent = ((ExternalContentReference)object).getExternalContent()) != null && (labeProvider = (IItemLabelProvider)new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE).adapt((Notifier)externalContent, IItemLabelProvider.class)) != null) {
            return labeProvider.getImage((Object)externalContent);
        }
        imagePath = this.getImageForStructureElement(object);
        if (imagePath == null) {
            imagePath = this.getImageForDescriptionUnitElement(object);
        }
        if (imagePath == null) {
            imagePath = this.getImageForModelingUnitElement(object);
        }
        returnedImage = imagePath != null ? IntentEditorActivator.getDefault().getImage("icon/outline/" + imagePath) : IntentEditorActivator.getDefault().getImage("icon/outline/default.gif");
        returnedImage = this.decorateImageAccordingToStatus(returnedImage, object);
        return returnedImage;
    }

    private String getImageForDescriptionUnitElement(Object object) {
        String imagePath = null;
        if (object instanceof DescriptionUnit) {
            imagePath = "descriptionunit.gif";
        }
        if (object instanceof DescriptionBloc) {
            imagePath = "descriptionBloc.gif";
        }
        if (object instanceof LabelReferenceInstruction || object instanceof IntentReferenceInstruction) {
            imagePath = "labelorreference.gif";
        }
        if (object instanceof LabelDeclaration) {
            imagePath = "labdef.gif";
        }
        return imagePath;
    }

    private String getImageForModelingUnitElement(Object object) {
        String imagePath = null;
        if (object instanceof ModelingUnit) {
            imagePath = "modelingunit.png";
        }
        if (object instanceof StructuralFeatureAffectation) {
            imagePath = "modelingunit_affect.png";
        }
        if (object instanceof InstanciationInstruction) {
            imagePath = "modelingunit_new_element.png";
        }
        if (object instanceof ContributionInstruction) {
            imagePath = "modelingunit_contribution.png";
        }
        if (object instanceof ReferenceValueForStructuralFeature) {
            imagePath = "modelingunit_ref.png";
        }
        if (object instanceof NativeValueForStructuralFeature) {
            imagePath = "modelingunit_value.gif";
        }
        if (object instanceof ResourceDeclaration) {
            imagePath = "modelingunit_resource.gif";
        }
        if (object instanceof ModelingUnitInstructionReference) {
            imagePath = "modelingunit_ref.png";
        }
        return imagePath;
    }

    private String getImageForStructureElement(Object object) {
        String imagePath = null;
        if (object instanceof IntentDocument) {
            imagePath = "document.gif";
        }
        if (object instanceof IntentChapter) {
            imagePath = "chapter.gif";
        }
        if (object instanceof IntentSection) {
            imagePath = "section.gif";
        }
        return imagePath;
    }

    private Image decorateImageAccordingToStatus(Image baseImage, Object element) {
        Image decoratedImage = baseImage;
        if (element instanceof IntentGenericElement) {
            Iterator statusIterator = IntentHelper.getAllStatus((IntentGenericElement)((IntentGenericElement)element)).iterator();
            boolean foundError = false;
            boolean foundWarning = false;
            boolean foundSyncWarning = false;
            while (!foundError & statusIterator.hasNext()) {
                CompilationStatus status = (CompilationStatus)statusIterator.next();
                foundError = status.getSeverity().equals((Object)CompilationStatusSeverity.ERROR);
                if (!status.getSeverity().equals((Object)CompilationStatusSeverity.WARNING)) continue;
                boolean bl = foundSyncWarning = foundSyncWarning || status.getType() == CompilationMessageType.SYNCHRONIZER_WARNING;
                if (status.getType() == CompilationMessageType.SYNCHRONIZER_WARNING) continue;
                foundWarning = true;
            }
            String imagePath = null;
            if (foundSyncWarning) {
                imagePath = "IMG_ELCL_SYNCED_DISABLED";
            }
            if (foundWarning) {
                imagePath = "IMG_DEC_FIELD_WARNING";
            }
            if (foundError) {
                imagePath = "IMG_DEC_FIELD_ERROR";
            }
            if (imagePath != null) {
                ImageDescriptor errorDescriptor = PlatformUI.getWorkbench().getSharedImages().getImageDescriptor(imagePath);
                decoratedImage = new DecorationOverlayIcon(baseImage, errorDescriptor, 2).createImage();
            }
        }
        return decoratedImage;
    }

    public String getText(Object object) {
        StringBuffer text = new StringBuffer();
        if (object instanceof EObject) {
            EObject eObject = (EObject)object;
            EClass eClass = eObject.eClass();
            if (eClass.getEPackage() == ModelingUnitPackage.eINSTANCE) {
                this.getTextForModelingUnitElement(text, eObject, eClass);
            }
            if (eClass.getEPackage() == IntentDocumentPackage.eINSTANCE) {
                this.getTextForStructureElement(object, text, eClass);
            }
            if (eClass.getEPackage() == DescriptionUnitPackage.eINSTANCE) {
                this.getTextForDescriptionUnitElement(object, text, eClass);
            }
            if (eClass.getEPackage() == GenericUnitPackage.eINSTANCE) {
                this.getTextForGenericUnitElement(object, text, eClass);
            }
        }
        return text.toString().trim();
    }

    private void getTextForDescriptionUnitElement(Object object, StringBuffer text, EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 0: {
                if (this.hideDescriptionUnitsContent) {
                    text.append("Description zone");
                    break;
                }
                text.append(DescriptionUnitHelper.getDescriptionUnitTitle((DescriptionUnit)((DescriptionUnit)object), (int)50));
                break;
            }
            case 2: {
                text.append(DescriptionUnitHelper.getDescriptionBlocTitle((DescriptionBloc)((DescriptionBloc)object), (int)50));
                break;
            }
            default: {
                text.append(eClass.getName());
            }
        }
    }

    private void getTextForGenericUnitElement(Object object, StringBuffer text, EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 3: {
                LabelDeclaration label = (LabelDeclaration)object;
                text.append("new Label " + label.getLabelValue());
                break;
            }
            case 4: {
                LabelReferenceInstruction labelRef = (LabelReferenceInstruction)object;
                text.append("reference to " + labelRef.getIntentHref());
                break;
            }
            case 2: {
                IntentReferenceInstruction ref = (IntentReferenceInstruction)object;
                text.append("reference to " + ref.getIntentHref());
                break;
            }
            default: {
                text.append(eClass.getName());
            }
        }
    }

    private void getTextForStructureElement(Object object, StringBuffer text, EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 5: 
            case 6: {
                String title = StructuredElementHelper.getTitle((IntentStructuredElement)((IntentStructuredElement)object), (int)50);
                if (title.length() > 0) {
                    text.append(title);
                    break;
                }
                text.append("Untitled " + eClass.getName().replace("Intent", ""));
                break;
            }
            default: {
                text.append(eClass.getName().replace("Intent", ""));
            }
        }
    }

    private void getTextForModelingUnitElement(StringBuffer text, EObject eObject, EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 1: {
                String name = ((ModelingUnit)eObject).getUnitName();
                if (name != null && name.length() > 0) {
                    text.append(name);
                    break;
                }
                text.append("Untitled Modeling Unit");
                break;
            }
            case 5: {
                text.append(((ModelingUnitInstructionReference)eObject).getIntentHref());
                break;
            }
            case 13: {
                text.append(((StructuralFeatureAffectation)eObject).getName());
                break;
            }
            case 15: {
                String textValue = ((NativeValueForStructuralFeature)eObject).getValue();
                if (textValue.startsWith("\"")) {
                    textValue = textValue.substring(1);
                }
                if (textValue.endsWith("\"")) {
                    textValue = textValue.substring(0, textValue.length() - 1);
                }
                text.append(textValue);
                break;
            }
            case 17: {
                text.append(String.valueOf(((ReferenceValueForStructuralFeature)eObject).getInstanciationReference().getInstanceName()) + " (Reference to)");
                break;
            }
            case 12: {
                InstanciationInstruction instruction = (InstanciationInstruction)eObject;
                String instanceName = instruction.getName();
                if (instanceName != null && instanceName.length() > 0) {
                    text.append(String.valueOf(instanceName) + " : " + instruction.getMetaType().getTypeName());
                    break;
                }
                text.append("? : " + instruction.getMetaType().getTypeName());
                break;
            }
            case 18: {
                text.append(((ContributionInstruction)eObject).getContributionReference().getIntentHref());
                break;
            }
            case 19: {
                text.append(((ExternalContentReference)eObject).getUri());
                break;
            }
            case 6: {
                String resourceName = ((ResourceDeclaration)eObject).getName();
                if (resourceName != null && resourceName.length() > 0) {
                    text.append(resourceName);
                    break;
                }
                text.append("Untitled");
                break;
            }
            case 7: {
                IntentReferenceinModelingUnit reference = (IntentReferenceinModelingUnit)eObject;
                text.append("Reference to Section " + reference.getIntentHref());
                if (reference.getReferencedElement() == null) break;
                text.append(this.getText(reference.getReferencedElement()));
                break;
            }
            default: {
                text.append(eClass.getName());
            }
        }
    }

    public Collection<?> getChildren(Object object) {
        LinkedHashSet<Object> childrens = new LinkedHashSet<Object>();
        if (object instanceof IntentGenericElement) {
            for (EObject potentialChildren : ((EObject)object).eContents()) {
                if (!(potentialChildren instanceof IntentGenericElement)) continue;
                childrens.add((IntentGenericElement)potentialChildren);
                childrens.addAll(this.getChildren(potentialChildren));
            }
        }
        return childrens;
    }
}

