/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.client.ui.editor.drop;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CancellationException;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.mylyn.docs.intent.client.ui.IntentEditorActivator;
import org.eclipse.mylyn.docs.intent.client.ui.editor.IntentDocumentProvider;
import org.eclipse.mylyn.docs.intent.client.ui.editor.IntentEditor;
import org.eclipse.mylyn.docs.intent.client.ui.editor.IntentEditorDocument;
import org.eclipse.mylyn.docs.intent.client.ui.editor.drop.DropModeDialog;
import org.eclipse.mylyn.docs.intent.client.ui.editor.renderers.IEditorRendererExtension;
import org.eclipse.mylyn.docs.intent.client.ui.internal.renderers.IEditorRendererExtensionRegistry;
import org.eclipse.mylyn.docs.intent.collab.common.logger.IIntentLogger;
import org.eclipse.mylyn.docs.intent.collab.common.logger.IntentLogger;
import org.eclipse.mylyn.docs.intent.collab.handlers.adapters.RepositoryAdapter;
import org.eclipse.mylyn.docs.intent.core.descriptionunit.DescriptionBloc;
import org.eclipse.mylyn.docs.intent.core.descriptionunit.DescriptionUnit;
import org.eclipse.mylyn.docs.intent.core.document.IntentChapter;
import org.eclipse.mylyn.docs.intent.core.document.IntentDocument;
import org.eclipse.mylyn.docs.intent.core.document.IntentSection;
import org.eclipse.mylyn.docs.intent.core.document.IntentSubSectionContainer;
import org.eclipse.mylyn.docs.intent.core.modelingunit.ModelingUnit;
import org.eclipse.mylyn.docs.intent.modelingunit.update.ExternalContentReferencesMergeUpdater;
import org.eclipse.mylyn.docs.intent.modelingunit.update.MergeUpdater;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.widgets.Display;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntentEditorDropSupport
extends DropTargetAdapter {
    private IntentEditor editor;
    private IntentEditorDocument document;

    public IntentEditorDropSupport(IntentEditor editor) {
        this.editor = editor;
        this.document = (IntentEditorDocument)editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
    }

    public void drop(DropTargetEvent event) {
        List<EObject> droppedEObjects = this.getDroppedEObjectsFromEvent(event);
        if (!droppedEObjects.isEmpty()) {
            EObject intentElement;
            IntentDocumentProvider documentProvider = (IntentDocumentProvider)this.editor.getDocumentProvider();
            RepositoryAdapter repositoryAdapter = documentProvider.getListenedElementsHandler().getRepositoryAdapter();
            int carretOffset = this.editor.getProjectionViewer().getTextWidget().getCaretOffset();
            EObject parent = intentElement = this.document.getElementAtOffset(carretOffset);
            try {
                while (!(intentElement instanceof DescriptionBloc) && !(intentElement instanceof DescriptionUnit) && this.document.get(carretOffset, this.document.getLineLength(this.document.getLineOfOffset(carretOffset))).trim().length() < 1 && carretOffset > -1) {
                    --carretOffset;
                }
                intentElement = this.document.getElementAtOffset(carretOffset);
            }
            catch (BadLocationException badLocationException) {}
            while (!(parent == null || parent instanceof ModelingUnit || parent instanceof IntentSubSectionContainer || parent instanceof IntentDocument)) {
                parent = parent.eContainer();
            }
            try {
                this.reactToDrop(repositoryAdapter, parent, intentElement, droppedEObjects);
                this.document.reloadFromAST();
            }
            catch (CancellationException cancellationException) {}
        }
    }

    private List<EObject> getDroppedEObjectsFromEvent(DropTargetEvent event) {
        ArrayList<EObject> droppedEObjects = new ArrayList<EObject>();
        if (event.data instanceof IStructuredSelection) {
            for (Object data : (IStructuredSelection)event.data) {
                if (data instanceof EObject) {
                    droppedEObjects.add((EObject)data);
                    continue;
                }
                for (IEditorRendererExtension editorRendererExtension : IEditorRendererExtensionRegistry.getEditorRendererExtensions()) {
                    droppedEObjects.addAll(editorRendererExtension.getEObjectsFromDropTargetEvent(event));
                }
            }
        } else {
            for (IEditorRendererExtension editorRendererExtension : IEditorRendererExtensionRegistry.getEditorRendererExtensions()) {
                droppedEObjects.addAll(editorRendererExtension.getEObjectsFromDropTargetEvent(event));
            }
        }
        return droppedEObjects;
    }

    private void reactToDrop(RepositoryAdapter repositoryAdapter, EObject parent, EObject sibling, List<EObject> droppedEObjects) throws CancellationException {
        boolean shouldUseExternalContentReferencesDropMode = this.shouldUseExternalContentReferencesDropMode();
        if (this.shouldDisplayDropModePopUp()) {
            shouldUseExternalContentReferencesDropMode = this.displayDropModePopUp(shouldUseExternalContentReferencesDropMode);
        }
        Object updater = null;
        updater = shouldUseExternalContentReferencesDropMode ? new ExternalContentReferencesMergeUpdater(repositoryAdapter) : new MergeUpdater(repositoryAdapter);
        if (parent instanceof ModelingUnit) {
            updater.create((ModelingUnit)parent, sibling, droppedEObjects);
        } else if (parent instanceof IntentSection) {
            updater.create((IntentSection)parent, sibling, droppedEObjects);
        } else if (parent instanceof IntentDocument) {
            updater.create((IntentDocument)parent, sibling, droppedEObjects);
        } else if (parent instanceof IntentChapter) {
            updater.create((IntentChapter)parent, sibling, droppedEObjects);
        } else {
            IntentLogger.getInstance().log(IIntentLogger.LogType.ERROR, "Can't drop external references in this container:" + parent);
        }
    }

    private boolean displayDropModePopUp(boolean shouldUseExternalContentReferencesDropMode) throws CancellationException {
        DropModeDialog dropModeDialog = new DropModeDialog(Display.getCurrent().getActiveShell());
        dropModeDialog.open();
        if (dropModeDialog.isCancelled()) {
            throw new CancellationException();
        }
        IEclipsePreferences node = InstanceScope.INSTANCE.getNode(IntentEditorActivator.getDefault().getBundle().getSymbolicName());
        node.putBoolean("org.eclipse.mylyn.docs.intent.client.ui.preferences.dnd_display_popup", !dropModeDialog.getToggleState());
        node.putBoolean("org.eclipse.mylyn.docs.intent.client.ui.preferences.dnd_use_external_refs", dropModeDialog.shouldUseExternalReferences());
        return dropModeDialog.shouldUseExternalReferences();
    }

    private boolean shouldDisplayDropModePopUp() {
        IEclipsePreferences node = InstanceScope.INSTANCE.getNode(IntentEditorActivator.getDefault().getBundle().getSymbolicName());
        return node.getBoolean("org.eclipse.mylyn.docs.intent.client.ui.preferences.dnd_display_popup", true);
    }

    private boolean shouldUseExternalContentReferencesDropMode() {
        IEclipsePreferences node = InstanceScope.INSTANCE.getNode(IntentEditorActivator.getDefault().getBundle().getSymbolicName());
        return node.getBoolean("org.eclipse.mylyn.docs.intent.client.ui.preferences.dnd_use_external_refs", true);
    }
}

