/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.client.ui.editor.quickfix;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.quickassist.IQuickAssistInvocationContext;
import org.eclipse.jface.text.quickassist.IQuickAssistProcessor;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.TextInvocationContext;
import org.eclipse.mylyn.docs.intent.client.ui.editor.annotation.IntentAnnotation;
import org.eclipse.mylyn.docs.intent.client.ui.editor.quickfix.ClearResourceFix;
import org.eclipse.mylyn.docs.intent.client.ui.editor.quickfix.CreateResourceFix;
import org.eclipse.mylyn.docs.intent.client.ui.editor.quickfix.EMFCompareFix;
import org.eclipse.mylyn.docs.intent.client.ui.editor.quickfix.MergeEmptyResourceFix;
import org.eclipse.mylyn.docs.intent.client.ui.editor.quickfix.UpdateModelingUnitFix;
import org.eclipse.mylyn.docs.intent.core.compiler.ResourceChangeStatus;
import org.eclipse.mylyn.docs.intent.core.compiler.SynchronizerCompilationStatus;
import org.eclipse.mylyn.docs.intent.core.compiler.SynchronizerResourceState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntentQuickAssistProcessor
implements IQuickAssistProcessor {
    public String getErrorMessage() {
        return null;
    }

    public boolean canFix(Annotation annotation) {
        return "org.eclipse.mylyn.docs.intent.client.ui.annotation.sync.warning".equals(annotation.getType());
    }

    public boolean canAssist(IQuickAssistInvocationContext invocationContext) {
        return false;
    }

    public ICompletionProposal[] computeQuickAssistProposals(IQuickAssistInvocationContext quickAssistContext) {
        ISourceViewer viewer = quickAssistContext.getSourceViewer();
        int documentOffset = quickAssistContext.getOffset();
        int length = viewer.getSelectedRange().y;
        TextInvocationContext context = new TextInvocationContext(viewer, documentOffset, length);
        IAnnotationModel model = viewer.getAnnotationModel();
        int offset = context.getOffset();
        Iterator iter = model.getAnnotationIterator();
        while (iter.hasNext()) {
            Position pos;
            Annotation annotation = (Annotation)iter.next();
            if (!this.canFix(annotation) || (pos = model.getPosition(annotation)) == null || !pos.includes(offset)) continue;
            List<ICompletionProposal> proposals = this.computeProposalsFromStatus(annotation);
            return proposals.toArray(new ICompletionProposal[proposals.size()]);
        }
        return null;
    }

    private List<ICompletionProposal> computeProposalsFromStatus(Annotation annotation) {
        SynchronizerCompilationStatus status = (SynchronizerCompilationStatus)((IntentAnnotation)annotation).getCompilationStatus();
        ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
        if (status instanceof ResourceChangeStatus) {
            ResourceChangeStatus resourceChangeStatus = (ResourceChangeStatus)status;
            SynchronizerResourceState compiledResourceState = resourceChangeStatus.getCompiledResourceState();
            SynchronizerResourceState workingCopyResourceState = resourceChangeStatus.getWorkingCopyResourceState();
            if (SynchronizerResourceState.EMPTY.equals((Object)compiledResourceState)) {
                proposals.add(new ClearResourceFix(annotation));
            } else if (SynchronizerResourceState.EMPTY.equals((Object)workingCopyResourceState)) {
                proposals.add(new MergeEmptyResourceFix(annotation));
            } else if (SynchronizerResourceState.NULL.equals((Object)workingCopyResourceState)) {
                proposals.add(new CreateResourceFix(annotation));
            }
        } else {
            proposals.add(new EMFCompareFix(annotation));
            proposals.add(new UpdateModelingUnitFix(annotation));
        }
        return proposals;
    }
}

