/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.collab.ide.adapters;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.impl.XMLParserPoolImpl;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.mylyn.docs.intent.collab.handlers.adapters.IntentCommand;
import org.eclipse.mylyn.docs.intent.collab.handlers.adapters.ReadOnlyException;
import org.eclipse.mylyn.docs.intent.collab.handlers.adapters.RepositoryAdapter;
import org.eclipse.mylyn.docs.intent.collab.handlers.adapters.RepositoryStructurer;
import org.eclipse.mylyn.docs.intent.collab.handlers.adapters.SaveException;
import org.eclipse.mylyn.docs.intent.collab.handlers.notification.Notificator;
import org.eclipse.mylyn.docs.intent.collab.ide.adapters.RemoveDanglingReferences;
import org.eclipse.mylyn.docs.intent.collab.ide.notification.WorkspaceTypeListener;
import org.eclipse.mylyn.docs.intent.collab.ide.repository.WorkspaceRepository;
import org.eclipse.mylyn.docs.intent.collab.ide.repository.WorkspaceSession;
import org.eclipse.mylyn.docs.intent.collab.repository.RepositoryConnectionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkspaceAdapter
implements RepositoryAdapter {
    private static final long TIME_TO_WAIT_BEFORE_CHECKING_SESSIONDELTA = 5L;
    private static Map<String, Object> saveOptions;
    private static Map<String, Object> loadOptions;
    private WorkspaceRepository repository;
    private boolean isReadOnlyContext;
    private Map<Notificator, Set<WorkspaceTypeListener>> notificatorToListener;
    private RepositoryStructurer documentStructurer;
    private boolean sendSessionWarningBeforeSaving;
    private List<String> resourcesToIgnorePaths;
    private Predicate<Resource> unloadableResourcePredicate = new Predicate<Resource>(){

        public boolean apply(Resource input) {
            return false;
        }
    };

    public WorkspaceAdapter(WorkspaceRepository repository) {
        this.repository = repository;
        this.isReadOnlyContext = false;
        this.notificatorToListener = new HashMap<Notificator, Set<WorkspaceTypeListener>>();
        this.resourcesToIgnorePaths = new ArrayList<String>();
    }

    public static Map<String, Object> getSaveOptions() {
        if (saveOptions == null) {
            saveOptions = new HashMap<String, Object>();
            saveOptions.put("FORMATTED", false);
        }
        return saveOptions;
    }

    public static Map<String, Object> getLoadOptions() {
        if (loadOptions == null) {
            loadOptions = new HashMap<String, Object>();
            loadOptions.put("DEFER_IDREF_RESOLUTION", true);
            loadOptions.put("USE_PARSER_POOL", new XMLParserPoolImpl());
        }
        return loadOptions;
    }

    public Object openSaveContext() {
        this.isReadOnlyContext = false;
        return null;
    }

    public Object openReadOnlyContext() {
        this.isReadOnlyContext = true;
        return null;
    }

    public void save() throws ReadOnlyException, SaveException {
        if (this.isReadOnlyContext) {
            throw new ReadOnlyException("Cannot save with a read-only context. The context should have been started with the 'openSaveContext' method.");
        }
        if (this.documentStructurer != null) {
            this.documentStructurer.structure((RepositoryAdapter)this);
        }
        ArrayList resources = Lists.newArrayList((Iterable)this.repository.getResourceSet().getResources());
        SaveException saveException = null;
        try {
            for (Resource resource : resources) {
                try {
                    if (this.removeDanglingElements(resource) || !this.hasDifferentSerialization(resource)) continue;
                    try {
                        while (((WorkspaceSession)this.repository.getOrCreateSession()).isProcessingDelta()) {
                            try {
                                Thread.sleep(5L);
                            }
                            catch (InterruptedException e) {
                                throw new SaveException(e.getMessage());
                            }
                        }
                        this.treatSessionWarning(resource);
                        if (resource.getContents().isEmpty()) {
                            resource.delete(WorkspaceAdapter.getSaveOptions());
                            continue;
                        }
                        resource.save(WorkspaceAdapter.getSaveOptions());
                    }
                    catch (IOException iOException) {
                        this.removeDanglingElements(resource);
                    }
                    catch (RepositoryConnectionException e) {
                        saveException = new SaveException(e.getMessage());
                    }
                }
                catch (RepositoryConnectionException e) {
                    saveException = new SaveException(e.getMessage());
                }
                catch (IOException e) {
                    saveException = new SaveException(e.getMessage());
                }
            }
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            this.save();
        }
        if (saveException != null) {
            throw saveException;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean hasDifferentSerialization(Resource resourcetoSave) throws IOException {
        boolean equal;
        block18: {
            resourcetoSave.eSetDeliver(false);
            File temporaryFile = File.createTempFile("ResourceSaveHelper", null);
            equal = true;
            try {
                URI temporaryFileURI = URI.createFileURI((String)temporaryFile.getPath());
                URIConverter uriConverter = resourcetoSave.getResourceSet() == null ? new ResourceSetImpl().getURIConverter() : resourcetoSave.getResourceSet().getURIConverter();
                OutputStream temporaryFileOutputStream = uriConverter.createOutputStream(temporaryFileURI);
                try {
                    resourcetoSave.save(temporaryFileOutputStream, WorkspaceAdapter.getSaveOptions());
                }
                finally {
                    temporaryFileOutputStream.close();
                }
                InputStream oldContents = null;
                try {
                    oldContents = uriConverter.createInputStream(resourcetoSave.getURI());
                }
                catch (IOException iOException) {
                    equal = false;
                }
                byte[] newContentBuffer = new byte[4000];
                if (oldContents == null) break block18;
                try {
                    InputStream newContents = uriConverter.createInputStream(temporaryFileURI);
                    try {
                        byte[] oldContentBuffer = new byte[4000];
                        int oldLength = oldContents.read(oldContentBuffer);
                        int newLength = newContents.read(newContentBuffer);
                        while ((equal = oldLength == newLength) && oldLength > 0) {
                            int i = 0;
                            while (i < oldLength) {
                                if (oldContentBuffer[i] != newContentBuffer[i]) {
                                    equal = false;
                                    break block18;
                                }
                                ++i;
                            }
                            oldLength = oldContents.read(oldContentBuffer);
                            newLength = newContents.read(newContentBuffer);
                        }
                    }
                    finally {
                        newContents.close();
                    }
                }
                finally {
                    oldContents.close();
                }
            }
            finally {
                temporaryFile.delete();
                resourcetoSave.eSetDeliver(true);
            }
        }
        if (!equal) return true;
        return false;
    }

    private void treatSessionWarning(Resource resource) throws RepositoryConnectionException {
        if (this.sendSessionWarningBeforeSaving) {
            ((WorkspaceSession)this.repository.getOrCreateSession()).addSavedResource(resource);
        } else if (this.isInResourcesToIgnorePath(resource)) {
            ((WorkspaceSession)this.repository.getOrCreateSession()).addSavedResource(resource);
        }
    }

    public boolean isInResourcesToIgnorePath(Resource resource) {
        boolean isInResourceToIgnorePath = false;
        Iterator<String> iterator = this.resourcesToIgnorePaths.iterator();
        while (iterator.hasNext() && !isInResourceToIgnorePath) {
            String resourceToIgnorePath = iterator.next();
            isInResourceToIgnorePath = this.repository.isIncludedInPath(resourceToIgnorePath, resource);
        }
        return isInResourceToIgnorePath;
    }

    public void undo() throws ReadOnlyException {
        CommandStack commandStack = this.repository.getEditingDomain().getCommandStack();
        if (commandStack != null) {
            commandStack.undo();
        }
    }

    public void setUnloadableResourcePredicate(Predicate<Resource> unloadableResourcePredicate) {
        this.unloadableResourcePredicate = unloadableResourcePredicate;
    }

    private boolean isUnloadableResource(Resource resource) {
        return this.unloadableResourcePredicate.apply((Object)resource);
    }

    public void closeContext() {
        this.isReadOnlyContext = false;
    }

    public void attachSessionListenerForTypes(Notificator typeNotificator, Set<EStructuralFeature> listenedTypes) {
        try {
            WorkspaceTypeListener typeListener = new WorkspaceTypeListener(typeNotificator, listenedTypes);
            if (this.notificatorToListener.get(typeNotificator) == null) {
                this.notificatorToListener.put(typeNotificator, new LinkedHashSet());
            }
            this.notificatorToListener.get(typeNotificator).add(typeListener);
            ((WorkspaceSession)this.repository.getOrCreateSession()).addListener(typeListener);
        }
        catch (RepositoryConnectionException repositoryConnectionException) {}
    }

    public void detachSessionListenerForTypes(Notificator typeNotificator) {
        try {
            for (WorkspaceTypeListener listenerToRemove : this.notificatorToListener.get(typeNotificator)) {
                ((WorkspaceSession)this.repository.getOrCreateSession()).removeListener(listenerToRemove);
            }
            this.notificatorToListener.remove(typeNotificator);
        }
        catch (RepositoryConnectionException repositoryConnectionException) {}
    }

    public void allowChangeSubscriptionPolicy() {
    }

    public Object getContext() {
        return null;
    }

    public Resource getResource(String repositoryRelativePath) {
        return this.getResource(repositoryRelativePath, true);
    }

    public Resource getResource(String repositoryRelativePath, boolean loadResourceOnDemand) {
        URI uri = this.repository.getURIMatchingPath(repositoryRelativePath);
        Resource resource = this.repository.getResourceSet().getResource(uri, loadResourceOnDemand);
        return resource;
    }

    public Resource getOrCreateResource(String path) throws ReadOnlyException {
        if (this.isReadOnlyContext) {
            throw new ReadOnlyException("Cannot create a resource with a read-only context. The context should have been started with the 'openSaveContext' method.");
        }
        URI uri = this.repository.getURIMatchingPath(path);
        Resource returnedResource = this.repository.getResourceSet().getResource(uri, false);
        if (returnedResource == null) {
            returnedResource = this.repository.getResourceSet().createResource(uri);
        } else if (!returnedResource.isLoaded()) {
            try {
                returnedResource.load(WorkspaceAdapter.getLoadOptions());
            }
            catch (IOException iOException) {
                returnedResource = null;
            }
        }
        return returnedResource;
    }

    public EObject getElementWithID(Object uri) {
        if (uri instanceof URI) {
            EObject eObject = this.repository.getResourceSet().getEObject((URI)uri, true);
            return eObject;
        }
        return null;
    }

    public Object getIDFromElement(EObject element) {
        URI uri = null;
        if (element != null && (uri = EcoreUtil.getURI((EObject)element)).toString().startsWith("#")) {
            return null;
        }
        return uri;
    }

    public void attachRepositoryStructurer(RepositoryStructurer structurer) {
        if (!(structurer instanceof RepositoryStructurer)) {
            throw new IllegalArgumentException("Cannot attach " + structurer.getClass().getName() + " to this adapter : should be " + RepositoryStructurer.class.getName());
        }
        this.documentStructurer = structurer;
    }

    public void setSendSessionWarningBeforeSaving(boolean notifySessionBeforeSaving) {
        this.sendSessionWarningBeforeSaving = notifySessionBeforeSaving;
    }

    public void setSendSessionWarningBeforeSaving(Collection<String> resourcesToIgnorePathList) {
        this.sendSessionWarningBeforeSaving = false;
        this.resourcesToIgnorePaths.clear();
        this.resourcesToIgnorePaths.addAll(resourcesToIgnorePathList);
    }

    public EObject reload(EObject elementToReload) {
        EObject resolve = elementToReload;
        if (elementToReload.eIsProxy()) {
            resolve = EcoreUtil.resolve((EObject)elementToReload, (ResourceSet)this.repository.getResourceSet());
        }
        return resolve;
    }

    public void execute(final IntentCommand command) {
        TransactionalEditingDomain editingDomain = this.repository.getEditingDomain();
        RecordingCommand recordingCommand = new RecordingCommand(editingDomain){

            protected void doExecute() {
                command.execute();
            }
        };
        CommandStack commandStack = editingDomain.getCommandStack();
        if (commandStack != null) {
            try {
                commandStack.execute((Command)recordingCommand);
            }
            catch (NullPointerException nullPointerException) {}
        }
    }

    public String getResourcePath(URI resourceURI) {
        return resourceURI.toString().replace("." + resourceURI.fileExtension(), "").replace("platform:/resource", "").replace(this.repository.getWorkspaceConfig().getRepositoryAbsolutePath(), "");
    }

    private boolean removeDanglingElements(Resource resource) throws SaveException, RepositoryConnectionException {
        block9: {
            LinkedHashSet objectsToRemove = Sets.newLinkedHashSet();
            for (EObject root : resource.getContents()) {
                if (root.eContainer() == null || root.eContainer().eResource() != null) continue;
                objectsToRemove.add(root);
            }
            if (objectsToRemove.isEmpty()) break block9;
            this.treatSessionWarning(resource);
            if (resource.getContents().size() <= objectsToRemove.size()) {
                resource.delete(WorkspaceAdapter.getSaveOptions());
            } else {
                for (EObject objectToRemove : objectsToRemove) {
                    EcoreUtil.remove((EObject)objectToRemove);
                }
                for (EObject nonDanglingElement : resource.getContents()) {
                    new RemoveDanglingReferences(this.repository.getEditingDomain(), nonDanglingElement).execute();
                }
                resource.save(WorkspaceAdapter.getSaveOptions());
            }
            return true;
        }
        try {
            for (EObject nonDanglingElement : resource.getContents()) {
                new RemoveDanglingReferences(this.repository.getEditingDomain(), nonDanglingElement).execute();
            }
        }
        catch (IOException ioE) {
            throw new SaveException(ioE.getMessage());
        }
        return false;
    }
}

