/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.client.ui.editor.scanner;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.MultiLineRule;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WhitespaceRule;
import org.eclipse.jface.text.rules.WordRule;
import org.eclipse.mylyn.docs.intent.client.ui.editor.configuration.ColorManager;
import org.eclipse.mylyn.docs.intent.client.ui.editor.configuration.IntentColorConstants;
import org.eclipse.mylyn.docs.intent.client.ui.editor.configuration.IntentFontConstants;
import org.eclipse.mylyn.docs.intent.client.ui.editor.scanner.AbstractIntentScanner;
import org.eclipse.mylyn.docs.intent.client.ui.editor.scanner.IntentWordDetector;
import org.eclipse.swt.graphics.Color;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntentModelingUnitScanner
extends AbstractIntentScanner {
    public static final String KEYWORD_ATTRIBUTE = "__Intent_keyword";
    public static final String DEFAULT_ATTRIBUTE = "__Intent_default";
    private static String[] MU_KEYWORDS = new String[]{"new", "Resource", "@M", "M@", "@Annotation"};
    private Color defaultforeGroundColor;
    private Color defaultBackGroundColor;
    private Color keyWordforeGroundColor;
    private Color stringforeGroundColor;
    private Color backgroundColor;

    public IntentModelingUnitScanner(ColorManager colorManager) {
        super(colorManager);
        this.defaultforeGroundColor = colorManager.getColor(IntentColorConstants.MU_DEFAULT_FOREGROUND);
        this.keyWordforeGroundColor = colorManager.getColor(IntentColorConstants.MU_KEYWORD_FOREGROUND);
        this.stringforeGroundColor = colorManager.getColor(IntentColorConstants.MU_STRING_FOREGROUND);
        this.defaultBackGroundColor = null;
        this.backgroundColor = null;
        ArrayList<Object> rules = new ArrayList<Object>();
        rules.add(this.computeMUKeyWordsRule());
        rules.addAll(this.computeStringRules());
        rules.add(this.computeWhiteSpaceRule());
        this.setRules(rules.toArray(new IRule[rules.size()]));
    }

    private IRule computeMUKeyWordsRule() {
        Token keyWordToken = new Token((Object)new TextAttribute(this.keyWordforeGroundColor, this.defaultBackGroundColor, 1, IntentFontConstants.MU_KW_FONT));
        Token defaultToken = new Token((Object)new TextAttribute(this.defaultforeGroundColor, this.defaultBackGroundColor, 0, IntentFontConstants.MU_DEFAULT_FONT));
        WordRule keyWordsRule = new WordRule((IWordDetector)new IntentWordDetector(true), (IToken)defaultToken);
        MU_KEYWORDS = new String[]{"new", "Resource", "@M", "M@", "@Annotation"};
        int i = 0;
        while (i < MU_KEYWORDS.length) {
            keyWordsRule.addWord(MU_KEYWORDS[i], (IToken)keyWordToken);
            ++i;
        }
        return keyWordsRule;
    }

    private Collection<? extends IRule> computeStringRules() {
        Token stringToken = new Token((Object)new TextAttribute(this.stringforeGroundColor, this.defaultBackGroundColor, 2, IntentFontConstants.MU_DEFAULT_FONT));
        ArrayList<Object> rules = new ArrayList<Object>();
        rules.add(new SingleLineRule("\"", "\"", (IToken)stringToken, '\\'));
        rules.add(new MultiLineRule("'", "'", (IToken)stringToken, '\\'));
        return rules;
    }

    private IRule computeWhiteSpaceRule() {
        Token whiteSpaceToken = new Token((Object)new TextAttribute(null, this.backgroundColor, 0, IntentFontConstants.MU_DEFAULT_FONT));
        return new WhitespaceRule(new IWhitespaceDetector(){

            public boolean isWhitespace(char c) {
                return c == ' ' || c == '\t' || c == '\n' || c == '\r';
            }
        }, (IToken)whiteSpaceToken);
    }

    @Override
    public String getConfiguredContentType() {
        return "__Intent__modelingunit";
    }
}

