/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.client.synchronizer.factory;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.compare.diff.metamodel.AttributeChange;
import org.eclipse.emf.compare.diff.metamodel.DiffElement;
import org.eclipse.emf.compare.diff.metamodel.ModelElementChangeLeftTarget;
import org.eclipse.emf.compare.diff.metamodel.ModelElementChangeRightTarget;
import org.eclipse.emf.compare.diff.metamodel.ReferenceChange;
import org.eclipse.emf.compare.diff.metamodel.ReferenceChangeLeftTarget;
import org.eclipse.emf.compare.diff.metamodel.ReferenceChangeRightTarget;
import org.eclipse.emf.compare.diff.metamodel.UpdateAttribute;
import org.eclipse.emf.compare.diff.metamodel.UpdateReference;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.mylyn.docs.intent.client.synchronizer.factory.SynchronizerMessageProvider;
import org.eclipse.mylyn.docs.intent.core.compiler.CompilationMessageType;
import org.eclipse.mylyn.docs.intent.core.compiler.CompilationStatus;
import org.eclipse.mylyn.docs.intent.core.compiler.CompilationStatusSeverity;
import org.eclipse.mylyn.docs.intent.core.compiler.CompilerFactory;
import org.eclipse.mylyn.docs.intent.core.compiler.SynchronizerCompilationStatus;
import org.eclipse.mylyn.docs.intent.core.compiler.TraceabilityIndexEntry;
import org.eclipse.mylyn.docs.intent.core.document.IntentGenericElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SynchronizerStatusFactory {
    private SynchronizerStatusFactory() {
    }

    public static List<CompilationStatus> createStatusFromDiffElement(TraceabilityIndexEntry indexEntry, DiffElement difference) {
        ArrayList<CompilationStatus> statusList = new ArrayList<CompilationStatus>();
        if (difference.getSubDiffElements().isEmpty()) {
            SynchronizerCompilationStatus status = CompilerFactory.eINSTANCE.createSynchronizerCompilationStatus();
            status.setSeverity(CompilationStatusSeverity.WARNING);
            status.setType(CompilationMessageType.SYNCHRONIZER_WARNING);
            IntentGenericElement targetInstruction = SynchronizerStatusFactory.getTargetInstructionFromDiffElement(indexEntry, difference);
            status.setMessage(SynchronizerMessageProvider.createMessageFromDiffElement(difference));
            status.setWorkingCopyResourceURI(indexEntry.getResourceDeclaration().getUri().toString());
            status.setCompiledResourceURI(indexEntry.getGeneratedResourcePath());
            if (targetInstruction != null) {
                status.setTarget(targetInstruction);
                statusList.add((CompilationStatus)status);
            }
        } else {
            for (DiffElement subDifference : difference.getSubDiffElements()) {
                statusList.addAll(SynchronizerStatusFactory.createStatusFromDiffElement(indexEntry, subDifference));
            }
        }
        return statusList;
    }

    private static IntentGenericElement getTargetInstructionFromDiffElement(TraceabilityIndexEntry indexEntry, DiffElement difference) {
        EObject compiledElement = SynchronizerStatusFactory.getCompiledElementTargetFromDiffElement(difference);
        IntentGenericElement targetInstruction = null;
        if (compiledElement != null) {
            EObject compiledContainer = compiledElement;
            while (targetInstruction == null && compiledContainer != null && !(compiledContainer instanceof Resource)) {
                targetInstruction = SynchronizerStatusFactory.getInstructionFromCompiledElement(indexEntry, compiledContainer);
                compiledContainer = compiledContainer.eContainer();
            }
        }
        if (targetInstruction == null) {
            System.err.println("CANNOT FIND ANY INSTRUCTION FOR " + compiledElement);
            targetInstruction = indexEntry.getResourceDeclaration();
        }
        return targetInstruction;
    }

    private static EObject getCompiledElementTargetFromDiffElement(DiffElement difference) {
        EObject compiledElementTarget = null;
        switch (difference.eClass().getClassifierID()) {
            case 14: {
                compiledElementTarget = ((AttributeChange)difference).getLeftElement();
                break;
            }
            case 19: {
                compiledElementTarget = ((ReferenceChange)difference).getLeftElement();
                break;
            }
            case 18: {
                compiledElementTarget = ((UpdateAttribute)difference).getLeftElement();
                break;
            }
            case 22: {
                compiledElementTarget = ((UpdateReference)difference).getLeftElement();
                break;
            }
            case 9: {
                compiledElementTarget = ((ModelElementChangeLeftTarget)difference).getLeftElement();
                break;
            }
            case 10: {
                compiledElementTarget = ((ModelElementChangeRightTarget)difference).getLeftParent();
                break;
            }
            case 20: {
                compiledElementTarget = ((ReferenceChangeLeftTarget)difference).getLeftElement();
                break;
            }
            case 21: {
                compiledElementTarget = ((ReferenceChangeRightTarget)difference).getRightElement();
                break;
            }
            case 25: {
                break;
            }
        }
        return compiledElementTarget;
    }

    private static IntentGenericElement getInstructionFromCompiledElement(TraceabilityIndexEntry indexEntry, EObject compiledElement) {
        return (IntentGenericElement)indexEntry.getContainedElementToInstructions().get((Object)compiledElement);
    }
}

