/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.service.cli;

import java.io.Closeable;
import java.io.Console;
import java.io.File;
import java.net.ConnectException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.MessageHandler;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TTransport;
import org.eclipse.hawk.service.api.AttributeSlot;
import org.eclipse.hawk.service.api.Credentials;
import org.eclipse.hawk.service.api.DerivedAttributeSpec;
import org.eclipse.hawk.service.api.Hawk;
import org.eclipse.hawk.service.api.HawkChangeEvent;
import org.eclipse.hawk.service.api.HawkInstance;
import org.eclipse.hawk.service.api.HawkQueryOptions;
import org.eclipse.hawk.service.api.HawkState;
import org.eclipse.hawk.service.api.IndexedAttributeSpec;
import org.eclipse.hawk.service.api.ModelElement;
import org.eclipse.hawk.service.api.QueryResult;
import org.eclipse.hawk.service.api.Repository;
import org.eclipse.hawk.service.api.Subscription;
import org.eclipse.hawk.service.api.SubscriptionDurability;
import org.eclipse.hawk.service.api.utils.APIUtils;
import org.eclipse.hawk.service.api.utils.ActiveMQBufferTransport;
import org.eclipse.hawk.service.artemis.consumer.Consumer;
import org.eclipse.hawk.service.cli.Activator;
import org.eclipse.osgi.framework.console.CommandInterpreter;
import org.eclipse.osgi.framework.console.CommandProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HawkCommandProvider
implements CommandProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(HawkCommandProvider.class);
    private Hawk.Client client;
    private APIUtils.ThriftProtocol clientProtocol;
    private String currentInstance;
    private String defaultNamespaces;
    private Consumer consumer;
    private String username;
    private String password;

    public Object _hawkHelp(CommandInterpreter intp) {
        return this.getHelp();
    }

    public Object _hawkConnect(CommandInterpreter intp) throws Exception {
        String url = this.requiredArgument(intp, "url");
        this.username = intp.nextArgument();
        this.password = intp.nextArgument();
        if (this.username != null && this.password == null) {
            Console console = System.console();
            if (console == null) {
                throw new Exception("No console: cannot read password safely");
            }
            console.writer().print("Password: ");
            this.password = String.valueOf(console.readPassword());
        }
        this.clientProtocol = APIUtils.ThriftProtocol.guessFromURL((String)url);
        if (this.client != null) {
            TTransport transport = this.client.getInputProtocol().getTransport();
            Activator.getInstance().removeCloseable((Closeable)transport);
            transport.close();
        }
        this.client = (Hawk.Client)APIUtils.connectTo(Hawk.Client.class, (String)url, (APIUtils.ThriftProtocol)this.clientProtocol, (String)this.username, (String)this.password);
        Activator.getInstance().addCloseable((Closeable)this.client.getInputProtocol().getTransport());
        this.currentInstance = null;
        return "Connected to " + url;
    }

    public Object _hawkDisconnect(CommandInterpreter intp) throws Exception {
        if (this.client != null) {
            TTransport transport = this.client.getInputProtocol().getTransport();
            Activator.getInstance().removeCloseable((Closeable)transport);
            transport.close();
            this.client = null;
            this.currentInstance = null;
            this.username = null;
            this.password = null;
            return "Connection closed";
        }
        return "Connection not open";
    }

    public Object _hawkListInstances(CommandInterpreter intp) throws Exception {
        this.checkConnected();
        List instances = this.client.listInstances();
        Collections.sort(instances, new Comparator<HawkInstance>(){

            @Override
            public int compare(HawkInstance o1, HawkInstance o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        if (instances.isEmpty()) {
            return "No instances exist";
        }
        StringBuffer sbuf = new StringBuffer();
        for (HawkInstance i : instances) {
            sbuf.append(String.format("%s (%s%s)\n", i.name, i.state.toString(), i.name.equals(this.currentInstance) ? ", selected" : ""));
        }
        return sbuf.toString();
    }

    public Object _hawkAddInstance(CommandInterpreter intp) throws Exception {
        this.checkConnected();
        String name = this.requiredArgument(intp, "name");
        String backend = this.requiredArgument(intp, "backend");
        String factory = this.requiredArgument(intp, "factory");
        String sMinimum = intp.nextArgument();
        String sMaximum = intp.nextArgument();
        int minimumDelay = sMinimum != null ? Integer.parseInt(sMinimum) : 1000;
        int maximumDelay = sMaximum != null ? Integer.parseInt(sMaximum) : 512000;
        this.client.createInstance(name, backend, minimumDelay, maximumDelay, null, factory);
        return String.format("Created instance %s", name);
    }

    public Object _hawkListBackends(CommandInterpreter intp) throws Exception {
        this.checkConnected();
        return this.formatList(this.client.listBackends());
    }

    public Object _hawkRemoveInstance(CommandInterpreter intp) throws Exception {
        this.checkConnected();
        String name = this.requiredArgument(intp, "name");
        this.client.removeInstance(name);
        return String.format("Removed instance %s", name);
    }

    public Object _hawkSelectInstance(CommandInterpreter intp) throws Exception {
        this.checkConnected();
        String name = this.requiredArgument(intp, "name");
        this.findInstance(name);
        this.currentInstance = name;
        return String.format("Selected instance %s", name);
    }

    public Object _hawkStartInstance(CommandInterpreter intp) throws Exception {
        this.checkConnected();
        String name = this.requiredArgument(intp, "name");
        HawkInstance hi = this.findInstance(name);
        if (hi.state == HawkState.STOPPED) {
            this.client.startInstance(name);
            return String.format("Started instance %s", name);
        }
        return String.format("Instance %s was already running", name);
    }

    public Object _hawkStopInstance(CommandInterpreter intp) throws Exception {
        this.checkConnected();
        String name = this.requiredArgument(intp, "name");
        HawkInstance hi = this.findInstance(name);
        if (hi.state != HawkState.STOPPED) {
            this.client.stopInstance(name);
            return String.format("Stopped instance %s", name);
        }
        return String.format("Instance %s was already stopped", name);
    }

    public Object _hawkSyncInstance(CommandInterpreter intp) throws Exception {
        this.checkConnected();
        String name = this.requiredArgument(intp, "name");
        String sWaitForSync = intp.nextArgument();
        HawkInstance hi = this.findInstance(name);
        if (hi.state != HawkState.STOPPED) {
            this.client.syncInstance(name, sWaitForSync != null && Boolean.valueOf(sWaitForSync.toLowerCase()) != false);
            return String.format("Requested immediate sync on instance %s", this.currentInstance);
        }
        return String.format("Instance %s is not running", name);
    }

    public Object _hawkRegisterMetamodel(CommandInterpreter intp) throws Exception {
        this.checkInstanceSelected();
        ArrayList<org.eclipse.hawk.service.api.File> mmFiles = new ArrayList<org.eclipse.hawk.service.api.File>();
        String path = intp.nextArgument();
        while (path != null) {
            File rawFile = new File(path);
            mmFiles.add(APIUtils.convertJavaFileToThriftFile((File)rawFile));
            path = intp.nextArgument();
        }
        this.client.registerMetamodels(this.currentInstance, mmFiles);
        return String.format("Registered %d metamodel(s)", mmFiles.size());
    }

    public Object _hawkUnregisterMetamodel(CommandInterpreter intp) throws Exception {
        this.checkInstanceSelected();
        List<String> mmURIs = this.readRemainingArguments(intp);
        this.client.unregisterMetamodels(this.currentInstance, mmURIs);
        return String.format("Unregistered metamodels %s", mmURIs);
    }

    public Object _hawkListMetamodels(CommandInterpreter intp) throws Exception {
        this.checkInstanceSelected();
        return this.formatList(this.client.listMetamodels(this.currentInstance));
    }

    public Object _hawkAddRepository(CommandInterpreter intp) throws Exception {
        this.checkInstanceSelected();
        String repoURL = this.requiredArgument(intp, "url");
        String repoType = this.requiredArgument(intp, "type");
        Credentials creds = new Credentials();
        creds.username = intp.nextArgument();
        creds.password = intp.nextArgument();
        if (creds.username == null) {
            creds.username = "anonymous";
        }
        if (creds.password == null) {
            creds.password = "anonymous";
        }
        Repository repo = new Repository(repoURL, repoType);
        repo.setIsFrozen(false);
        this.client.addRepository(this.currentInstance, repo, creds);
        return String.format("Added repository of type '%s' at '%s'", repoType, repoURL);
    }

    public Object _hawkRemoveRepository(CommandInterpreter intp) throws Exception {
        this.checkInstanceSelected();
        String repoURL = this.requiredArgument(intp, "url");
        this.client.removeRepository(this.currentInstance, repoURL);
        return String.format("Removed repository '%s'", repoURL);
    }

    public Object _hawkUpdateRepositoryCredentials(CommandInterpreter intp) throws Exception {
        this.checkInstanceSelected();
        String repoURL = this.requiredArgument(intp, "url");
        String user = this.requiredArgument(intp, "user");
        String pass = this.requiredArgument(intp, "pass");
        this.client.updateRepositoryCredentials(this.currentInstance, repoURL, new Credentials(user, pass));
        return String.format("Credentials changed for '%s'", repoURL);
    }

    public Object _hawkListRepositories(CommandInterpreter intp) throws Exception {
        this.checkInstanceSelected();
        return this.formatList(this.client.listRepositories(this.currentInstance));
    }

    public Object _hawkSetFrozenRepository(CommandInterpreter intp) throws Exception {
        this.checkInstanceSelected();
        String repoURL = this.requiredArgument(intp, "url");
        boolean isFrozen = Boolean.valueOf(this.requiredArgument(intp, "url"));
        this.client.setFrozen(this.currentInstance, repoURL, isFrozen);
        return String.format("Set repository '%s' frozen flag to %s", repoURL, isFrozen);
    }

    public Object _hawkListRepositoryTypes(CommandInterpreter intp) throws Exception {
        this.checkInstanceSelected();
        return this.formatList(this.client.listRepositoryTypes());
    }

    public Object _hawkListFiles(CommandInterpreter intp) throws Exception {
        this.checkInstanceSelected();
        String repo = this.requiredArgument(intp, "url");
        List<String> filePatterns = this.readRemainingArguments(intp);
        if (filePatterns.isEmpty()) {
            filePatterns.add("*");
        }
        return this.formatList(this.client.listFiles(this.currentInstance, Arrays.asList(repo), filePatterns));
    }

    public Object _hawkListQueryLanguages(CommandInterpreter intp) throws Exception {
        this.checkInstanceSelected();
        return this.formatList(this.client.listQueryLanguages(this.currentInstance));
    }

    public Object _hawkQuery(CommandInterpreter intp) throws Exception {
        List<String> filePatterns;
        this.checkInstanceSelected();
        String query = this.requiredArgument(intp, "query");
        String language = this.requiredArgument(intp, "language");
        String repo = intp.nextArgument();
        if (repo == null) {
            repo = "*";
        }
        if ((filePatterns = this.readRemainingArguments(intp)).isEmpty()) {
            filePatterns.add("*");
        }
        HawkQueryOptions opts = new HawkQueryOptions();
        opts.setDefaultNamespaces(this.defaultNamespaces);
        opts.setFilePatterns(filePatterns);
        opts.setRepositoryPattern(repo);
        opts.setIncludeAttributes(true);
        opts.setIncludeReferences(true);
        opts.setIncludeNodeIDs(true);
        opts.setIncludeContained(false);
        QueryResult ret = this.client.query(this.currentInstance, query, language, opts);
        return "Result: " + ret;
    }

    public Object _hawkSetDefaultNamespaces(CommandInterpreter intp) throws Exception {
        String arg;
        StringBuffer sbuf = new StringBuffer();
        boolean first = false;
        while ((arg = intp.nextArgument()) != null) {
            if (first) {
                first = false;
            } else {
                sbuf.append(',');
            }
            sbuf.append(arg);
        }
        this.defaultNamespaces = sbuf.toString();
        return "Changed default namespaces to '" + this.defaultNamespaces + "'";
    }

    public Object _hawkGetModel(CommandInterpreter intp) throws Exception {
        return this.listModelElements(intp, true);
    }

    public Object _hawkGetRoots(CommandInterpreter intp) throws Exception {
        return this.listModelElements(intp, false);
    }

    public Object _hawkResolveProxies(CommandInterpreter intp) throws Exception {
        this.checkInstanceSelected();
        List<String> ids = this.readRemainingArguments(intp);
        HawkQueryOptions options = new HawkQueryOptions();
        options.setIncludeAttributes(true);
        options.setIncludeReferences(true);
        List elems = this.client.resolveProxies(this.currentInstance, ids, options);
        return this.formatModelElements(elems, "");
    }

    public Object _hawkListIndexedAttributes(CommandInterpreter intp) throws Exception {
        this.checkInstanceSelected();
        ArrayList<String> lines = new ArrayList<String>();
        for (IndexedAttributeSpec spec : this.client.listIndexedAttributes(this.currentInstance)) {
            lines.add(String.format("metamodel '%s', type '%s', indexed attribute '%s'", spec.metamodelUri, spec.typeName, spec.attributeName));
        }
        return this.formatList(lines);
    }

    public Object _hawkAddIndexedAttribute(CommandInterpreter intp) throws Exception {
        this.checkInstanceSelected();
        String mmURI = this.requiredArgument(intp, "mmURI");
        String typeName = this.requiredArgument(intp, "typeName");
        String attributeName = this.requiredArgument(intp, "attributeName");
        this.client.addIndexedAttribute(this.currentInstance, new IndexedAttributeSpec(mmURI, typeName, attributeName));
        return String.format("Added indexed attribute '%s' to '%s' in '%s'", attributeName, typeName, mmURI);
    }

    public Object _hawkRemoveIndexedAttribute(CommandInterpreter intp) throws Exception {
        this.checkInstanceSelected();
        String mmURI = this.requiredArgument(intp, "mmURI");
        String typeName = this.requiredArgument(intp, "typeName");
        String attributeName = this.requiredArgument(intp, "attributeName");
        this.client.removeIndexedAttribute(this.currentInstance, new IndexedAttributeSpec(mmURI, typeName, attributeName));
        return String.format("Removed indexed attribute '%s' from '%s' in '%s'", attributeName, typeName, mmURI);
    }

    public Object _hawkListDerivedAttributes(CommandInterpreter intp) throws Exception {
        this.checkInstanceSelected();
        ArrayList<String> lines = new ArrayList<String>();
        for (DerivedAttributeSpec spec : this.client.listDerivedAttributes(this.currentInstance)) {
            lines.add(String.format("metamodel '%s', type '%s', derived attribute '%s'", spec.metamodelUri, spec.typeName, spec.attributeName));
        }
        return this.formatList(lines);
    }

    public Object _hawkAddDerivedAttribute(CommandInterpreter intp) throws Exception {
        String nextArg;
        this.checkInstanceSelected();
        DerivedAttributeSpec spec = new DerivedAttributeSpec();
        spec.metamodelUri = this.requiredArgument(intp, "mmURI");
        spec.typeName = this.requiredArgument(intp, "typeName");
        spec.attributeName = this.requiredArgument(intp, "attributeName");
        spec.attributeType = this.requiredArgument(intp, "attributeType");
        spec.derivationLanguage = this.requiredArgument(intp, "lang");
        spec.derivationLogic = this.requiredArgument(intp, "expr");
        while ((nextArg = intp.nextArgument()) != null) {
            switch (nextArg.toLowerCase()) {
                case "many": {
                    spec.isMany = true;
                    break;
                }
                case "ordered": {
                    spec.isOrdered = true;
                    break;
                }
                case "unique": {
                    spec.isUnique = true;
                }
            }
        }
        this.client.addDerivedAttribute(this.currentInstance, spec);
        return String.format("Added derived attribute '%s' to '%s' in '%s'", spec.attributeName, spec.typeName, spec.metamodelUri);
    }

    public Object _hawkRemoveDerivedAttribute(CommandInterpreter intp) throws Exception {
        this.checkInstanceSelected();
        String mmURI = this.requiredArgument(intp, "mmURI");
        String typeName = this.requiredArgument(intp, "typeName");
        String attributeName = this.requiredArgument(intp, "attributeName");
        DerivedAttributeSpec spec = new DerivedAttributeSpec();
        spec.metamodelUri = mmURI;
        spec.typeName = typeName;
        spec.attributeName = attributeName;
        this.client.removeDerivedAttribute(this.currentInstance, spec);
        return String.format("Removed derived attribute '%s' from '%s' in '%s'", attributeName, typeName, mmURI);
    }

    public Object _hawkWatchModelChanges(CommandInterpreter intp) throws Exception {
        List<String> files;
        String repository;
        String clientId;
        this.checkInstanceSelected();
        if (this.consumer != null) {
            this.consumer.closeSession();
            Activator.getInstance().removeCloseable((Closeable)this.consumer);
        }
        SubscriptionDurability durability = SubscriptionDurability.DEFAULT;
        String sDurability = intp.nextArgument();
        if (sDurability != null) {
            durability = SubscriptionDurability.valueOf((String)sDurability.toUpperCase());
        }
        if ((clientId = intp.nextArgument()) == null) {
            clientId = System.getenv("user.name");
        }
        if ((repository = intp.nextArgument()) == null) {
            repository = "*";
        }
        if ((files = this.readRemainingArguments(intp)).isEmpty()) {
            files.add("*");
        }
        Subscription subscription = this.client.watchModelChanges(this.currentInstance, repository, files, clientId, durability);
        this.consumer = APIUtils.connectToArtemis((Subscription)subscription, (SubscriptionDurability)durability);
        this.consumer.openSession(this.username, this.password);
        Activator.getInstance().addCloseable((Closeable)this.consumer);
        MessageHandler handler = new MessageHandler(){

            public void onMessage(ClientMessage message) {
                try {
                    TProtocol proto = HawkCommandProvider.this.clientProtocol.getProtocolFactory().getProtocol((TTransport)new ActiveMQBufferTransport(message.getBodyBuffer()));
                    HawkChangeEvent change = new HawkChangeEvent();
                    try {
                        change.read(proto);
                    }
                    catch (TException e) {
                        LOGGER.error(e.getMessage(), (Throwable)e);
                    }
                    message.acknowledge();
                    HawkCommandProvider.this.consumer.commitSession();
                }
                catch (ActiveMQException e) {
                    LOGGER.error("Failed to ack message", (Throwable)e);
                }
            }
        };
        this.consumer.processChangesAsync(handler);
        return String.format("Watching changes on queue '%s' at address '%s' of '%s:%s'", subscription.queueName, subscription.queueAddress, subscription.host, subscription.port);
    }

    private void checkConnected() throws ConnectException {
        if (this.client == null) {
            throw new ConnectException("Please connect to a Thrift endpoint first!");
        }
    }

    private void checkInstanceSelected() throws ConnectException {
        this.checkConnected();
        if (this.currentInstance == null) {
            throw new IllegalArgumentException("No Hawk instance has been selected");
        }
    }

    private HawkInstance findInstance(String name) throws TException {
        for (HawkInstance i : this.client.listInstances()) {
            if (!i.name.equals(name)) continue;
            return i;
        }
        throw new NoSuchElementException(String.format("No instance exists with the name '%s'", name));
    }

    private Object formatList(List<?> elements) {
        if (elements.isEmpty()) {
            return "(no results)";
        }
        StringBuffer sbuf = new StringBuffer();
        boolean bFirst = true;
        for (Object element : elements) {
            if (bFirst) {
                bFirst = false;
            } else {
                sbuf.append("\n");
            }
            sbuf.append("\t- ");
            sbuf.append(element);
        }
        return sbuf.toString();
    }

    private Object formatModelElements(List<ModelElement> elems, String indent) {
        StringBuffer sbuf = new StringBuffer();
        boolean isFirst = true;
        for (ModelElement me : elems) {
            if (isFirst) {
                isFirst = false;
            } else {
                sbuf.append("\n");
            }
            sbuf.append(String.format("%sElement %s:\n\t", indent, me.id));
            sbuf.append(String.format("%sMetamodel: %s\n\t", indent, me.metamodelUri));
            sbuf.append(String.format("%sType: %s\n\t", indent, me.typeName));
            if (me.isSetAttributes()) {
                sbuf.append(String.valueOf(indent) + "Attributes:");
                for (AttributeSlot s : me.attributes) {
                    sbuf.append(String.format("\n\t\t%s%s = %s", indent, s.name, s.value));
                }
            }
            if (me.isSetReferences()) {
                sbuf.append("\n\t" + indent + "References:");
                for (AttributeSlot s : me.references) {
                    sbuf.append(String.format("\n\t\t%s%s =", indent, s.name));
                    if (s.isSetId()) {
                        sbuf.append(String.format(" id(%s)", s.id));
                    }
                    if (s.isSetIds()) {
                        sbuf.append(String.format(" ids(%s)", s.ids));
                    }
                    if (s.isSetPosition()) {
                        sbuf.append(String.format(" position(%s)", s.position));
                    }
                    if (!s.isSetPositions()) continue;
                    sbuf.append(String.format(" positions(%s)", s.positions));
                }
            }
            if (!me.isSetContainers()) continue;
            sbuf.append("\n\t" + indent + "Contained elements:");
            for (AttributeSlot s : me.containers) {
                sbuf.append(String.format("\n\t\t%s%s = %s", indent, s.name, this.formatModelElements(s.elements, String.valueOf(indent) + "\t\t")));
            }
        }
        return sbuf.toString();
    }

    private Object listModelElements(CommandInterpreter intp, boolean entireModel) throws Exception {
        List elems;
        this.checkInstanceSelected();
        String repo = this.requiredArgument(intp, "repo");
        List<String> patterns = this.readRemainingArguments(intp);
        if (patterns.isEmpty()) {
            patterns.add("*");
        }
        HawkQueryOptions opts = new HawkQueryOptions();
        opts.setRepositoryPattern(repo);
        opts.setFilePatterns(patterns);
        opts.setIncludeAttributes(true);
        opts.setIncludeReferences(true);
        if (entireModel) {
            opts.setIncludeNodeIDs(false);
            elems = this.client.getModel(this.currentInstance, opts);
        } else {
            elems = this.client.getRootElements(this.currentInstance, opts);
        }
        return this.formatModelElements(elems, "");
    }

    private String requiredArgument(CommandInterpreter intp, String argumentName) {
        String value = intp.nextArgument();
        if (value == null) {
            throw new IllegalArgumentException(String.format("Required argument '%s' has not been provided", argumentName));
        }
        return value;
    }

    private List<String> readRemainingArguments(CommandInterpreter intp) {
        ArrayList<String> patterns = new ArrayList<String>();
        String pattern = intp.nextArgument();
        while (pattern != null) {
            patterns.add(pattern);
            pattern = intp.nextArgument();
        }
        return patterns;
    }

    public String getHelp() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("---HAWK (commands are case insensitive, <> means required, [] means optional)---\n\t");
        sbuf.append("hawkHelp - lists all the available commands for Hawk\n");
        sbuf.append("--Connections--\n\t");
        sbuf.append("hawkConnect <url> [username] [password] - connects to a Thrift endpoint (guesses the protocol from the URL)\n\t");
        sbuf.append("hawkDisconnect - disconnects from the current Thrift endpoint\n");
        sbuf.append("--Instances--\n\t");
        sbuf.append("hawkAddInstance <name> <backend> <factory> [minDelay] [maxDelay|0] - adds an instance with the provided name (if maxDelay = 0, periodic updates are disabled)\n\t");
        sbuf.append("hawkListBackends - lists the available Hawk backends\n\t");
        sbuf.append("hawkListInstances - lists the available Hawk instances\n\t");
        sbuf.append("hawkRemoveInstance <name> - removes an instance with the provided name, if it exists\n\t");
        sbuf.append("hawkSelectInstance <name> - selects the instance with the provided name\n\t");
        sbuf.append("hawkStartInstance <name> - starts the instance with the provided name\n\t");
        sbuf.append("hawkStopInstance <name> - stops the instance with the provided name\n\t");
        sbuf.append("hawkSyncInstance <name> [waitForSync:true|false] - forces an immediate sync on the instance with the provided name\n");
        sbuf.append("--Metamodels--\n\t");
        sbuf.append("hawkListMetamodels - lists all registered metamodels in this instance\n\t");
        sbuf.append("hawkRegisterMetamodel <files...> - registers one or more metamodels\n\t");
        sbuf.append("hawkUnregisterMetamodel <uri> - unregisters the metamodel with the specified URI\n");
        sbuf.append("--Repositories--\n\t");
        sbuf.append("hawkAddRepository <url> <type> [user] [pwd] - adds a repository\n\t");
        sbuf.append("hawkSetFrozenRepository <url> <frozen:true|false> - changes the frozen state of a repository\n\t");
        sbuf.append("hawkListFiles <url> [filepatterns...] - lists files within a repository\n\t");
        sbuf.append("hawkListRepositories - lists all registered metamodels in this instance\n\t");
        sbuf.append("hawkListRepositoryTypes - lists available repository types\n\t");
        sbuf.append("hawkRemoveRepository <url> - removes the repository with the specified URL\n\t");
        sbuf.append("hawkUpdateRepositoryCredentials <url> <user> <pwd> - changes the user/password used to monitor a repository\n");
        sbuf.append("--Queries--\n\t");
        sbuf.append("hawkSetDefaultNamespaces <namespaces...> - changes the default namespaces used to deambiguate type names\n\t");
        sbuf.append("hawkGetModel <repo> [filepatterns...] - returns all the model elements of the specified files within the repo\n\t");
        sbuf.append("hawkGetRoots <repo> [filepatterns...] - returns only the root model elements of the specified files within the repo\n\t");
        sbuf.append("hawkListQueryLanguages - lists all available query languages\n\t");
        sbuf.append("hawkQuery <query> <language> [repo] [files] - queries the index\n\t");
        sbuf.append("hawkResolveProxies <ids...> - retrieves model elements by ID\n");
        sbuf.append("--Derived attributes--\n\t");
        sbuf.append("hawkAddDerivedAttribute <mmURI> <mmType> <name> <type> <lang> <expr> [many|ordered|unique]* - adds a derived attribute\n\t");
        sbuf.append("hawkListDerivedAttributes - lists all available derived attributes\n\t");
        sbuf.append("hawkRemoveDerivedAttribute <mmURI> <mmType> <name> - removes a derived attribute, if it exists\n");
        sbuf.append("--Indexed attributes--\n\t");
        sbuf.append("hawkAddIndexedAttribute <mmURI> <mmType> <name> - adds an indexed attribute\n\t");
        sbuf.append("hawkListIndexedAttributes - lists all available indexed attributes\n\t");
        sbuf.append("hawkRemoveIndexedAttribute <mmURI> <mmType> <name> - removes an indexed attribute, if it exists\n");
        sbuf.append("--Notifications--\n\t");
        sbuf.append("hawkWatchModelChanges [default|temporary|durable] [client ID] [repo] [files...] - watches an Artemis message queue with detected model changes\n");
        return sbuf.toString();
    }
}

