/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.web.tomcat.internal;

import java.io.IOException;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.apache.catalina.Container;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.eclipse.gemini.web.core.spi.ServletContainerException;
import org.osgi.framework.Bundle;

final class WebappConfigLocator {
    static final String DEFAULT_CONFIG_DIRECTORY = "config";
    private static final String DEFAULT_CONTEXT_XML = "context.xml";
    private static final String DEFAULT_WEB_XML = "web.xml";
    static final String CONTEXT_XML = "META-INF/context.xml";
    private static final String XML_EXTENSION = ".xml";
    private static final String ROOT_PATH = "/";
    private static final String ROOT_CONTEXT_FILE = "ROOT";
    private static final char SLASH_SEPARATOR = '/';
    private static final char HASH_SEPARATOR = '#';
    static final String JAR_SCHEMA = "jar:";
    static final String JAR_TO_ENTRY_SEPARATOR = "!/";
    static final String EMPTY_STRING = "";

    WebappConfigLocator() {
    }

    static String resolveDefaultContextXml(Path configLocation) {
        if (configLocation == null) {
            return null;
        }
        Path defaultContextXml = configLocation.resolve(DEFAULT_CONTEXT_XML);
        if (Files.exists(defaultContextXml, new LinkOption[0])) {
            return defaultContextXml.toAbsolutePath().toString();
        }
        return null;
    }

    static String resolveDefaultWebXml(Path configLocation) {
        if (configLocation == null) {
            return null;
        }
        Path defaultWebXml = configLocation.resolve(DEFAULT_WEB_XML);
        if (Files.exists(defaultWebXml, new LinkOption[0])) {
            return defaultWebXml.toAbsolutePath().toString();
        }
        return null;
    }

    static URL resolveWebappContextXml(String path, String docBase, Path configLocation, Bundle bundle) throws MalformedURLException {
        block18: {
            Path contextXml = configLocation.resolve(String.valueOf(path = WebappConfigLocator.formatContextPath(path)) + XML_EXTENSION);
            if (Files.exists(contextXml, new LinkOption[0])) {
                return contextXml.toUri().toURL();
            }
            if (EMPTY_STRING.equals(docBase)) {
                if (bundle != null) {
                    return WebappConfigLocator.resolveWebappContextXmlFromJarURLConnection(bundle);
                }
                return null;
            }
            Path docBaseFile = Paths.get(docBase, new String[0]);
            if (Files.isDirectory(docBaseFile, new LinkOption[0])) {
                contextXml = docBaseFile.resolve(CONTEXT_XML);
                if (Files.exists(contextXml, new LinkOption[0])) {
                    return contextXml.toUri().toURL();
                }
            } else {
                try {
                    Throwable throwable = null;
                    Object var7_9 = null;
                    try (JarFile jar = new JarFile(docBaseFile.toFile());){
                        ZipEntry contextXmlEntry = jar.getEntry(CONTEXT_XML);
                        if (contextXmlEntry == null) break block18;
                        return new URL(JAR_SCHEMA + docBaseFile.toUri().toString() + JAR_TO_ENTRY_SEPARATOR + CONTEXT_XML);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException e) {
                    throw new ServletContainerException("Cannot open for reading [" + docBaseFile.toAbsolutePath().toString() + "].", (Throwable)e);
                }
            }
        }
        return null;
    }

    static Path resolveWebappConfigDir(Path mainConfigDir, Host host) {
        Path configLocation = mainConfigDir = mainConfigDir != null ? mainConfigDir : Paths.get(DEFAULT_CONFIG_DIRECTORY, new String[0]);
        Container parent = host.getParent();
        if (parent != null && parent instanceof Engine) {
            configLocation = configLocation.resolve(parent.getName());
        }
        return configLocation.resolve(host.getName());
    }

    private static String formatContextPath(String contextPath) {
        if (contextPath.equals(ROOT_PATH)) {
            contextPath = ROOT_CONTEXT_FILE;
        } else if ('/' == contextPath.charAt(0)) {
            contextPath = contextPath.substring(1);
        }
        return contextPath.replace('/', '#');
    }

    private static URL resolveWebappContextXmlFromJarURLConnection(Bundle bundle) {
        block14: {
            URL bundleUrl;
            try {
                bundleUrl = new URL(JAR_SCHEMA + bundle.getLocation() + JAR_TO_ENTRY_SEPARATOR + CONTEXT_XML);
            }
            catch (MalformedURLException malformedURLException) {
                return null;
            }
            try {
                URLConnection connection = bundleUrl.openConnection();
                if (!(connection instanceof JarURLConnection)) break block14;
                JarURLConnection jarURLConnection = (JarURLConnection)connection;
                jarURLConnection.setUseCaches(false);
                Throwable throwable = null;
                Object var5_6 = null;
                try (JarFile jarFile = jarURLConnection.getJarFile();){
                    String entryName = jarURLConnection.getEntryName();
                    if (entryName == null || jarFile == null || jarFile.getEntry(entryName) == null) break block14;
                    return bundleUrl;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException iOException) {
                return null;
            }
        }
        return null;
    }
}

