/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http2;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Iterator;
import org.apache.coyote.ActionCode;
import org.apache.coyote.Constants;
import org.apache.coyote.InputBuffer;
import org.apache.coyote.OutputBuffer;
import org.apache.coyote.Request;
import org.apache.coyote.Response;
import org.apache.coyote.http2.AbstractStream;
import org.apache.coyote.http2.ConnectionException;
import org.apache.coyote.http2.FrameType;
import org.apache.coyote.http2.HpackDecoder;
import org.apache.coyote.http2.Http2Error;
import org.apache.coyote.http2.Http2Exception;
import org.apache.coyote.http2.Http2UpgradeHandler;
import org.apache.coyote.http2.StreamException;
import org.apache.coyote.http2.StreamStateMachine;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.res.StringManager;

public class Stream
extends AbstractStream
implements HpackDecoder.HeaderEmitter {
    private static final Log log = LogFactory.getLog(Stream.class);
    private static final StringManager sm = StringManager.getManager(Stream.class);
    private static final Response ACK_RESPONSE = new Response();
    private volatile int weight = 16;
    private final Http2UpgradeHandler handler;
    private final StreamStateMachine state;
    private final Request coyoteRequest;
    private final Response coyoteResponse = new Response();
    private final StreamInputBuffer inputBuffer;
    private final StreamOutputBuffer outputBuffer = new StreamOutputBuffer();

    public Stream(Integer identifier, Http2UpgradeHandler handler) {
        this(identifier, handler, null);
    }

    public Stream(Integer identifier, Http2UpgradeHandler handler, Request coyoteRequest) {
        super(identifier);
        this.handler = handler;
        this.setParentStream(handler);
        this.setWindowSize(handler.getRemoteSettings().getInitialWindowSize());
        this.state = new StreamStateMachine(this);
        if (coyoteRequest == null) {
            this.coyoteRequest = new Request();
            this.inputBuffer = new StreamInputBuffer();
            this.coyoteRequest.setInputBuffer(this.inputBuffer);
        } else {
            this.coyoteRequest = coyoteRequest;
            this.inputBuffer = null;
            this.state.receivedStartOfHeaders();
            this.state.recievedEndOfStream();
        }
        this.coyoteRequest.setSendfile(false);
        this.coyoteResponse.setOutputBuffer(this.outputBuffer);
        this.coyoteRequest.setResponse(this.coyoteResponse);
        this.coyoteRequest.protocol().setString("HTTP/2.0");
    }

    void rePrioritise(AbstractStream parent, boolean exclusive, int weight) {
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("stream.reprioritisation.debug", new Object[]{this.getConnectionId(), this.getIdentifier(), Boolean.toString(exclusive), parent.getIdentifier(), Integer.toString(weight)}));
        }
        if (this.isDescendant(parent)) {
            parent.detachFromParent();
            this.getParentStream().addChild(parent);
        }
        if (exclusive) {
            Iterator<AbstractStream> parentsChildren = parent.getChildStreams().iterator();
            while (parentsChildren.hasNext()) {
                AbstractStream parentsChild = parentsChildren.next();
                parentsChildren.remove();
                this.addChild(parentsChild);
            }
        }
        parent.addChild(this);
        this.weight = weight;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void receiveReset(long errorCode) {
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("stream.reset.debug", new Object[]{this.getConnectionId(), this.getIdentifier(), Long.toString(errorCode)}));
        }
        this.state.receiveReset();
        if (this.inputBuffer != null) {
            this.inputBuffer.receiveReset();
        }
        Stream stream = this;
        synchronized (stream) {
            this.notifyAll();
        }
    }

    void checkState(FrameType frameType) throws Http2Exception {
        this.state.checkFrameType(frameType);
    }

    @Override
    protected synchronized void incrementWindowSize(int windowSizeIncrement) throws Http2Exception {
        boolean notify = this.getWindowSize() < 1L;
        super.incrementWindowSize(windowSizeIncrement);
        if (notify && this.getWindowSize() > 0L) {
            this.notifyAll();
        }
    }

    private synchronized int reserveWindowSize(int reservation, boolean block) throws IOException {
        long windowSize = this.getWindowSize();
        while (windowSize < 1L) {
            if (!this.canWrite()) {
                throw new IOException(sm.getString("stream.notWritable", new Object[]{this.getConnectionId(), this.getIdentifier()}));
            }
            try {
                if (!block) {
                    return 0;
                }
                this.wait();
            }
            catch (InterruptedException e) {
                throw new IOException(e);
            }
            windowSize = this.getWindowSize();
        }
        int allocation = windowSize < (long)reservation ? (int)windowSize : reservation;
        this.decrementWindowSize(allocation);
        return allocation;
    }

    @Override
    protected synchronized void doNotifyAll() {
        if (this.coyoteResponse.getWriteListener() == null) {
            this.notifyAll();
        } else if (this.outputBuffer.isRegisteredForWrite()) {
            this.coyoteResponse.action(ActionCode.DISPATCH_WRITE, null);
        }
    }

    @Override
    public void emitHeader(String name, String value, boolean neverIndex) {
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("stream.header.debug", new Object[]{this.getConnectionId(), this.getIdentifier(), name, value}));
        }
        switch (name) {
            case ":method": {
                this.coyoteRequest.method().setString(value);
                break;
            }
            case ":scheme": {
                this.coyoteRequest.scheme().setString(value);
                break;
            }
            case ":path": {
                int queryStart = value.indexOf(63);
                if (queryStart == -1) {
                    this.coyoteRequest.requestURI().setString(value);
                    this.coyoteRequest.decodedURI().setString(this.coyoteRequest.getURLDecoder().convert(value, false));
                    break;
                }
                String uri = value.substring(0, queryStart);
                String query = value.substring(queryStart + 1);
                this.coyoteRequest.requestURI().setString(uri);
                this.coyoteRequest.decodedURI().setString(this.coyoteRequest.getURLDecoder().convert(uri, false));
                this.coyoteRequest.queryString().setString(this.coyoteRequest.getURLDecoder().convert(query, true));
                break;
            }
            case ":authority": {
                int i = value.lastIndexOf(58);
                if (i > -1) {
                    this.coyoteRequest.serverName().setString(value.substring(0, i));
                    this.coyoteRequest.setServerPort(Integer.parseInt(value.substring(i + 1)));
                    break;
                }
                this.coyoteRequest.serverName().setString(value);
                break;
            }
            default: {
                if ("expect".equals(name) && "100-continue".equals(value)) {
                    this.coyoteRequest.setExpectation(true);
                }
                this.coyoteRequest.getMimeHeaders().addValue(name).setString(value);
            }
        }
    }

    void writeHeaders() throws IOException {
        this.handler.writeHeaders(this, this.coyoteResponse, 1024);
    }

    void writeAck() throws IOException {
        this.handler.writeHeaders(this, ACK_RESPONSE, 64);
    }

    void flushData() throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("stream.write", new Object[]{this.getConnectionId(), this.getIdentifier()}));
        }
        this.outputBuffer.flush(true);
    }

    @Override
    protected final String getConnectionId() {
        return this.getParentStream().getConnectionId();
    }

    @Override
    protected int getWeight() {
        return this.weight;
    }

    Request getCoyoteRequest() {
        return this.coyoteRequest;
    }

    Response getCoyoteResponse() {
        return this.coyoteResponse;
    }

    ByteBuffer getInputByteBuffer() {
        return this.inputBuffer.getInBuffer();
    }

    void receivedStartOfHeaders() {
        this.state.receivedStartOfHeaders();
    }

    void receivedEndOfStream() {
        this.state.recievedEndOfStream();
    }

    void sentEndOfStream() {
        this.outputBuffer.endOfStreamSent = true;
        this.state.sentEndOfStream();
    }

    StreamInputBuffer getInputBuffer() {
        return this.inputBuffer;
    }

    StreamOutputBuffer getOutputBuffer() {
        return this.outputBuffer;
    }

    void sendReset() {
        this.state.sendReset();
    }

    void sentPushPromise() {
        this.state.sentPushPromise();
    }

    boolean isActive() {
        return this.state.isActive();
    }

    boolean canWrite() {
        return this.state.canWrite();
    }

    boolean isClosedFinal() {
        return this.state.isClosedFinal();
    }

    void closeIfIdle() {
        this.state.closeIfIdle();
    }

    boolean isInputFinished() {
        return !this.state.isFrameTypePermitted(FrameType.DATA);
    }

    void close(Http2Exception http2Exception) {
        if (http2Exception instanceof StreamException) {
            try {
                StreamException se = (StreamException)http2Exception;
                this.receiveReset(se.getError().getCode());
                this.handler.sendStreamReset(se);
            }
            catch (IOException ioe) {
                ConnectionException ce = new ConnectionException(sm.getString("stream.reset.fail"), Http2Error.PROTOCOL_ERROR);
                ce.initCause(ioe);
                this.handler.closeConnection(ce);
            }
        } else {
            this.handler.closeConnection(http2Exception);
        }
    }

    boolean isPushSupported() {
        return this.handler.getRemoteSettings().getEnablePush();
    }

    boolean push(Request request) throws IOException {
        if (!this.isPushSupported()) {
            return false;
        }
        request.getMimeHeaders().addValue(":method").duplicate(request.method());
        request.getMimeHeaders().addValue(":scheme").duplicate(request.scheme());
        StringBuilder path = new StringBuilder(request.requestURI().toString());
        if (!request.queryString().isNull()) {
            path.append('?');
            path.append(request.queryString().toString());
        }
        request.getMimeHeaders().addValue(":path").setString(path.toString());
        if (!(request.scheme().equals("http") && request.getServerPort() == 80 || request.scheme().equals("https") && request.getServerPort() == 443)) {
            request.getMimeHeaders().addValue(":authority").setString(request.serverName().getString() + ":" + request.getServerPort());
        } else {
            request.getMimeHeaders().addValue(":authority").duplicate(request.serverName());
        }
        Stream.push(this.handler, request, this);
        return true;
    }

    private static void push(final Http2UpgradeHandler handler, final Request request, final Stream stream) throws IOException {
        if (Constants.IS_SECURITY_ENABLED) {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws IOException {
                        handler.push(request, stream);
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException ex) {
                Exception e = ex.getException();
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                throw new IOException(ex);
            }
        } else {
            handler.push(request, stream);
        }
    }

    static {
        ACK_RESPONSE.setStatus(100);
    }

    class StreamInputBuffer
    implements InputBuffer {
        private byte[] outBuffer;
        private volatile ByteBuffer inBuffer;
        private volatile boolean readInterest;
        private boolean reset = false;

        StreamInputBuffer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int doRead(ByteChunk chunk) throws IOException {
            this.ensureBuffersExist();
            int written = -1;
            ByteBuffer byteBuffer = this.inBuffer;
            synchronized (byteBuffer) {
                while (this.inBuffer.position() == 0 && !Stream.this.isInputFinished()) {
                    try {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)sm.getString("stream.inputBuffer.empty"));
                        }
                        this.inBuffer.wait();
                        if (!this.reset) continue;
                        throw new IOException("HTTP/2 Stream reset");
                    }
                    catch (InterruptedException e) {
                        throw new IOException(e);
                    }
                }
                if (this.inBuffer.position() > 0) {
                    this.inBuffer.flip();
                    written = this.inBuffer.remaining();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)sm.getString("stream.inputBuffer.copy", new Object[]{Integer.toString(written)}));
                    }
                } else {
                    if (Stream.this.isInputFinished()) {
                        return -1;
                    }
                    throw new IllegalStateException();
                }
                this.inBuffer.get(this.outBuffer, 0, written);
                this.inBuffer.clear();
            }
            chunk.setBytes(this.outBuffer, 0, written);
            Stream.this.handler.writeWindowUpdate(Stream.this, written, true);
            return written;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void registerReadInterest() {
            ByteBuffer byteBuffer = this.inBuffer;
            synchronized (byteBuffer) {
                this.readInterest = true;
            }
        }

        synchronized boolean isRequestBodyFullyRead() {
            return (this.inBuffer == null || this.inBuffer.position() == 0) && Stream.this.isInputFinished();
        }

        synchronized int available() {
            if (this.inBuffer == null) {
                return 0;
            }
            return this.inBuffer.position();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        synchronized boolean onDataAvailable() {
            if (this.readInterest) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)sm.getString("stream.inputBuffer.dispatch"));
                }
                this.readInterest = false;
                Stream.this.coyoteRequest.action(ActionCode.DISPATCH_READ, null);
                Stream.this.coyoteRequest.action(ActionCode.DISPATCH_EXECUTE, null);
                return true;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("stream.inputBuffer.signal"));
            }
            ByteBuffer byteBuffer = this.inBuffer;
            synchronized (byteBuffer) {
                this.inBuffer.notifyAll();
            }
            return false;
        }

        public ByteBuffer getInBuffer() {
            this.ensureBuffersExist();
            return this.inBuffer;
        }

        protected synchronized void insertReplayedBody(ByteChunk body) {
            this.inBuffer = ByteBuffer.wrap(body.getBytes(), body.getOffset(), body.getLength());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void ensureBuffersExist() {
            if (this.inBuffer == null) {
                int size = Stream.this.handler.getLocalSettings().getInitialWindowSize();
                StreamInputBuffer streamInputBuffer = this;
                synchronized (streamInputBuffer) {
                    if (this.inBuffer == null) {
                        this.inBuffer = ByteBuffer.allocate(size);
                        this.outBuffer = new byte[size];
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void receiveReset() {
            if (this.inBuffer != null) {
                ByteBuffer byteBuffer = this.inBuffer;
                synchronized (byteBuffer) {
                    this.reset = true;
                    this.inBuffer.notifyAll();
                }
            }
        }
    }

    class StreamOutputBuffer
    implements OutputBuffer {
        private final ByteBuffer buffer = ByteBuffer.allocate(8192);
        private volatile long written = 0L;
        private volatile boolean closed = false;
        private volatile boolean endOfStreamSent = false;
        private volatile boolean writeInterest = false;

        StreamOutputBuffer() {
        }

        @Override
        public synchronized int doWrite(ByteChunk chunk) throws IOException {
            if (this.closed) {
                throw new IllegalStateException(sm.getString("stream.closed", new Object[]{Stream.this.getConnectionId(), Stream.this.getIdentifier()}));
            }
            if (!Stream.this.coyoteResponse.isCommitted()) {
                Stream.this.coyoteResponse.sendHeaders();
            }
            int len = chunk.getLength();
            int offset = 0;
            while (len > 0) {
                int thisTime = Math.min(this.buffer.remaining(), len);
                this.buffer.put(chunk.getBytes(), chunk.getOffset() + offset, thisTime);
                offset += thisTime;
                if ((len -= thisTime) <= 0 || this.buffer.hasRemaining() || !this.flush(true, Stream.this.coyoteResponse.getWriteListener() == null)) continue;
                break;
            }
            this.written += (long)offset;
            return offset;
        }

        public synchronized boolean flush(boolean block) throws IOException {
            return this.flush(false, block);
        }

        private synchronized boolean flush(boolean writeInProgress, boolean block) throws IOException {
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("stream.outputBuffer.flush.debug", new Object[]{Stream.this.getConnectionId(), Stream.this.getIdentifier(), Integer.toString(this.buffer.position()), Boolean.toString(writeInProgress), Boolean.toString(this.closed)}));
            }
            if (this.buffer.position() == 0) {
                if (this.closed && !this.endOfStreamSent) {
                    Stream.this.handler.writeBody(Stream.this, this.buffer, 0, true);
                }
                return false;
            }
            this.buffer.flip();
            int left = this.buffer.remaining();
            while (left > 0) {
                int streamReservation = Stream.this.reserveWindowSize(left, block);
                if (streamReservation == 0) {
                    this.buffer.compact();
                    return true;
                }
                while (streamReservation > 0) {
                    int connectionReservation = Stream.this.handler.reserveWindowSize(Stream.this, streamReservation);
                    Stream.this.handler.writeBody(Stream.this, this.buffer, connectionReservation, !writeInProgress && this.closed && left == connectionReservation);
                    streamReservation -= connectionReservation;
                    left -= connectionReservation;
                    this.buffer.position(this.buffer.position() + connectionReservation);
                }
            }
            this.buffer.clear();
            return false;
        }

        synchronized boolean isReady() {
            if (Stream.this.getWindowSize() > 0L && Stream.this.handler.getWindowSize() > 0L) {
                return true;
            }
            this.writeInterest = true;
            return false;
        }

        synchronized boolean isRegisteredForWrite() {
            if (this.writeInterest) {
                this.writeInterest = false;
                return true;
            }
            return false;
        }

        @Override
        public long getBytesWritten() {
            return this.written;
        }

        public void close() throws IOException {
            this.closed = true;
            Stream.this.flushData();
        }

        public boolean isClosed() {
            return this.closed;
        }

        public boolean hasNoBody() {
            return this.written == 0L && this.closed;
        }
    }
}

